/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.impl;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;

public class ClusterDefinitionStore {
    private final File file;

    public ClusterDefinitionStore(String filePath) {
        this.file = new File(filePath);
    }

    public Set<DefaultControllerNode> read() throws IOException {
        HashSet<DefaultControllerNode> nodes = new HashSet<DefaultControllerNode>();
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode clusterNodeDef = (ObjectNode)mapper.readTree(this.file);
        Iterator it = ((ArrayNode)clusterNodeDef.get("nodes")).elements();
        while (it.hasNext()) {
            ObjectNode nodeDef = (ObjectNode)it.next();
            nodes.add(new DefaultControllerNode(new NodeId(nodeDef.get("id").asText()), IpAddress.valueOf((String)nodeDef.get("ip").asText()), nodeDef.get("tcpPort").asInt(9876)));
        }
        return nodes;
    }

    public void write(Set<DefaultControllerNode> nodes) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode clusterNodeDef = mapper.createObjectNode();
        ArrayNode nodeDefs = mapper.createArrayNode();
        clusterNodeDef.set("nodes", (JsonNode)nodeDefs);
        for (DefaultControllerNode node : nodes) {
            ObjectNode nodeDef = mapper.createObjectNode();
            nodeDef.put("id", node.id().toString()).put("ip", node.ip().toString()).put("tcpPort", node.tcpPort());
            nodeDefs.add((JsonNode)nodeDef);
        }
        mapper.writeTree(new JsonFactory().createGenerator(this.file, JsonEncoding.UTF8), (JsonNode)clusterNodeDef);
    }
}

