/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.KryoSerializer;
import org.onosproject.store.service.Lock;
import org.onosproject.store.service.LockService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(enabled=false)
@Service
public class LeadershipManager
implements LeadershipService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int TERM_DURATION_MS = 5000;
    private static final int WAIT_BEFORE_RETRY_MS = 2000;
    private final ScheduledExecutorService threadPool = Executors.newScheduledThreadPool(25, Tools.namedThreads((String)"leadership-manager-%d"));
    private static final MessageSubject LEADERSHIP_UPDATES = new MessageSubject("leadership-contest-updates");
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private LockService lockService;
    private final Map<String, Leadership> leaderBoard = Maps.newHashMap();
    private final Map<String, Lock> openContests = Maps.newConcurrentMap();
    private final Set<LeadershipEventListener> listeners = Sets.newIdentityHashSet();
    private NodeId localNodeId;
    private final LeadershipEventListener peerAdvertiser = new PeerAdvertiser();
    private final LeadershipEventListener leaderBoardUpdater = new LeaderBoardUpdater();
    public static final KryoSerializer SERIALIZER = new KryoSerializer(){

        protected void setupKryoPool() {
            this.serializerPool = KryoNamespace.newBuilder().register(KryoNamespaces.API).build().populate(1);
        }
    };

    @Activate
    public void activate() {
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.addListener(this.peerAdvertiser);
        this.addListener(this.leaderBoardUpdater);
        this.clusterCommunicator.addSubscriber(LEADERSHIP_UPDATES, (ClusterMessageHandler)new PeerAdvertisementHandler());
        this.log.info("Started.");
    }

    @Deactivate
    public void deactivate() {
        this.removeListener(this.peerAdvertiser);
        this.removeListener(this.leaderBoardUpdater);
        this.clusterCommunicator.removeSubscriber(LEADERSHIP_UPDATES);
        this.threadPool.shutdown();
        this.log.info("Stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeId getLeader(String path) {
        Map<String, Leadership> map = this.leaderBoard;
        synchronized (map) {
            Leadership leadership = this.leaderBoard.get(path);
            if (leadership != null) {
                return leadership.leader();
            }
        }
        return null;
    }

    public void runForLeadership(String path) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0);
        if (this.openContests.containsKey(path)) {
            this.log.info("Already in the leadership contest for {}", (Object)path);
            return;
        }
        Lock lock = this.lockService.create(path);
        this.openContests.put(path, lock);
        this.threadPool.schedule(new TryLeadership(lock), 0L, TimeUnit.MILLISECONDS);
    }

    public void withdraw(String path) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0);
        Lock lock = this.openContests.remove(path);
        if (lock != null && lock.isLocked()) {
            lock.unlock();
            this.notifyListeners(new LeadershipEvent(LeadershipEvent.Type.LEADER_BOOTED, new Leadership(lock.path(), this.localNodeId, lock.epoch())));
        }
    }

    public Map<String, Leadership> getLeaderBoard() {
        return ImmutableMap.copyOf(this.leaderBoard);
    }

    public void addListener(LeadershipEventListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0);
        this.listeners.add(listener);
    }

    public void removeListener(LeadershipEventListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0);
        this.listeners.remove(listener);
    }

    private void notifyListeners(LeadershipEvent event) {
        for (LeadershipEventListener listener : this.listeners) {
            try {
                listener.event((Event)event);
            }
            catch (Exception e) {
                this.log.error("Notifying listener failed with exception.", (Throwable)e);
            }
        }
    }

    private void tryAcquireLeadership(String path) {
        Lock lock = this.openContests.get(path);
        if (lock == null) {
            return;
        }
        lock.lockAsync(5000).whenComplete((response, error) -> {
            if (error == null) {
                this.threadPool.schedule(new ReelectionTask(lock), 2500L, TimeUnit.MILLISECONDS);
                this.notifyListeners(new LeadershipEvent(LeadershipEvent.Type.LEADER_ELECTED, new Leadership(lock.path(), this.localNodeId, lock.epoch())));
                return;
            }
            this.log.warn("Failed to acquire lock for {}. Will retry in {} ms", new Object[]{path, 2000, error});
            this.threadPool.schedule(new TryLeadership(lock), 2000L, TimeUnit.MILLISECONDS);
        });
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindLockService(LockService lockService) {
        this.lockService = lockService;
    }

    protected void unbindLockService(LockService lockService) {
        if (this.lockService == lockService) {
            this.lockService = null;
        }
    }

    private class LeaderBoardUpdater
    implements LeadershipEventListener {
        private LeaderBoardUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(LeadershipEvent event) {
            Leadership leadershipUpdate = (Leadership)event.subject();
            Map map = LeadershipManager.this.leaderBoard;
            synchronized (map) {
                Leadership currentLeadership = (Leadership)LeadershipManager.this.leaderBoard.get(leadershipUpdate.topic());
                switch ((LeadershipEvent.Type)event.type()) {
                    case LEADER_ELECTED: 
                    case LEADER_REELECTED: {
                        if (currentLeadership != null && currentLeadership.epoch() >= leadershipUpdate.epoch()) break;
                        LeadershipManager.this.leaderBoard.put(leadershipUpdate.topic(), leadershipUpdate);
                        break;
                    }
                    case LEADER_BOOTED: {
                        if (currentLeadership == null || currentLeadership.epoch() > leadershipUpdate.epoch()) break;
                        LeadershipManager.this.leaderBoard.remove(leadershipUpdate.topic());
                        break;
                    }
                }
            }
        }
    }

    private class PeerAdvertisementHandler
    implements ClusterMessageHandler {
        private PeerAdvertisementHandler() {
        }

        public void handle(ClusterMessage message) {
            LeadershipEvent event = (LeadershipEvent)SERIALIZER.decode(message.payload());
            LeadershipManager.this.log.trace("Received {} from {}", (Object)event, (Object)message.sender());
            LeadershipManager.this.notifyListeners(event);
        }
    }

    private class PeerAdvertiser
    implements LeadershipEventListener {
        private PeerAdvertiser() {
        }

        public void event(LeadershipEvent event) {
            if (((Leadership)event.subject()).leader().equals((Object)LeadershipManager.this.localNodeId)) {
                try {
                    LeadershipManager.this.clusterCommunicator.broadcast(new ClusterMessage(LeadershipManager.this.localNodeId, LEADERSHIP_UPDATES, SERIALIZER.encode((Object)event)));
                }
                catch (IOException e) {
                    LeadershipManager.this.log.error("Failed to broadcast leadership update message", (Throwable)e);
                }
            }
        }
    }

    private class TryLeadership
    implements Runnable {
        private final Lock lock;

        public TryLeadership(Lock lock) {
            this.lock = lock;
        }

        @Override
        public void run() {
            LeadershipManager.this.tryAcquireLeadership(this.lock.path());
        }
    }

    private class ReelectionTask
    implements Runnable {
        private final Lock lock;

        public ReelectionTask(Lock lock) {
            this.lock = lock;
        }

        @Override
        public void run() {
            if (!LeadershipManager.this.openContests.containsKey(this.lock.path())) {
                LeadershipManager.this.log.debug("Node withdrew from leadership race for {}. Cancelling reelection task.", (Object)this.lock.path());
                return;
            }
            boolean lockExtended = false;
            try {
                lockExtended = this.lock.extendExpiration(5000);
            }
            catch (Exception e) {
                LeadershipManager.this.log.warn("Attempt to extend lock failed with an exception.", (Throwable)e);
            }
            if (lockExtended) {
                LeadershipManager.this.notifyListeners(new LeadershipEvent(LeadershipEvent.Type.LEADER_REELECTED, new Leadership(this.lock.path(), LeadershipManager.this.localNodeId, this.lock.epoch())));
                LeadershipManager.this.threadPool.schedule(this, 2500L, TimeUnit.MILLISECONDS);
            } else if (LeadershipManager.this.openContests.containsKey(this.lock.path())) {
                LeadershipManager.this.notifyListeners(new LeadershipEvent(LeadershipEvent.Type.LEADER_BOOTED, new Leadership(this.lock.path(), LeadershipManager.this.localNodeId, this.lock.epoch())));
                LeadershipManager.this.threadPool.schedule(new TryLeadership(this.lock), 2000L, TimeUnit.MILLISECONDS);
            }
        }
    }
}

