/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.core.impl;

import com.google.common.collect.ImmutableSet;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.ApplicationIdStore;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.store.core.impl.AppIdEvent;
import org.onosproject.store.core.impl.AppIdStoreDelegate;
import org.onosproject.store.hz.AbstractHazelcastStore;
import org.onosproject.store.hz.SMap;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.KryoSerializer;

@Component(immediate=true)
@Service
public class DistributedApplicationIdStore
extends AbstractHazelcastStore<AppIdEvent, AppIdStoreDelegate>
implements ApplicationIdStore {
    protected IAtomicLong lastAppId;
    protected SMap<String, DefaultApplicationId> appIdsByName;
    protected Map<Short, DefaultApplicationId> appIds = new ConcurrentHashMap<Short, DefaultApplicationId>();
    private String listenerId;

    @Override
    @Activate
    public void activate() {
        super.activate();
        this.serializer = new KryoSerializer(){

            protected void setupKryoPool() {
                this.serializerPool = KryoNamespace.newBuilder().register(KryoNamespaces.API).nextId(300).build();
            }
        };
        this.lastAppId = this.theInstance.getAtomicLong("applicationId");
        this.appIdsByName = new SMap((IMap<byte[], byte[]>)this.theInstance.getMap("appIdsByName"), this.serializer);
        this.listenerId = this.appIdsByName.addEntryListener(new RemoteAppIdEventHandler(), true);
        this.primeAppIds();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.appIdsByName.removeEntryListener(this.listenerId);
        this.log.info("Stopped");
    }

    public Set<ApplicationId> getAppIds() {
        return ImmutableSet.copyOf(this.appIds.values());
    }

    public ApplicationId getAppId(Short id) {
        ApplicationId appId = (ApplicationId)this.appIds.get(id);
        if (appId == null) {
            this.primeAppIds();
        }
        return appId;
    }

    private void primeAppIds() {
        for (DefaultApplicationId appId : this.appIdsByName.values()) {
            this.appIds.put(appId.id(), appId);
        }
    }

    public ApplicationId registerApplication(String name) {
        DefaultApplicationId appId = this.appIdsByName.get(name);
        if (appId == null) {
            short id = (short)this.lastAppId.getAndIncrement();
            appId = (DefaultApplicationId)ConcurrentUtils.putIfAbsent(this.appIdsByName, (Object)name, (Object)new DefaultApplicationId(Short.valueOf(id), name));
        }
        return appId;
    }

    private class RemoteAppIdEventHandler
    implements EntryListener<String, DefaultApplicationId> {
        private RemoteAppIdEventHandler() {
        }

        public void entryAdded(EntryEvent<String, DefaultApplicationId> event) {
            DefaultApplicationId appId = (DefaultApplicationId)event.getValue();
            DistributedApplicationIdStore.this.appIds.put(appId.id(), appId);
        }

        public void entryRemoved(EntryEvent<String, DefaultApplicationId> event) {
        }

        public void entryUpdated(EntryEvent<String, DefaultApplicationId> event) {
            this.entryAdded(event);
        }

        public void entryEvicted(EntryEvent<String, DefaultApplicationId> event) {
        }

        public void mapEvicted(MapEvent event) {
        }

        public void mapCleared(MapEvent event) {
        }
    }
}

