/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.device.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceClockProviderService;
import org.onosproject.net.device.DeviceClockService;
import org.onosproject.store.Timestamp;
import org.onosproject.store.impl.MastershipBasedTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DeviceClockManager
implements DeviceClockService,
DeviceClockProviderService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicInteger ticker = new AtomicInteger(0);
    private ConcurrentMap<DeviceId, MastershipTerm> deviceMastershipTerms = new ConcurrentHashMap<DeviceId, MastershipTerm>();

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public Timestamp getTimestamp(DeviceId deviceId) {
        MastershipTerm term = (MastershipTerm)this.deviceMastershipTerms.get(deviceId);
        this.log.trace("term info for {} is: {}", (Object)deviceId, (Object)term);
        if (term == null) {
            throw new IllegalStateException("Requesting timestamp for a deviceId without mastership");
        }
        return new MastershipBasedTimestamp(term.termNumber(), this.ticker.incrementAndGet());
    }

    public void setMastershipTerm(DeviceId deviceId, MastershipTerm term) {
        this.log.info("adding term info {} {}", (Object)deviceId, (Object)term.master());
        this.deviceMastershipTerms.put(deviceId, term);
    }

    public boolean isTimestampAvailable(DeviceId deviceId) {
        return this.deviceMastershipTerms.containsKey(deviceId);
    }
}

