/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.flow.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.hazelcast.core.IMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.BatchOperationTarget;
import org.onosproject.net.flow.CompletedBatchOperation;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleBatchEntry;
import org.onosproject.net.flow.FlowRuleBatchEvent;
import org.onosproject.net.flow.FlowRuleBatchOperation;
import org.onosproject.net.flow.FlowRuleBatchRequest;
import org.onosproject.net.flow.FlowRuleEvent;
import org.onosproject.net.flow.FlowRuleStore;
import org.onosproject.net.flow.FlowRuleStoreDelegate;
import org.onosproject.net.flow.StoredFlowEntry;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.flow.ReplicaInfo;
import org.onosproject.store.flow.ReplicaInfoEvent;
import org.onosproject.store.flow.ReplicaInfoEventListener;
import org.onosproject.store.flow.ReplicaInfoService;
import org.onosproject.store.flow.impl.FlowStoreMessageSubjects;
import org.onosproject.store.hz.AbstractHazelcastStore;
import org.onosproject.store.hz.SMap;
import org.onosproject.store.serializers.DecodeTo;
import org.onosproject.store.serializers.KryoSerializer;
import org.onosproject.store.serializers.StoreSerializer;
import org.onosproject.store.serializers.impl.DistributedStoreSerializers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedFlowRuleStore
extends AbstractHazelcastStore<FlowRuleBatchEvent, FlowRuleStoreDelegate>
implements FlowRuleStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ReentrantReadWriteLock flowEntriesLock = new ReentrantReadWriteLock();
    private final Multimap<DeviceId, StoredFlowEntry> flowEntries = ArrayListMultimap.create();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ReplicaInfoService replicaInfoManager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    private final AtomicInteger localBatchIdGen = new AtomicInteger();
    private int pendingFutureTimeoutMinutes = 5;
    private Cache<Integer, SettableFuture<CompletedBatchOperation>> pendingFutures = CacheBuilder.newBuilder().expireAfterWrite((long)this.pendingFutureTimeoutMinutes, TimeUnit.MINUTES).removalListener((RemovalListener)new TimeoutFuture()).build();
    private LoadingCache<DeviceId, SMap<FlowId, ImmutableList<StoredFlowEntry>>> smaps;
    private final ExecutorService futureListeners = Executors.newCachedThreadPool(Tools.namedThreads((String)"flowstore-peer-responders"));
    private final ExecutorService backupExecutors = Executors.newSingleThreadExecutor(Tools.namedThreads((String)"async-backups"));
    private boolean syncBackup = false;
    protected static final StoreSerializer SERIALIZER = new KryoSerializer(){

        protected void setupKryoPool() {
            this.serializerPool = KryoNamespace.newBuilder().register(DistributedStoreSerializers.STORE_COMMON).nextId(310).register(new Class[]{FlowRuleEvent.class}).build();
        }
    };
    private static final long FLOW_RULE_STORE_TIMEOUT_MILLIS = 5000L;
    private ReplicaInfoEventListener replicaInfoEventListener;

    @Override
    @Activate
    public void activate() {
        this.serializer = SERIALIZER;
        this.theInstance = this.storeService.getHazelcastInstance();
        this.smaps = CacheBuilder.newBuilder().softValues().build((CacheLoader)new SMapLoader());
        NodeId local = this.clusterService.getLocalNode().id();
        this.clusterCommunicator.addSubscriber(FlowStoreMessageSubjects.APPLY_BATCH_FLOWS, (ClusterMessageHandler)new OnStoreBatch(local));
        this.clusterCommunicator.addSubscriber(FlowStoreMessageSubjects.GET_FLOW_ENTRY, new ClusterMessageHandler(){

            public void handle(ClusterMessage message) {
                FlowRule rule = (FlowRule)SERIALIZER.decode(message.payload());
                DistributedFlowRuleStore.this.log.trace("received get flow entry request for {}", (Object)rule);
                StoredFlowEntry flowEntry = DistributedFlowRuleStore.this.getFlowEntryInternal(rule);
                try {
                    message.respond(SERIALIZER.encode((Object)flowEntry));
                }
                catch (IOException e) {
                    DistributedFlowRuleStore.this.log.error("Failed to respond back", (Throwable)e);
                }
            }
        });
        this.clusterCommunicator.addSubscriber(FlowStoreMessageSubjects.GET_DEVICE_FLOW_ENTRIES, new ClusterMessageHandler(){

            public void handle(ClusterMessage message) {
                DeviceId deviceId = (DeviceId)SERIALIZER.decode(message.payload());
                DistributedFlowRuleStore.this.log.trace("Received get flow entries request for {} from {}", (Object)deviceId, (Object)message.sender());
                Set flowEntries = DistributedFlowRuleStore.this.getFlowEntriesInternal(deviceId);
                try {
                    message.respond(SERIALIZER.encode((Object)flowEntries));
                }
                catch (IOException e) {
                    DistributedFlowRuleStore.this.log.error("Failed to respond to peer's getFlowEntries request", (Throwable)e);
                }
            }
        });
        this.clusterCommunicator.addSubscriber(FlowStoreMessageSubjects.REMOVE_FLOW_ENTRY, new ClusterMessageHandler(){

            public void handle(ClusterMessage message) {
                FlowEntry rule = (FlowEntry)SERIALIZER.decode(message.payload());
                DistributedFlowRuleStore.this.log.trace("received get flow entry request for {}", (Object)rule);
                FlowRuleEvent event = DistributedFlowRuleStore.this.removeFlowRuleInternal(rule);
                try {
                    message.respond(SERIALIZER.encode((Object)event));
                }
                catch (IOException e) {
                    DistributedFlowRuleStore.this.log.error("Failed to respond back", (Throwable)e);
                }
            }
        });
        this.replicaInfoEventListener = new InternalReplicaInfoEventListener();
        this.replicaInfoManager.addListener(this.replicaInfoEventListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.clusterCommunicator.removeSubscriber(FlowStoreMessageSubjects.REMOVE_FLOW_ENTRY);
        this.clusterCommunicator.removeSubscriber(FlowStoreMessageSubjects.GET_DEVICE_FLOW_ENTRIES);
        this.clusterCommunicator.removeSubscriber(FlowStoreMessageSubjects.GET_FLOW_ENTRY);
        this.clusterCommunicator.removeSubscriber(FlowStoreMessageSubjects.APPLY_BATCH_FLOWS);
        this.replicaInfoManager.removeListener(this.replicaInfoEventListener);
        this.log.info("Stopped");
    }

    public int getFlowRuleCount() {
        int sum = 0;
        for (Device device : this.deviceService.getDevices()) {
            DeviceId did = device.id();
            sum += Iterables.size(this.getFlowEntries(did));
        }
        return sum;
    }

    public FlowEntry getFlowEntry(FlowRule rule) {
        ReplicaInfo replicaInfo = this.replicaInfoManager.getReplicaInfoFor(rule.deviceId());
        if (!replicaInfo.master().isPresent()) {
            this.log.warn("Failed to getFlowEntry: No master for {}", (Object)rule.deviceId());
            return null;
        }
        if (((NodeId)replicaInfo.master().get()).equals((Object)this.clusterService.getLocalNode().id())) {
            return this.getFlowEntryInternal(rule);
        }
        this.log.trace("Forwarding getFlowEntry to {}, which is the primary (master) for device {}", replicaInfo.master().orNull(), (Object)rule.deviceId());
        ClusterMessage message = new ClusterMessage(this.clusterService.getLocalNode().id(), FlowStoreMessageSubjects.GET_FLOW_ENTRY, SERIALIZER.encode((Object)rule));
        try {
            ListenableFuture responseFuture = this.clusterCommunicator.sendAndReceive(message, (NodeId)replicaInfo.master().get());
            return (FlowEntry)SERIALIZER.decode((byte[])responseFuture.get(5000L, TimeUnit.MILLISECONDS));
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            this.log.warn("Unable to fetch flow store contents from {}", replicaInfo.master().get());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoredFlowEntry getFlowEntryInternal(FlowRule rule) {
        this.flowEntriesLock.readLock().lock();
        try {
            for (StoredFlowEntry f : this.flowEntries.get((Object)rule.deviceId())) {
                if (!f.equals(rule)) continue;
                StoredFlowEntry storedFlowEntry = f;
                return storedFlowEntry;
            }
        }
        finally {
            this.flowEntriesLock.readLock().unlock();
        }
        return null;
    }

    public Iterable<FlowEntry> getFlowEntries(DeviceId deviceId) {
        ReplicaInfo replicaInfo = this.replicaInfoManager.getReplicaInfoFor(deviceId);
        if (!replicaInfo.master().isPresent()) {
            this.log.warn("Failed to getFlowEntries: No master for {}", (Object)deviceId);
            return Collections.emptyList();
        }
        if (((NodeId)replicaInfo.master().get()).equals((Object)this.clusterService.getLocalNode().id())) {
            return this.getFlowEntriesInternal(deviceId);
        }
        this.log.trace("Forwarding getFlowEntries to {}, which is the primary (master) for device {}", replicaInfo.master().orNull(), (Object)deviceId);
        ClusterMessage message = new ClusterMessage(this.clusterService.getLocalNode().id(), FlowStoreMessageSubjects.GET_DEVICE_FLOW_ENTRIES, SERIALIZER.encode((Object)deviceId));
        try {
            ListenableFuture responseFuture = this.clusterCommunicator.sendAndReceive(message, (NodeId)replicaInfo.master().get());
            return (Iterable)SERIALIZER.decode((byte[])responseFuture.get(5000L, TimeUnit.MILLISECONDS));
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            this.log.warn("Unable to fetch flow store contents from {}", replicaInfo.master().get());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<FlowEntry> getFlowEntriesInternal(DeviceId deviceId) {
        this.flowEntriesLock.readLock().lock();
        try {
            Collection rules = this.flowEntries.get((Object)deviceId);
            if (rules == null) {
                Set<FlowEntry> set = Collections.emptySet();
                return set;
            }
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)rules);
            return immutableSet;
        }
        finally {
            this.flowEntriesLock.readLock().unlock();
        }
    }

    public void storeFlowRule(FlowRule rule) {
        this.storeBatch(new FlowRuleBatchOperation(Arrays.asList(new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.ADD, rule))));
    }

    public Future<CompletedBatchOperation> storeBatch(FlowRuleBatchOperation operation) {
        if (operation.getOperations().isEmpty()) {
            return Futures.immediateFuture((Object)new CompletedBatchOperation(true, Collections.emptySet()));
        }
        DeviceId deviceId = ((FlowRule)((FlowRuleBatchEntry)operation.getOperations().get(0)).getTarget()).deviceId();
        ReplicaInfo replicaInfo = this.replicaInfoManager.getReplicaInfoFor(deviceId);
        if (!replicaInfo.master().isPresent()) {
            this.log.warn("Failed to storeBatch: No master for {}", (Object)deviceId);
            return Futures.immediateFailedFuture((Throwable)new IOException("Failed to storeBatch: No master for " + deviceId));
        }
        NodeId local = this.clusterService.getLocalNode().id();
        if (((NodeId)replicaInfo.master().get()).equals((Object)local)) {
            return this.storeBatchInternal(operation);
        }
        this.log.trace("Forwarding storeBatch to {}, which is the primary (master) for device {}", replicaInfo.master().orNull(), (Object)deviceId);
        ClusterMessage message = new ClusterMessage(local, FlowStoreMessageSubjects.APPLY_BATCH_FLOWS, SERIALIZER.encode((Object)operation));
        try {
            ListenableFuture responseFuture = this.clusterCommunicator.sendAndReceive(message, (NodeId)replicaInfo.master().get());
            return Futures.transform((ListenableFuture)responseFuture, (Function)new DecodeTo(SERIALIZER));
        }
        catch (IOException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<CompletedBatchOperation> storeBatchInternal(FlowRuleBatchOperation operation) {
        ArrayList<FlowRuleBatchEntry> toRemove = new ArrayList<FlowRuleBatchEntry>();
        ArrayList<FlowRuleBatchEntry> toAdd = new ArrayList<FlowRuleBatchEntry>();
        DeviceId did = null;
        this.flowEntriesLock.writeLock().lock();
        try {
            for (FlowRuleBatchEntry batchEntry : operation.getOperations()) {
                FlowRule flowRule = (FlowRule)batchEntry.getTarget();
                FlowRuleBatchEntry.FlowRuleOperation op = (FlowRuleBatchEntry.FlowRuleOperation)batchEntry.getOperator();
                if (did == null) {
                    did = flowRule.deviceId();
                }
                if (op.equals((Object)FlowRuleBatchEntry.FlowRuleOperation.REMOVE)) {
                    StoredFlowEntry entry = this.getFlowEntryInternal(flowRule);
                    if (entry == null) continue;
                    entry.setState(FlowEntry.FlowEntryState.PENDING_REMOVE);
                    toRemove.add(batchEntry);
                    continue;
                }
                if (!op.equals((Object)FlowRuleBatchEntry.FlowRuleOperation.ADD)) continue;
                DefaultFlowEntry flowEntry = new DefaultFlowEntry(flowRule);
                DeviceId deviceId = flowRule.deviceId();
                if (this.flowEntries.containsEntry((Object)deviceId, (Object)flowEntry)) continue;
                this.flowEntries.put((Object)deviceId, (Object)flowEntry);
                toAdd.add(batchEntry);
            }
            if (toAdd.isEmpty() && toRemove.isEmpty()) {
                ListenableFuture listenableFuture = Futures.immediateFuture((Object)new CompletedBatchOperation(true, Collections.emptySet()));
                return listenableFuture;
            }
            this.updateBackup(did, toAdd, toRemove);
        }
        finally {
            this.flowEntriesLock.writeLock().unlock();
        }
        SettableFuture r = SettableFuture.create();
        int batchId = this.localBatchIdGen.incrementAndGet();
        this.pendingFutures.put((Object)batchId, (Object)r);
        this.notifyDelegate((Event)FlowRuleBatchEvent.requested((FlowRuleBatchRequest)new FlowRuleBatchRequest(batchId, toAdd, toRemove)));
        return r;
    }

    private void updateBackup(DeviceId deviceId, List<FlowRuleBatchEntry> toAdd, List<FlowRuleBatchEntry> list) {
        Future<?> submit = this.backupExecutors.submit(new UpdateBackup(deviceId, toAdd, list));
        if (this.syncBackup) {
            try {
                submit.get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.log.error("Failed to create backups", (Throwable)e);
            }
        }
    }

    private void updateBackup(DeviceId deviceId, List<FlowRuleBatchEntry> toAdd) {
        this.updateBackup(deviceId, toAdd, Collections.emptyList());
    }

    public void deleteFlowRule(FlowRule rule) {
        this.storeBatch(new FlowRuleBatchOperation(Arrays.asList(new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.REMOVE, rule))));
    }

    public FlowRuleEvent addOrUpdateFlowRule(FlowEntry rule) {
        ReplicaInfo replicaInfo = this.replicaInfoManager.getReplicaInfoFor(rule.deviceId());
        NodeId localId = this.clusterService.getLocalNode().id();
        if (localId.equals(replicaInfo.master().orNull())) {
            return this.addOrUpdateFlowRuleInternal(rule);
        }
        this.log.warn("Tried to update FlowRule {} state, while the Node was not the master.", (Object)rule);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlowRuleEvent addOrUpdateFlowRuleInternal(FlowEntry rule) {
        DeviceId did = rule.deviceId();
        this.flowEntriesLock.writeLock().lock();
        try {
            StoredFlowEntry stored = this.getFlowEntryInternal((FlowRule)rule);
            if (stored != null) {
                stored.setBytes(rule.bytes());
                stored.setLife(rule.life());
                stored.setPackets(rule.packets());
                if (stored.state() == FlowEntry.FlowEntryState.PENDING_ADD) {
                    stored.setState(FlowEntry.FlowEntryState.ADDED);
                    FlowRuleBatchEntry entry = new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.ADD, (FlowRule)stored);
                    this.updateBackup(did, Arrays.asList(entry));
                    FlowRuleEvent flowRuleEvent = new FlowRuleEvent(FlowRuleEvent.Type.RULE_ADDED, (FlowRule)rule);
                    return flowRuleEvent;
                }
                FlowRuleEvent flowRuleEvent = new FlowRuleEvent(FlowRuleEvent.Type.RULE_UPDATED, (FlowRule)rule);
                return flowRuleEvent;
            }
            this.flowEntries.put((Object)did, (Object)new DefaultFlowEntry((FlowRule)rule));
        }
        finally {
            this.flowEntriesLock.writeLock().unlock();
        }
        return null;
    }

    public FlowRuleEvent removeFlowRule(FlowEntry rule) {
        DeviceId deviceId = rule.deviceId();
        ReplicaInfo replicaInfo = this.replicaInfoManager.getReplicaInfoFor(deviceId);
        NodeId localId = this.clusterService.getLocalNode().id();
        if (localId.equals(replicaInfo.master().orNull())) {
            return this.removeFlowRuleInternal(rule);
        }
        if (!replicaInfo.master().isPresent()) {
            this.log.warn("Failed to removeFlowRule: No master for {}", (Object)deviceId);
            return null;
        }
        this.log.trace("Forwarding removeFlowRule to {}, which is the primary (master) for device {}", replicaInfo.master().orNull(), (Object)deviceId);
        ClusterMessage message = new ClusterMessage(this.clusterService.getLocalNode().id(), FlowStoreMessageSubjects.REMOVE_FLOW_ENTRY, SERIALIZER.encode((Object)rule));
        try {
            ListenableFuture responseFuture = this.clusterCommunicator.sendAndReceive(message, (NodeId)replicaInfo.master().get());
            return (FlowRuleEvent)SERIALIZER.decode((byte[])responseFuture.get(5000L, TimeUnit.MILLISECONDS));
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlowRuleEvent removeFlowRuleInternal(FlowEntry rule) {
        DeviceId deviceId = rule.deviceId();
        this.flowEntriesLock.writeLock().lock();
        try {
            boolean removed = this.flowEntries.remove((Object)deviceId, (Object)rule);
            FlowRuleBatchEntry entry = new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.REMOVE, (FlowRule)rule);
            this.updateBackup(deviceId, Collections.emptyList(), Arrays.asList(entry));
            if (removed) {
                FlowRuleEvent flowRuleEvent = new FlowRuleEvent(FlowRuleEvent.Type.RULE_REMOVED, (FlowRule)rule);
                return flowRuleEvent;
            }
            FlowRuleEvent flowRuleEvent = null;
            return flowRuleEvent;
        }
        finally {
            this.flowEntriesLock.writeLock().unlock();
        }
    }

    public void batchOperationComplete(FlowRuleBatchEvent event) {
        Integer batchId = ((FlowRuleBatchRequest)event.subject()).batchId();
        SettableFuture future = (SettableFuture)this.pendingFutures.getIfPresent((Object)batchId);
        if (future != null) {
            future.set((Object)event.result());
            this.pendingFutures.invalidate((Object)batchId);
        }
        this.notifyDelegate((Event)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromBackup(DeviceId did) {
        this.flowEntriesLock.writeLock().lock();
        try {
            this.log.debug("Loading FlowRules for {} from backups", (Object)did);
            SMap backupFlowTable = (SMap)this.smaps.get((Object)did);
            for (Map.Entry e : backupFlowTable.entrySet()) {
                this.log.trace("loading {}", e.getValue());
                for (StoredFlowEntry entry : (ImmutableList)e.getValue()) {
                    this.flowEntries.remove((Object)did, (Object)entry);
                    this.flowEntries.put((Object)did, (Object)entry);
                }
            }
        }
        catch (ExecutionException e) {
            this.log.error("Failed to load backup flowtable for {}", (Object)did, (Object)e);
        }
        finally {
            this.flowEntriesLock.writeLock().unlock();
        }
    }

    private void removeFromPrimary(DeviceId did) {
        Collection removed = null;
        this.flowEntriesLock.writeLock().lock();
        try {
            removed = this.flowEntries.removeAll((Object)did);
        }
        finally {
            this.flowEntriesLock.writeLock().unlock();
        }
        this.log.trace("removedFromPrimary {}", (Object)removed);
    }

    protected void bindReplicaInfoManager(ReplicaInfoService replicaInfoService) {
        this.replicaInfoManager = replicaInfoService;
    }

    protected void unbindReplicaInfoManager(ReplicaInfoService replicaInfoService) {
        if (this.replicaInfoManager == replicaInfoService) {
            this.replicaInfoManager = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    private final class UpdateBackup
    implements Runnable {
        private final DeviceId deviceId;
        private final List<FlowRuleBatchEntry> toAdd;
        private final List<FlowRuleBatchEntry> toRemove;

        public UpdateBackup(DeviceId deviceId, List<FlowRuleBatchEntry> toAdd, List<FlowRuleBatchEntry> list) {
            this.deviceId = (DeviceId)Preconditions.checkNotNull((Object)deviceId);
            this.toAdd = (List)Preconditions.checkNotNull(toAdd);
            this.toRemove = (List)Preconditions.checkNotNull(list);
        }

        @Override
        public void run() {
            try {
                boolean success;
                ImmutableList newValue;
                ArrayList<StoredFlowEntry> list;
                ImmutableList original;
                FlowId id;
                FlowRule entry;
                DistributedFlowRuleStore.this.log.trace("update backup {} +{} -{}", new Object[]{this.deviceId, this.toAdd, this.toRemove});
                SMap backupFlowTable = (SMap)DistributedFlowRuleStore.this.smaps.get((Object)this.deviceId);
                for (FlowRuleBatchEntry bEntry : this.toAdd) {
                    entry = (FlowRule)bEntry.getTarget();
                    id = entry.id();
                    original = (ImmutableList)backupFlowTable.get(id);
                    list = new ArrayList<StoredFlowEntry>();
                    if (original != null) {
                        list.addAll((Collection<StoredFlowEntry>)original);
                    }
                    list.remove(bEntry.getTarget());
                    list.add((StoredFlowEntry)entry);
                    newValue = ImmutableList.copyOf(list);
                    success = original == null ? backupFlowTable.putIfAbsent(id, newValue) == null : backupFlowTable.replace(id, original, newValue);
                    if (success) continue;
                    DistributedFlowRuleStore.this.log.error("Updating backup failed.");
                }
                for (FlowRuleBatchEntry bEntry : this.toRemove) {
                    entry = (FlowRule)bEntry.getTarget();
                    id = entry.id();
                    original = (ImmutableList)backupFlowTable.get(id);
                    list = new ArrayList();
                    if (original != null) {
                        list.addAll((Collection<StoredFlowEntry>)original);
                    }
                    list.remove(bEntry.getTarget());
                    newValue = ImmutableList.copyOf(list);
                    success = original == null ? backupFlowTable.putIfAbsent(id, newValue) == null : backupFlowTable.replace(id, original, newValue);
                    if (success) continue;
                    DistributedFlowRuleStore.this.log.error("Updating backup failed.");
                }
            }
            catch (ExecutionException e) {
                DistributedFlowRuleStore.this.log.error("Failed to write to backups", (Throwable)e);
            }
        }
    }

    private final class InternalReplicaInfoEventListener
    implements ReplicaInfoEventListener {
        private InternalReplicaInfoEventListener() {
        }

        public void event(ReplicaInfoEvent event) {
            NodeId local = DistributedFlowRuleStore.this.clusterService.getLocalNode().id();
            DeviceId did = (DeviceId)event.subject();
            ReplicaInfo rInfo = event.replicaInfo();
            switch ((ReplicaInfoEvent.Type)event.type()) {
                case MASTER_CHANGED: {
                    if (local.equals(rInfo.master().orNull())) {
                        DistributedFlowRuleStore.this.loadFromBackup(did);
                        break;
                    }
                    DistributedFlowRuleStore.this.removeFromPrimary(did);
                    break;
                }
            }
        }
    }

    private final class SMapLoader
    extends CacheLoader<DeviceId, SMap<FlowId, ImmutableList<StoredFlowEntry>>> {
        private SMapLoader() {
        }

        public SMap<FlowId, ImmutableList<StoredFlowEntry>> load(DeviceId id) throws Exception {
            IMap map = DistributedFlowRuleStore.this.theInstance.getMap("flowtable_" + id.toString());
            return new SMap<FlowId, ImmutableList<StoredFlowEntry>>((IMap<byte[], byte[]>)map, SERIALIZER);
        }
    }

    private final class OnStoreBatch
    implements ClusterMessageHandler {
        private final NodeId local;

        private OnStoreBatch(NodeId local) {
            this.local = local;
        }

        public void handle(final ClusterMessage message) {
            final FlowRuleBatchOperation operation = (FlowRuleBatchOperation)SERIALIZER.decode(message.payload());
            DistributedFlowRuleStore.this.log.debug("received batch request {}", (Object)operation);
            DeviceId deviceId = ((FlowRule)((FlowRuleBatchEntry)operation.getOperations().get(0)).getTarget()).deviceId();
            ReplicaInfo replicaInfo = DistributedFlowRuleStore.this.replicaInfoManager.getReplicaInfoFor(deviceId);
            if (!this.local.equals(replicaInfo.master().orNull())) {
                HashSet<BatchOperationTarget> failures = new HashSet<BatchOperationTarget>(operation.size());
                for (FlowRuleBatchEntry op : operation.getOperations()) {
                    failures.add(op.getTarget());
                }
                CompletedBatchOperation allFailed = new CompletedBatchOperation(false, failures);
                try {
                    message.respond(SERIALIZER.encode((Object)allFailed));
                }
                catch (IOException e) {
                    DistributedFlowRuleStore.this.log.error("Failed to respond back", (Throwable)e);
                }
                return;
            }
            final ListenableFuture f = DistributedFlowRuleStore.this.storeBatchInternal(operation);
            f.addListener(new Runnable(){

                @Override
                public void run() {
                    CompletedBatchOperation result;
                    try {
                        result = (CompletedBatchOperation)f.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        DistributedFlowRuleStore.this.log.error("Batch operation failed", (Throwable)e);
                        HashSet<BatchOperationTarget> failures = new HashSet<BatchOperationTarget>(operation.size());
                        for (FlowRuleBatchEntry op : operation.getOperations()) {
                            failures.add(op.getTarget());
                        }
                        result = new CompletedBatchOperation(false, failures);
                    }
                    try {
                        message.respond(SERIALIZER.encode((Object)result));
                    }
                    catch (IOException e) {
                        DistributedFlowRuleStore.this.log.error("Failed to respond back", (Throwable)e);
                    }
                }
            }, (Executor)DistributedFlowRuleStore.this.futureListeners);
        }
    }

    private static final class TimeoutFuture
    implements RemovalListener<Integer, SettableFuture<CompletedBatchOperation>> {
        private TimeoutFuture() {
        }

        public void onRemoval(RemovalNotification<Integer, SettableFuture<CompletedBatchOperation>> notification) {
            ((SettableFuture)notification.getValue()).setException((Throwable)new ExecutionException("Timed out", new TimeoutException()));
        }
    }
}

