/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.hz;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.event.Event;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.hz.StoreService;
import org.onosproject.store.serializers.KryoSerializer;
import org.onosproject.store.serializers.StoreSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public abstract class AbstractHazelcastStore<E extends Event, D extends StoreDelegate<E>>
extends AbstractStore<E, D> {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StoreService storeService;
    protected StoreSerializer serializer;
    protected HazelcastInstance theInstance;

    @Activate
    public void activate() {
        this.serializer = new KryoSerializer();
        this.theInstance = this.storeService.getHazelcastInstance();
    }

    protected byte[] serialize(Object obj) {
        return this.serializer.encode(obj);
    }

    protected <T> T deserialize(byte[] bytes) {
        return (T)this.serializer.decode(bytes);
    }

    protected void bindStoreService(StoreService storeService) {
        this.storeService = storeService;
    }

    protected void unbindStoreService(StoreService storeService) {
        if (this.storeService == storeService) {
            this.storeService = null;
        }
    }

    public class RemoteEventHandler<K, V>
    extends EntryAdapter<byte[], byte[]> {
        private final Member localMember;

        public RemoteEventHandler() {
            this.localMember = AbstractHazelcastStore.this.theInstance.getCluster().getLocalMember();
        }

        public void entryAdded(EntryEvent<byte[], byte[]> event) {
            if (this.localMember.equals(event.getMember())) {
                return;
            }
            Object key = AbstractHazelcastStore.this.deserialize((byte[])event.getKey());
            Object newVal = AbstractHazelcastStore.this.deserialize((byte[])event.getValue());
            this.onAdd(key, newVal);
        }

        public void entryRemoved(EntryEvent<byte[], byte[]> event) {
            if (this.localMember.equals(event.getMember())) {
                return;
            }
            Object key = AbstractHazelcastStore.this.deserialize((byte[])event.getKey());
            Object val = AbstractHazelcastStore.this.deserialize((byte[])event.getValue());
            this.onRemove(key, val);
        }

        public void entryUpdated(EntryEvent<byte[], byte[]> event) {
            if (this.localMember.equals(event.getMember())) {
                return;
            }
            Object key = AbstractHazelcastStore.this.deserialize((byte[])event.getKey());
            Object oldVal = AbstractHazelcastStore.this.deserialize((byte[])event.getOldValue());
            Object newVal = AbstractHazelcastStore.this.deserialize((byte[])event.getValue());
            this.onUpdate(key, oldVal, newVal);
        }

        protected void onAdd(K key, V newVal) {
        }

        protected void onUpdate(K key, V oldValue, V newVal) {
        }

        protected void onRemove(K key, V val) {
        }
    }

    public class RemoteCacheEventHandler<K, V>
    extends EntryAdapter<byte[], byte[]> {
        private final Member localMember;
        private LoadingCache<K, Optional<V>> cache;

        public RemoteCacheEventHandler(LoadingCache<K, Optional<V>> cache) {
            this.localMember = AbstractHazelcastStore.this.theInstance.getCluster().getLocalMember();
            this.cache = (LoadingCache)Preconditions.checkNotNull(cache);
        }

        public void mapCleared(MapEvent event) {
            if (this.localMember.equals(event.getMember())) {
                return;
            }
            this.cache.invalidateAll();
        }

        public void entryAdded(EntryEvent<byte[], byte[]> event) {
            if (this.localMember.equals(event.getMember())) {
                return;
            }
            Object key = AbstractHazelcastStore.this.deserialize((byte[])event.getKey());
            Object newVal = AbstractHazelcastStore.this.deserialize((byte[])event.getValue());
            Optional newValue = Optional.of(newVal);
            this.cache.asMap().putIfAbsent(key, newValue);
            this.onAdd(key, newVal);
        }

        public void entryUpdated(EntryEvent<byte[], byte[]> event) {
            if (this.localMember.equals(event.getMember())) {
                return;
            }
            Object key = AbstractHazelcastStore.this.deserialize((byte[])event.getKey());
            Object oldVal = AbstractHazelcastStore.this.deserialize((byte[])event.getOldValue());
            Optional oldValue = Optional.fromNullable(oldVal);
            Object newVal = AbstractHazelcastStore.this.deserialize((byte[])event.getValue());
            Optional newValue = Optional.of(newVal);
            this.cache.asMap().replace(key, oldValue, newValue);
            this.onUpdate(key, oldVal, newVal);
        }

        public void entryRemoved(EntryEvent<byte[], byte[]> event) {
            if (this.localMember.equals(event.getMember())) {
                return;
            }
            Object key = AbstractHazelcastStore.this.deserialize((byte[])event.getKey());
            Object val = AbstractHazelcastStore.this.deserialize((byte[])event.getOldValue());
            this.cache.invalidate(key);
            this.onRemove(key, val);
        }

        protected void onAdd(K key, V newVal) {
        }

        protected void onUpdate(K key, V oldValue, V newVal) {
        }

        protected void onRemove(K key, V val) {
        }
    }
}

