/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.hz;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.query.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.onosproject.store.serializers.StoreSerializer;

public class SMap<K, V>
implements IMap<K, V> {
    private final IMap<byte[], byte[]> m;
    private final StoreSerializer serializer;

    public SMap(IMap<byte[], byte[]> baseMap, StoreSerializer serializer) {
        this.m = (IMap)Preconditions.checkNotNull(baseMap);
        this.serializer = (StoreSerializer)Preconditions.checkNotNull((Object)serializer);
    }

    public int size() {
        return this.m.size();
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        IdentityHashMap<byte[], byte[]> sm = new IdentityHashMap<byte[], byte[]>(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            sm.put(this.serializeKey(e.getKey()), this.serializeVal(e.getValue()));
        }
        this.m.putAll(sm);
    }

    @Deprecated
    public Object getId() {
        return this.m.getId();
    }

    public String getPartitionKey() {
        return this.m.getPartitionKey();
    }

    public String getName() {
        return this.m.getName();
    }

    public String getServiceName() {
        return this.m.getServiceName();
    }

    public void destroy() {
        this.m.destroy();
    }

    public boolean containsKey(Object key) {
        return this.m.containsKey((Object)this.serializeKey(key));
    }

    public boolean containsValue(Object value) {
        return this.m.containsValue((Object)this.serializeVal(value));
    }

    public V get(Object key) {
        return this.deserializeVal((byte[])this.m.get((Object)this.serializeKey(key)));
    }

    public V put(K key, V value) {
        return this.deserializeVal((byte[])this.m.put((Object)this.serializeKey(key), (Object)this.serializeVal(value)));
    }

    public V remove(Object key) {
        return this.deserializeVal((byte[])this.m.remove((Object)this.serializeKey(key)));
    }

    public boolean remove(Object key, Object value) {
        return this.m.remove((Object)this.serializeKey(key), (Object)this.serializeVal(value));
    }

    public void delete(Object key) {
        this.m.delete((Object)this.serializeKey(key));
    }

    public void flush() {
        this.m.flush();
    }

    public Map<K, V> getAll(Set<K> keys) {
        Set<byte[]> sk = this.serializeKeySet(keys);
        Map bm = this.m.getAll(sk);
        HashMap<K, V> dsm = new HashMap<K, V>(bm.size());
        for (Map.Entry e : bm.entrySet()) {
            dsm.put(this.deserializeKey((byte[])e.getKey()), this.deserializeVal((byte[])e.getValue()));
        }
        return dsm;
    }

    public void loadAll(boolean replaceExistingValues) {
        this.m.loadAll(replaceExistingValues);
    }

    public void loadAll(Set<K> keys, boolean replaceExistingValues) {
        Set<byte[]> sk = this.serializeKeySet(keys);
        this.m.loadAll(sk, replaceExistingValues);
    }

    public void clear() {
        this.m.clear();
    }

    public Future<V> getAsync(K key) {
        Future f = this.m.getAsync((Object)this.serializeKey(key));
        return Futures.lazyTransform((Future)f, (Function)new DeserializeVal());
    }

    public Future<V> putAsync(K key, V value) {
        Future f = this.m.putAsync((Object)this.serializeKey(key), (Object)this.serializeVal(value));
        return Futures.lazyTransform((Future)f, (Function)new DeserializeVal());
    }

    public Future<V> putAsync(K key, V value, long ttl, TimeUnit timeunit) {
        Future f = this.m.putAsync((Object)this.serializeKey(key), (Object)this.serializeVal(value), ttl, timeunit);
        return Futures.lazyTransform((Future)f, (Function)new DeserializeVal());
    }

    public Future<V> removeAsync(K key) {
        Future f = this.m.removeAsync((Object)this.serializeKey(key));
        return Futures.lazyTransform((Future)f, (Function)new DeserializeVal());
    }

    public boolean tryRemove(K key, long timeout, TimeUnit timeunit) {
        return this.m.tryRemove((Object)this.serializeKey(key), timeout, timeunit);
    }

    public boolean tryPut(K key, V value, long timeout, TimeUnit timeunit) {
        return this.m.tryPut((Object)this.serializeKey(key), (Object)this.serializeVal(value), timeout, timeunit);
    }

    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        return this.deserializeVal((byte[])this.m.put((Object)this.serializeKey(key), (Object)this.serializeVal(value), ttl, timeunit));
    }

    public void putTransient(K key, V value, long ttl, TimeUnit timeunit) {
        this.m.putTransient((Object)this.serializeKey(key), (Object)this.serializeVal(value), ttl, timeunit);
    }

    public V putIfAbsent(K key, V value) {
        return this.deserializeVal((byte[])this.m.putIfAbsent((Object)this.serializeKey(key), (Object)this.serializeVal(value)));
    }

    public V putIfAbsent(K key, V value, long ttl, TimeUnit timeunit) {
        return this.deserializeVal((byte[])this.m.putIfAbsent((Object)this.serializeKey(key), (Object)this.serializeVal(value), ttl, timeunit));
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.m.replace((Object)this.serializeKey(key), (Object)this.serializeVal(oldValue), (Object)this.serializeVal(newValue));
    }

    public V replace(K key, V value) {
        return this.deserializeVal((byte[])this.m.replace((Object)this.serializeKey(key), (Object)this.serializeVal(value)));
    }

    public void set(K key, V value) {
        this.m.set((Object)this.serializeKey(key), (Object)this.serializeVal(value));
    }

    public void set(K key, V value, long ttl, TimeUnit timeunit) {
        this.m.set((Object)this.serializeKey(key), (Object)this.serializeVal(value), ttl, timeunit);
    }

    public void lock(K key) {
        this.m.lock((Object)this.serializeKey(key));
    }

    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        this.m.lock((Object)this.serializeKey(key), leaseTime, timeUnit);
    }

    public boolean isLocked(K key) {
        return this.m.isLocked((Object)this.serializeKey(key));
    }

    public boolean tryLock(K key) {
        return this.m.tryLock((Object)this.serializeKey(key));
    }

    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        return this.m.tryLock((Object)this.serializeKey(key), time, timeunit);
    }

    public void unlock(K key) {
        this.m.unlock((Object)this.serializeKey(key));
    }

    public void forceUnlock(K key) {
        this.m.forceUnlock((Object)this.serializeKey(key));
    }

    public String addLocalEntryListener(EntryListener<K, V> listener) {
        return this.m.addLocalEntryListener((EntryListener)new BaseEntryListener(listener));
    }

    @Deprecated
    public String addLocalEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, boolean includeValue) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String addLocalEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String addInterceptor(MapInterceptor interceptor) {
        throw new UnsupportedOperationException();
    }

    public void removeInterceptor(String id) {
        this.m.removeInterceptor(id);
    }

    public String addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        return this.m.addEntryListener((EntryListener)new BaseEntryListener(listener), includeValue);
    }

    public boolean removeEntryListener(String id) {
        return this.m.removeEntryListener(id);
    }

    public String addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        return this.m.addEntryListener((EntryListener)new BaseEntryListener(listener), (Object)this.serializeKey(key), includeValue);
    }

    @Deprecated
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, boolean includeValue) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public EntryView<K, V> getEntryView(K key) {
        throw new UnsupportedOperationException();
    }

    public boolean evict(K key) {
        return this.m.evict((Object)this.serializeKey(key));
    }

    public void evictAll() {
        this.m.evictAll();
    }

    public Set<K> keySet() {
        return this.deserializeKeySet(this.m.keySet());
    }

    public Collection<V> values() {
        return this.deserializeVal(this.m.values());
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.deserializeEntrySet(this.m.entrySet());
    }

    @Deprecated
    public Set<K> keySet(Predicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Collection<V> values(Predicate predicate) {
        throw new UnsupportedOperationException();
    }

    public Set<K> localKeySet() {
        return this.deserializeKeySet(this.m.localKeySet());
    }

    @Deprecated
    public Set<K> localKeySet(Predicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void addIndex(String attribute, boolean ordered) {
        throw new UnsupportedOperationException();
    }

    public LocalMapStats getLocalMapStats() {
        return this.m.getLocalMapStats();
    }

    @Deprecated
    public Object executeOnKey(K key, EntryProcessor entryProcessor) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Map<K, Object> executeOnKeys(Set<K> keys, EntryProcessor entryProcessor) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void submitToKey(K key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Future submitToKey(K key, EntryProcessor entryProcessor) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor, Predicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
        throw new UnsupportedOperationException();
    }

    private byte[] serializeKey(Object key) {
        return this.serializer.encode(key);
    }

    private K deserializeKey(byte[] key) {
        return (K)this.serializer.decode(key);
    }

    private byte[] serializeVal(Object val) {
        return this.serializer.encode(val);
    }

    private V deserializeVal(byte[] val) {
        if (val == null) {
            return null;
        }
        return (V)this.serializer.decode((byte[])val.clone());
    }

    private Set<byte[]> serializeKeySet(Set<K> keys) {
        Set<byte[]> sk = Collections.newSetFromMap(new IdentityHashMap(keys.size()));
        for (K key : keys) {
            sk.add(this.serializeKey(key));
        }
        return sk;
    }

    private Set<K> deserializeKeySet(Set<byte[]> keys) {
        HashSet<K> dsk = new HashSet<K>(keys.size());
        for (byte[] key : keys) {
            dsk.add(this.deserializeKey(key));
        }
        return dsk;
    }

    private Collection<V> deserializeVal(Collection<byte[]> vals) {
        ArrayList<V> dsl = new ArrayList<V>(vals.size());
        for (byte[] val : vals) {
            dsl.add(this.deserializeVal(val));
        }
        return dsl;
    }

    private Set<Map.Entry<K, V>> deserializeEntrySet(Set<Map.Entry<byte[], byte[]>> entries) {
        HashSet<Map.Entry<K, V>> dse = new HashSet<Map.Entry<K, V>>(entries.size());
        for (Map.Entry<byte[], byte[]> entry : entries) {
            dse.add((Map.Entry<K, V>)Pair.of(this.deserializeKey(entry.getKey()), this.deserializeVal(entry.getValue())));
        }
        return dse;
    }

    private final class DeserializeVal
    implements Function<byte[], V> {
        private DeserializeVal() {
        }

        public V apply(byte[] input) {
            return SMap.this.deserializeVal(input);
        }
    }

    private final class BaseEntryListener
    implements EntryListener<byte[], byte[]> {
        private final EntryListener<K, V> listener;

        public BaseEntryListener(EntryListener<K, V> listener) {
            this.listener = listener;
        }

        public void mapEvicted(MapEvent event) {
            this.listener.mapEvicted(event);
        }

        public void mapCleared(MapEvent event) {
            this.listener.mapCleared(event);
        }

        public void entryUpdated(EntryEvent<byte[], byte[]> event) {
            EntryEvent evt = new EntryEvent(event.getSource(), event.getMember(), event.getEventType().getType(), SMap.this.deserializeKey((byte[])event.getKey()), SMap.this.deserializeVal((byte[])event.getOldValue()), SMap.this.deserializeVal((byte[])event.getValue()));
            this.listener.entryUpdated(evt);
        }

        public void entryRemoved(EntryEvent<byte[], byte[]> event) {
            EntryEvent evt = new EntryEvent(event.getSource(), event.getMember(), event.getEventType().getType(), SMap.this.deserializeKey((byte[])event.getKey()), SMap.this.deserializeVal((byte[])event.getOldValue()), null);
            this.listener.entryRemoved(evt);
        }

        public void entryEvicted(EntryEvent<byte[], byte[]> event) {
            EntryEvent evt = new EntryEvent(event.getSource(), event.getMember(), event.getEventType().getType(), SMap.this.deserializeKey((byte[])event.getKey()), SMap.this.deserializeVal((byte[])event.getOldValue()), SMap.this.deserializeVal((byte[])event.getValue()));
            this.listener.entryEvicted(evt);
        }

        public void entryAdded(EntryEvent<byte[], byte[]> event) {
            EntryEvent evt = new EntryEvent(event.getSource(), event.getMember(), event.getEventType().getType(), SMap.this.deserializeKey((byte[])event.getKey()), null, SMap.this.deserializeVal((byte[])event.getValue()));
            this.listener.entryAdded(evt);
        }
    }
}

