/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.hz;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.monitor.LocalQueueStats;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.onosproject.store.serializers.StoreSerializer;

public class SQueue<T>
implements IQueue<T> {
    private final IQueue<byte[]> q;
    private final StoreSerializer serializer;

    public SQueue(IQueue<byte[]> baseQueue, StoreSerializer serializer) {
        this.q = (IQueue)Preconditions.checkNotNull(baseQueue);
        this.serializer = (StoreSerializer)Preconditions.checkNotNull((Object)serializer);
    }

    private byte[] serialize(Object key) {
        return this.serializer.encode(key);
    }

    private T deserialize(byte[] key) {
        return (T)this.serializer.decode(key);
    }

    public boolean add(T t) {
        return this.q.add((Object)this.serialize(t));
    }

    public boolean offer(T t) {
        return this.q.offer((Object)this.serialize(t));
    }

    public void put(T t) throws InterruptedException {
        this.q.put((Object)this.serialize(t));
    }

    public boolean offer(T t, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.q.offer((Object)this.serialize(t), l, timeUnit);
    }

    public T take() throws InterruptedException {
        return this.deserialize((byte[])this.q.take());
    }

    public T poll(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.deserialize((byte[])this.q.poll(l, timeUnit));
    }

    public int remainingCapacity() {
        return this.q.remainingCapacity();
    }

    public boolean remove(Object o) {
        return this.q.remove((Object)this.serialize(o));
    }

    public boolean contains(Object o) {
        return this.q.contains((Object)this.serialize(o));
    }

    @Deprecated
    public int drainTo(Collection<? super T> collection) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int drainTo(Collection<? super T> collection, int i) {
        throw new UnsupportedOperationException();
    }

    public T remove() {
        return this.deserialize((byte[])this.q.remove());
    }

    public T poll() {
        return this.deserialize((byte[])this.q.poll());
    }

    public T element() {
        return this.deserialize((byte[])this.q.element());
    }

    public T peek() {
        return this.deserialize((byte[])this.q.peek());
    }

    public int size() {
        return this.q.size();
    }

    public boolean isEmpty() {
        return this.q.isEmpty();
    }

    public Iterator<T> iterator() {
        return FluentIterable.from(this.q).transform((Function)new DeserializeVal()).iterator();
    }

    @Deprecated
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public <T1> T1[] toArray(T1[] t1s) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.q.clear();
    }

    public LocalQueueStats getLocalQueueStats() {
        return this.q.getLocalQueueStats();
    }

    public String addItemListener(final ItemListener<T> itemListener, boolean withValue) {
        ItemListener<byte[]> il = new ItemListener<byte[]>(){

            public void itemAdded(ItemEvent<byte[]> item) {
                itemListener.itemAdded(new ItemEvent(this.getName(item), item.getEventType(), SQueue.this.deserialize((byte[])item.getItem()), item.getMember()));
            }

            public void itemRemoved(ItemEvent<byte[]> item) {
                itemListener.itemRemoved(new ItemEvent(this.getName(item), item.getEventType(), SQueue.this.deserialize((byte[])item.getItem()), item.getMember()));
            }

            private String getName(ItemEvent<byte[]> item) {
                return item.getSource() instanceof String ? (String)item.getSource() : item.getSource().toString();
            }
        };
        return this.q.addItemListener((ItemListener)il, withValue);
    }

    public boolean removeItemListener(String registrationId) {
        return this.q.removeItemListener(registrationId);
    }

    @Deprecated
    public Object getId() {
        return this.q.getId();
    }

    public String getPartitionKey() {
        return this.q.getPartitionKey();
    }

    public String getName() {
        return this.q.getName();
    }

    public String getServiceName() {
        return this.q.getServiceName();
    }

    public void destroy() {
        this.q.destroy();
    }

    private final class DeserializeVal
    implements Function<byte[], T> {
        private DeserializeVal() {
        }

        public T apply(byte[] input) {
            return SQueue.this.deserialize(input);
        }
    }
}

