/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.hz;

import com.google.common.base.Preconditions;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.query.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.onosproject.store.serializers.StoreSerializer;

public class STxMap<K, V>
implements TransactionalMap<K, V> {
    private final TransactionalMap<byte[], byte[]> m;
    private final StoreSerializer serializer;

    public STxMap(TransactionalMap<byte[], byte[]> baseMap, StoreSerializer serializer) {
        this.m = (TransactionalMap)Preconditions.checkNotNull(baseMap);
        this.serializer = (StoreSerializer)Preconditions.checkNotNull((Object)serializer);
    }

    public int size() {
        return this.m.size();
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Deprecated
    public Object getId() {
        return this.m.getId();
    }

    public String getPartitionKey() {
        return this.m.getPartitionKey();
    }

    public String getName() {
        return this.m.getName();
    }

    public String getServiceName() {
        return this.m.getServiceName();
    }

    public void destroy() {
        this.m.destroy();
    }

    public boolean containsKey(Object key) {
        return this.m.containsKey((Object)this.serializeKey(key));
    }

    public V get(Object key) {
        return this.deserializeVal((byte[])this.m.get((Object)this.serializeKey(key)));
    }

    public V getForUpdate(Object key) {
        return this.deserializeVal((byte[])this.m.getForUpdate((Object)this.serializeKey(key)));
    }

    public V put(K key, V value) {
        return this.deserializeVal((byte[])this.m.put((Object)this.serializeKey(key), (Object)this.serializeVal(value)));
    }

    public V remove(Object key) {
        return this.deserializeVal((byte[])this.m.remove((Object)this.serializeKey(key)));
    }

    public boolean remove(Object key, Object value) {
        return this.m.remove((Object)this.serializeKey(key), (Object)this.serializeVal(value));
    }

    public void delete(Object key) {
        this.m.delete((Object)this.serializeKey(key));
    }

    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        return this.deserializeVal((byte[])this.m.put((Object)this.serializeKey(key), (Object)this.serializeVal(value), ttl, timeunit));
    }

    public V putIfAbsent(K key, V value) {
        return this.deserializeVal((byte[])this.m.putIfAbsent((Object)this.serializeKey(key), (Object)this.serializeVal(value)));
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.m.replace((Object)this.serializeKey(key), (Object)this.serializeVal(oldValue), (Object)this.serializeVal(newValue));
    }

    public V replace(K key, V value) {
        return this.deserializeVal((byte[])this.m.replace((Object)this.serializeKey(key), (Object)this.serializeVal(value)));
    }

    public void set(K key, V value) {
        this.m.set((Object)this.serializeKey(key), (Object)this.serializeVal(value));
    }

    public Set<K> keySet() {
        return this.deserializeKeySet(this.m.keySet());
    }

    public Collection<V> values() {
        return this.deserializeVals(this.m.values());
    }

    @Deprecated
    public Set<K> keySet(Predicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Collection<V> values(Predicate predicate) {
        throw new UnsupportedOperationException();
    }

    private byte[] serializeKey(Object key) {
        return this.serializer.encode(key);
    }

    private K deserializeKey(byte[] key) {
        return (K)this.serializer.decode(key);
    }

    private byte[] serializeVal(Object val) {
        return this.serializer.encode(val);
    }

    private V deserializeVal(byte[] val) {
        if (val == null) {
            return null;
        }
        return (V)this.serializer.decode((byte[])val.clone());
    }

    private Set<K> deserializeKeySet(Set<byte[]> keys) {
        HashSet<K> dsk = new HashSet<K>(keys.size());
        for (byte[] key : keys) {
            dsk.add(this.deserializeKey(key));
        }
        return dsk;
    }

    private Collection<V> deserializeVals(Collection<byte[]> vals) {
        ArrayList<V> dsl = new ArrayList<V>(vals.size());
        for (byte[] val : vals) {
            dsl.add(this.deserializeVal(val));
        }
        return dsl;
    }
}

