/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.store.Timestamp;

public final class Timestamped<T> {
    private final Timestamp timestamp;
    private final T value;

    public Timestamped(T value, Timestamp timestamp) {
        this.value = Preconditions.checkNotNull(value);
        this.timestamp = (Timestamp)Preconditions.checkNotNull((Object)timestamp);
    }

    public T value() {
        return this.value;
    }

    public Timestamp timestamp() {
        return this.timestamp;
    }

    public boolean isNewer(Timestamped<T> other) {
        return this.isNewer(((Timestamped)Preconditions.checkNotNull(other)).timestamp());
    }

    public boolean isNewer(Timestamp other) {
        return this.timestamp.compareTo(Preconditions.checkNotNull((Object)other)) > 0;
    }

    public int hashCode() {
        return this.timestamp.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Timestamped)) {
            return false;
        }
        Timestamped that = (Timestamped)obj;
        return Objects.equals(this.timestamp, that.timestamp);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("timestamp", (Object)this.timestamp).add("value", this.value).toString();
    }

    @Deprecated
    private Timestamped() {
        this.value = null;
        this.timestamp = null;
    }
}

