/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.intent.impl;

import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.metrics.MetricsService;
import org.onlab.metrics.MetricsUtil;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.MetricsHelper;
import org.onosproject.event.Event;
import org.onosproject.net.intent.BatchWrite;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.IntentStore;
import org.onosproject.net.intent.IntentStoreDelegate;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.KryoSerializer;
import org.onosproject.store.serializers.StoreSerializer;
import org.onosproject.store.service.BatchWriteRequest;
import org.onosproject.store.service.BatchWriteResult;
import org.onosproject.store.service.DatabaseAdminService;
import org.onosproject.store.service.DatabaseService;
import org.onosproject.store.service.impl.CMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=false)
@Service
public class DistributedIntentStore
extends AbstractStore<IntentEvent, IntentStoreDelegate>
implements IntentStore,
MetricsHelper {
    private static final Set<IntentState> PRE_INSTALLED = EnumSet.of(IntentState.INSTALL_REQ, IntentState.INSTALLED, IntentState.FAILED);
    private static final Set<IntentState> PRE_WITHDRAWN = EnumSet.of(IntentState.INSTALLED, IntentState.FAILED);
    private static final Set<IntentState> PARKING = EnumSet.of(IntentState.INSTALL_REQ, IntentState.INSTALLED, IntentState.WITHDRAWN, IntentState.FAILED);
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String INTENTS_TABLE = "intents";
    private CMap<IntentId, Intent> intents;
    private static final String STATES_TABLE = "intent-states";
    private CMap<IntentId, IntentState> states;
    private transient Map<IntentId, IntentState> transientStates = new ConcurrentHashMap<IntentId, IntentState>();
    private static final String INSTALLABLE_TABLE = "installable-intents";
    private CMap<IntentId, List<Intent>> installable;
    private LoadingCache<IntentId, String> keyCache;
    private StoreSerializer serializer;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DatabaseAdminService dbAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DatabaseService dbService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MetricsService metricsService;
    private boolean onlyLogTransitionError = true;
    private Timer createIntentTimer;
    private Timer removeIntentTimer;
    private Timer setInstallableIntentsTimer;
    private Timer getInstallableIntentsTimer;
    private Timer removeInstalledIntentsTimer;
    private Timer setStateTimer;
    private Timer getIntentCountTimer;
    private Timer getIntentsTimer;
    private Timer getIntentTimer;
    private Timer getIntentStateTimer;

    private Timer createResponseTimer(String methodName) {
        return this.createTimer("IntentStore", methodName, "responseTime");
    }

    @Activate
    public void activate() {
        this.createIntentTimer = this.createResponseTimer("createIntent");
        this.removeIntentTimer = this.createResponseTimer("removeIntent");
        this.setInstallableIntentsTimer = this.createResponseTimer("setInstallableIntents");
        this.getInstallableIntentsTimer = this.createResponseTimer("getInstallableIntents");
        this.removeInstalledIntentsTimer = this.createResponseTimer("removeInstalledIntents");
        this.setStateTimer = this.createResponseTimer("setState");
        this.getIntentCountTimer = this.createResponseTimer("getIntentCount");
        this.getIntentsTimer = this.createResponseTimer("getIntents");
        this.getIntentTimer = this.createResponseTimer("getIntent");
        this.getIntentStateTimer = this.createResponseTimer("getIntentState");
        this.serializer = new KryoSerializer(){

            protected void setupKryoPool() {
                this.serializerPool = KryoNamespace.newBuilder().setRegistrationRequired(false).register(KryoNamespaces.API).nextId(300).build();
            }
        };
        this.keyCache = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<IntentId, String>(){

            public String load(IntentId key) {
                return key.toString();
            }
        });
        this.intents = new IntentIdMap<Intent>(this.dbAdminService, this.dbService, INTENTS_TABLE, this.serializer);
        this.states = new IntentIdMap<IntentState>(this.dbAdminService, this.dbService, STATES_TABLE, this.serializer);
        this.transientStates.clear();
        this.installable = new IntentIdMap<List<Intent>>(this.dbAdminService, this.dbService, INSTALLABLE_TABLE, this.serializer);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public MetricsService metricsService() {
        return this.metricsService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIntent(Intent intent) {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.createIntentTimer);
        try {
            boolean absent = this.intents.putIfAbsent(intent.id(), intent);
            if (!absent) {
                return;
            }
            this.setState(intent, IntentState.INSTALL_REQ);
            return;
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    public void removeIntent(IntentId intentId) {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.removeIntentTimer);
        Preconditions.checkState((this.getIntentState(intentId) == IntentState.WITHDRAWN ? 1 : 0) != 0, (String)"Intent state for {} is not WITHDRAWN.", (Object[])new Object[]{intentId});
        try {
            this.intents.remove(intentId);
            this.states.remove(intentId);
            this.transientStates.remove(intentId);
            this.installable.remove(intentId);
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getIntentCount() {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.getIntentCountTimer);
        try {
            long l = this.intents.size();
            return l;
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    public Iterable<Intent> getIntents() {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.getIntentsTimer);
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(this.intents.values());
            return immutableSet;
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Intent getIntent(IntentId intentId) {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.getIntentTimer);
        try {
            Intent intent = this.intents.get(intentId);
            return intent;
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntentState getIntentState(IntentId id) {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.getIntentStateTimer);
        try {
            IntentState localState = this.transientStates.get(id);
            if (localState != null) {
                IntentState intentState = localState;
                return intentState;
            }
            IntentState intentState = this.states.get(id);
            return intentState;
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    private void verify(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (this.onlyLogTransitionError) {
            if (!expression) {
                this.log.error(errorMessageTemplate.replace("%s", "{}"), errorMessageArgs);
            }
        } else {
            Verify.verify((boolean)expression, (String)errorMessageTemplate, (Object[])errorMessageArgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(Intent intent, IntentState state) {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.setStateTimer);
        try {
            IntentState prevParking;
            IntentId id = intent.id();
            IntentEvent.Type evtType = null;
            boolean transitionedToParking = true;
            switch (state) {
                case INSTALL_REQ: {
                    prevParking = this.states.get(id);
                    if (prevParking == null) {
                        boolean updated = this.states.putIfAbsent(id, IntentState.INSTALL_REQ);
                        this.verify(updated, "Conditional replace %s => %s failed", prevParking, IntentState.INSTALL_REQ);
                    } else {
                        this.verify(prevParking == IntentState.WITHDRAWN, "Illegal state transition attempted from %s to INSTALL_REQ", prevParking);
                        boolean updated = this.states.replace(id, prevParking, IntentState.INSTALL_REQ);
                        this.verify(updated, "Conditional replace %s => %s failed", prevParking, IntentState.INSTALL_REQ);
                    }
                    evtType = IntentEvent.Type.INSTALL_REQ;
                    break;
                }
                case INSTALLED: {
                    prevParking = this.states.get(id);
                    this.verify(PRE_INSTALLED.contains(prevParking), "Illegal state transition attempted from %s to INSTALLED", prevParking);
                    boolean updated = this.states.replace(id, prevParking, IntentState.INSTALLED);
                    this.verify(updated, "Conditional replace %s => %s failed", prevParking, IntentState.INSTALLED);
                    evtType = IntentEvent.Type.INSTALLED;
                    break;
                }
                case FAILED: {
                    prevParking = this.states.get(id);
                    boolean updated = this.states.replace(id, prevParking, IntentState.FAILED);
                    this.verify(updated, "Conditional replace %s => %s failed", prevParking, IntentState.FAILED);
                    evtType = IntentEvent.Type.FAILED;
                    break;
                }
                case WITHDRAWN: {
                    prevParking = this.states.get(id);
                    this.verify(PRE_WITHDRAWN.contains(prevParking), "Illegal state transition attempted from %s to WITHDRAWN", prevParking);
                    boolean updated = this.states.replace(id, prevParking, IntentState.WITHDRAWN);
                    this.verify(updated, "Conditional replace %s => %s failed", prevParking, IntentState.WITHDRAWN);
                    evtType = IntentEvent.Type.WITHDRAWN;
                    break;
                }
                default: {
                    transitionedToParking = false;
                    prevParking = null;
                }
            }
            if (transitionedToParking) {
                this.log.debug("Parking State change: {} {}=>{}", new Object[]{id, prevParking, state});
                this.transientStates.remove(id);
            } else {
                IntentState prevTransient = this.transientStates.put(id, state);
                this.log.debug("Transient State change: {} {}=>{}", new Object[]{id, prevTransient, state});
            }
            if (evtType != null) {
                this.notifyDelegate((Event)new IntentEvent(evtType, intent));
            }
            return;
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstallableIntents(IntentId intentId, List<Intent> result) {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.setInstallableIntentsTimer);
        try {
            this.installable.put(intentId, result);
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Intent> getInstallableIntents(IntentId intentId) {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.getInstallableIntentsTimer);
        try {
            List<Intent> list = this.installable.get(intentId);
            return list;
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    public void removeInstalledIntents(IntentId intentId) {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.removeInstalledIntentsTimer);
        try {
            this.installable.remove(intentId);
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    protected String strIntentId(IntentId key) {
        return (String)this.keyCache.getUnchecked((Object)key);
    }

    public List<BatchWrite.Operation> batchWrite(BatchWrite batch) {
        ArrayList<BatchWrite.Operation> failed = new ArrayList<BatchWrite.Operation>();
        BatchWriteRequest.Builder builder = BatchWriteRequest.newBuilder();
        ArrayList events = Lists.newArrayList();
        HashSet<IntentId> transitionedToParking = new HashSet<IntentId>();
        block7: for (BatchWrite.Operation op : batch.operations()) {
            switch (op.type()) {
                case CREATE_INTENT: {
                    Preconditions.checkArgument((op.args().size() == 1 ? 1 : 0) != 0, (String)"CREATE_INTENT takes 1 argument. %s", (Object[])new Object[]{op});
                    Intent intent = (Intent)op.arg(0);
                    builder.putIfAbsent(INTENTS_TABLE, this.strIntentId(intent.id()), this.serializer.encode((Object)intent));
                    builder.putIfAbsent(STATES_TABLE, this.strIntentId(intent.id()), this.serializer.encode((Object)IntentState.INSTALL_REQ));
                    events.add(IntentEvent.getEvent((IntentState)IntentState.INSTALL_REQ, (Intent)intent));
                    continue block7;
                }
                case REMOVE_INTENT: {
                    Preconditions.checkArgument((op.args().size() == 1 ? 1 : 0) != 0, (String)"REMOVE_INTENT takes 1 argument. %s", (Object[])new Object[]{op});
                    IntentId intentId2 = (IntentId)op.arg(0);
                    builder.remove(INTENTS_TABLE, this.strIntentId(intentId2));
                    builder.remove(STATES_TABLE, this.strIntentId(intentId2));
                    builder.remove(INSTALLABLE_TABLE, this.strIntentId(intentId2));
                    continue block7;
                }
                case SET_STATE: {
                    Preconditions.checkArgument((op.args().size() == 2 ? 1 : 0) != 0, (String)"SET_STATE takes 2 arguments. %s", (Object[])new Object[]{op});
                    Intent intent = (Intent)op.arg(0);
                    IntentState newState = (IntentState)op.arg(1);
                    builder.put(STATES_TABLE, this.strIntentId(intent.id()), this.serializer.encode((Object)newState));
                    if (PARKING.contains(newState)) {
                        transitionedToParking.add(intent.id());
                        events.add(IntentEvent.getEvent((IntentState)newState, (Intent)intent));
                        continue block7;
                    }
                    transitionedToParking.remove(intent.id());
                    continue block7;
                }
                case SET_INSTALLABLE: {
                    Preconditions.checkArgument((op.args().size() == 2 ? 1 : 0) != 0, (String)"SET_INSTALLABLE takes 2 arguments. %s", (Object[])new Object[]{op});
                    IntentId intentId2 = (IntentId)op.arg(0);
                    List installableIntents = (List)op.arg(1);
                    builder.put(INSTALLABLE_TABLE, this.strIntentId(intentId2), this.serializer.encode((Object)installableIntents));
                    continue block7;
                }
                case REMOVE_INSTALLED: {
                    Preconditions.checkArgument((op.args().size() == 1 ? 1 : 0) != 0, (String)"REMOVE_INSTALLED takes 1 argument. %s", (Object[])new Object[]{op});
                    IntentId intentId2 = (IntentId)op.arg(0);
                    builder.remove(INSTALLABLE_TABLE, this.strIntentId(intentId2));
                    continue block7;
                }
            }
            this.log.warn("Unknown Operation encountered: {}", (Object)op);
            failed.add(op);
        }
        BatchWriteResult batchWriteResult = this.dbService.batchWrite(builder.build());
        if (batchWriteResult.isSuccessful()) {
            transitionedToParking.forEach(intentId -> this.transientStates.remove(intentId));
            this.notifyDelegate(events);
            return failed;
        }
        return batch.operations();
    }

    protected void bindDbAdminService(DatabaseAdminService databaseAdminService) {
        this.dbAdminService = databaseAdminService;
    }

    protected void unbindDbAdminService(DatabaseAdminService databaseAdminService) {
        if (this.dbAdminService == databaseAdminService) {
            this.dbAdminService = null;
        }
    }

    protected void bindDbService(DatabaseService databaseService) {
        this.dbService = databaseService;
    }

    protected void unbindDbService(DatabaseService databaseService) {
        if (this.dbService == databaseService) {
            this.dbService = null;
        }
    }

    protected void bindMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    protected void unbindMetricsService(MetricsService metricsService) {
        if (this.metricsService == metricsService) {
            this.metricsService = null;
        }
    }

    final class IntentIdMap<V>
    extends CMap<IntentId, V> {
        public IntentIdMap(DatabaseAdminService dbAdminService, DatabaseService dbService, String tableName, StoreSerializer serializer) {
            super(dbAdminService, dbService, tableName, serializer);
        }

        @Override
        protected String sK(IntentId key) {
            return DistributedIntentStore.this.strIntentId(key);
        }
    }
}

