/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.intent.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.AbstractListenerRegistry;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.event.EventListener;
import org.onosproject.net.intent.IntentBatchDelegate;
import org.onosproject.net.intent.IntentBatchLeaderEvent;
import org.onosproject.net.intent.IntentBatchListener;
import org.onosproject.net.intent.IntentBatchService;
import org.onosproject.net.intent.IntentOperations;
import org.onosproject.store.hz.SQueue;
import org.onosproject.store.hz.StoreService;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.KryoSerializer;
import org.onosproject.store.serializers.StoreSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class HazelcastIntentBatchQueue
implements IntentBatchService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String TOPIC_BASE = "intent-batch-";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StoreService storeService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected EventDeliveryService eventDispatcher;
    private HazelcastInstance theInstance;
    private NodeId localControllerNodeId;
    protected StoreSerializer serializer;
    private IntentBatchDelegate delegate;
    private InternalLeaderListener leaderListener = new InternalLeaderListener();
    private final Map<ApplicationId, SQueue<IntentOperations>> batchQueues = Maps.newHashMap();
    private final Set<ApplicationId> myTopics = Sets.newHashSet();
    private final Map<ApplicationId, IntentOperations> outstandingOps = Maps.newHashMap();
    private final AbstractListenerRegistry<IntentBatchLeaderEvent, IntentBatchListener> listenerRegistry = new AbstractListenerRegistry();

    @Activate
    public void activate() {
        this.theInstance = this.storeService.getHazelcastInstance();
        this.localControllerNodeId = this.clusterService.getLocalNode().id();
        this.leadershipService.addListener((LeadershipEventListener)this.leaderListener);
        this.serializer = new KryoSerializer(){

            protected void setupKryoPool() {
                this.serializerPool = KryoNamespace.newBuilder().setRegistrationRequired(false).register(KryoNamespaces.API).nextId(300).build();
            }
        };
        this.eventDispatcher.addSink(IntentBatchLeaderEvent.class, this.listenerRegistry);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.eventDispatcher.removeSink(IntentBatchLeaderEvent.class);
        this.leadershipService.removeListener((LeadershipEventListener)this.leaderListener);
        for (ApplicationId appId : this.batchQueues.keySet()) {
            this.leadershipService.withdraw(HazelcastIntentBatchQueue.getTopic(appId));
        }
        this.log.info("Stopped");
    }

    public static String getTopic(ApplicationId appId) {
        return TOPIC_BASE + Preconditions.checkNotNull((Object)appId.id());
    }

    public ApplicationId getAppId(String topic) {
        Preconditions.checkState((boolean)topic.startsWith(TOPIC_BASE), (String)"Trying to get app id for invalid topic: {}", (Object[])new Object[]{topic});
        Short id = Short.parseShort(topic.substring(TOPIC_BASE.length()));
        return this.coreService.getAppId(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQueue<IntentOperations> getQueue(ApplicationId appId) {
        SQueue<Object> queue = this.batchQueues.get(appId);
        if (queue == null) {
            HazelcastIntentBatchQueue hazelcastIntentBatchQueue = this;
            synchronized (hazelcastIntentBatchQueue) {
                String topic = HazelcastIntentBatchQueue.getTopic(appId);
                IQueue rawQueue = this.theInstance.getQueue(topic);
                queue = new SQueue((IQueue<byte[]>)rawQueue, this.serializer);
                queue.addItemListener(new InternalItemListener(appId), false);
                this.batchQueues.putIfAbsent(appId, queue);
                this.leadershipService.runForLeadership(topic);
            }
        }
        return queue;
    }

    public void addIntentOperations(IntentOperations ops) {
        Preconditions.checkNotNull((Object)ops, (Object)"Intent operations cannot be null.");
        ApplicationId appId = ops.appId();
        this.getQueue(appId).add(ops);
        this.dispatchNextOperation(appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIntentOperations(IntentOperations ops) {
        ApplicationId appId = ops.appId();
        HazelcastIntentBatchQueue hazelcastIntentBatchQueue = this;
        synchronized (hazelcastIntentBatchQueue) {
            IntentOperations outstanding = this.outstandingOps.get(appId);
            if (outstanding != null) {
                Preconditions.checkState((boolean)Objects.equals(ops, outstanding), (String)"Operation {} does not match outstanding operation {}", (Object[])new Object[]{ops, outstanding});
            } else {
                this.log.warn("Operation {} not found", (Object)ops);
            }
            SQueue<IntentOperations> queue = this.batchQueues.get(appId);
            Preconditions.checkState((boolean)queue.remove().equals((Object)ops), (Object)"Operations are wrong.");
            this.outstandingOps.remove(appId);
            this.dispatchNextOperation(appId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchNextOperation(ApplicationId appId) {
        HazelcastIntentBatchQueue hazelcastIntentBatchQueue = this;
        synchronized (hazelcastIntentBatchQueue) {
            if (!this.myTopics.contains(appId) || this.outstandingOps.containsKey(appId)) {
                return;
            }
            IntentOperations ops = this.batchQueues.get(appId).peek();
            if (ops != null) {
                this.outstandingOps.put(appId, ops);
                this.delegate.execute(ops);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaderChanged(String topic, boolean leader) {
        ApplicationId appId = this.getAppId(topic);
        HazelcastIntentBatchQueue hazelcastIntentBatchQueue = this;
        synchronized (hazelcastIntentBatchQueue) {
            if (leader) {
                this.myTopics.add(appId);
                Preconditions.checkState((!this.outstandingOps.containsKey(appId) ? 1 : 0) != 0, (String)"Existing intent ops for app id: {}", (Object[])new Object[]{appId});
                this.dispatchNextOperation(appId);
            } else {
                this.myTopics.remove(appId);
                IntentOperations ops = this.outstandingOps.get(appId);
                if (ops != null) {
                    this.delegate.cancel(ops);
                }
                this.outstandingOps.remove(appId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IntentOperations> getPendingOperations() {
        HashSet ops = Sets.newHashSet();
        HazelcastIntentBatchQueue hazelcastIntentBatchQueue = this;
        synchronized (hazelcastIntentBatchQueue) {
            for (SQueue<IntentOperations> queue : this.batchQueues.values()) {
                ops.addAll(queue);
            }
            return ops;
        }
    }

    public boolean isLocalLeader(ApplicationId applicationId) {
        return this.myTopics.contains(applicationId);
    }

    public void setDelegate(IntentBatchDelegate delegate) {
        this.delegate = (IntentBatchDelegate)Preconditions.checkNotNull((Object)delegate, (Object)"Delegate cannot be null");
    }

    public void unsetDelegate(IntentBatchDelegate delegate) {
        if (this.delegate != null && this.delegate.equals(delegate)) {
            this.delegate = null;
        }
    }

    public void addListener(IntentBatchListener listener) {
        this.listenerRegistry.addListener((EventListener)listener);
    }

    public void removeListener(IntentBatchListener listener) {
        this.listenerRegistry.removeListener((EventListener)listener);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindLeadershipService(LeadershipService leadershipService) {
        this.leadershipService = leadershipService;
    }

    protected void unbindLeadershipService(LeadershipService leadershipService) {
        if (this.leadershipService == leadershipService) {
            this.leadershipService = null;
        }
    }

    protected void bindStoreService(StoreService storeService) {
        this.storeService = storeService;
    }

    protected void unbindStoreService(StoreService storeService) {
        if (this.storeService == storeService) {
            this.storeService = null;
        }
    }

    protected void bindEventDispatcher(EventDeliveryService eventDeliveryService) {
        this.eventDispatcher = eventDeliveryService;
    }

    protected void unbindEventDispatcher(EventDeliveryService eventDeliveryService) {
        if (this.eventDispatcher == eventDeliveryService) {
            this.eventDispatcher = null;
        }
    }

    private class InternalLeaderListener
    implements LeadershipEventListener {
        private InternalLeaderListener() {
        }

        public void event(LeadershipEvent event) {
            HazelcastIntentBatchQueue.this.log.trace("Leadership Event: time = {} type = {} event = {}", new Object[]{event.time(), event.type(), event});
            String topic = ((Leadership)event.subject()).topic();
            if (!topic.startsWith(HazelcastIntentBatchQueue.TOPIC_BASE)) {
                return;
            }
            if (!((Leadership)event.subject()).leader().equals((Object)HazelcastIntentBatchQueue.this.localControllerNodeId)) {
                HazelcastIntentBatchQueue.this.getQueue(HazelcastIntentBatchQueue.this.getAppId(topic));
                return;
            }
            switch ((LeadershipEvent.Type)event.type()) {
                case LEADER_ELECTED: {
                    HazelcastIntentBatchQueue.this.log.info("Elected leader for app {}", (Object)HazelcastIntentBatchQueue.this.getAppId(topic));
                    HazelcastIntentBatchQueue.this.leaderChanged(topic, true);
                    break;
                }
                case LEADER_BOOTED: {
                    HazelcastIntentBatchQueue.this.log.info("Lost leader election for app {}", (Object)HazelcastIntentBatchQueue.this.getAppId(topic));
                    HazelcastIntentBatchQueue.this.leaderChanged(topic, false);
                    break;
                }
                case LEADER_REELECTED: {
                    break;
                }
            }
        }
    }

    private class InternalItemListener
    implements ItemListener<IntentOperations> {
        private final ApplicationId appId;

        public InternalItemListener(ApplicationId appId) {
            this.appId = appId;
        }

        public void itemAdded(ItemEvent<IntentOperations> item) {
            HazelcastIntentBatchQueue.this.dispatchNextOperation(this.appId);
        }

        public void itemRemoved(ItemEvent<IntentOperations> item) {
        }
    }
}

