/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.intent.impl;

import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.metrics.MetricsService;
import org.onlab.metrics.MetricsUtil;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.MetricsHelper;
import org.onosproject.event.Event;
import org.onosproject.net.intent.BatchWrite;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.IntentStore;
import org.onosproject.net.intent.IntentStoreDelegate;
import org.onosproject.store.hz.AbstractHazelcastStore;
import org.onosproject.store.hz.SMap;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.KryoSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class HazelcastIntentStore
extends AbstractHazelcastStore<IntentEvent, IntentStoreDelegate>
implements IntentStore,
MetricsHelper {
    private static final Set<IntentState> PRE_INSTALLED = EnumSet.of(IntentState.INSTALL_REQ, IntentState.INSTALLED, IntentState.FAILED);
    private static final Set<IntentState> PRE_WITHDRAWN = EnumSet.of(IntentState.INSTALLED, IntentState.FAILED);
    private static final Set<IntentState> PARKING = EnumSet.of(IntentState.INSTALL_REQ, IntentState.INSTALLED, IntentState.WITHDRAWN, IntentState.FAILED);
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String INTENTS_MAP_NAME = "intents";
    private SMap<IntentId, Intent> intents;
    private static final String INTENT_STATES_MAP_NAME = "intent-states";
    private SMap<IntentId, IntentState> states;
    private transient Map<IntentId, IntentState> transientStates = new ConcurrentHashMap<IntentId, IntentState>();
    private static final String INSTALLABLE_INTENTS_MAP_NAME = "installable-intents";
    private SMap<IntentId, List<Intent>> installable;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MetricsService metricsService;
    private boolean onlyLogTransitionError = true;
    private Timer createIntentTimer;
    private Timer removeIntentTimer;
    private Timer setInstallableIntentsTimer;
    private Timer getInstallableIntentsTimer;
    private Timer removeInstalledIntentsTimer;
    private Timer setStateTimer;
    private Timer getIntentCountTimer;
    private Timer getIntentsTimer;
    private Timer getIntentTimer;
    private Timer getIntentStateTimer;
    private Map<IntentId, Intent> localIntents;
    private String stateListenerId;
    private String intentsListenerId;

    private Timer createResponseTimer(String methodName) {
        return this.createTimer("IntentStore", methodName, "responseTime");
    }

    @Override
    @Activate
    public void activate() {
        this.localIntents = new ConcurrentHashMap<IntentId, Intent>();
        this.createIntentTimer = this.createResponseTimer("createIntent");
        this.removeIntentTimer = this.createResponseTimer("removeIntent");
        this.setInstallableIntentsTimer = this.createResponseTimer("setInstallableIntents");
        this.getInstallableIntentsTimer = this.createResponseTimer("getInstallableIntents");
        this.removeInstalledIntentsTimer = this.createResponseTimer("removeInstalledIntents");
        this.setStateTimer = this.createResponseTimer("setState");
        this.getIntentCountTimer = this.createResponseTimer("getIntentCount");
        this.getIntentsTimer = this.createResponseTimer("getIntents");
        this.getIntentTimer = this.createResponseTimer("getIntent");
        this.getIntentStateTimer = this.createResponseTimer("getIntentState");
        super.activate();
        this.serializer = new KryoSerializer(){

            protected void setupKryoPool() {
                this.serializerPool = KryoNamespace.newBuilder().setRegistrationRequired(false).register(KryoNamespaces.API).nextId(300).build();
            }
        };
        Config config = this.theInstance.getConfig();
        MapConfig intentsCfg = config.getMapConfig(INTENTS_MAP_NAME);
        intentsCfg.setAsyncBackupCount(6 - intentsCfg.getBackupCount());
        IMap rawIntents = this.theInstance.getMap(INTENTS_MAP_NAME);
        this.intents = new SMap((IMap<byte[], byte[]>)rawIntents, this.serializer);
        this.intentsListenerId = this.intents.addEntryListener((EntryListener<IntentId, Intent>)new RemoteIntentsListener(), true);
        MapConfig statesCfg = config.getMapConfig(INTENT_STATES_MAP_NAME);
        statesCfg.setAsyncBackupCount(6 - statesCfg.getBackupCount());
        IMap rawStates = this.theInstance.getMap(INTENT_STATES_MAP_NAME);
        this.states = new SMap((IMap<byte[], byte[]>)rawStates, this.serializer);
        RemoteIntentStateListener listener = new RemoteIntentStateListener();
        this.stateListenerId = this.states.addEntryListener((EntryListener<IntentId, IntentState>)listener, true);
        this.transientStates.clear();
        MapConfig installableCfg = config.getMapConfig(INSTALLABLE_INTENTS_MAP_NAME);
        installableCfg.setAsyncBackupCount(6 - installableCfg.getBackupCount());
        IMap rawInstallables = this.theInstance.getMap(INSTALLABLE_INTENTS_MAP_NAME);
        this.installable = new SMap((IMap<byte[], byte[]>)rawInstallables, this.serializer);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.intents.removeEntryListener(this.intentsListenerId);
        this.states.removeEntryListener(this.stateListenerId);
        this.log.info("Stopped");
    }

    public MetricsService metricsService() {
        return this.metricsService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIntent(Intent intent) {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.createIntentTimer);
        try {
            Intent existing = this.intents.putIfAbsent(intent.id(), intent);
            if (existing != null) {
                return;
            }
            this.setState(intent, IntentState.INSTALL_REQ);
            return;
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    public void removeIntent(IntentId intentId) {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.removeIntentTimer);
        Preconditions.checkState((this.getIntentState(intentId) == IntentState.WITHDRAWN ? 1 : 0) != 0, (String)"Intent state for {} is not WITHDRAWN.", (Object[])new Object[]{intentId});
        try {
            this.intents.remove(intentId);
            this.installable.remove(intentId);
            this.states.remove(intentId);
            this.transientStates.remove(intentId);
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getIntentCount() {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.getIntentCountTimer);
        try {
            long l = this.intents.size();
            return l;
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    public Iterable<Intent> getIntents() {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.getIntentsTimer);
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(this.intents.values());
            return immutableSet;
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Intent getIntent(IntentId intentId) {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.getIntentTimer);
        try {
            Intent intent = this.localIntents.get(intentId);
            if (intent != null) {
                Intent intent2 = intent;
                return intent2;
            }
            intent = this.intents.get(intentId);
            if (intent != null) {
                this.localIntents.put(intentId, intent);
            }
            Intent intent3 = intent;
            return intent3;
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntentState getIntentState(IntentId id) {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.getIntentStateTimer);
        try {
            IntentState localState = this.transientStates.get(id);
            if (localState != null) {
                IntentState intentState = localState;
                return intentState;
            }
            IntentState intentState = this.states.get(id);
            return intentState;
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    private void verify(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (this.onlyLogTransitionError) {
            if (!expression) {
                this.log.error(errorMessageTemplate.replace("%s", "{}"), errorMessageArgs);
            }
        } else {
            Verify.verify((boolean)expression, (String)errorMessageTemplate, (Object[])errorMessageArgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(Intent intent, IntentState state) {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.setStateTimer);
        try {
            IntentState prevParking;
            IntentId id = intent.id();
            IntentEvent.Type type = null;
            boolean transientStateChangeOnly = false;
            switch (state) {
                case INSTALL_REQ: {
                    prevParking = this.states.get(id);
                    if (prevParking == null) {
                        IntentState existing = this.states.putIfAbsent(id, IntentState.INSTALL_REQ);
                        this.verify(existing == null, "Conditional replace %s => %s failed", prevParking, IntentState.INSTALL_REQ);
                    } else {
                        this.verify(PRE_INSTALLED.contains(prevParking), "Illegal state transition attempted from %s to INSTALL_REQ", prevParking);
                        boolean updated = this.states.replace(id, prevParking, IntentState.INSTALL_REQ);
                        this.verify(updated, "Conditional replace %s => %s failed", prevParking, IntentState.INSTALL_REQ);
                    }
                    type = IntentEvent.Type.INSTALL_REQ;
                    break;
                }
                case INSTALLED: {
                    prevParking = this.states.replace(id, IntentState.INSTALLED);
                    this.verify(prevParking == IntentState.INSTALL_REQ, "Illegal state transition attempted from %s to INSTALLED", prevParking);
                    type = IntentEvent.Type.INSTALLED;
                    break;
                }
                case FAILED: {
                    prevParking = this.states.replace(id, IntentState.FAILED);
                    type = IntentEvent.Type.FAILED;
                    break;
                }
                case WITHDRAW_REQ: {
                    prevParking = this.states.replace(id, IntentState.WITHDRAW_REQ);
                    this.verify(PRE_WITHDRAWN.contains(prevParking), "Illegal state transition attempted from %s to WITHDRAW_REQ", prevParking);
                    type = IntentEvent.Type.WITHDRAW_REQ;
                    break;
                }
                case WITHDRAWN: {
                    prevParking = this.states.replace(id, IntentState.WITHDRAWN);
                    this.verify(prevParking == IntentState.WITHDRAW_REQ, "Illegal state transition attempted from %s to WITHDRAWN", prevParking);
                    type = IntentEvent.Type.WITHDRAWN;
                    break;
                }
                default: {
                    transientStateChangeOnly = true;
                    prevParking = null;
                }
            }
            if (!transientStateChangeOnly) {
                this.log.debug("Parking State change: {} {}=>{}", new Object[]{id, prevParking, state});
            }
            IntentState prevTransient = this.transientStates.put(id, state);
            this.log.debug("Transient State change: {} {}=>{}", new Object[]{id, prevTransient, state});
            if (type != null) {
                this.notifyDelegate((Event)new IntentEvent(type, intent));
            }
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstallableIntents(IntentId intentId, List<Intent> result) {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.setInstallableIntentsTimer);
        try {
            this.installable.put(intentId, result);
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Intent> getInstallableIntents(IntentId intentId) {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.getInstallableIntentsTimer);
        try {
            List<Intent> list = this.installable.get(intentId);
            return list;
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    public void removeInstalledIntents(IntentId intentId) {
        Timer.Context timer = MetricsUtil.startTimer((Timer)this.removeInstalledIntentsTimer);
        try {
            this.installable.remove(intentId);
        }
        finally {
            MetricsUtil.stopTimer((Timer.Context)timer);
        }
    }

    public List<BatchWrite.Operation> batchWrite(BatchWrite batch) {
        ArrayList<BatchWrite.Operation> failed = new ArrayList<BatchWrite.Operation>();
        ArrayList futures = new ArrayList(batch.operations().size());
        ArrayList events = Lists.newArrayList();
        this.batchWriteAsync(batch, failed, futures);
        this.verifyAsyncWrites(futures, failed, events);
        this.notifyDelegate(events);
        return failed;
    }

    private void batchWriteAsync(BatchWrite batch, List<BatchWrite.Operation> failed, List<Pair<BatchWrite.Operation, List<Future<?>>>> futures) {
        block7: for (BatchWrite.Operation op : batch.operations()) {
            switch (op.type()) {
                case CREATE_INTENT: {
                    Preconditions.checkArgument((op.args().size() == 1 ? 1 : 0) != 0, (String)"CREATE_INTENT takes 1 argument. %s", (Object[])new Object[]{op});
                    Intent intent = (Intent)op.arg(0);
                    futures.add(Pair.of((Object)op, (Object)ImmutableList.of(this.intents.putAsync(intent.id(), intent), this.states.putAsync(intent.id(), IntentState.INSTALL_REQ))));
                    continue block7;
                }
                case REMOVE_INTENT: {
                    Preconditions.checkArgument((op.args().size() == 1 ? 1 : 0) != 0, (String)"REMOVE_INTENT takes 1 argument. %s", (Object[])new Object[]{op});
                    IntentId intentId = (IntentId)op.arg(0);
                    futures.add(Pair.of((Object)op, (Object)ImmutableList.of(this.intents.removeAsync(intentId), this.states.removeAsync(intentId), this.installable.removeAsync(intentId))));
                    continue block7;
                }
                case SET_STATE: {
                    Preconditions.checkArgument((op.args().size() == 2 ? 1 : 0) != 0, (String)"SET_STATE takes 2 arguments. %s", (Object[])new Object[]{op});
                    Intent intent = (Intent)op.arg(0);
                    IntentState newState = (IntentState)op.arg(1);
                    futures.add(Pair.of((Object)op, (Object)ImmutableList.of(this.states.putAsync(intent.id(), newState))));
                    continue block7;
                }
                case SET_INSTALLABLE: {
                    Preconditions.checkArgument((op.args().size() == 2 ? 1 : 0) != 0, (String)"SET_INSTALLABLE takes 2 arguments. %s", (Object[])new Object[]{op});
                    IntentId intentId = (IntentId)op.arg(0);
                    List installableIntents = (List)op.arg(1);
                    futures.add(Pair.of((Object)op, (Object)ImmutableList.of(this.installable.putAsync(intentId, installableIntents))));
                    continue block7;
                }
                case REMOVE_INSTALLED: {
                    Preconditions.checkArgument((op.args().size() == 1 ? 1 : 0) != 0, (String)"REMOVE_INSTALLED takes 1 argument. %s", (Object[])new Object[]{op});
                    IntentId intentId = (IntentId)op.arg(0);
                    futures.add(Pair.of((Object)op, (Object)ImmutableList.of(this.installable.removeAsync(intentId))));
                    continue block7;
                }
            }
            this.log.warn("Unknown Operation encountered: {}", (Object)op);
            failed.add(op);
        }
    }

    private void verifyAsyncWrites(List<Pair<BatchWrite.Operation, List<Future<?>>>> futures, List<BatchWrite.Operation> failed, List<IntentEvent> events) {
        block22: for (Pair<BatchWrite.Operation, List<Future<?>>> future : futures) {
            BatchWrite.Operation op = (BatchWrite.Operation)future.getLeft();
            List subops = (List)future.getRight();
            switch (op.type()) {
                case CREATE_INTENT: {
                    IntentState prevIntentState;
                    Intent intent = (Intent)op.arg(0);
                    IntentState newIntentState = IntentState.INSTALL_REQ;
                    try {
                        Intent prevIntent = (Intent)((Future)subops.get(0)).get();
                        prevIntentState = (IntentState)((Future)subops.get(1)).get();
                        if (prevIntent != null || prevIntentState != null) {
                            this.log.warn("Overwriting existing Intent: {}@{} with {}@{}", new Object[]{prevIntent, prevIntentState, intent, newIntentState});
                        }
                        events.add(IntentEvent.getEvent((IntentState)IntentState.INSTALL_REQ, (Intent)intent));
                    }
                    catch (InterruptedException e) {
                        this.log.error("Batch write was interrupted while processing {}", (Object)op, (Object)e);
                        failed.add(op);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        this.log.error("Batch write failed processing {}", (Object)op, (Object)e);
                        failed.add(op);
                    }
                    break;
                }
                case REMOVE_INTENT: {
                    IntentId intentId = (IntentId)op.arg(0);
                    try {
                        Intent prevIntent = (Intent)((Future)subops.get(0)).get();
                        IntentState prevIntentState = (IntentState)((Future)subops.get(1)).get();
                        List prevInstallable = (List)((Future)subops.get(2)).get();
                        if (prevIntent == null) {
                            this.log.warn("Intent {} was already removed.", (Object)intentId);
                        }
                        if (prevIntentState == null) {
                            this.log.warn("Intent {} state was already removed", (Object)intentId);
                        }
                        if (prevInstallable == null) continue block22;
                        this.log.warn("Intent {} removed installable still found", (Object)intentId);
                    }
                    catch (InterruptedException e) {
                        this.log.error("Batch write was interrupted while processing {}", (Object)op, (Object)e);
                        failed.add(op);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        this.log.error("Batch write failed processing {}", (Object)op, (Object)e);
                        failed.add(op);
                    }
                    break;
                }
                case SET_STATE: {
                    IntentState prevIntentState;
                    Intent intent = (Intent)op.arg(0);
                    IntentId intentId = intent.id();
                    IntentState newState = (IntentState)op.arg(1);
                    try {
                        prevIntentState = (IntentState)((Future)subops.get(0)).get();
                        if (PARKING.contains(newState)) {
                            this.transientStates.remove(intentId);
                            events.add(IntentEvent.getEvent((IntentState)newState, (Intent)intent));
                        }
                        this.log.trace("{} - {} -> {}", new Object[]{intentId, prevIntentState, newState});
                    }
                    catch (InterruptedException e) {
                        this.log.error("Batch write was interrupted while processing {}", (Object)op, (Object)e);
                        failed.add(op);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        this.log.error("Batch write failed processing {}", (Object)op, (Object)e);
                        failed.add(op);
                    }
                    break;
                }
                case SET_INSTALLABLE: {
                    IntentId intentId = (IntentId)op.arg(0);
                    List installableIntents = (List)op.arg(1);
                    try {
                        List prevInstallable = (List)((Future)subops.get(0)).get();
                        if (prevInstallable == null) continue block22;
                        this.log.warn("Overwriting Intent {} installable {} -> {}", new Object[]{intentId, prevInstallable, installableIntents});
                    }
                    catch (InterruptedException e) {
                        this.log.error("Batch write was interrupted while processing {}", (Object)op, (Object)e);
                        failed.add(op);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        this.log.error("Batch write failed processing {}", (Object)op, (Object)e);
                        failed.add(op);
                    }
                    break;
                }
                case REMOVE_INSTALLED: {
                    IntentId intentId = (IntentId)op.arg(0);
                    try {
                        List prevInstallable = (List)((Future)subops.get(0)).get();
                        if (prevInstallable != null) continue block22;
                        this.log.warn("Intent {} installable was already removed", (Object)intentId);
                    }
                    catch (InterruptedException e) {
                        this.log.error("Batch write was interrupted while processing {}", (Object)op, (Object)e);
                        failed.add(op);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        this.log.error("Batch write failed processing {}", (Object)op, (Object)e);
                        failed.add(op);
                    }
                    break;
                }
                default: {
                    this.log.warn("Unknown Operation encountered: {}", (Object)op);
                    if (failed.contains(op)) continue block22;
                    failed.add(op);
                }
            }
        }
    }

    protected void bindMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    protected void unbindMetricsService(MetricsService metricsService) {
        if (this.metricsService == metricsService) {
            this.metricsService = null;
        }
    }

    public final class RemoteIntentStateListener
    extends EntryAdapter<IntentId, IntentState> {
        public void onEntryEvent(EntryEvent<IntentId, IntentState> event) {
            IntentId intentId = (IntentId)event.getKey();
            Member myself = HazelcastIntentStore.this.theInstance.getCluster().getLocalMember();
            if (!myself.equals(event.getMember())) {
                IntentState oldState = (IntentState)HazelcastIntentStore.this.transientStates.remove(intentId);
                if (oldState != null) {
                    HazelcastIntentStore.this.log.debug("{} state updated remotely, removing transient state {}", (Object)intentId, (Object)oldState);
                }
                if (event.getValue() != null) {
                    Intent intent = HazelcastIntentStore.this.getIntent(intentId);
                    if (intent == null) {
                        HazelcastIntentStore.this.log.warn("no Intent found for {} on Event {}", (Object)intentId, event);
                        return;
                    }
                    HazelcastIntentStore.this.notifyDelegate((Event)IntentEvent.getEvent((IntentState)((IntentState)event.getValue()), (Intent)intent));
                    HazelcastIntentStore.this.localIntents.remove(intentId, intent);
                }
            }
            HazelcastIntentStore.this.getIntent(intentId);
        }
    }

    public final class RemoteIntentsListener
    extends EntryAdapter<IntentId, Intent> {
        public void entryAdded(EntryEvent<IntentId, Intent> event) {
            HazelcastIntentStore.this.localIntents.put(event.getKey(), event.getValue());
        }

        public void entryUpdated(EntryEvent<IntentId, Intent> event) {
            this.entryAdded(event);
        }
    }
}

