/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.mastership.impl;

import com.esotericsoftware.kryo.Serializer;
import com.google.common.base.Objects;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.event.Event;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipStore;
import org.onosproject.mastership.MastershipStoreDelegate;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.store.hz.AbstractHazelcastStore;
import org.onosproject.store.hz.SMap;
import org.onosproject.store.mastership.impl.RoleValue;
import org.onosproject.store.mastership.impl.RoleValueSerializer;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.KryoSerializer;

@Component(immediate=true)
@Service
public class DistributedMastershipStore
extends AbstractHazelcastStore<MastershipEvent, MastershipStoreDelegate>
implements MastershipStore {
    private static final Integer NOTHING = 0;
    private static final Integer INIT = 1;
    private static final String NODE_ROLES_MAP_NAME = "nodeRoles";
    protected SMap<DeviceId, RoleValue> roleMap;
    private static final String TERMS_MAP_NAME = "terms";
    protected SMap<DeviceId, Integer> terms;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    private String listenerId;

    @Override
    @Activate
    public void activate() {
        super.activate();
        this.serializer = new KryoSerializer(){

            protected void setupKryoPool() {
                this.serializerPool = KryoNamespace.newBuilder().register(KryoNamespaces.API).nextId(300).register((Serializer)new RoleValueSerializer(), new Class[]{RoleValue.class}).build();
            }
        };
        Config config = this.theInstance.getConfig();
        MapConfig nodeRolesCfg = config.getMapConfig(NODE_ROLES_MAP_NAME);
        nodeRolesCfg.setAsyncBackupCount(6 - nodeRolesCfg.getBackupCount());
        MapConfig termsCfg = config.getMapConfig(TERMS_MAP_NAME);
        termsCfg.setAsyncBackupCount(6 - termsCfg.getBackupCount());
        this.roleMap = new SMap((IMap<byte[], byte[]>)this.theInstance.getMap(NODE_ROLES_MAP_NAME), this.serializer);
        this.listenerId = this.roleMap.addEntryListener(new RemoteMasterShipEventHandler(), true);
        this.terms = new SMap((IMap<byte[], byte[]>)this.theInstance.getMap(TERMS_MAP_NAME), this.serializer);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.roleMap.removeEntryListener(this.listenerId);
        this.log.info("Stopped");
    }

    public MastershipRole getRole(NodeId nodeId, DeviceId deviceId) {
        RoleValue roleInfo = this.roleMap.get(deviceId);
        if (roleInfo != null) {
            return roleInfo.getRole(nodeId);
        }
        return MastershipRole.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MastershipEvent setMaster(NodeId newMaster, DeviceId deviceId) {
        this.roleMap.lock(deviceId);
        try {
            RoleValue rv = this.getRoleValue(deviceId);
            MastershipRole currentRole = rv.getRole(newMaster);
            switch (currentRole) {
                case MASTER: {
                    boolean modified = rv.reassign(newMaster, MastershipRole.STANDBY, MastershipRole.NONE);
                    if (modified) {
                        this.roleMap.put(deviceId, rv);
                        this.log.warn("{} was in both MASTER and STANDBY for {}", (Object)newMaster, (Object)deviceId);
                    }
                    MastershipEvent mastershipEvent = null;
                    return mastershipEvent;
                }
                case STANDBY: 
                case NONE: {
                    NodeId currentMaster = rv.get(MastershipRole.MASTER);
                    if (currentMaster != null) {
                        rv.reassign(currentMaster, MastershipRole.NONE, MastershipRole.STANDBY);
                        rv.replace(currentMaster, newMaster, MastershipRole.MASTER);
                    } else {
                        rv.add(MastershipRole.MASTER, newMaster);
                    }
                    rv.reassign(newMaster, MastershipRole.STANDBY, MastershipRole.NONE);
                    this.updateTerm(deviceId);
                    this.roleMap.put(deviceId, rv);
                    MastershipEvent mastershipEvent = new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, rv.roleInfo());
                    return mastershipEvent;
                }
            }
            this.log.warn("unknown Mastership Role {}", (Object)currentRole);
            MastershipEvent mastershipEvent = null;
            return mastershipEvent;
        }
        finally {
            this.roleMap.unlock(deviceId);
        }
    }

    public NodeId getMaster(DeviceId deviceId) {
        return this.getNode(MastershipRole.MASTER, deviceId);
    }

    public RoleInfo getNodes(DeviceId deviceId) {
        RoleValue rv = this.roleMap.get(deviceId);
        if (rv != null) {
            return rv.roleInfo();
        }
        return new RoleInfo();
    }

    public Set<DeviceId> getDevices(NodeId nodeId) {
        HashSet<DeviceId> devices = new HashSet<DeviceId>();
        for (Map.Entry<DeviceId, RoleValue> el : this.roleMap.entrySet()) {
            if (!nodeId.equals((Object)el.getValue().get(MastershipRole.MASTER))) continue;
            devices.add(el.getKey());
        }
        return devices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MastershipRole requestRole(DeviceId deviceId) {
        NodeId local = this.clusterService.getLocalNode().id();
        boolean modified = false;
        this.roleMap.lock(deviceId);
        try {
            RoleValue rv = this.getRoleValue(deviceId);
            if (rv.get(MastershipRole.MASTER) == null) {
                rv.reassign(local, MastershipRole.STANDBY, MastershipRole.NONE);
                rv.add(MastershipRole.MASTER, local);
                this.updateTerm(deviceId);
                this.roleMap.put(deviceId, rv);
                MastershipRole mastershipRole = MastershipRole.MASTER;
                return mastershipRole;
            }
            MastershipRole currentRole = rv.getRole(local);
            switch (currentRole) {
                case MASTER: {
                    modified = rv.reassign(local, MastershipRole.STANDBY, MastershipRole.NONE);
                    if (modified) {
                        this.log.warn("{} was in both MASTER and STANDBY for {}", (Object)local, (Object)deviceId);
                        this.roleMap.put(deviceId, rv);
                    }
                    MastershipRole mastershipRole = currentRole;
                    return mastershipRole;
                }
                case STANDBY: {
                    modified = rv.reassign(local, MastershipRole.NONE, MastershipRole.STANDBY);
                    if (modified) {
                        this.log.warn("{} was in both NONE and STANDBY for {}", (Object)local, (Object)deviceId);
                        this.roleMap.put(deviceId, rv);
                    }
                    MastershipRole mastershipRole = currentRole;
                    return mastershipRole;
                }
                case NONE: {
                    rv.reassign(local, MastershipRole.NONE, MastershipRole.STANDBY);
                    this.roleMap.put(deviceId, rv);
                    MastershipRole mastershipRole = MastershipRole.STANDBY;
                    return mastershipRole;
                }
            }
            this.log.warn("unknown Mastership Role {}", (Object)currentRole);
            MastershipRole mastershipRole = currentRole;
            return mastershipRole;
        }
        finally {
            this.roleMap.unlock(deviceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MastershipTerm getTermFor(DeviceId deviceId) {
        this.roleMap.lock(deviceId);
        try {
            RoleValue rv = this.getRoleValue(deviceId);
            Integer term = this.terms.get(deviceId);
            NodeId master = rv.get(MastershipRole.MASTER);
            if (term == null) {
                MastershipTerm mastershipTerm = MastershipTerm.of(null, (int)NOTHING);
                return mastershipTerm;
            }
            MastershipTerm mastershipTerm = MastershipTerm.of((NodeId)master, (int)term);
            return mastershipTerm;
        }
        finally {
            this.roleMap.unlock(deviceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MastershipEvent setStandby(NodeId nodeId, DeviceId deviceId) {
        this.roleMap.lock(deviceId);
        try {
            RoleValue rv = this.getRoleValue(deviceId);
            MastershipRole currentRole = this.getRole(nodeId, deviceId);
            switch (currentRole) {
                case MASTER: {
                    NodeId newMaster = this.reelect(nodeId, deviceId, rv);
                    rv.reassign(nodeId, MastershipRole.NONE, MastershipRole.STANDBY);
                    this.updateTerm(deviceId);
                    if (newMaster != null) {
                        this.roleMap.put(deviceId, rv);
                        MastershipEvent mastershipEvent = new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, rv.roleInfo());
                        return mastershipEvent;
                    }
                    this.roleMap.put(deviceId, rv);
                    MastershipEvent mastershipEvent = new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, rv.roleInfo());
                    return mastershipEvent;
                }
                case STANDBY: {
                    MastershipEvent mastershipEvent = null;
                    return mastershipEvent;
                }
                case NONE: {
                    rv.reassign(nodeId, MastershipRole.NONE, MastershipRole.STANDBY);
                    this.roleMap.put(deviceId, rv);
                    MastershipEvent mastershipEvent = new MastershipEvent(MastershipEvent.Type.BACKUPS_CHANGED, deviceId, rv.roleInfo());
                    return mastershipEvent;
                }
            }
            this.log.warn("unknown Mastership Role {}", (Object)currentRole);
            MastershipEvent mastershipEvent = null;
            return mastershipEvent;
        }
        finally {
            this.roleMap.unlock(deviceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MastershipEvent relinquishRole(NodeId nodeId, DeviceId deviceId) {
        this.roleMap.lock(deviceId);
        try {
            RoleValue rv = this.getRoleValue(deviceId);
            MastershipRole currentRole = rv.getRole(nodeId);
            switch (currentRole) {
                case MASTER: {
                    NodeId newMaster = this.reelect(nodeId, deviceId, rv);
                    if (newMaster != null) {
                        this.updateTerm(deviceId);
                        this.roleMap.put(deviceId, rv);
                        MastershipEvent mastershipEvent = new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, rv.roleInfo());
                        return mastershipEvent;
                    }
                    this.roleMap.put(deviceId, rv);
                    MastershipEvent mastershipEvent = null;
                    return mastershipEvent;
                }
                case STANDBY: 
                case NONE: {
                    boolean modified = rv.reassign(nodeId, MastershipRole.STANDBY, MastershipRole.NONE);
                    if (modified) {
                        this.roleMap.put(deviceId, rv);
                        MastershipEvent mastershipEvent = new MastershipEvent(MastershipEvent.Type.BACKUPS_CHANGED, deviceId, rv.roleInfo());
                        return mastershipEvent;
                    }
                    MastershipEvent mastershipEvent = null;
                    return mastershipEvent;
                }
            }
            this.log.warn("unknown Mastership Role {}", (Object)currentRole);
            MastershipEvent mastershipEvent = null;
            return mastershipEvent;
        }
        finally {
            this.roleMap.unlock(deviceId);
        }
    }

    private NodeId reelect(NodeId current, DeviceId deviceId, RoleValue rv) {
        NodeId candidate = null;
        for (NodeId n : rv.nodesOfRole(MastershipRole.STANDBY)) {
            if (current.equals((Object)n)) continue;
            candidate = n;
            break;
        }
        if (candidate == null) {
            this.log.info("{} giving up and going to NONE for {}", (Object)current, (Object)deviceId);
            rv.remove(MastershipRole.MASTER, current);
            return null;
        }
        this.log.info("{} trying to pass mastership for {} to {}", new Object[]{current, deviceId, candidate});
        rv.replace(current, candidate, MastershipRole.MASTER);
        rv.reassign(candidate, MastershipRole.STANDBY, MastershipRole.NONE);
        return candidate;
    }

    private RoleValue getRoleValue(DeviceId deviceId) {
        RoleValue concurrentlyAdded;
        RoleValue value = this.roleMap.get(deviceId);
        if (value == null && (concurrentlyAdded = this.roleMap.putIfAbsent(deviceId, value = new RoleValue())) != null) {
            return concurrentlyAdded;
        }
        return value;
    }

    private NodeId getNode(MastershipRole role, DeviceId deviceId) {
        RoleValue value = this.roleMap.get(deviceId);
        if (value != null) {
            return value.get(role);
        }
        return null;
    }

    private void updateTerm(DeviceId deviceId) {
        Integer term = this.terms.get(deviceId);
        if (term == null && (term = this.terms.putIfAbsent(deviceId, INIT)) == null) {
            return;
        }
        Integer nextTerm = term + 1;
        boolean success = this.terms.replace(deviceId, term, nextTerm);
        while (!success) {
            term = this.terms.get(deviceId);
            if (term == null) {
                this.log.warn("Term info for {} disappeared.", (Object)deviceId);
                term = (Integer)ConcurrentUtils.putIfAbsent(this.terms, (Object)deviceId, (Object)nextTerm);
            }
            nextTerm = term + 1;
            success = this.terms.replace(deviceId, term, nextTerm);
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    private class RemoteMasterShipEventHandler
    implements EntryListener<DeviceId, RoleValue> {
        private RemoteMasterShipEventHandler() {
        }

        public void entryAdded(EntryEvent<DeviceId, RoleValue> event) {
            this.entryUpdated(event);
        }

        public void entryRemoved(EntryEvent<DeviceId, RoleValue> event) {
        }

        public void entryUpdated(EntryEvent<DeviceId, RoleValue> event) {
            NodeId newMaster;
            RoleValue oldValue = (RoleValue)event.getOldValue();
            RoleValue newValue = (RoleValue)event.getValue();
            NodeId oldMaster = null;
            if (oldValue != null) {
                oldMaster = oldValue.get(MastershipRole.MASTER);
            }
            if (!Objects.equal((Object)oldMaster, (Object)(newMaster = newValue.get(MastershipRole.MASTER)))) {
                DistributedMastershipStore.this.notifyDelegate((Event)new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, (DeviceId)event.getKey(), ((RoleValue)event.getValue()).roleInfo()));
            } else {
                DistributedMastershipStore.this.notifyDelegate((Event)new MastershipEvent(MastershipEvent.Type.BACKUPS_CHANGED, (DeviceId)event.getKey(), ((RoleValue)event.getValue()).roleInfo()));
            }
        }

        public void entryEvicted(EntryEvent<DeviceId, RoleValue> event) {
        }

        public void mapEvicted(MapEvent event) {
        }

        public void mapCleared(MapEvent event) {
        }
    }
}

