/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.HexString;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.resource.Bandwidth;
import org.onosproject.net.resource.BandwidthResourceAllocation;
import org.onosproject.net.resource.Lambda;
import org.onosproject.net.resource.LambdaResourceAllocation;
import org.onosproject.net.resource.LinkResourceAllocations;
import org.onosproject.net.resource.LinkResourceEvent;
import org.onosproject.net.resource.LinkResourceStore;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceType;
import org.onosproject.store.serializers.KryoSerializer;
import org.onosproject.store.serializers.StoreSerializer;
import org.onosproject.store.service.BatchWriteRequest;
import org.onosproject.store.service.BatchWriteResult;
import org.onosproject.store.service.DatabaseAdminService;
import org.onosproject.store.service.DatabaseException;
import org.onosproject.store.service.DatabaseService;
import org.onosproject.store.service.VersionedValue;
import org.onosproject.store.service.WriteRequest;
import org.onosproject.store.service.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=false)
@Service
public class DistributedLinkResourceStore
implements LinkResourceStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Bandwidth DEFAULT_BANDWIDTH = Bandwidth.valueOf((double)1000.0);
    private static final String LINK_RESOURCE_ALLOCATIONS = "LinkResourceAllocations";
    private static final String INTENT_ALLOCATIONS = "IntentAllocations";
    private static final Bandwidth EMPTY_BW = Bandwidth.valueOf((double)0.0);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DatabaseAdminService databaseAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DatabaseService databaseService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    private String bandwidthAnnotation = "bandwidth";
    private String wavesAnnotation = "optical.waves";
    private StoreSerializer serializer;

    void createTable(String tableName) {
        boolean tableReady = false;
        do {
            try {
                if (!this.databaseAdminService.listTables().contains(tableName)) {
                    this.databaseAdminService.createTable(tableName);
                }
                tableReady = true;
            }
            catch (DatabaseException e) {
                this.log.debug("Failed creating table, retrying", (Throwable)e);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e1) {
                    throw new DatabaseException((Throwable)e1);
                }
            }
        } while (!tableReady);
    }

    @Activate
    public void activate() {
        this.serializer = new KryoSerializer();
        this.createTable(LINK_RESOURCE_ALLOCATIONS);
        this.createTable(INTENT_ALLOCATIONS);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    private Set<? extends ResourceAllocation> getResourceCapacity(ResourceType type, Link link) {
        if (type == ResourceType.BANDWIDTH) {
            return ImmutableSet.of((Object)this.getBandwidthResourceCapacity(link));
        }
        if (type == ResourceType.LAMBDA) {
            return this.getLambdaResourceCapacity(link);
        }
        return null;
    }

    private Set<LambdaResourceAllocation> getLambdaResourceCapacity(Link link) {
        HashSet<LambdaResourceAllocation> allocations = new HashSet<LambdaResourceAllocation>();
        try {
            int waves = Integer.parseInt(link.annotations().value(this.wavesAnnotation));
            for (int i = 1; i <= waves; ++i) {
                allocations.add(new LambdaResourceAllocation(Lambda.valueOf((int)i)));
            }
        }
        catch (NumberFormatException e) {
            this.log.debug("No {} annotation on link %s", (Object)this.wavesAnnotation, (Object)link);
        }
        return allocations;
    }

    private BandwidthResourceAllocation getBandwidthResourceCapacity(Link link) {
        Bandwidth bandwidth = null;
        String strBw = link.annotations().value(this.bandwidthAnnotation);
        if (strBw != null) {
            try {
                bandwidth = Bandwidth.valueOf((double)Double.parseDouble(strBw));
            }
            catch (NumberFormatException e) {
                bandwidth = null;
            }
        }
        if (bandwidth == null) {
            bandwidth = DEFAULT_BANDWIDTH;
        }
        return new BandwidthResourceAllocation(bandwidth);
    }

    private Map<ResourceType, Set<? extends ResourceAllocation>> getResourceCapacity(Link link) {
        HashMap<ResourceType, Set<? extends ResourceAllocation>> caps = new HashMap<ResourceType, Set<? extends ResourceAllocation>>();
        for (ResourceType type : ResourceType.values()) {
            Set<? extends ResourceAllocation> cap = this.getResourceCapacity(type, link);
            if (cap == null) continue;
            caps.put(type, cap);
        }
        return caps;
    }

    public Set<ResourceAllocation> getFreeResources(Link link) {
        Map<ResourceType, Set<? extends ResourceAllocation>> freeResources = this.getFreeResourcesEx(link);
        HashSet<ResourceAllocation> allFree = new HashSet<ResourceAllocation>();
        for (Set<? extends ResourceAllocation> r : freeResources.values()) {
            allFree.addAll(r);
        }
        return allFree;
    }

    private Map<ResourceType, Set<? extends ResourceAllocation>> getFreeResourcesEx(Link link) {
        Preconditions.checkNotNull((Object)link);
        HashMap<ResourceType, Set<? extends ResourceAllocation>> free = new HashMap<ResourceType, Set<? extends ResourceAllocation>>();
        Map<ResourceType, Set<? extends ResourceAllocation>> caps = this.getResourceCapacity(link);
        Iterable allocations = this.getAllocations(link);
        block4: for (ResourceType type : ResourceType.values()) {
            switch (type) {
                case BANDWIDTH: {
                    HashSet bw = caps.get(ResourceType.BANDWIDTH);
                    if (bw == null || bw.isEmpty()) {
                        bw = Sets.newHashSet((Object[])new BandwidthResourceAllocation[]{new BandwidthResourceAllocation(EMPTY_BW)});
                    }
                    BandwidthResourceAllocation cap = (BandwidthResourceAllocation)bw.iterator().next();
                    double freeBw = cap.bandwidth().toDouble();
                    for (LinkResourceAllocations alloc : allocations) {
                        Set types = alloc.getResourceAllocation(link);
                        for (ResourceAllocation a : types) {
                            if (!(a instanceof BandwidthResourceAllocation)) continue;
                            BandwidthResourceAllocation bwA = (BandwidthResourceAllocation)a;
                            freeBw -= bwA.bandwidth().toDouble();
                        }
                    }
                    free.put(type, Sets.newHashSet((Object[])new BandwidthResourceAllocation[]{new BandwidthResourceAllocation(Bandwidth.valueOf((double)freeBw))}));
                    continue block4;
                }
                case LAMBDA: {
                    Set<? extends ResourceAllocation> lmd = caps.get(type);
                    if (lmd == null || lmd.isEmpty()) continue block4;
                    HashSet<LambdaResourceAllocation> freeL = new HashSet<LambdaResourceAllocation>();
                    for (ResourceAllocation resourceAllocation : lmd) {
                        if (!(resourceAllocation instanceof LambdaResourceAllocation)) continue;
                        freeL.add((LambdaResourceAllocation)resourceAllocation);
                    }
                    for (LinkResourceAllocations linkResourceAllocations : allocations) {
                        Set types = linkResourceAllocations.getResourceAllocation(link);
                        for (ResourceAllocation a : types) {
                            if (!(a instanceof LambdaResourceAllocation)) continue;
                            freeL.remove(a);
                        }
                    }
                    free.put(type, freeL);
                    continue block4;
                }
            }
        }
        return free;
    }

    private LinkResourceAllocations getIntentAllocations(IntentId id) {
        VersionedValue vv = this.databaseService.get(INTENT_ALLOCATIONS, this.toIntentDbKey((IntentId)Preconditions.checkNotNull((Object)id)));
        if (vv == null || vv.value() == null) {
            return null;
        }
        return this.decodeIntentAllocations(vv.value());
    }

    private BatchWriteRequest.Builder putIntentAllocations(BatchWriteRequest.Builder ctx, IntentId id, LinkResourceAllocations alloc) {
        return ctx.put(INTENT_ALLOCATIONS, this.toIntentDbKey(id), this.encodeIntentAllocations(alloc));
    }

    public void allocateResources(LinkResourceAllocations allocations) {
        Preconditions.checkNotNull((Object)allocations);
        BatchWriteRequest.Builder tx = BatchWriteRequest.newBuilder();
        this.putIntentAllocations(tx, allocations.intendId(), allocations);
        for (Link link : allocations.links()) {
            this.allocateLinkResource(tx, link, allocations);
        }
        BatchWriteRequest batch = tx.build();
        BatchWriteResult result = this.databaseService.batchWrite(batch);
        if (!result.isSuccessful()) {
            this.log.error("Allocation Failed.");
            if (this.log.isDebugEnabled()) {
                this.logFailureDetail(batch, result);
            }
            Preconditions.checkState((boolean)result.isSuccessful(), (Object)"Allocation failed");
        }
    }

    private void logFailureDetail(BatchWriteRequest batch, BatchWriteResult result) {
        block9: for (int i = 0; i < batch.batchSize(); ++i) {
            WriteRequest req = (WriteRequest)batch.getAsList().get(i);
            WriteResult fail = (WriteResult)result.getAsList().get(i);
            switch (fail.status()) {
                case ABORTED: {
                    this.log.debug("ABORTED: {}@{}", (Object)req.key(), (Object)req.tableName());
                    continue block9;
                }
                case PRECONDITION_VIOLATION: {
                    switch (req.type()) {
                        case PUT_IF_ABSENT: {
                            this.log.debug("{}: {}@{} : {}", new Object[]{req.type(), req.key(), req.tableName(), fail.previousValue()});
                            continue block9;
                        }
                        case PUT_IF_VALUE: 
                        case REMOVE_IF_VALUE: {
                            this.log.debug("{}: {}@{} : was {}, expected {}", new Object[]{req.type(), req.key(), req.tableName(), fail.previousValue(), HexString.toHexString((byte[])req.oldValue())});
                            continue block9;
                        }
                        case PUT_IF_VERSION: 
                        case REMOVE_IF_VERSION: {
                            this.log.debug("{}: {}@{} : was {}, expected {}", new Object[]{req.type(), req.key(), req.tableName(), fail.previousValue().version(), req.previousVersion()});
                            continue block9;
                        }
                    }
                    this.log.error("Should never reach here.");
                    continue block9;
                }
                default: {
                    this.log.error("Should never reach here.");
                }
            }
        }
    }

    private BatchWriteRequest.Builder allocateLinkResource(BatchWriteRequest.Builder builder, Link link, LinkResourceAllocations allocations) {
        Set reqs = allocations.getResourceAllocation(link);
        Map<ResourceType, Set<? extends ResourceAllocation>> available = this.getFreeResourcesEx(link);
        for (ResourceAllocation req : reqs) {
            Set<? extends ResourceAllocation> avail = available.get(req.type());
            if (req instanceof BandwidthResourceAllocation) {
                if (avail.isEmpty()) {
                    Preconditions.checkState((!avail.isEmpty() ? 1 : 0) != 0, (String)"There's no Bandwidth resource on %s?", (Object[])new Object[]{link});
                }
                BandwidthResourceAllocation bw = (BandwidthResourceAllocation)avail.iterator().next();
                double bwLeft = bw.bandwidth().toDouble();
                if (!((bwLeft -= ((BandwidthResourceAllocation)req).bandwidth().toDouble()) < 0.0)) continue;
                Preconditions.checkState((bwLeft >= 0.0 ? 1 : 0) != 0, (String)"There's no Bandwidth left on %s. %s", (Object[])new Object[]{link, bwLeft});
                continue;
            }
            if (!(req instanceof LambdaResourceAllocation) || avail.contains(req)) continue;
            Preconditions.checkState((boolean)avail.contains(req), (String)"Allocating %s on %s failed", (Object[])new Object[]{req, link});
        }
        Iterable before = this.getAllocations(link);
        ArrayList<LinkResourceAllocations> after = new ArrayList<LinkResourceAllocations>(before.size());
        after.addAll((Collection<LinkResourceAllocations>)before);
        after.add(allocations);
        this.replaceLinkAllocations(builder, LinkKey.linkKey((Link)link), (List<LinkResourceAllocations>)before, after);
        return builder;
    }

    private BatchWriteRequest.Builder replaceLinkAllocations(BatchWriteRequest.Builder builder, LinkKey linkKey, List<LinkResourceAllocations> before, List<LinkResourceAllocations> after) {
        byte[] oldValue = this.encodeLinkAllocations(before);
        byte[] newValue = this.encodeLinkAllocations(after);
        builder.putIfValueMatches(LINK_RESOURCE_ALLOCATIONS, this.toLinkDbKey(linkKey), oldValue, newValue);
        return builder;
    }

    public LinkResourceEvent releaseResources(LinkResourceAllocations allocations) {
        BatchWriteRequest.Builder tx;
        BatchWriteResult batchWrite;
        boolean success;
        Preconditions.checkNotNull((Object)allocations);
        IntentId intendId = allocations.intendId();
        String dbIntentId = this.toIntentDbKey(intendId);
        Collection links = allocations.links();
        do {
            tx = BatchWriteRequest.newBuilder();
            tx.remove(INTENT_ALLOCATIONS, dbIntentId);
            for (Link link : links) {
                LinkKey linkId = LinkKey.linkKey((Link)link);
                String dbLinkId = this.toLinkDbKey(linkId);
                VersionedValue vv = this.databaseService.get(LINK_RESOURCE_ALLOCATIONS, dbLinkId);
                if (vv == null || vv.value() == null) {
                    this.log.warn("There was no resource left to release on {}", (Object)linkId);
                    continue;
                }
                List<LinkResourceAllocations> before = this.decodeLinkAllocations(vv.value());
                ArrayList<LinkResourceAllocations> after = new ArrayList<LinkResourceAllocations>(before);
                after.remove(allocations);
                byte[] oldValue = this.encodeLinkAllocations(before);
                byte[] newValue = this.encodeLinkAllocations(after);
                tx.putIfValueMatches(LINK_RESOURCE_ALLOCATIONS, dbLinkId, oldValue, newValue);
            }
        } while (!(success = (batchWrite = this.databaseService.batchWrite(tx.build())).isSuccessful()));
        ImmutableList releasedResources = ImmutableList.of((Object)allocations);
        return new LinkResourceEvent(LinkResourceEvent.Type.ADDITIONAL_RESOURCES_AVAILABLE, (Collection)releasedResources);
    }

    public LinkResourceAllocations getAllocations(IntentId intentId) {
        Preconditions.checkNotNull((Object)intentId);
        VersionedValue vv = this.databaseService.get(INTENT_ALLOCATIONS, this.toIntentDbKey(intentId));
        if (vv == null) {
            return null;
        }
        LinkResourceAllocations allocations = this.decodeIntentAllocations(vv.value());
        return allocations;
    }

    private String toLinkDbKey(LinkKey linkid) {
        return linkid.toString();
    }

    private String toIntentDbKey(IntentId intentid) {
        return intentid.toString();
    }

    private IntentId toIntentId(String intentid) {
        Preconditions.checkArgument((boolean)intentid.startsWith("0x"));
        return IntentId.valueOf((long)Long.parseLong(intentid.substring(2)));
    }

    private LinkResourceAllocations decodeIntentAllocations(byte[] bytes) {
        return (LinkResourceAllocations)this.serializer.decode(bytes);
    }

    private byte[] encodeIntentAllocations(LinkResourceAllocations alloc) {
        return this.serializer.encode(Preconditions.checkNotNull((Object)alloc));
    }

    private List<LinkResourceAllocations> decodeLinkAllocations(byte[] bytes) {
        return (List)this.serializer.decode(bytes);
    }

    private byte[] encodeLinkAllocations(List<LinkResourceAllocations> alloc) {
        return this.serializer.encode(Preconditions.checkNotNull(alloc));
    }

    public List<LinkResourceAllocations> getAllocations(Link link) {
        Preconditions.checkNotNull((Object)link);
        LinkKey key = LinkKey.linkKey((Link)link);
        String dbKey = this.toLinkDbKey(key);
        VersionedValue vv = this.databaseService.get(LINK_RESOURCE_ALLOCATIONS, dbKey);
        if (vv == null) {
            byte[] emptyList = this.encodeLinkAllocations(new ArrayList<LinkResourceAllocations>());
            boolean written = this.databaseService.putIfAbsent(LINK_RESOURCE_ALLOCATIONS, dbKey, emptyList);
            this.log.trace("Empty allocation write success? {}", (Object)written);
            vv = this.databaseService.get(LINK_RESOURCE_ALLOCATIONS, dbKey);
            if (vv == null) {
                this.log.error("Failed to re-read allocation for {}", (Object)dbKey);
                return new ArrayList<LinkResourceAllocations>();
            }
        }
        List<LinkResourceAllocations> allocations = this.decodeLinkAllocations(vv.value());
        return allocations;
    }

    public Iterable<LinkResourceAllocations> getAllocations() {
        Map all = this.databaseService.getAll(INTENT_ALLOCATIONS);
        return FluentIterable.from(all.values()).transform((Function)new Function<VersionedValue, LinkResourceAllocations>(){

            public LinkResourceAllocations apply(VersionedValue input) {
                if (input == null || input.value() == null) {
                    return null;
                }
                return DistributedLinkResourceStore.this.decodeIntentAllocations(input.value());
            }
        }).filter(Predicates.notNull());
    }

    protected void bindDatabaseAdminService(DatabaseAdminService databaseAdminService) {
        this.databaseAdminService = databaseAdminService;
    }

    protected void unbindDatabaseAdminService(DatabaseAdminService databaseAdminService) {
        if (this.databaseAdminService == databaseAdminService) {
            this.databaseAdminService = null;
        }
    }

    protected void bindDatabaseService(DatabaseService databaseService) {
        this.databaseService = databaseService;
    }

    protected void unbindDatabaseService(DatabaseService databaseService) {
        if (this.databaseService == databaseService) {
            this.databaseService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }
}

