/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import java.util.Map;
import org.onosproject.store.serializers.StoreSerializer;
import org.onosproject.store.service.DatabaseAdminService;
import org.onosproject.store.service.DatabaseException;
import org.onosproject.store.service.DatabaseService;
import org.onosproject.store.service.VersionedValue;

public class CMap<K, V> {
    private final DatabaseAdminService dbAdminService;
    private final DatabaseService dbService;
    private final String tableName;
    private final StoreSerializer serializer;
    private final LoadingCache<K, String> keyCache;

    public CMap(DatabaseAdminService dbAdminService, DatabaseService dbService, String tableName, StoreSerializer serializer) {
        this.dbAdminService = (DatabaseAdminService)Preconditions.checkNotNull((Object)dbAdminService);
        this.dbService = (DatabaseService)Preconditions.checkNotNull((Object)dbService);
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName);
        this.serializer = (StoreSerializer)Preconditions.checkNotNull((Object)serializer);
        boolean tableReady = false;
        do {
            try {
                if (!dbAdminService.listTables().contains(tableName)) {
                    dbAdminService.createTable(tableName);
                }
                tableReady = true;
            }
            catch (DatabaseException e) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e1) {
                    throw new DatabaseException((Throwable)e1);
                }
            }
        } while (!tableReady);
        this.keyCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<K, String>(){

            public String load(K key) {
                return key.toString();
            }
        });
    }

    protected String sK(K key) {
        return (String)this.keyCache.getUnchecked(key);
    }

    protected byte[] sV(V val) {
        return this.serializer.encode(val);
    }

    protected V dV(byte[] valBytes) {
        return (V)this.serializer.decode(valBytes);
    }

    public boolean putIfAbsent(K key, V value) {
        return this.dbService.putIfAbsent(this.tableName, this.sK(key), this.sV(value));
    }

    public V remove(K key) {
        VersionedValue removed = this.dbService.remove(this.tableName, this.sK(key));
        if (removed == null) {
            return null;
        }
        return this.dV(removed.value());
    }

    public long size() {
        return this.dbService.getAll(this.tableName).size();
    }

    public Iterable<V> values() {
        Map all = this.dbService.getAll(this.tableName);
        return FluentIterable.from(all.values()).transform(new Function<VersionedValue, V>(){

            public V apply(VersionedValue input) {
                if (input == null) {
                    return null;
                }
                return CMap.this.dV(input.value());
            }
        }).filter(Predicates.notNull());
    }

    public V get(K key) {
        VersionedValue vv = this.dbService.get(this.tableName, this.sK(key));
        if (vv == null) {
            return null;
        }
        return this.dV(vv.value());
    }

    public boolean replace(K key, V oldVal, V newVal) {
        return this.dbService.putIfValueMatches(this.tableName, this.sK(key), this.sV(oldVal), this.sV(newVal));
    }

    public V put(K key, V value) {
        VersionedValue vv = this.dbService.put(this.tableName, this.sK(key), this.sV(value));
        if (vv == null) {
            return null;
        }
        return this.dV(vv.value());
    }
}

