/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service.impl;

import java.util.Vector;
import net.kuujo.copycat.cluster.TcpClusterConfig;
import net.kuujo.copycat.cluster.TcpMember;
import net.kuujo.copycat.event.LeaderElectEvent;
import net.kuujo.copycat.internal.log.ConfigurationEntry;
import net.kuujo.copycat.internal.log.CopycatEntry;
import net.kuujo.copycat.internal.log.OperationEntry;
import net.kuujo.copycat.internal.log.SnapshotEntry;
import net.kuujo.copycat.protocol.PingRequest;
import net.kuujo.copycat.protocol.PingResponse;
import net.kuujo.copycat.protocol.PollRequest;
import net.kuujo.copycat.protocol.PollResponse;
import net.kuujo.copycat.protocol.Response;
import net.kuujo.copycat.protocol.SubmitRequest;
import net.kuujo.copycat.protocol.SubmitResponse;
import net.kuujo.copycat.protocol.SyncRequest;
import net.kuujo.copycat.protocol.SyncResponse;
import net.kuujo.copycat.spi.protocol.Protocol;
import net.kuujo.copycat.spi.protocol.ProtocolClient;
import net.kuujo.copycat.spi.protocol.ProtocolServer;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.ClusterService;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.KryoSerializer;
import org.onosproject.store.serializers.StoreSerializer;
import org.onosproject.store.service.impl.ClusterMessagingProtocolClient;
import org.onosproject.store.service.impl.ClusterMessagingProtocolServer;
import org.onosproject.store.service.impl.DatabaseProtocolService;
import org.onosproject.store.service.impl.DatabaseStateMachine;
import org.onosproject.store.service.impl.TableModificationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=false)
@Service
public class ClusterMessagingProtocol
implements DatabaseProtocolService,
Protocol<TcpMember> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    public static final MessageSubject COPYCAT_PING = new MessageSubject("copycat-raft-consensus-ping");
    public static final MessageSubject COPYCAT_SYNC = new MessageSubject("copycat-raft-consensus-sync");
    public static final MessageSubject COPYCAT_POLL = new MessageSubject("copycat-raft-consensus-poll");
    public static final MessageSubject COPYCAT_SUBMIT = new MessageSubject("copycat-raft-consensus-submit");
    static final int AFTER_COPYCAT = 350;
    static final KryoNamespace COPYCAT = KryoNamespace.newBuilder().register(KryoNamespaces.API).nextId(300).register(new Class[]{PingRequest.class}).register(new Class[]{PingResponse.class}).register(new Class[]{PollRequest.class}).register(new Class[]{PollResponse.class}).register(new Class[]{SyncRequest.class}).register(new Class[]{SyncResponse.class}).register(new Class[]{SubmitRequest.class}).register(new Class[]{SubmitResponse.class}).register(new Class[]{Response.Status.class}).register(new Class[]{ConfigurationEntry.class}).register(new Class[]{SnapshotEntry.class}).register(new Class[]{CopycatEntry.class}).register(new Class[]{OperationEntry.class}).register(new Class[]{TcpClusterConfig.class}).register(new Class[]{TcpMember.class}).register(new Class[]{LeaderElectEvent.class}).register(new Class[]{Vector.class}).build();
    public static final StoreSerializer DB_SERIALIZER = new KryoSerializer(){

        protected void setupKryoPool() {
            this.serializerPool = KryoNamespace.newBuilder().register(COPYCAT).nextId(350).register(new Class[]{DatabaseStateMachine.State.class}).register(new Class[]{DatabaseStateMachine.TableMetadata.class}).register(new Class[]{TableModificationEvent.class}).register(new Class[]{TableModificationEvent.Type.class}).build();
        }
    };

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public ProtocolServer createServer(TcpMember member) {
        return new ClusterMessagingProtocolServer(this.clusterCommunicator);
    }

    public ProtocolClient createClient(TcpMember member) {
        return new ClusterMessagingProtocolClient(this.clusterService, this.clusterCommunicator, this.clusterService.getLocalNode(), member);
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }
}

