/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service.impl;

import com.google.common.base.Verify;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kuujo.copycat.cluster.TcpMember;
import net.kuujo.copycat.protocol.PingRequest;
import net.kuujo.copycat.protocol.PingResponse;
import net.kuujo.copycat.protocol.PollRequest;
import net.kuujo.copycat.protocol.PollResponse;
import net.kuujo.copycat.protocol.SubmitRequest;
import net.kuujo.copycat.protocol.SubmitResponse;
import net.kuujo.copycat.protocol.SyncRequest;
import net.kuujo.copycat.protocol.SyncResponse;
import net.kuujo.copycat.spi.protocol.ProtocolClient;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.service.impl.ClusterMessagingProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterMessagingProtocolClient
implements ProtocolClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final long RETRY_INTERVAL_MILLIS = 2000L;
    private final ClusterService clusterService;
    private final ClusterCommunicationService clusterCommunicator;
    private final ControllerNode localNode;
    private final TcpMember remoteMember;
    private ControllerNode remoteNode;
    private final AtomicBoolean connectionOK = new AtomicBoolean(true);
    private ExecutorService pool;

    public ClusterMessagingProtocolClient(ClusterService clusterService, ClusterCommunicationService clusterCommunicator, ControllerNode localNode, TcpMember remoteMember) {
        this.clusterService = clusterService;
        this.clusterCommunicator = clusterCommunicator;
        this.localNode = localNode;
        this.remoteMember = remoteMember;
    }

    public CompletableFuture<PingResponse> ping(PingRequest request) {
        return this.requestReply(request);
    }

    public CompletableFuture<SyncResponse> sync(SyncRequest request) {
        return this.requestReply(request);
    }

    public CompletableFuture<PollResponse> poll(PollRequest request) {
        return this.requestReply(request);
    }

    public CompletableFuture<SubmitResponse> submit(SubmitRequest request) {
        return this.requestReply(request);
    }

    public synchronized CompletableFuture<Void> connect() {
        if (this.pool == null || this.pool.isShutdown()) {
            this.pool = Executors.newCachedThreadPool(Tools.namedThreads((String)"copycat-netty-messaging-client-%d"));
        }
        return CompletableFuture.completedFuture(null);
    }

    public synchronized CompletableFuture<Void> close() {
        if (this.pool != null) {
            this.pool.shutdownNow();
            this.pool = null;
        }
        return CompletableFuture.completedFuture(null);
    }

    private <I> MessageSubject messageType(I input) {
        Class<?> clazz = input.getClass();
        if (clazz.equals(PollRequest.class)) {
            return ClusterMessagingProtocol.COPYCAT_POLL;
        }
        if (clazz.equals(SyncRequest.class)) {
            return ClusterMessagingProtocol.COPYCAT_SYNC;
        }
        if (clazz.equals(SubmitRequest.class)) {
            return ClusterMessagingProtocol.COPYCAT_SUBMIT;
        }
        if (clazz.equals(PingRequest.class)) {
            return ClusterMessagingProtocol.COPYCAT_PING;
        }
        throw new IllegalArgumentException("Unknown class " + clazz.getName());
    }

    private <I, O> CompletableFuture<O> requestReply(I request) {
        CompletableFuture future = new CompletableFuture();
        if (this.pool == null) {
            this.log.info("Attempted to use closed client, connecting now. {}", request);
            this.connect();
        }
        this.pool.submit(new RPCTask(request, future));
        return future;
    }

    private ControllerNode getControllerNode(TcpMember remoteMember) {
        String host = remoteMember.host();
        int port = remoteMember.port();
        for (ControllerNode node : this.clusterService.getNodes()) {
            if (!node.ip().toString().equals(host) || node.tcpPort() != port) continue;
            return node;
        }
        return null;
    }

    private class RPCTask<I, O>
    implements Runnable {
        private final I request;
        private final ClusterMessage message;
        private final CompletableFuture<O> future;

        public RPCTask(I request, CompletableFuture<O> future) {
            this.request = request;
            this.message = new ClusterMessage(ClusterMessagingProtocolClient.this.localNode.id(), ClusterMessagingProtocolClient.this.messageType(request), (byte[])Verify.verifyNotNull((Object)ClusterMessagingProtocol.DB_SERIALIZER.encode(request)));
            this.future = future;
        }

        @Override
        public void run() {
            try {
                if (ClusterMessagingProtocolClient.this.remoteNode == null) {
                    ClusterMessagingProtocolClient.this.remoteNode = ClusterMessagingProtocolClient.this.getControllerNode(ClusterMessagingProtocolClient.this.remoteMember);
                    if (ClusterMessagingProtocolClient.this.remoteNode == null) {
                        throw new IOException("Remote node is offline!");
                    }
                }
                byte[] response = (byte[])ClusterMessagingProtocolClient.this.clusterCommunicator.sendAndReceive(this.message, ClusterMessagingProtocolClient.this.remoteNode.id()).get(2000L, TimeUnit.MILLISECONDS);
                if (!ClusterMessagingProtocolClient.this.connectionOK.getAndSet(true)) {
                    ClusterMessagingProtocolClient.this.log.info("Connectivity to {} restored", (Object)ClusterMessagingProtocolClient.this.remoteNode);
                }
                this.future.complete(Verify.verifyNotNull((Object)ClusterMessagingProtocol.DB_SERIALIZER.decode(response)));
            }
            catch (IOException | TimeoutException e) {
                if (ClusterMessagingProtocolClient.this.connectionOK.getAndSet(false)) {
                    ClusterMessagingProtocolClient.this.log.warn("Detected connectivity issues with {}. Reason: {}", (Object)ClusterMessagingProtocolClient.this.remoteNode, (Object)e.getMessage());
                }
                ClusterMessagingProtocolClient.this.log.debug("RPCTask for {} failed.", this.request, (Object)e);
                this.future.completeExceptionally(e);
            }
            catch (ExecutionException e) {
                ClusterMessagingProtocolClient.this.log.warn("RPCTask execution for {} failed: {}", this.request, (Object)e.getMessage());
                ClusterMessagingProtocolClient.this.log.debug("RPCTask execution for {} failed.", this.request, (Object)e);
                this.future.completeExceptionally(e);
            }
            catch (InterruptedException e) {
                ClusterMessagingProtocolClient.this.log.warn("RPCTask for {} was interrupted: {}", this.request, (Object)e.getMessage());
                ClusterMessagingProtocolClient.this.log.debug("RPCTask for {} was interrupted.", this.request, (Object)e);
                this.future.completeExceptionally(e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                ClusterMessagingProtocolClient.this.log.warn("RPCTask for {} terribly failed.", this.request, (Object)e);
                this.future.completeExceptionally(e);
            }
        }
    }
}

