/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service.impl;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.cluster.TcpMember;
import net.kuujo.copycat.event.LeaderElectEvent;
import net.kuujo.copycat.protocol.Response;
import net.kuujo.copycat.protocol.SubmitRequest;
import net.kuujo.copycat.protocol.SubmitResponse;
import net.kuujo.copycat.spi.protocol.ProtocolClient;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.service.BatchReadRequest;
import org.onosproject.store.service.BatchWriteRequest;
import org.onosproject.store.service.DatabaseException;
import org.onosproject.store.service.ReadResult;
import org.onosproject.store.service.VersionedValue;
import org.onosproject.store.service.WriteResult;
import org.onosproject.store.service.impl.ClusterMessagingProtocol;
import org.onosproject.store.service.impl.DatabaseProtocolService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseClient
implements ClusterMessageHandler {
    private static final int RETRIES = 5;
    private static final int TIMEOUT_MS = 2000;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DatabaseProtocolService protocol;
    private volatile ProtocolClient client = null;
    private volatile Member currentLeader = null;
    private volatile long currentLeaderTerm = 0L;

    public DatabaseClient(DatabaseProtocolService protocol) {
        this.protocol = (DatabaseProtocolService)Preconditions.checkNotNull((Object)protocol);
    }

    public void handle(ClusterMessage message) {
        LeaderElectEvent event = (LeaderElectEvent)ClusterMessagingProtocol.DB_SERIALIZER.decode(message.payload());
        TcpMember newLeader = (TcpMember)event.leader();
        long newLeaderTerm = event.term();
        if (newLeader != null && !newLeader.equals((Object)this.currentLeader) && newLeaderTerm > this.currentLeaderTerm) {
            this.log.info("New leader detected. Leader: {}, term: {}", (Object)newLeader, (Object)newLeaderTerm);
            ProtocolClient prevClient = this.client;
            ProtocolClient newClient = this.protocol.createClient((Member)newLeader);
            newClient.connect();
            this.client = newClient;
            this.currentLeader = newLeader;
            this.currentLeaderTerm = newLeaderTerm;
            if (prevClient != null) {
                prevClient.close();
            }
        }
    }

    private String nextRequestId() {
        return UUID.randomUUID().toString();
    }

    public void waitForLeader() {
        if (this.currentLeader != null) {
            return;
        }
        this.log.info("No leader in cluster, waiting for election.");
        try {
            while (this.currentLeader == null) {
                Thread.sleep(200L);
            }
            return;
        }
        catch (InterruptedException e) {
            this.log.error("Interrupted while waiting for Leader", (Throwable)e);
            Thread.currentThread().interrupt();
            return;
        }
    }

    private <T> T submit(String operationName, Object ... args) {
        this.waitForLeader();
        if (this.currentLeader == null) {
            throw new DatabaseException("Raft cluster does not have a leader.");
        }
        SubmitRequest request = new SubmitRequest((Object)this.nextRequestId(), operationName, Arrays.asList(args));
        CompletableFuture submitResponse = this.client.submit(request);
        this.log.debug("Sent {} to {}", (Object)request, (Object)this.currentLeader);
        try {
            SubmitResponse response = (SubmitResponse)submitResponse.get(2000L, TimeUnit.MILLISECONDS);
            if (response.status() != Response.Status.OK) {
                throw new DatabaseException(response.error());
            }
            return (T)response.result();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new DatabaseException.Timeout((Throwable)e);
        }
    }

    public boolean createTable(String tableName) {
        return (Boolean)this.submit("createTable", tableName);
    }

    public boolean createTable(String tableName, int ttlMillis) {
        return (Boolean)this.submit("createTable", tableName, ttlMillis);
    }

    public void dropTable(String tableName) {
        this.submit("dropTable", tableName);
    }

    public void dropAllTables() {
        this.submit("dropAllTables", new Object[0]);
    }

    public Set<String> listTables() {
        return (Set)this.submit("listTables", new Object[0]);
    }

    public List<ReadResult> batchRead(BatchReadRequest batchRequest) {
        return (List)this.submit("read", batchRequest);
    }

    public List<WriteResult> batchWrite(BatchWriteRequest batchRequest) {
        return (List)this.submit("write", batchRequest);
    }

    public Map<String, VersionedValue> getAll(String tableName) {
        return (Map)this.submit("getAll", tableName);
    }

    Member getCurrentLeader() {
        return this.currentLeader;
    }
}

