/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service.impl;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jodah.expiringmap.ExpiringMap;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.event.EventHandler;
import net.kuujo.copycat.event.LeaderElectEvent;
import org.onlab.util.Tools;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.service.DatabaseService;
import org.onosproject.store.service.VersionedValue;
import org.onosproject.store.service.impl.ClusterMessagingProtocol;
import org.onosproject.store.service.impl.DatabaseStateMachine;
import org.onosproject.store.service.impl.DatabaseUpdateEventListener;
import org.onosproject.store.service.impl.TableModificationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseEntryExpirationTracker
implements DatabaseUpdateEventListener,
EventHandler<LeaderElectEvent> {
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool(Tools.namedThreads((String)"database-stale-entry-expirer-%d"));
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DatabaseService databaseService;
    private final ClusterCommunicationService clusterCommunicator;
    private final Member localMember;
    private final ControllerNode localNode;
    private final AtomicBoolean isLocalMemberLeader = new AtomicBoolean(false);
    private final Map<String, Map<DatabaseRow, Long>> tableEntryExpirationMap = new HashMap<String, Map<DatabaseRow, Long>>();
    private final ExpiringMap.ExpirationListener<DatabaseRow, Long> expirationObserver = new ExpirationObserver();

    DatabaseEntryExpirationTracker(Member localMember, ControllerNode localNode, ClusterCommunicationService clusterCommunicator, DatabaseService databaseService) {
        this.localMember = localMember;
        this.localNode = localNode;
        this.clusterCommunicator = clusterCommunicator;
        this.databaseService = databaseService;
    }

    @Override
    public void tableModified(TableModificationEvent event) {
        this.log.debug("{}: Received {}", (Object)this.localNode.id(), (Object)event);
        if (!this.tableEntryExpirationMap.containsKey(event.tableName())) {
            return;
        }
        Map<DatabaseRow, Long> map = this.tableEntryExpirationMap.get(event.tableName());
        DatabaseRow row = new DatabaseRow(event.tableName(), event.key());
        Long eventVersion = event.value().version();
        switch (event.type()) {
            case ROW_DELETED: {
                map.remove(row, eventVersion);
                if (!this.isLocalMemberLeader.get()) break;
                try {
                    this.log.debug("Broadcasting {} to the entire cluster", (Object)event);
                    this.clusterCommunicator.broadcastIncludeSelf(new ClusterMessage(this.localNode.id(), DatabaseStateMachine.DATABASE_UPDATE_EVENTS, ClusterMessagingProtocol.DB_SERIALIZER.encode((Object)event)));
                }
                catch (IOException e) {
                    this.log.error("Failed to broadcast a database row deleted event.", (Throwable)e);
                }
                break;
            }
            case ROW_ADDED: 
            case ROW_UPDATED: {
                Long currentVersion = map.get(row);
                if (currentVersion != null && currentVersion >= eventVersion) break;
                map.put(row, eventVersion);
                break;
            }
        }
    }

    @Override
    public void tableCreated(DatabaseStateMachine.TableMetadata metadata) {
        this.log.debug("Received a table created event {}", (Object)metadata);
        if (metadata.expireOldEntries()) {
            this.tableEntryExpirationMap.put(metadata.tableName(), (Map<DatabaseRow, Long>)ExpiringMap.builder().expiration((long)metadata.ttlMillis(), TimeUnit.MILLISECONDS).expirationListener(new ExpiringMap.ExpirationListener[]{this.expirationObserver}).expirationPolicy(ExpiringMap.ExpirationPolicy.CREATED).build());
        }
    }

    @Override
    public void tableDeleted(String tableName) {
        this.log.debug("Received a table deleted event for table ({})", (Object)tableName);
        this.tableEntryExpirationMap.remove(tableName);
    }

    public void handle(LeaderElectEvent event) {
        this.isLocalMemberLeader.set(this.localMember.equals((Object)event.leader()));
        if (this.isLocalMemberLeader.get()) {
            this.log.info("{} is now the leader of Raft cluster", (Object)this.localNode.id());
        }
    }

    @Override
    public void snapshotInstalled(DatabaseStateMachine.State state) {
        if (!this.tableEntryExpirationMap.isEmpty()) {
            return;
        }
        this.log.debug("Received a snapshot installed notification");
        for (String tableName : state.getTableNames()) {
            DatabaseStateMachine.TableMetadata metadata = state.getTableMetadata(tableName);
            if (!metadata.expireOldEntries()) continue;
            ExpiringMap tableExpirationMap = ExpiringMap.builder().expiration((long)metadata.ttlMillis(), TimeUnit.MILLISECONDS).expirationListener(new ExpiringMap.ExpirationListener[]{this.expirationObserver}).expirationPolicy(ExpiringMap.ExpirationPolicy.CREATED).build();
            for (Map.Entry<String, VersionedValue> entry : state.getTable(tableName).entrySet()) {
                tableExpirationMap.put(new DatabaseRow(tableName, entry.getKey()), entry.getValue().version());
            }
            this.tableEntryExpirationMap.put(tableName, (Map<DatabaseRow, Long>)tableExpirationMap);
        }
    }

    private class DatabaseRow {
        String tableName;
        String key;

        public DatabaseRow(String tableName, String key) {
            this.tableName = tableName;
            this.key = key;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("tableName", (Object)this.tableName).add("key", (Object)this.key).toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DatabaseRow)) {
                return false;
            }
            DatabaseRow that = (DatabaseRow)obj;
            return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.tableName, this.key);
        }
    }

    private class ExpirationTask
    implements Runnable {
        private final DatabaseRow row;
        private final Long version;

        public ExpirationTask(DatabaseRow row, Long version) {
            this.row = row;
            this.version = version;
        }

        @Override
        public void run() {
            DatabaseEntryExpirationTracker.this.log.trace("Received an expiration event for {}, version: {}", (Object)this.row, (Object)this.version);
            Map map = (Map)DatabaseEntryExpirationTracker.this.tableEntryExpirationMap.get(this.row.tableName);
            try {
                if (DatabaseEntryExpirationTracker.this.isLocalMemberLeader.get()) {
                    if (!DatabaseEntryExpirationTracker.this.databaseService.removeIfVersionMatches(this.row.tableName, this.row.key, this.version.longValue())) {
                        DatabaseEntryExpirationTracker.this.log.info("Entry in database was updated right before its expiration.");
                    } else {
                        DatabaseEntryExpirationTracker.this.log.debug("Successfully expired old entry with key ({}) from table ({})", (Object)this.row.key, (Object)this.row.tableName);
                    }
                } else if (map != null) {
                    map.putIfAbsent(this.row, this.version);
                }
            }
            catch (Exception e) {
                DatabaseEntryExpirationTracker.this.log.warn("Failed to delete entry from the database after ttl expiration. Operation will be retried.", (Throwable)e);
                map.putIfAbsent(this.row, this.version);
            }
        }
    }

    private class ExpirationObserver
    implements ExpiringMap.ExpirationListener<DatabaseRow, Long> {
        private ExpirationObserver() {
        }

        public void expired(DatabaseRow row, Long version) {
            THREAD_POOL.submit(new ExpirationTask(row, version));
        }
    }
}

