/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service.impl;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.kuujo.copycat.Copycat;
import net.kuujo.copycat.CopycatConfig;
import net.kuujo.copycat.StateMachine;
import net.kuujo.copycat.cluster.Cluster;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.cluster.TcpCluster;
import net.kuujo.copycat.cluster.TcpClusterConfig;
import net.kuujo.copycat.cluster.TcpMember;
import net.kuujo.copycat.event.EventHandler;
import net.kuujo.copycat.event.LeaderElectEvent;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.spi.protocol.Protocol;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ClusterEventListener;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.service.BatchReadRequest;
import org.onosproject.store.service.BatchReadResult;
import org.onosproject.store.service.BatchWriteRequest;
import org.onosproject.store.service.BatchWriteResult;
import org.onosproject.store.service.DatabaseAdminService;
import org.onosproject.store.service.DatabaseException;
import org.onosproject.store.service.DatabaseService;
import org.onosproject.store.service.ReadResult;
import org.onosproject.store.service.ReadStatus;
import org.onosproject.store.service.VersionedValue;
import org.onosproject.store.service.WriteResult;
import org.onosproject.store.service.WriteStatus;
import org.onosproject.store.service.impl.ClusterMessagingProtocol;
import org.onosproject.store.service.impl.DatabaseClient;
import org.onosproject.store.service.impl.DatabaseEntryExpirationTracker;
import org.onosproject.store.service.impl.DatabaseProtocolService;
import org.onosproject.store.service.impl.DatabaseStateMachine;
import org.onosproject.store.service.impl.MapDBLog;
import org.onosproject.store.service.impl.TabletDefinitionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=false)
@Service
public class DatabaseManager
implements DatabaseService,
DatabaseAdminService {
    private static final int RETRY_MS = 500;
    private static final int ACTIVATE_MAX_RETRIES = 100;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DatabaseProtocolService copycatMessagingProtocol;
    public static final String LOG_FILE_PREFIX = "raft/onos-copy-cat-log_";
    private static final String CONFIG_DIR = "../config";
    private static final String DEFAULT_MEMBER_FILE = "tablets.json";
    private static final String DEFAULT_TABLET = "default";
    private String initialMemberConfig = "tablets.json";
    public static final MessageSubject RAFT_LEADER_ELECTION_EVENT = new MessageSubject("raft-leader-election-event");
    private Copycat copycat;
    private DatabaseClient client;
    private ClusterConfig<TcpMember> clusterConfig;
    private CountDownLatch clusterEventLatch;
    private ClusterEventListener clusterEventListener;
    private Map<String, Set<DefaultControllerNode>> tabletMembers;
    private boolean autoAddMember = false;
    private ScheduledExecutorService executor;
    private volatile LeaderElectEvent myLeaderEvent = null;
    private int maxLogSizeBytes = 0x8000000;
    private long electionTimeoutMs = 5000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    public void activate() throws InterruptedException, ExecutionException {
        String dataDir = System.getProperty("karaf.data", "./data");
        File file = new File(CONFIG_DIR, this.initialMemberConfig);
        this.log.info("Loading config: {}", (Object)file.getAbsolutePath());
        TabletDefinitionStore tabletDef = new TabletDefinitionStore(file);
        try {
            this.tabletMembers = tabletDef.read();
        }
        catch (IOException e) {
            this.log.error("Failed to load tablet config {}", (Object)file);
            throw new IllegalStateException("Failed to load tablet config", e);
        }
        this.clusterConfig = new TcpClusterConfig();
        Set<DefaultControllerNode> defaultMembers = this.tabletMembers.get(DEFAULT_TABLET);
        if (defaultMembers == null || defaultMembers.isEmpty()) {
            this.log.error("No members found in [{}] tablet configuration.", (Object)DEFAULT_TABLET);
            throw new IllegalStateException("No member found in tablet configuration");
        }
        ControllerNode localNode = this.clusterService.getLocalNode();
        for (ControllerNode controllerNode : defaultMembers) {
            TcpMember tcpMember = new TcpMember(controllerNode.ip().toString(), controllerNode.tcpPort());
            if (localNode.equals(controllerNode)) {
                this.clusterConfig.setLocalMember((Member)tcpMember);
                continue;
            }
            this.clusterConfig.addRemoteMember((Member)tcpMember);
        }
        if (this.clusterConfig.getLocalMember() != null) {
            TcpCluster cluster;
            this.waitForClusterQuorum();
            ClusterConfig<TcpMember> clusterConfig = this.clusterConfig;
            synchronized (clusterConfig) {
                cluster = new TcpCluster(this.clusterConfig);
            }
            this.log.info("Starting cluster: {}", (Object)cluster);
            DatabaseEntryExpirationTracker databaseEntryExpirationTracker = new DatabaseEntryExpirationTracker(this.clusterConfig.getLocalMember(), this.clusterService.getLocalNode(), this.clusterCommunicator, this);
            DatabaseStateMachine stateMachine = new DatabaseStateMachine();
            stateMachine.addEventListener(databaseEntryExpirationTracker);
            MapDBLog consensusLog = new MapDBLog(dataDir + "/" + LOG_FILE_PREFIX + localNode.id(), ClusterMessagingProtocol.DB_SERIALIZER);
            CopycatConfig ccConfig = new CopycatConfig();
            ccConfig.setMaxLogSize(this.maxLogSizeBytes);
            ccConfig.setElectionTimeout(this.electionTimeoutMs);
            this.copycat = new Copycat((StateMachine)stateMachine, (Log)consensusLog, (Cluster)cluster, (Protocol)this.copycatMessagingProtocol, ccConfig);
            this.copycat.event(LeaderElectEvent.class).registerHandler((EventHandler)new RaftLeaderElectionMonitor());
            this.copycat.event(LeaderElectEvent.class).registerHandler((EventHandler)databaseEntryExpirationTracker);
        }
        this.client = new DatabaseClient(this.copycatMessagingProtocol);
        this.clusterCommunicator.addSubscriber(RAFT_LEADER_ELECTION_EVENT, (ClusterMessageHandler)this.client);
        if (this.copycat != null) {
            this.copycat.start().get();
            this.executor = Executors.newSingleThreadScheduledExecutor(Tools.namedThreads((String)"db-heartbeat-%d"));
            this.executor.scheduleWithFixedDelay(new LeaderAdvertiser(), 5L, 2L, TimeUnit.SECONDS);
        }
        this.client.waitForLeader();
        this.tryTableListing();
        this.log.info("Started.");
    }

    @Deactivate
    public void deactivate() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.clusterService.removeListener(this.clusterEventListener);
        this.clusterCommunicator.removeSubscriber(RAFT_LEADER_ELECTION_EVENT);
        if (this.copycat != null) {
            this.copycat.stop();
        }
        this.log.info("Stopped.");
    }

    private void waitForClusterQuorum() {
        this.clusterEventLatch = new CountDownLatch(1);
        this.clusterEventListener = new InternalClusterEventListener();
        this.clusterService.addListener(this.clusterEventListener);
        int raftClusterSize = this.clusterConfig.getMembers().size();
        int raftClusterQuorumSize = (int)Math.floor(raftClusterSize / 2) + 1;
        if (this.clusterService.getNodes().size() < raftClusterQuorumSize) {
            try {
                int waitTimeSec = 120;
                this.log.info("Waiting for a maximum of {}s for raft cluster quorum to boot up...", (Object)120);
                if (!this.clusterEventLatch.await(120L, TimeUnit.SECONDS)) {
                    this.log.info("Starting with {}/{} nodes cluster", (Object)this.clusterService.getNodes().size(), (Object)raftClusterSize);
                }
            }
            catch (InterruptedException e) {
                this.log.info("Interrupted waiting for raft quorum.", (Throwable)e);
            }
        }
    }

    private void tryTableListing() throws InterruptedException {
        int retries = 0;
        while (true) {
            try {
                this.listTables();
                return;
            }
            catch (DatabaseException.Timeout e) {
                this.log.debug("Failed to listTables. Will retry...", (Throwable)e);
            }
            catch (DatabaseException e) {
                this.log.debug("Failed to listTables. Will retry later...", (Throwable)e);
                Thread.sleep(500L);
            }
            if (retries == 100) {
                this.log.error("Failed to listTables after multiple attempts. Giving up.");
                return;
            }
            ++retries;
        }
    }

    public boolean createTable(String name) {
        return this.client.createTable(name);
    }

    public boolean createTable(String name, int ttlMillis) {
        return this.client.createTable(name, ttlMillis);
    }

    public void dropTable(String name) {
        this.client.dropTable(name);
    }

    public void dropAllTables() {
        this.client.dropAllTables();
    }

    public Set<String> listTables() {
        return this.client.listTables();
    }

    public VersionedValue get(String tableName, String key) {
        BatchReadRequest batchRequest = new BatchReadRequest.Builder().get(tableName, key).build();
        ReadResult readResult = (ReadResult)this.batchRead(batchRequest).getAsList().get(0);
        if (readResult.status().equals((Object)ReadStatus.OK)) {
            return readResult.value();
        }
        throw new DatabaseException("get failed due to status: " + readResult.status());
    }

    public Map<String, VersionedValue> getAll(String tableName) {
        return this.client.getAll(tableName);
    }

    public BatchReadResult batchRead(BatchReadRequest batchRequest) {
        return new BatchReadResult(this.client.batchRead(batchRequest));
    }

    public BatchWriteResult batchWrite(BatchWriteRequest batchRequest) {
        return new BatchWriteResult(this.client.batchWrite(batchRequest));
    }

    public VersionedValue put(String tableName, String key, byte[] value) {
        BatchWriteRequest batchRequest = new BatchWriteRequest.Builder().put(tableName, key, value).build();
        WriteResult writeResult = (WriteResult)this.batchWrite(batchRequest).getAsList().get(0);
        if (writeResult.status().equals((Object)WriteStatus.OK)) {
            return writeResult.previousValue();
        }
        throw new DatabaseException("put failed due to status: " + writeResult.status());
    }

    public boolean putIfAbsent(String tableName, String key, byte[] value) {
        BatchWriteRequest batchRequest = new BatchWriteRequest.Builder().putIfAbsent(tableName, key, value).build();
        WriteResult writeResult = (WriteResult)this.batchWrite(batchRequest).getAsList().get(0);
        if (writeResult.status().equals((Object)WriteStatus.OK)) {
            return true;
        }
        if (writeResult.status().equals((Object)WriteStatus.PRECONDITION_VIOLATION)) {
            return false;
        }
        throw new DatabaseException("putIfAbsent failed due to status: " + writeResult.status());
    }

    public boolean putIfVersionMatches(String tableName, String key, byte[] value, long version) {
        BatchWriteRequest batchRequest = new BatchWriteRequest.Builder().putIfVersionMatches(tableName, key, value, version).build();
        WriteResult writeResult = (WriteResult)this.batchWrite(batchRequest).getAsList().get(0);
        if (writeResult.status().equals((Object)WriteStatus.OK)) {
            return true;
        }
        if (writeResult.status().equals((Object)WriteStatus.PRECONDITION_VIOLATION)) {
            return false;
        }
        throw new DatabaseException("putIfVersionMatches failed due to status: " + writeResult.status());
    }

    public boolean putIfValueMatches(String tableName, String key, byte[] oldValue, byte[] newValue) {
        BatchWriteRequest batchRequest = new BatchWriteRequest.Builder().putIfValueMatches(tableName, key, oldValue, newValue).build();
        WriteResult writeResult = (WriteResult)this.batchWrite(batchRequest).getAsList().get(0);
        if (writeResult.status().equals((Object)WriteStatus.OK)) {
            return true;
        }
        if (writeResult.status().equals((Object)WriteStatus.PRECONDITION_VIOLATION)) {
            return false;
        }
        throw new DatabaseException("putIfValueMatches failed due to status: " + writeResult.status());
    }

    public VersionedValue remove(String tableName, String key) {
        BatchWriteRequest batchRequest = new BatchWriteRequest.Builder().remove(tableName, key).build();
        WriteResult writeResult = (WriteResult)this.batchWrite(batchRequest).getAsList().get(0);
        if (writeResult.status().equals((Object)WriteStatus.OK)) {
            return writeResult.previousValue();
        }
        throw new DatabaseException("remove failed due to status: " + writeResult.status());
    }

    public boolean removeIfVersionMatches(String tableName, String key, long version) {
        BatchWriteRequest batchRequest = new BatchWriteRequest.Builder().removeIfVersionMatches(tableName, key, version).build();
        WriteResult writeResult = (WriteResult)this.batchWrite(batchRequest).getAsList().get(0);
        if (writeResult.status().equals((Object)WriteStatus.OK)) {
            return true;
        }
        if (writeResult.status().equals((Object)WriteStatus.PRECONDITION_VIOLATION)) {
            return false;
        }
        throw new DatabaseException("removeIfVersionMatches failed due to status: " + writeResult.status());
    }

    public boolean removeIfValueMatches(String tableName, String key, byte[] value) {
        BatchWriteRequest batchRequest = new BatchWriteRequest.Builder().removeIfValueMatches(tableName, key, value).build();
        WriteResult writeResult = (WriteResult)this.batchWrite(batchRequest).getAsList().get(0);
        if (writeResult.status().equals((Object)WriteStatus.OK)) {
            return true;
        }
        if (writeResult.status().equals((Object)WriteStatus.PRECONDITION_VIOLATION)) {
            return false;
        }
        throw new DatabaseException("removeIfValueMatches failed due to status: " + writeResult.status());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMember(ControllerNode node) {
        TcpMember tcpMember = new TcpMember(node.ip().toString(), node.tcpPort());
        this.log.info("{} was added to the cluster", (Object)tcpMember);
        ClusterConfig<TcpMember> clusterConfig = this.clusterConfig;
        synchronized (clusterConfig) {
            this.clusterConfig.addRemoteMember((Member)tcpMember);
        }
    }

    public Optional<ControllerNode> leader() {
        if (this.copycat != null) {
            if (this.copycat.isLeader()) {
                return Optional.of(this.clusterService.getLocalNode());
            }
            Member leader = this.copycat.cluster().remoteMember(this.copycat.leader());
            return Optional.ofNullable(this.getNodeIdFromMember(leader));
        }
        return Optional.ofNullable(this.getNodeIdFromMember(this.client.getCurrentLeader()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(ControllerNode node) {
        TcpMember tcpMember = new TcpMember(node.ip().toString(), node.tcpPort());
        this.log.info("{} was removed from the cluster", (Object)tcpMember);
        ClusterConfig<TcpMember> clusterConfig = this.clusterConfig;
        synchronized (clusterConfig) {
            this.clusterConfig.removeRemoteMember((Member)tcpMember);
        }
    }

    public Collection<ControllerNode> listMembers() {
        if (this.copycat == null) {
            return ImmutableList.of();
        }
        HashSet<ControllerNode> members = new HashSet<ControllerNode>();
        for (Member member : this.copycat.cluster().members()) {
            ControllerNode node = this.getNodeIdFromMember(member);
            if (node == null) {
                this.log.info("No Node found for {}", (Object)member);
                continue;
            }
            members.add(node);
        }
        return members;
    }

    private ControllerNode getNodeIdFromMember(Member member) {
        if (member instanceof TcpMember) {
            TcpMember tcpMember = (TcpMember)member;
            IpAddress ip = IpAddress.valueOf((String)tcpMember.host());
            int tcpPort = tcpMember.port();
            for (ControllerNode node : this.clusterService.getNodes()) {
                if (!node.ip().equals((Object)ip) || node.tcpPort() != tcpPort) continue;
                return node;
            }
        }
        return null;
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindCopycatMessagingProtocol(DatabaseProtocolService databaseProtocolService) {
        this.copycatMessagingProtocol = databaseProtocolService;
    }

    protected void unbindCopycatMessagingProtocol(DatabaseProtocolService databaseProtocolService) {
        if (this.copycatMessagingProtocol == databaseProtocolService) {
            this.copycatMessagingProtocol = null;
        }
    }

    private final class InternalClusterEventListener
    implements ClusterEventListener {
        private InternalClusterEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(ClusterEvent event) {
            ControllerNode node = (ControllerNode)event.subject();
            TcpMember tcpMember = new TcpMember(node.ip().toString(), node.tcpPort());
            switch ((ClusterEvent.Type)event.type()) {
                case INSTANCE_ACTIVATED: 
                case INSTANCE_ADDED: {
                    if (!DatabaseManager.this.autoAddMember) break;
                    ClusterConfig clusterConfig = DatabaseManager.this.clusterConfig;
                    synchronized (clusterConfig) {
                        if (!DatabaseManager.this.clusterConfig.getMembers().contains(tcpMember)) {
                            DatabaseManager.this.log.info("{} was automatically added to the cluster", (Object)tcpMember);
                            DatabaseManager.this.clusterConfig.addRemoteMember((Member)tcpMember);
                        }
                        break;
                    }
                }
                case INSTANCE_DEACTIVATED: 
                case INSTANCE_REMOVED: {
                    Set members;
                    if (!DatabaseManager.this.autoAddMember || (members = DatabaseManager.this.tabletMembers.getOrDefault(DatabaseManager.DEFAULT_TABLET, Collections.emptySet())).contains(node)) break;
                    ClusterConfig clusterConfig = DatabaseManager.this.clusterConfig;
                    synchronized (clusterConfig) {
                        if (DatabaseManager.this.clusterConfig.getMembers().contains(tcpMember)) {
                            DatabaseManager.this.log.info("{} was automatically removed from the cluster", (Object)tcpMember);
                            DatabaseManager.this.clusterConfig.removeRemoteMember((Member)tcpMember);
                        }
                        break;
                    }
                }
            }
            if (DatabaseManager.this.copycat != null) {
                DatabaseManager.this.log.debug("Current cluster: {}", (Object)DatabaseManager.this.copycat.cluster());
            }
            DatabaseManager.this.clusterEventLatch.countDown();
        }
    }

    private final class RaftLeaderElectionMonitor
    implements EventHandler<LeaderElectEvent> {
        private RaftLeaderElectionMonitor() {
        }

        public void handle(LeaderElectEvent event) {
            try {
                DatabaseManager.this.log.debug("Received LeaderElectEvent: {}", (Object)event);
                if (DatabaseManager.this.clusterConfig.getLocalMember() != null && event.leader().equals((Object)DatabaseManager.this.clusterConfig.getLocalMember())) {
                    DatabaseManager.this.log.debug("Broadcasting RAFT_LEADER_ELECTION_EVENT");
                    DatabaseManager.this.myLeaderEvent = event;
                    DatabaseManager.this.clusterCommunicator.broadcastIncludeSelf(new ClusterMessage(DatabaseManager.this.clusterService.getLocalNode().id(), RAFT_LEADER_ELECTION_EVENT, ClusterMessagingProtocol.DB_SERIALIZER.encode((Object)event)));
                } else {
                    if (DatabaseManager.this.myLeaderEvent != null) {
                        DatabaseManager.this.log.debug("This node is no longer the Leader");
                    }
                    DatabaseManager.this.myLeaderEvent = null;
                }
            }
            catch (IOException e) {
                DatabaseManager.this.log.error("Failed to broadcast raft leadership change event", (Throwable)e);
            }
        }
    }

    private final class LeaderAdvertiser
    implements Runnable {
        private LeaderAdvertiser() {
        }

        @Override
        public void run() {
            try {
                LeaderElectEvent event = DatabaseManager.this.myLeaderEvent;
                if (event != null) {
                    DatabaseManager.this.log.trace("Broadcasting RAFT_LEADER_ELECTION_EVENT: {}", (Object)event);
                    DatabaseManager.this.clusterCommunicator.broadcastIncludeSelf(new ClusterMessage(DatabaseManager.this.clusterService.getLocalNode().id(), RAFT_LEADER_ELECTION_EVENT, ClusterMessagingProtocol.DB_SERIALIZER.encode((Object)event)));
                }
            }
            catch (Exception e) {
                DatabaseManager.this.log.debug("LeaderAdvertiser failed with exception", (Throwable)e);
            }
        }
    }
}

