/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service.impl;

import com.google.common.base.Verify;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.onosproject.cluster.ClusterService;
import org.onosproject.store.service.DatabaseException;
import org.onosproject.store.service.DatabaseService;
import org.onosproject.store.service.Lock;
import org.onosproject.store.service.VersionedValue;
import org.onosproject.store.service.impl.DistributedLockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLock
implements Lock {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DistributedLockManager lockManager;
    private final DatabaseService databaseService;
    private final String path;
    private DateTime lockExpirationTime;
    private AtomicBoolean isLocked = new AtomicBoolean(false);
    private volatile long epoch = 0L;
    private byte[] lockId;

    public DistributedLock(String path, DatabaseService databaseService, ClusterService clusterService, DistributedLockManager lockManager) {
        this.path = path;
        this.databaseService = databaseService;
        this.lockManager = lockManager;
        this.lockId = (UUID.randomUUID().toString() + "::" + clusterService.getLocalNode().id().toString()).getBytes(StandardCharsets.UTF_8);
    }

    public String path() {
        return this.path;
    }

    public void lock(int leaseDurationMillis) throws InterruptedException {
        try {
            this.lockAsync(leaseDurationMillis).get();
        }
        catch (ExecutionException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public CompletableFuture<Void> lockAsync(int leaseDurationMillis) {
        try {
            if (this.isLocked() || this.tryLock(leaseDurationMillis)) {
                return CompletableFuture.completedFuture(null);
            }
            return this.lockManager.lockIfAvailable(this, leaseDurationMillis);
        }
        catch (DatabaseException e) {
            CompletableFuture<Void> lockFuture = new CompletableFuture<Void>();
            lockFuture.completeExceptionally(e);
            return lockFuture;
        }
    }

    public boolean tryLock(int leaseDurationMillis) {
        if (this.databaseService.putIfAbsent("onos-locks", this.path, this.lockId)) {
            VersionedValue vv = this.databaseService.get("onos-locks", this.path);
            Verify.verify((boolean)Arrays.equals(vv.value(), this.lockId));
            this.epoch = vv.version();
            this.isLocked.set(true);
            this.lockExpirationTime = DateTime.now().plusMillis(leaseDurationMillis);
            return true;
        }
        return false;
    }

    public boolean tryLock(int waitTimeMillis, int leaseDurationMillis) throws InterruptedException {
        if (this.isLocked() || this.tryLock(leaseDurationMillis)) {
            return true;
        }
        CompletableFuture<Void> future = this.lockManager.lockIfAvailable(this, waitTimeMillis, leaseDurationMillis);
        try {
            future.get(waitTimeMillis, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (ExecutionException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (TimeoutException e) {
            this.log.debug("Timed out waiting to acquire lock for {}", (Object)this.path);
            return false;
        }
    }

    public boolean isLocked() {
        if (this.isLocked.get()) {
            if (DateTime.now().isAfter((ReadableInstant)this.lockExpirationTime)) {
                this.isLocked.set(false);
                return false;
            }
            return true;
        }
        return false;
    }

    public long epoch() {
        return this.epoch;
    }

    public void unlock() {
        if (!this.isLocked()) {
            return;
        }
        if (this.databaseService.removeIfValueMatches("onos-locks", this.path, this.lockId)) {
            this.isLocked.set(false);
        }
    }

    public boolean extendExpiration(int leaseDurationMillis) {
        if (!this.isLocked()) {
            this.log.warn("Ignoring request to extend expiration for lock {}. ExtendExpiration must be called for locks that are already acquired.", (Object)this.path);
            return false;
        }
        if (this.databaseService.putIfValueMatches("onos-locks", this.path, this.lockId, this.lockId)) {
            this.lockExpirationTime = DateTime.now().plusMillis(leaseDurationMillis);
            this.log.debug("Succeeded in extending lock {} expiration time to {}", (Object)this.lockExpirationTime);
            return true;
        }
        this.log.info("Failed to extend expiration for {}", (Object)this.path);
        return false;
    }
}

