/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service.impl;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.service.DatabaseAdminService;
import org.onosproject.store.service.DatabaseException;
import org.onosproject.store.service.DatabaseService;
import org.onosproject.store.service.Lock;
import org.onosproject.store.service.LockEventListener;
import org.onosproject.store.service.LockService;
import org.onosproject.store.service.impl.ClusterMessagingProtocol;
import org.onosproject.store.service.impl.DatabaseStateMachine;
import org.onosproject.store.service.impl.DistributedLock;
import org.onosproject.store.service.impl.TableModificationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=false)
@Service
public class DistributedLockManager
implements LockService {
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool(Tools.namedThreads((String)"lock-manager-%d"));
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String ONOS_LOCK_TABLE_NAME = "onos-locks";
    public static final int DEAD_LOCK_TIMEOUT_MS = 5000;
    private final ListMultimap<String, LockRequest> locksToAcquire = Multimaps.synchronizedListMultimap((ListMultimap)LinkedListMultimap.create());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private DatabaseAdminService databaseAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private DatabaseService databaseService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private ClusterService clusterService;

    @Activate
    public void activate() {
        try {
            Set tables = this.databaseAdminService.listTables();
            if (!tables.contains(ONOS_LOCK_TABLE_NAME) && this.databaseAdminService.createTable(ONOS_LOCK_TABLE_NAME, 5000)) {
                this.log.info("Created {} table.", (Object)ONOS_LOCK_TABLE_NAME);
            }
        }
        catch (DatabaseException e) {
            this.log.error("DistributedLockManager#activate failed.", (Throwable)e);
        }
        this.clusterCommunicator.addSubscriber(DatabaseStateMachine.DATABASE_UPDATE_EVENTS, (ClusterMessageHandler)new LockEventMessageListener());
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.clusterCommunicator.removeSubscriber(DatabaseStateMachine.DATABASE_UPDATE_EVENTS);
        this.locksToAcquire.clear();
        this.log.info("Stopped.");
    }

    public Lock create(String path) {
        return new DistributedLock(path, this.databaseService, this.clusterService, this);
    }

    public void addListener(LockEventListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeListener(LockEventListener listener) {
        throw new UnsupportedOperationException();
    }

    protected CompletableFuture<Void> lockIfAvailable(Lock lock, int waitTimeMillis, int leaseDurationMillis) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        LockRequest request = new LockRequest(lock, leaseDurationMillis, DateTime.now().plusMillis(waitTimeMillis), future);
        this.locksToAcquire.put((Object)lock.path(), (Object)request);
        return future;
    }

    protected CompletableFuture<Void> lockIfAvailable(Lock lock, int leaseDurationMillis) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        LockRequest request = new LockRequest(lock, leaseDurationMillis, DateTime.now().plusYears(100), future);
        this.locksToAcquire.put((Object)lock.path(), (Object)request);
        return future;
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindDatabaseAdminService(DatabaseAdminService databaseAdminService) {
        this.databaseAdminService = databaseAdminService;
    }

    protected void unbindDatabaseAdminService(DatabaseAdminService databaseAdminService) {
        if (this.databaseAdminService == databaseAdminService) {
            this.databaseAdminService = null;
        }
    }

    protected void bindDatabaseService(DatabaseService databaseService) {
        this.databaseService = databaseService;
    }

    protected void unbindDatabaseService(DatabaseService databaseService) {
        if (this.databaseService == databaseService) {
            this.databaseService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    private class LockRequest {
        private final Lock lock;
        private final DateTime requestExpirationTime;
        private final int leaseDurationMillis;
        private final CompletableFuture<Void> future;

        public LockRequest(Lock lock, int leaseDurationMillis, DateTime requestExpirationTime, CompletableFuture<Void> future) {
            this.lock = lock;
            this.requestExpirationTime = requestExpirationTime;
            this.leaseDurationMillis = leaseDurationMillis;
            this.future = future;
        }

        public Lock lock() {
            return this.lock;
        }

        public DateTime requestExpirationTime() {
            return this.requestExpirationTime;
        }

        public int leaseDurationMillis() {
            return this.leaseDurationMillis;
        }

        public CompletableFuture<Void> future() {
            return this.future;
        }
    }

    private class RetryLockTask
    implements Runnable {
        private final String path;

        public RetryLockTask(String path) {
            this.path = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!DistributedLockManager.this.locksToAcquire.containsKey((Object)this.path)) {
                return;
            }
            List existingRequests = DistributedLockManager.this.locksToAcquire.get((Object)this.path);
            if (existingRequests == null || existingRequests.isEmpty()) {
                return;
            }
            DistributedLockManager.this.log.info("Path {} is now available for locking. There are {} outstanding requests for it.", (Object)this.path, (Object)existingRequests.size());
            List list = existingRequests;
            synchronized (list) {
                Iterator existingRequestIterator = existingRequests.iterator();
                while (existingRequestIterator.hasNext()) {
                    LockRequest request = (LockRequest)existingRequestIterator.next();
                    if (DateTime.now().isAfter((ReadableInstant)request.requestExpirationTime())) {
                        existingRequestIterator.remove();
                        continue;
                    }
                    if (!request.lock().tryLock(request.leaseDurationMillis())) continue;
                    request.future().complete(null);
                    existingRequestIterator.remove();
                }
            }
        }
    }

    private class LockEventMessageListener
    implements ClusterMessageHandler {
        private LockEventMessageListener() {
        }

        public void handle(ClusterMessage message) {
            TableModificationEvent event = (TableModificationEvent)ClusterMessagingProtocol.DB_SERIALIZER.decode(message.payload());
            if (event.tableName().equals(DistributedLockManager.ONOS_LOCK_TABLE_NAME) && event.type().equals((Object)TableModificationEvent.Type.ROW_DELETED)) {
                THREAD_POOL.submit(new RetryLockTask(event.key()));
            }
        }
    }
}

