/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import net.kuujo.copycat.log.Entry;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.log.LogIndexOutOfBoundsException;
import org.mapdb.Atomic;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.mapdb.TxBlock;
import org.mapdb.TxMaker;
import org.onosproject.store.serializers.StoreSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDBLog
implements Log {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final File dbFile;
    private TxMaker txMaker;
    private final StoreSerializer serializer;
    private static final String LOG_NAME = "log";
    private static final String SIZE_FIELD_NAME = "size";
    private int cacheSize = 256;

    public MapDBLog(String dbFileName, StoreSerializer serializer) {
        this.dbFile = new File(dbFileName);
        this.serializer = serializer;
    }

    public void open() throws IOException {
        this.txMaker = DBMaker.newFileDB((File)this.dbFile).mmapFileEnableIfSupported().cacheSize(this.cacheSize).makeTxMaker();
        this.log.info("Raft log file: {}", (Object)this.dbFile.getCanonicalPath());
    }

    public void close() throws IOException {
        this.assertIsOpen();
        this.txMaker.close();
        this.txMaker = null;
    }

    public boolean isOpen() {
        return this.txMaker != null;
    }

    protected void assertIsOpen() {
        Preconditions.checkState((boolean)this.isOpen(), (Object)"The log is not currently open.");
    }

    public long appendEntry(Entry entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"expecting non-null entry");
        return this.appendEntries(entry).get(0);
    }

    public List<Long> appendEntries(Entry ... entries) {
        Preconditions.checkArgument((entries != null ? 1 : 0) != 0, (Object)"expecting non-null entries");
        return this.appendEntries(Arrays.asList(entries));
    }

    public synchronized List<Long> appendEntries(final List<Entry> entries) {
        this.assertIsOpen();
        Preconditions.checkArgument((entries != null ? 1 : 0) != 0, (Object)"expecting non-null entries");
        final ArrayList<Long> indices = new ArrayList<Long>(entries.size());
        this.txMaker.execute(new TxBlock(){

            public void tx(DB db) {
                BTreeMap log = MapDBLog.this.getLogMap(db);
                Atomic.Long size = db.getAtomicLong(MapDBLog.SIZE_FIELD_NAME);
                long nextIndex = log.isEmpty() ? 1L : (Long)log.lastKey() + 1L;
                long addedBytes = 0L;
                for (Entry entry : entries) {
                    byte[] entryBytes = (byte[])Verify.verifyNotNull((Object)MapDBLog.this.serializer.encode((Object)entry), (String)"Writing LogEntry %s failed", (Object[])new Object[]{nextIndex});
                    log.put((Object)nextIndex, (Object)entryBytes);
                    addedBytes += (long)entryBytes.length;
                    indices.add(nextIndex);
                    ++nextIndex;
                }
                size.addAndGet(addedBytes);
            }
        });
        return indices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntry(long index) {
        this.assertIsOpen();
        try (DB db = this.txMaker.makeTx();){
            BTreeMap<Long, byte[]> log = this.getLogMap(db);
            boolean bl = log.containsKey((Object)index);
            return bl;
        }
    }

    public void delete() throws IOException {
        this.assertIsOpen();
        this.txMaker.execute(new TxBlock(){

            public void tx(DB db) {
                BTreeMap log = MapDBLog.this.getLogMap(db);
                Atomic.Long size = db.getAtomicLong(MapDBLog.SIZE_FIELD_NAME);
                log.clear();
                size.set(0L);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entry> T firstEntry() {
        this.assertIsOpen();
        try (DB db = this.txMaker.makeTx();){
            BTreeMap<Long, byte[]> log = this.getLogMap(db);
            Entry entry = log.isEmpty() ? null : (Entry)Verify.verifyNotNull(this.decodeEntry((byte[])log.firstEntry().getValue()));
            return (T)entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long firstIndex() {
        this.assertIsOpen();
        try (DB db = this.txMaker.makeTx();){
            BTreeMap<Long, byte[]> log = this.getLogMap(db);
            long l = log.isEmpty() ? 0L : (Long)log.firstKey();
            return l;
        }
    }

    private <T extends Entry> T decodeEntry(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return (T)((Entry)this.serializer.decode((byte[])bytes.clone()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entry> List<T> getEntries(long from, long to) {
        this.assertIsOpen();
        try (DB db = this.txMaker.makeTx();){
            BTreeMap<Long, byte[]> log = this.getLogMap(db);
            if (log.isEmpty()) {
                throw new LogIndexOutOfBoundsException("Log is empty", new Object[0]);
            }
            if (from < (Long)log.firstKey()) {
                throw new LogIndexOutOfBoundsException("From index out of bounds.", new Object[0]);
            }
            if (to > (Long)log.lastKey()) {
                throw new LogIndexOutOfBoundsException("To index out of bounds.", new Object[0]);
            }
            ArrayList<Entry> entries = new ArrayList<Entry>((int)(to - from + 1L));
            for (long i = from; i <= to; ++i) {
                Entry entry = (Entry)Verify.verifyNotNull(this.decodeEntry((byte[])log.get((Object)i)), (String)"LogEntry %s was null", (Object[])new Object[]{i});
                entries.add(entry);
            }
            ArrayList<Entry> arrayList = entries;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entry> T getEntry(long index) {
        this.assertIsOpen();
        try (DB db = this.txMaker.makeTx();){
            BTreeMap<Long, byte[]> log = this.getLogMap(db);
            byte[] entryBytes = (byte[])log.get((Object)index);
            Entry entry = entryBytes == null ? null : (Entry)Verify.verifyNotNull(this.decodeEntry(entryBytes), (String)"LogEntry %s was null", (Object[])new Object[]{index});
            return (T)entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.assertIsOpen();
        try (DB db = this.txMaker.makeTx();){
            BTreeMap<Long, byte[]> log = this.getLogMap(db);
            boolean bl = log.isEmpty();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entry> T lastEntry() {
        this.assertIsOpen();
        try (DB db = this.txMaker.makeTx();){
            BTreeMap<Long, byte[]> log = this.getLogMap(db);
            Entry entry = log.isEmpty() ? null : (Entry)Verify.verifyNotNull(this.decodeEntry((byte[])log.lastEntry().getValue()));
            return (T)entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lastIndex() {
        this.assertIsOpen();
        try (DB db = this.txMaker.makeTx();){
            BTreeMap<Long, byte[]> log = this.getLogMap(db);
            long l = log.isEmpty() ? 0L : (Long)log.lastKey();
            return l;
        }
    }

    public void removeAfter(final long index) {
        this.assertIsOpen();
        this.txMaker.execute(new TxBlock(){

            public void tx(DB db) {
                BTreeMap log = MapDBLog.this.getLogMap(db);
                Atomic.Long size = db.getAtomicLong(MapDBLog.SIZE_FIELD_NAME);
                long removedBytes = 0L;
                ConcurrentNavigableMap tailMap = log.tailMap((Object)index, false);
                Iterator it = tailMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    removedBytes += (long)((byte[])entry.getValue()).length;
                    it.remove();
                }
                size.addAndGet(-removedBytes);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() {
        this.assertIsOpen();
        try (DB db = this.txMaker.makeTx();){
            Atomic.Long size = db.getAtomicLong(SIZE_FIELD_NAME);
            long l = size.get();
            return l;
        }
    }

    public void sync() throws IOException {
        this.assertIsOpen();
    }

    public void compact(final long index, final Entry entry) throws IOException {
        this.assertIsOpen();
        this.txMaker.execute(new TxBlock(){

            public void tx(DB db) {
                BTreeMap log = MapDBLog.this.getLogMap(db);
                Atomic.Long size = db.getAtomicLong(MapDBLog.SIZE_FIELD_NAME);
                ConcurrentNavigableMap headMap = log.headMap((Object)index);
                Iterator it = headMap.entrySet().iterator();
                long deletedBytes = 0L;
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    deletedBytes += (long)((byte[])e.getValue()).length;
                    it.remove();
                }
                size.addAndGet(-deletedBytes);
                byte[] entryBytes = (byte[])Verify.verifyNotNull((Object)MapDBLog.this.serializer.encode((Object)entry));
                byte[] existingEntry = (byte[])log.put((Object)index, (Object)entryBytes);
                if (existingEntry != null) {
                    size.addAndGet((long)(entryBytes.length - existingEntry.length));
                } else {
                    size.addAndGet((long)entryBytes.length);
                }
                db.compact();
            }
        });
    }

    private BTreeMap<Long, byte[]> getLogMap(DB db) {
        return db.createTreeMap(LOG_NAME).valuesOutsideNodesEnable().keySerializerWrap(Serializer.LONG).valueSerializer(Serializer.BYTE_ARRAY).makeOrGet();
    }
}

