/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service.impl;

import com.google.common.base.MoreObjects;
import org.onosproject.store.service.VersionedValue;

public final class TableModificationEvent {
    private final String tableName;
    private final String key;
    private final VersionedValue value;
    private final Type type;

    public static TableModificationEvent rowDeleted(String tableName, String key, VersionedValue value) {
        return new TableModificationEvent(tableName, key, value, Type.ROW_DELETED);
    }

    public static TableModificationEvent rowAdded(String tableName, String key, VersionedValue value) {
        return new TableModificationEvent(tableName, key, value, Type.ROW_ADDED);
    }

    public static TableModificationEvent rowUpdated(String tableName, String key, VersionedValue newValue) {
        return new TableModificationEvent(tableName, key, newValue, Type.ROW_UPDATED);
    }

    private TableModificationEvent(String tableName, String key, VersionedValue value, Type type) {
        this.tableName = tableName;
        this.key = key;
        this.value = value;
        this.type = type;
    }

    public String tableName() {
        return this.tableName;
    }

    public String key() {
        return this.key;
    }

    public VersionedValue value() {
        return this.value;
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("type", (Object)this.type).add("tableName", (Object)this.tableName).add("key", (Object)this.key).add("version", this.value.version()).toString();
    }

    public static enum Type {
        ROW_ADDED,
        ROW_DELETED,
        ROW_UPDATED;

    }
}

