/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service.impl;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletDefinitionStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final File file;

    public TabletDefinitionStore(String filePath) {
        this.file = new File(filePath);
    }

    public TabletDefinitionStore(File filePath) {
        this.file = (File)Preconditions.checkNotNull((Object)filePath);
    }

    public Map<String, Set<DefaultControllerNode>> read() throws IOException {
        HashMap<String, Set<DefaultControllerNode>> tablets = new HashMap<String, Set<DefaultControllerNode>>();
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode tabletNodes = (ObjectNode)mapper.readTree(this.file);
        Iterator fields = tabletNodes.fields();
        while (fields.hasNext()) {
            Map.Entry next = (Map.Entry)fields.next();
            HashSet<DefaultControllerNode> nodes = new HashSet<DefaultControllerNode>();
            Iterator elements = ((JsonNode)next.getValue()).elements();
            while (elements.hasNext()) {
                ObjectNode nodeDef = (ObjectNode)elements.next();
                nodes.add(new DefaultControllerNode(new NodeId(nodeDef.get("id").asText()), IpAddress.valueOf((String)nodeDef.get("ip").asText()), nodeDef.get("tcpPort").asInt(9876)));
            }
            tablets.put((String)next.getKey(), (Set<DefaultControllerNode>)nodes);
        }
        return tablets;
    }

    public void write(String tabletName, Set<DefaultControllerNode> nodes) throws IOException {
        Map<String, Set<DefaultControllerNode>> config;
        Preconditions.checkNotNull((Object)tabletName);
        Preconditions.checkArgument((boolean)tabletName.isEmpty(), (Object)"Tablet name cannot be empty");
        try {
            config = this.read();
        }
        catch (IOException e) {
            this.log.info("Reading tablet config failed, assuming empty definition.");
            config = new HashMap<String, Set<DefaultControllerNode>>();
        }
        config.put(tabletName, nodes);
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode tabletNodes = mapper.createObjectNode();
        for (Map.Entry<String, Set<DefaultControllerNode>> tablet : config.entrySet()) {
            ArrayNode nodeDefs = mapper.createArrayNode();
            tabletNodes.set(tablet.getKey(), (JsonNode)nodeDefs);
            for (DefaultControllerNode node : tablet.getValue()) {
                ObjectNode nodeDef = mapper.createObjectNode();
                nodeDef.put("id", node.id().toString()).put("ip", node.ip().toString()).put("tcpPort", node.tcpPort());
                nodeDefs.add((JsonNode)nodeDef);
            }
        }
        mapper.writeTree(new JsonFactory().createGenerator(this.file, JsonEncoding.UTF8), (JsonNode)tabletNodes);
    }
}

