/*
 * Copyright 2015 Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.onosproject.store.flowext.impl;

import org.onosproject.store.cluster.messaging.MessageSubject;

/**
 * Experimental extension to the flow rule subsystem; still under development.
 * MessageSubjects used by DefaultFlowRuleExtRouter peer-peer communication.
 */
public final class FlowExtRouterMessageSubjects {
    private FlowExtRouterMessageSubjects() {
    }

    /**
     * The subject of routing extended flow to specified device.
     */
    public static final MessageSubject APPLY_EXTEND_FLOWS
            = new MessageSubject("peer-forward-apply-batch-extension");
}
