/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.ecmap;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.store.Timestamp;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.ecmap.AntiEntropyAdvertisement;
import org.onosproject.store.ecmap.EventuallyConsistentMap;
import org.onosproject.store.ecmap.EventuallyConsistentMapEvent;
import org.onosproject.store.ecmap.EventuallyConsistentMapImpl;
import org.onosproject.store.ecmap.EventuallyConsistentMapListener;
import org.onosproject.store.ecmap.PutEntry;
import org.onosproject.store.ecmap.RemoveEntry;
import org.onosproject.store.impl.ClockService;
import org.onosproject.store.impl.WallClockTimestamp;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.KryoSerializer;

public class EventuallyConsistentMapImplTest {
    private EventuallyConsistentMap<String, String> ecMap;
    private ClusterService clusterService;
    private ClusterCommunicationService clusterCommunicator;
    private SequentialClockService<String, String> clockService;
    private static final String MAP_NAME = "test";
    private static final MessageSubject UPDATE_MESSAGE_SUBJECT = new MessageSubject("ecm-test-update");
    private static final MessageSubject ANTI_ENTROPY_MESSAGE_SUBJECT = new MessageSubject("ecm-test-anti-entropy");
    private static final String KEY1 = "one";
    private static final String KEY2 = "two";
    private static final String VALUE1 = "oneValue";
    private static final String VALUE2 = "twoValue";
    private final ControllerNode self = new DefaultControllerNode(new NodeId("local"), IpAddress.valueOf((int)1));
    private ClusterMessageHandler updateHandler;
    private ClusterMessageHandler antiEntropyHandler;
    private static final KryoSerializer SERIALIZER = new KryoSerializer(){

        protected void setupKryoPool() {
            this.serializerPool = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{TestTimestamp.class}).register(new Class[]{WallClockTimestamp.class}).register(new Class[]{PutEntry.class}).register(new Class[]{RemoveEntry.class}).register(new Class[]{ArrayList.class}).register(new Class[]{AntiEntropyAdvertisement.class}).register(new Class[]{HashMap.class}).build();
        }
    };

    @Before
    public void setUp() throws Exception {
        this.clusterService = (ClusterService)EasyMock.createMock(ClusterService.class);
        EasyMock.expect((Object)this.clusterService.getLocalNode()).andReturn((Object)this.self).anyTimes();
        EasyMock.expect((Object)this.clusterService.getNodes()).andReturn((Object)ImmutableSet.of((Object)this.self)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clusterService});
        this.clusterCommunicator = (ClusterCommunicationService)EasyMock.createMock(ClusterCommunicationService.class);
        this.clusterCommunicator.addSubscriber((MessageSubject)EasyMock.anyObject(MessageSubject.class), (ClusterMessageHandler)EasyMock.anyObject(ClusterMessageHandler.class), (ExecutorService)EasyMock.anyObject(ExecutorService.class));
        EasyMock.expectLastCall().andDelegateTo((Object)new TestClusterCommunicationService()).times(3);
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        this.clockService = new SequentialClockService();
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{TestTimestamp.class});
        this.ecMap = new EventuallyConsistentMapImpl(MAP_NAME, this.clusterService, this.clusterCommunicator, serializer, this.clockService).withBroadcastMessageExecutor((ExecutorService)MoreExecutors.newDirectExecutorService());
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
    }

    @After
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
        this.ecMap.destroy();
    }

    private EventuallyConsistentMapListener<String, String> getListener() {
        return (EventuallyConsistentMapListener)EasyMock.createMock(EventuallyConsistentMapListener.class);
    }

    @Test
    public void testSize() throws Exception {
        this.expectPeerMessage(this.clusterCommunicator);
        Assert.assertEquals((long)0L, (long)this.ecMap.size());
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        Assert.assertEquals((long)1L, (long)this.ecMap.size());
        this.ecMap.put((Object)KEY1, (Object)VALUE2);
        Assert.assertEquals((long)1L, (long)this.ecMap.size());
        this.ecMap.put((Object)KEY2, (Object)VALUE2);
        Assert.assertEquals((long)2L, (long)this.ecMap.size());
        for (int i = 0; i < 10; ++i) {
            this.ecMap.put((Object)("" + i), (Object)("" + i));
        }
        Assert.assertEquals((long)12L, (long)this.ecMap.size());
        this.ecMap.remove((Object)KEY1);
        Assert.assertEquals((long)11L, (long)this.ecMap.size());
        this.ecMap.remove((Object)KEY1);
        Assert.assertEquals((long)11L, (long)this.ecMap.size());
    }

    @Test
    public void testIsEmpty() throws Exception {
        this.expectPeerMessage(this.clusterCommunicator);
        Assert.assertTrue((boolean)this.ecMap.isEmpty());
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        TestCase.assertFalse((boolean)this.ecMap.isEmpty());
        this.ecMap.remove((Object)KEY1);
        Assert.assertTrue((boolean)this.ecMap.isEmpty());
    }

    @Test
    public void testContainsKey() throws Exception {
        this.expectPeerMessage(this.clusterCommunicator);
        TestCase.assertFalse((boolean)this.ecMap.containsKey((Object)KEY1));
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        Assert.assertTrue((boolean)this.ecMap.containsKey((Object)KEY1));
        TestCase.assertFalse((boolean)this.ecMap.containsKey((Object)KEY2));
        this.ecMap.remove((Object)KEY1);
        TestCase.assertFalse((boolean)this.ecMap.containsKey((Object)KEY1));
    }

    @Test
    public void testContainsValue() throws Exception {
        this.expectPeerMessage(this.clusterCommunicator);
        TestCase.assertFalse((boolean)this.ecMap.containsValue((Object)VALUE1));
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        Assert.assertTrue((boolean)this.ecMap.containsValue((Object)VALUE1));
        TestCase.assertFalse((boolean)this.ecMap.containsValue((Object)VALUE2));
        this.ecMap.put((Object)KEY1, (Object)VALUE2);
        TestCase.assertFalse((boolean)this.ecMap.containsValue((Object)VALUE1));
        Assert.assertTrue((boolean)this.ecMap.containsValue((Object)VALUE2));
        this.ecMap.remove((Object)KEY1);
        TestCase.assertFalse((boolean)this.ecMap.containsValue((Object)VALUE2));
    }

    @Test
    public void testGet() throws Exception {
        this.expectPeerMessage(this.clusterCommunicator);
        Assert.assertNull((Object)this.ecMap.get((Object)KEY1));
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        Assert.assertEquals((Object)VALUE1, (Object)this.ecMap.get((Object)KEY1));
        ClusterMessage message = this.generatePutMessage(KEY2, VALUE2, this.clockService.getTimestamp(KEY2, VALUE2));
        CountDownLatch latch = new CountDownLatch(1);
        this.ecMap.addListener((EventuallyConsistentMapListener)new TestListener(latch));
        Assert.assertNull((Object)this.ecMap.get((Object)KEY2));
        this.updateHandler.handle(message);
        Assert.assertTrue((String)"External listener never got notified of internal event", (boolean)latch.await(100L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)VALUE2, (Object)this.ecMap.get((Object)KEY2));
        this.ecMap.remove((Object)KEY2);
        Assert.assertNull((Object)this.ecMap.get((Object)KEY2));
        ClusterMessage removeMessage = this.generateRemoveMessage(KEY1, this.clockService.getTimestamp(KEY1, VALUE1));
        latch = new CountDownLatch(1);
        this.ecMap.addListener((EventuallyConsistentMapListener)new TestListener(latch));
        this.updateHandler.handle(removeMessage);
        Assert.assertTrue((String)"External listener never got notified of internal event", (boolean)latch.await(100L, TimeUnit.MILLISECONDS));
        Assert.assertNull((Object)this.ecMap.get((Object)KEY1));
    }

    @Test
    public void testPut() throws Exception {
        EventuallyConsistentMapListener<String, String> listener = this.getListener();
        listener.event(new EventuallyConsistentMapEvent(EventuallyConsistentMapEvent.Type.PUT, (Object)KEY1, (Object)VALUE1));
        listener.event(new EventuallyConsistentMapEvent(EventuallyConsistentMapEvent.Type.PUT, (Object)KEY1, (Object)VALUE2));
        EasyMock.replay((Object[])new Object[]{listener});
        this.ecMap.addListener(listener);
        EventuallyConsistentMapImplTest.expectSpecificMulticastMessage(this.generatePutMessage(KEY1, VALUE1, this.clockService.peekAtNextTimestamp()), this.clusterCommunicator);
        Assert.assertNull((Object)this.ecMap.get((Object)KEY1));
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        Assert.assertEquals((Object)VALUE1, (Object)this.ecMap.get((Object)KEY1));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EventuallyConsistentMapImplTest.expectSpecificMulticastMessage(this.generatePutMessage(KEY1, VALUE2, this.clockService.peekAtNextTimestamp()), this.clusterCommunicator);
        this.ecMap.put((Object)KEY1, (Object)VALUE2);
        Assert.assertEquals((Object)VALUE2, (Object)this.ecMap.get((Object)KEY1));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        this.clockService.turnBackTime();
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        Assert.assertEquals((Object)VALUE2, (Object)this.ecMap.get((Object)KEY1));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testRemove() throws Exception {
        EventuallyConsistentMapListener<String, String> listener = this.getListener();
        listener.event(new EventuallyConsistentMapEvent(EventuallyConsistentMapEvent.Type.REMOVE, (Object)KEY1, null));
        EasyMock.expectLastCall().times(2);
        listener.event(new EventuallyConsistentMapEvent(EventuallyConsistentMapEvent.Type.PUT, (Object)KEY1, (Object)VALUE1));
        listener.event(new EventuallyConsistentMapEvent(EventuallyConsistentMapEvent.Type.PUT, (Object)KEY2, (Object)VALUE2));
        EasyMock.replay((Object[])new Object[]{listener});
        this.ecMap.addListener(listener);
        this.expectPeerMessage(this.clusterCommunicator);
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        Assert.assertEquals((Object)VALUE1, (Object)this.ecMap.get((Object)KEY1));
        EventuallyConsistentMapImplTest.expectSpecificMulticastMessage(this.generateRemoveMessage(KEY1, this.clockService.peekAtNextTimestamp()), this.clusterCommunicator);
        this.ecMap.remove((Object)KEY1);
        Assert.assertNull((Object)this.ecMap.get((Object)KEY1));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EventuallyConsistentMapImplTest.expectSpecificMulticastMessage(this.generateRemoveMessage(KEY1, this.clockService.peekAtNextTimestamp()), this.clusterCommunicator);
        this.ecMap.remove((Object)KEY1);
        Assert.assertNull((Object)this.ecMap.get((Object)KEY1));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        this.expectPeerMessage(this.clusterCommunicator);
        this.ecMap.put((Object)KEY2, (Object)VALUE2);
        this.clockService.turnBackTime();
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        this.ecMap.remove((Object)KEY2);
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testPutAll() throws Exception {
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        this.ecMap.putAll(new HashMap());
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EventuallyConsistentMapListener<String, String> listener = this.getListener();
        listener.event(new EventuallyConsistentMapEvent(EventuallyConsistentMapEvent.Type.PUT, (Object)KEY1, (Object)VALUE1));
        listener.event(new EventuallyConsistentMapEvent(EventuallyConsistentMapEvent.Type.PUT, (Object)KEY2, (Object)VALUE2));
        EasyMock.replay((Object[])new Object[]{listener});
        this.ecMap.addListener(listener);
        EventuallyConsistentMapImplTest.expectSpecificBroadcastMessage(this.generatePutMessage(KEY1, VALUE1, KEY2, VALUE2), this.clusterCommunicator);
        HashMap<String, String> putAllValues = new HashMap<String, String>();
        putAllValues.put(KEY1, VALUE1);
        putAllValues.put(KEY2, VALUE2);
        this.ecMap.putAll(putAllValues);
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testClear() throws Exception {
        EventuallyConsistentMapListener<String, String> listener = this.getListener();
        listener.event(new EventuallyConsistentMapEvent(EventuallyConsistentMapEvent.Type.REMOVE, (Object)KEY1, null));
        listener.event(new EventuallyConsistentMapEvent(EventuallyConsistentMapEvent.Type.REMOVE, (Object)KEY2, null));
        EasyMock.replay((Object[])new Object[]{listener});
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        Assert.assertTrue((boolean)this.ecMap.isEmpty());
        this.ecMap.clear();
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        this.expectPeerMessage(this.clusterCommunicator);
        this.ecMap.put((Object)KEY1, (Object)VALUE1);
        this.ecMap.put((Object)KEY2, (Object)VALUE2);
        this.ecMap.addListener(listener);
        EventuallyConsistentMapImplTest.expectSpecificBroadcastMessage(this.generateRemoveMessage(KEY1, KEY2), this.clusterCommunicator);
        this.ecMap.clear();
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.verify((Object[])new Object[]{listener});
    }

    @Test
    public void testKeySet() throws Exception {
        this.expectPeerMessage(this.clusterCommunicator);
        Assert.assertTrue((boolean)this.ecMap.keySet().isEmpty());
        HashSet<String> keys = new HashSet<String>();
        for (int i = 1; i <= 10; ++i) {
            keys.add("" + i);
        }
        keys.forEach(k -> this.ecMap.put(k, (Object)("value" + k)));
        Assert.assertEquals(keys, (Object)this.ecMap.keySet());
        this.ecMap.put(keys.iterator().next(), (Object)"new-value");
        Assert.assertEquals(keys, (Object)this.ecMap.keySet());
        String removeKey = (String)keys.iterator().next();
        keys.remove(removeKey);
        this.ecMap.remove((Object)removeKey);
        Assert.assertEquals(keys, (Object)this.ecMap.keySet());
    }

    @Test
    public void testValues() throws Exception {
        this.expectPeerMessage(this.clusterCommunicator);
        Assert.assertTrue((boolean)this.ecMap.values().isEmpty());
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        for (int i = 1; i <= 10; ++i) {
            expectedValues.put("" + i, "value" + i);
        }
        expectedValues.entrySet().forEach(e -> this.ecMap.put(e.getKey(), e.getValue()));
        Assert.assertEquals((long)expectedValues.values().size(), (long)this.ecMap.values().size());
        expectedValues.values().forEach(v -> Assert.assertTrue((boolean)this.ecMap.values().contains(v)));
        Map.Entry first = expectedValues.entrySet().iterator().next();
        expectedValues.put((String)first.getKey(), "new-value");
        this.ecMap.put(first.getKey(), (Object)"new-value");
        Assert.assertEquals((long)expectedValues.values().size(), (long)this.ecMap.values().size());
        expectedValues.values().forEach(v -> Assert.assertTrue((boolean)this.ecMap.values().contains(v)));
        String removeKey = (String)expectedValues.keySet().iterator().next();
        expectedValues.remove(removeKey);
        this.ecMap.remove((Object)removeKey);
        Assert.assertEquals((long)expectedValues.values().size(), (long)this.ecMap.values().size());
        expectedValues.values().forEach(v -> Assert.assertTrue((boolean)this.ecMap.values().contains(v)));
    }

    @Test
    public void testEntrySet() throws Exception {
        this.expectPeerMessage(this.clusterCommunicator);
        Assert.assertTrue((boolean)this.ecMap.entrySet().isEmpty());
        HashMap<String, String> expectedValues = new HashMap<String, String>();
        for (int i = 1; i <= 10; ++i) {
            expectedValues.put("" + i, "value" + i);
        }
        expectedValues.entrySet().forEach(e -> this.ecMap.put(e.getKey(), e.getValue()));
        Assert.assertTrue((boolean)EventuallyConsistentMapImplTest.entrySetsAreEqual(expectedValues, this.ecMap.entrySet()));
        Map.Entry first = expectedValues.entrySet().iterator().next();
        expectedValues.put((String)first.getKey(), "new-value");
        this.ecMap.put(first.getKey(), (Object)"new-value");
        Assert.assertTrue((boolean)EventuallyConsistentMapImplTest.entrySetsAreEqual(expectedValues, this.ecMap.entrySet()));
        String removeKey = (String)expectedValues.keySet().iterator().next();
        expectedValues.remove(removeKey);
        this.ecMap.remove((Object)removeKey);
        Assert.assertTrue((boolean)EventuallyConsistentMapImplTest.entrySetsAreEqual(expectedValues, this.ecMap.entrySet()));
    }

    private static boolean entrySetsAreEqual(Map<String, String> expectedMap, Set<Map.Entry<String, String>> actual) {
        if (expectedMap.entrySet().size() != actual.size()) {
            return false;
        }
        for (Map.Entry<String, String> e : actual) {
            if (!expectedMap.containsKey(e.getKey())) {
                return false;
            }
            if (Objects.equals(expectedMap.get(e.getKey()), e.getValue())) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testDestroy() throws Exception {
        this.clusterCommunicator.removeSubscriber(UPDATE_MESSAGE_SUBJECT);
        this.clusterCommunicator.removeSubscriber(ANTI_ENTROPY_MESSAGE_SUBJECT);
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        this.ecMap.destroy();
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        try {
            this.ecMap.get((Object)KEY1);
            Assert.fail((String)"get after destroy should throw exception");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            this.ecMap.put((Object)KEY1, (Object)VALUE1);
            Assert.fail((String)"put after destroy should throw exception");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    private ClusterMessage generatePutMessage(String key, String value, Timestamp timestamp) {
        PutEntry event = new PutEntry((Object)key, (Object)value, timestamp);
        return new ClusterMessage(this.clusterService.getLocalNode().id(), UPDATE_MESSAGE_SUBJECT, SERIALIZER.encode((Object)Lists.newArrayList((Object[])new PutEntry[]{event})));
    }

    private ClusterMessage generatePutMessage(String key1, String value1, String key2, String value2) {
        ArrayList<PutEntry> list = new ArrayList<PutEntry>();
        Timestamp timestamp1 = this.clockService.peek(1);
        Timestamp timestamp2 = this.clockService.peek(2);
        PutEntry pe1 = new PutEntry((Object)key1, (Object)value1, timestamp1);
        PutEntry pe2 = new PutEntry((Object)key2, (Object)value2, timestamp2);
        list.add(pe1);
        list.add(pe2);
        return new ClusterMessage(this.clusterService.getLocalNode().id(), UPDATE_MESSAGE_SUBJECT, SERIALIZER.encode(list));
    }

    private ClusterMessage generateRemoveMessage(String key, Timestamp timestamp) {
        RemoveEntry event = new RemoveEntry((Object)key, timestamp);
        return new ClusterMessage(this.clusterService.getLocalNode().id(), UPDATE_MESSAGE_SUBJECT, SERIALIZER.encode((Object)Lists.newArrayList((Object[])new RemoveEntry[]{event})));
    }

    private ClusterMessage generateRemoveMessage(String key1, String key2) {
        ArrayList<RemoveEntry> list = new ArrayList<RemoveEntry>();
        Timestamp timestamp1 = this.clockService.peek(1);
        Timestamp timestamp2 = this.clockService.peek(2);
        RemoveEntry re1 = new RemoveEntry((Object)key1, timestamp1);
        RemoveEntry re2 = new RemoveEntry((Object)key2, timestamp2);
        list.add(re1);
        list.add(re2);
        return new ClusterMessage(this.clusterService.getLocalNode().id(), UPDATE_MESSAGE_SUBJECT, SERIALIZER.encode(list));
    }

    private static void expectSpecificBroadcastMessage(ClusterMessage m, ClusterCommunicationService clusterCommunicator) {
        EasyMock.reset((Object[])new Object[]{clusterCommunicator});
        EasyMock.expect((Object)clusterCommunicator.unicast((ClusterMessage)EasyMock.eq((Object)m), (NodeId)EasyMock.anyObject(NodeId.class))).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{clusterCommunicator});
    }

    private static void expectSpecificMulticastMessage(ClusterMessage m, ClusterCommunicationService clusterCommunicator) {
        EasyMock.reset((Object[])new Object[]{clusterCommunicator});
        EasyMock.expect((Object)clusterCommunicator.unicast((ClusterMessage)EasyMock.eq((Object)m), (NodeId)EasyMock.anyObject(NodeId.class))).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{clusterCommunicator});
    }

    private void expectPeerMessage(ClusterCommunicationService clusterCommunicator) {
        EasyMock.reset((Object[])new Object[]{clusterCommunicator});
        EasyMock.expect((Object)clusterCommunicator.unicast((ClusterMessage)EasyMock.anyObject(ClusterMessage.class), (NodeId)EasyMock.anyObject(NodeId.class))).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{clusterCommunicator});
    }

    private void expectBroadcastMessage(ClusterCommunicationService clusterCommunicator) {
        EasyMock.reset((Object[])new Object[]{clusterCommunicator});
        EasyMock.expect((Object)clusterCommunicator.unicast((ClusterMessage)EasyMock.anyObject(ClusterMessage.class), (NodeId)EasyMock.anyObject(NodeId.class))).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{clusterCommunicator});
    }

    private class TestListener
    implements EventuallyConsistentMapListener<String, String> {
        private CountDownLatch latch;

        public TestListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void event(EventuallyConsistentMapEvent<String, String> event) {
            this.latch.countDown();
        }
    }

    private class TestTimestamp
    implements Timestamp {
        private final long timestamp;

        public TestTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public int compareTo(Timestamp o) {
            Preconditions.checkArgument((boolean)(o instanceof TestTimestamp));
            TestTimestamp otherTimestamp = (TestTimestamp)o;
            return ComparisonChain.start().compare(this.timestamp, otherTimestamp.timestamp).result();
        }
    }

    private class SequentialClockService<T, U>
    implements ClockService<T, U> {
        private static final long INITIAL_VALUE = 1L;
        private final AtomicLong counter = new AtomicLong(1L);

        private SequentialClockService() {
        }

        public Timestamp getTimestamp(T object, U object2) {
            return new TestTimestamp(this.counter.getAndIncrement());
        }

        public Timestamp peekAtNextTimestamp() {
            return this.peek(1);
        }

        public Timestamp peek(int i) {
            Preconditions.checkArgument((i > 0 ? 1 : 0) != 0, (Object)"i must be a positive integer");
            return new TestTimestamp(this.counter.get() + (long)i - 1L);
        }

        public void turnBackTime() {
            this.counter.decrementAndGet();
            this.counter.decrementAndGet();
        }
    }

    private final class TestClusterCommunicationService
    implements ClusterCommunicationService {
        private TestClusterCommunicationService() {
        }

        public boolean broadcast(ClusterMessage message) {
            return false;
        }

        public boolean broadcastIncludeSelf(ClusterMessage message) {
            return false;
        }

        public boolean unicast(ClusterMessage message, NodeId toNodeId) {
            return false;
        }

        public boolean multicast(ClusterMessage message, Iterable<NodeId> nodeIds) {
            return false;
        }

        public ListenableFuture<byte[]> sendAndReceive(ClusterMessage message, NodeId toNodeId) throws IOException {
            return null;
        }

        public void addSubscriber(MessageSubject subject, ClusterMessageHandler subscriber) {
            if (subject.equals((Object)UPDATE_MESSAGE_SUBJECT)) {
                EventuallyConsistentMapImplTest.this.updateHandler = subscriber;
            } else if (subject.equals((Object)ANTI_ENTROPY_MESSAGE_SUBJECT)) {
                EventuallyConsistentMapImplTest.this.antiEntropyHandler = subscriber;
            } else {
                throw new RuntimeException("Unexpected message subject " + subject.toString());
            }
        }

        public void addSubscriber(MessageSubject subject, ClusterMessageHandler subscriber, ExecutorService executor) {
            if (subject.equals((Object)UPDATE_MESSAGE_SUBJECT)) {
                EventuallyConsistentMapImplTest.this.updateHandler = subscriber;
            } else if (subject.equals((Object)ANTI_ENTROPY_MESSAGE_SUBJECT)) {
                EventuallyConsistentMapImplTest.this.antiEntropyHandler = subscriber;
            } else {
                throw new RuntimeException("Unexpected message subject " + subject.toString());
            }
        }

        public void removeSubscriber(MessageSubject subject) {
        }
    }
}

