/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.hz;

import com.google.common.base.Preconditions;
import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import java.io.FileNotFoundException;
import java.util.UUID;
import org.onosproject.store.hz.StoreManager;

public class TestStoreManager
extends StoreManager {
    private TestHazelcastInstanceFactory factory;

    public static Config getTestConfig() {
        FileSystemXmlConfig config;
        try {
            config = new FileSystemXmlConfig("etc/hazelcast.xml");
        }
        catch (FileNotFoundException e) {
            config = new Config();
        }
        config.getGroupConfig().setName(UUID.randomUUID().toString());
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true).setConnectionTimeoutSeconds(0);
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        return config;
    }

    public HazelcastInstance initSingleInstance() {
        return this.initInstances(1)[0];
    }

    public HazelcastInstance[] initInstances(int count) {
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Cluster size must be > 0");
        this.factory = new TestHazelcastInstanceFactory(count);
        return this.factory.newInstances(TestStoreManager.getTestConfig());
    }

    public void setHazelcastInstance(HazelcastInstance instance) {
        this.instance = instance;
    }

    public void activate() {
        Preconditions.checkState((this.instance != null ? 1 : 0) != 0, (Object)"HazelcastInstance needs to be set");
    }

    public void deactivate() {
        this.factory.shutdownAll();
    }
}

