/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.impl;

import com.esotericsoftware.kryo.Serializer;
import com.google.common.testing.EqualsTester;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.KryoNamespace;
import org.onosproject.store.Timestamp;
import org.onosproject.store.impl.MastershipBasedTimestamp;
import org.onosproject.store.serializers.impl.MastershipBasedTimestampSerializer;

public class MastershipBasedTimestampTest {
    private static final Timestamp TS_1_1 = new MastershipBasedTimestamp(1L, 1L);
    private static final Timestamp TS_1_2 = new MastershipBasedTimestamp(1L, 2L);
    private static final Timestamp TS_2_1 = new MastershipBasedTimestamp(2L, 1L);
    private static final Timestamp TS_2_2 = new MastershipBasedTimestamp(2L, 2L);

    @Test
    public final void testBasic() {
        int termNumber = 5;
        int sequenceNumber = 6;
        MastershipBasedTimestamp ts = new MastershipBasedTimestamp(5L, 6L);
        Assert.assertEquals((long)5L, (long)ts.termNumber());
        Assert.assertEquals((long)6L, (long)ts.sequenceNumber());
    }

    @Test
    public final void testCompareTo() {
        Assert.assertTrue((TS_1_1.compareTo((Object)TS_1_1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((TS_1_1.compareTo((Object)new MastershipBasedTimestamp(1L, 1L)) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((TS_1_1.compareTo((Object)TS_1_2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((TS_1_2.compareTo((Object)TS_1_1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((TS_1_2.compareTo((Object)TS_2_1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((TS_1_2.compareTo((Object)TS_2_2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((TS_2_1.compareTo((Object)TS_1_1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((TS_2_2.compareTo((Object)TS_1_1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public final void testEqualsObject() {
        new EqualsTester().addEqualityGroup(new Object[]{new MastershipBasedTimestamp(1L, 1L), new MastershipBasedTimestamp(1L, 1L), TS_1_1}).addEqualityGroup(new Object[]{new MastershipBasedTimestamp(1L, 2L), new MastershipBasedTimestamp(1L, 2L), TS_1_2}).addEqualityGroup(new Object[]{new MastershipBasedTimestamp(2L, 1L), new MastershipBasedTimestamp(2L, 1L), TS_2_1}).addEqualityGroup(new Object[]{new MastershipBasedTimestamp(2L, 2L), new MastershipBasedTimestamp(2L, 2L), TS_2_2}).testEquals();
    }

    @Test
    public final void testKryoSerializable() {
        ByteBuffer buffer = ByteBuffer.allocate(0x100000);
        KryoNamespace kryos = KryoNamespace.newBuilder().register(new Class[]{MastershipBasedTimestamp.class}).build();
        kryos.serialize((Object)TS_2_1, buffer);
        buffer.flip();
        Timestamp copy = (Timestamp)kryos.deserialize(buffer);
        new EqualsTester().addEqualityGroup(new Object[]{TS_2_1, copy}).testEquals();
    }

    @Test
    public final void testKryoSerializableWithHandcraftedSerializer() {
        ByteBuffer buffer = ByteBuffer.allocate(0x100000);
        KryoNamespace kryos = KryoNamespace.newBuilder().register((Serializer)new MastershipBasedTimestampSerializer(), new Class[]{MastershipBasedTimestamp.class}).build();
        kryos.serialize((Object)TS_1_2, buffer);
        buffer.flip();
        Timestamp copy = (Timestamp)kryos.deserialize(buffer);
        new EqualsTester().addEqualityGroup(new Object[]{TS_1_2, copy}).testEquals();
    }
}

