/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.mastership.impl;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.onlab.junit.TestTools;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterServiceAdapter;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipStoreDelegate;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.hz.StoreManager;
import org.onosproject.store.hz.StoreService;
import org.onosproject.store.hz.TestStoreManager;
import org.onosproject.store.mastership.impl.DistributedMastershipStore;
import org.onosproject.store.mastership.impl.RoleValue;
import org.onosproject.store.serializers.KryoSerializer;

public class DistributedMastershipStoreTest {
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:01");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:02");
    private static final DeviceId DID3 = DeviceId.deviceId((String)"of:03");
    private static final IpAddress IP = IpAddress.valueOf((String)"127.0.0.1");
    private static final NodeId N1 = new NodeId("node1");
    private static final NodeId N2 = new NodeId("node2");
    private static final ControllerNode CN1 = new DefaultControllerNode(N1, IP);
    private static final ControllerNode CN2 = new DefaultControllerNode(N2, IP);
    private DistributedMastershipStore dms;
    private TestDistributedMastershipStore testStore;
    private KryoSerializer serializationMgr;
    private StoreManager storeMgr;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        TestStoreManager testStoreMgr = new TestStoreManager();
        testStoreMgr.setHazelcastInstance(testStoreMgr.initSingleInstance());
        this.storeMgr = testStoreMgr;
        this.storeMgr.activate();
        this.serializationMgr = new KryoSerializer();
        this.dms = new TestDistributedMastershipStore((StoreService)this.storeMgr, this.serializationMgr);
        this.dms.clusterService = new TestClusterService();
        this.dms.activate();
        this.testStore = (TestDistributedMastershipStore)this.dms;
    }

    @After
    public void tearDown() throws Exception {
        this.dms.deactivate();
        this.storeMgr.deactivate();
    }

    @Test
    @Ignore(value="Disabled this test due to intermittent failures seen on Jenkins runs")
    public void getRole() {
        Assert.assertEquals((String)"wrong role:", (Object)MastershipRole.NONE, (Object)this.dms.getRole(N1, DID1));
        this.testStore.put(DID1, N1, true, false, true);
        Assert.assertEquals((String)"wrong role:", (Object)MastershipRole.MASTER, (Object)this.dms.getRole(N1, DID1));
        this.testStore.put(DID1, N2, false, true, false);
        Assert.assertEquals((String)"wrong role:", (Object)MastershipRole.STANDBY, (Object)this.dms.getRole(N2, DID1));
    }

    @Test
    public void getMaster() {
        Assert.assertTrue((String)"wrong store state:", (boolean)this.dms.roleMap.isEmpty());
        this.testStore.put(DID1, N1, true, false, false);
        TestTools.assertAfter((int)100, () -> Assert.assertEquals((String)"wrong master:", (Object)N1, (Object)this.dms.getMaster(DID1)));
        Assert.assertNull((String)"wrong master:", (Object)this.dms.getMaster(DID2));
    }

    @Test
    public void getDevices() {
        Assert.assertTrue((String)"wrong store state:", (boolean)this.dms.roleMap.isEmpty());
        this.testStore.put(DID1, N1, true, false, false);
        this.testStore.put(DID2, N1, true, false, false);
        this.testStore.put(DID3, N2, true, false, false);
        Assert.assertEquals((String)"wrong devices", (Object)Sets.newHashSet((Object[])new DeviceId[]{DID1, DID2}), (Object)this.dms.getDevices(N1));
    }

    @Test
    public void requestRoleAndTerm() {
        this.testStore.setCurrent(CN1);
        this.testStore.put(DID2, N1, true, false, true);
        Assert.assertEquals((String)"wrong role for MASTER:", (Object)MastershipRole.MASTER, (Object)this.dms.requestRole(DID2));
        Assert.assertEquals((String)"wrong role for NONE:", (Object)MastershipRole.MASTER, (Object)this.dms.requestRole(DID1));
        Assert.assertTrue((String)"wrong state for store:", (!this.dms.terms.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"wrong term", (Object)MastershipTerm.of((NodeId)N1, (long)1L), (Object)this.dms.getTermFor(DID1));
        this.testStore.setCurrent(CN2);
        Assert.assertEquals((String)"wrong role for STANDBY:", (Object)MastershipRole.STANDBY, (Object)this.dms.requestRole(DID2));
        Assert.assertEquals((String)"wrong number of entries:", (long)2L, (long)this.dms.terms.size());
        this.testStore.increment(DID2);
        Assert.assertEquals((String)"wrong role for STANDBY:", (Object)MastershipRole.STANDBY, (Object)this.dms.requestRole(DID2));
        Assert.assertEquals((String)"wrong term", (Object)MastershipTerm.of((NodeId)N1, (long)1L), (Object)this.dms.getTermFor(DID2));
    }

    @Test
    public void setMaster() {
        this.testStore.setCurrent(CN1);
        Assert.assertEquals((String)"wrong role for NONE:", (Object)MastershipRole.MASTER, (Object)this.dms.requestRole(DID1));
        Assert.assertNull((String)"wrong event:", (Object)this.dms.setMaster(N1, DID1));
        Assert.assertEquals((String)"wrong event:", (Object)MastershipEvent.Type.MASTER_CHANGED, (Object)this.dms.setMaster(N2, DID1).type());
        System.out.println(this.dms.getTermFor(DID1).master() + ":" + this.dms.getTermFor(DID1).termNumber());
        Assert.assertEquals((String)"wrong term", (Object)MastershipTerm.of((NodeId)N2, (long)2L), (Object)this.dms.getTermFor(DID1));
        Assert.assertEquals((String)"wrong event:", (Object)MastershipEvent.Type.MASTER_CHANGED, (Object)this.dms.setMaster(N2, DID2).type());
        Assert.assertEquals((String)"wrong term", (Object)MastershipTerm.of((NodeId)N2, (long)1L), (Object)this.dms.getTermFor(DID2));
        this.dms.roleMap.clear();
        this.dms.setMaster(N2, DID2);
        Assert.assertEquals((String)"wrong term", (Object)MastershipTerm.of((NodeId)N2, (long)2L), (Object)this.dms.getTermFor(DID2));
    }

    @Test
    public void relinquishRole() {
        this.testStore.setCurrent(CN1);
        Assert.assertEquals((String)"wrong role for NONE:", (Object)MastershipRole.MASTER, (Object)this.dms.requestRole(DID1));
        Assert.assertNull((String)"wrong event:", (Object)this.dms.relinquishRole(N1, DID1));
        this.dms.requestRole(DID1);
        this.testStore.setCurrent(CN2);
        Assert.assertEquals((String)"wrong role for NONE:", (Object)MastershipRole.STANDBY, (Object)this.dms.requestRole(DID1));
        Assert.assertEquals((String)"wrong event:", (Object)MastershipEvent.Type.MASTER_CHANGED, (Object)this.dms.relinquishRole(N1, DID1).type());
        Assert.assertEquals((String)"wrong master", (Object)N2, (Object)this.dms.getMaster(DID1));
        Assert.assertNull((String)"wrong event:", (Object)this.dms.relinquishRole(N2, DID1));
        Assert.assertEquals((String)"wrong role for node:", (Object)MastershipRole.NONE, (Object)this.dms.getRole(N2, DID1));
        Assert.assertEquals((String)"wrong number of retired nodes", (long)2L, (long)((RoleValue)this.dms.roleMap.get((Object)DID1)).nodesOfRole(MastershipRole.NONE).size());
        Assert.assertEquals((String)"wrong role for NONE:", (Object)MastershipRole.MASTER, (Object)this.dms.requestRole(DID1));
        this.testStore.setCurrent(CN1);
        Assert.assertEquals((String)"wrong role for NONE:", (Object)MastershipRole.STANDBY, (Object)this.dms.requestRole(DID1));
        Assert.assertEquals((String)"wrong number of backup nodes", (long)1L, (long)((RoleValue)this.dms.roleMap.get((Object)DID1)).nodesOfRole(MastershipRole.STANDBY).size());
        Assert.assertEquals((String)"wrong event:", (Object)MastershipEvent.Type.BACKUPS_CHANGED, (Object)this.dms.relinquishRole(N1, DID1).type());
        Assert.assertEquals((String)"wrong role for node:", (Object)MastershipRole.NONE, (Object)this.dms.getRole(N1, DID1));
        Assert.assertEquals((String)"wrong event:", (Object)MastershipEvent.Type.BACKUPS_CHANGED, (Object)this.dms.relinquishRole(N1, DID2).type());
        Assert.assertEquals((String)"wrong role for node:", (Object)MastershipRole.NONE, (Object)this.dms.getRole(N1, DID2));
    }

    @Ignore(value="Ignore until Delegate spec. is clear.")
    @Test
    public void testEvents() throws InterruptedException {
        final CountDownLatch addLatch = new CountDownLatch(1);
        MastershipStoreDelegate checkAdd = new MastershipStoreDelegate(){

            public void notify(MastershipEvent event) {
                Assert.assertEquals((String)"wrong event:", (Object)MastershipEvent.Type.MASTER_CHANGED, (Object)event.type());
                Assert.assertEquals((String)"wrong subject", (Object)DID1, (Object)event.subject());
                Assert.assertEquals((String)"wrong subject", (Object)N1, (Object)event.roleInfo().master());
                addLatch.countDown();
            }
        };
        this.dms.setDelegate((StoreDelegate)checkAdd);
        this.dms.setMaster(N1, DID1);
        Assert.assertTrue((String)"Add event fired", (boolean)addLatch.await(1L, TimeUnit.SECONDS));
    }

    private class TestClusterService
    extends ClusterServiceAdapter {
        protected ControllerNode current;

        private TestClusterService() {
        }

        public ControllerNode getLocalNode() {
            return this.current;
        }

        public Set<ControllerNode> getNodes() {
            return Sets.newHashSet((Object[])new ControllerNode[]{CN1, CN2});
        }
    }

    private class TestDistributedMastershipStore
    extends DistributedMastershipStore {
        public TestDistributedMastershipStore(StoreService storeService, KryoSerializer kryoSerialization) {
            this.storeService = storeService;
            this.serializer = kryoSerialization;
        }

        public void put(DeviceId dev, NodeId node, boolean master, boolean backup, boolean term) {
            RoleValue rv = (RoleValue)((DistributedMastershipStoreTest)DistributedMastershipStoreTest.this).dms.roleMap.get((Object)dev);
            if (rv == null) {
                rv = new RoleValue();
            }
            if (master) {
                rv.add(MastershipRole.MASTER, node);
                rv.reassign(node, MastershipRole.STANDBY, MastershipRole.NONE);
            }
            if (backup) {
                rv.add(MastershipRole.STANDBY, node);
                rv.remove(MastershipRole.MASTER, node);
                rv.remove(MastershipRole.NONE, node);
            }
            if (term) {
                ((DistributedMastershipStoreTest)DistributedMastershipStoreTest.this).dms.terms.put((Object)dev, (Object)0);
            }
            ((DistributedMastershipStoreTest)DistributedMastershipStoreTest.this).dms.roleMap.put((Object)dev, (Object)rv);
        }

        public void dump() {
            for (Map.Entry el : ((DistributedMastershipStoreTest)DistributedMastershipStoreTest.this).dms.roleMap.entrySet()) {
                System.out.println("DID: " + el.getKey());
                for (MastershipRole role : MastershipRole.values()) {
                    System.out.println("\t" + role.toString() + ":");
                    for (NodeId n : ((RoleValue)el.getValue()).nodesOfRole(role)) {
                        System.out.println("\t\t" + n);
                    }
                }
            }
        }

        public void increment(DeviceId dev) {
            Integer t = (Integer)((DistributedMastershipStoreTest)DistributedMastershipStoreTest.this).dms.terms.get((Object)dev);
            if (t != null) {
                t = t + 1;
                ((DistributedMastershipStoreTest)DistributedMastershipStoreTest.this).dms.terms.put((Object)dev, (Object)t);
            }
        }

        public void setCurrent(ControllerNode node) {
            ((TestClusterService)this.clusterService).current = node;
        }
    }
}

