/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.app;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.app.ApplicationDescription;
import org.onosproject.app.ApplicationEvent;
import org.onosproject.app.ApplicationException;
import org.onosproject.app.ApplicationState;
import org.onosproject.app.ApplicationStore;
import org.onosproject.app.ApplicationStoreDelegate;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.common.app.ApplicationArchive;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.ApplicationIdStore;
import org.onosproject.core.DefaultApplication;
import org.onosproject.core.Permission;
import org.onosproject.event.Event;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.ecmap.EventuallyConsistentMap;
import org.onosproject.store.ecmap.EventuallyConsistentMapEvent;
import org.onosproject.store.ecmap.EventuallyConsistentMapImpl;
import org.onosproject.store.ecmap.EventuallyConsistentMapListener;
import org.onosproject.store.impl.ClockService;
import org.onosproject.store.impl.MultiValuedTimestamp;
import org.onosproject.store.impl.WallclockClockManager;
import org.onosproject.store.serializers.KryoNamespaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class GossipApplicationStore
extends ApplicationArchive
implements ApplicationStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final MessageSubject APP_BITS_REQUEST = new MessageSubject("app-bits-request");
    private static final int FETCH_TIMEOUT_MS = 10000;
    private static final int LOAD_TIMEOUT_MS = 5000;
    private ScheduledExecutorService executor;
    private ExecutorService messageHandlingExecutor;
    private EventuallyConsistentMap<ApplicationId, Application> apps;
    private EventuallyConsistentMap<Application, InternalState> states;
    private EventuallyConsistentMap<Application, Set<Permission>> permissions;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ApplicationIdStore idStore;
    private final AtomicLong sequence = new AtomicLong();

    @Activate
    public void activate() {
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{MultiValuedTimestamp.class}).register(new Class[]{InternalState.class});
        this.executor = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/app", (String)"store"));
        this.messageHandlingExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/store/app", (String)"message-handler"));
        this.clusterCommunicator.addSubscriber(APP_BITS_REQUEST, (ClusterMessageHandler)new InternalBitServer(), this.messageHandlingExecutor);
        ClockService<ApplicationId, Application> appsClockService = (appId, app) -> new MultiValuedTimestamp<Long, Long>(this.getUpdateTime(appId.name()), this.sequence.incrementAndGet());
        this.apps = new EventuallyConsistentMapImpl<ApplicationId, Application>("apps", this.clusterService, this.clusterCommunicator, serializer, appsClockService);
        ClockService<Application, InternalState> statesClockService = (app, state) -> new MultiValuedTimestamp<Long, Long>(this.getUpdateTime(app.id().name()), this.sequence.incrementAndGet());
        this.states = new EventuallyConsistentMapImpl<Application, InternalState>("app-states", this.clusterService, this.clusterCommunicator, serializer, statesClockService);
        this.states.addListener(new InternalAppStatesListener());
        this.permissions = new EventuallyConsistentMapImpl("app-permissions", this.clusterService, this.clusterCommunicator, serializer, new WallclockClockManager());
        this.log.info("Started");
    }

    private void loadFromDisk() {
        for (String name : this.getApplicationNames()) {
            Application app = this.create(this.getApplicationDescription(name));
            if (app == null || !this.isActive(app.id().name())) continue;
            this.activate(app.id());
        }
    }

    @Deactivate
    public void deactivate() {
        this.clusterCommunicator.removeSubscriber(APP_BITS_REQUEST);
        this.messageHandlingExecutor.shutdown();
        this.executor.shutdown();
        this.apps.destroy();
        this.states.destroy();
        this.permissions.destroy();
        this.log.info("Stopped");
    }

    public void setDelegate(ApplicationStoreDelegate delegate) {
        super.setDelegate((StoreDelegate)delegate);
        this.loadFromDisk();
    }

    public Set<Application> getApplications() {
        return ImmutableSet.copyOf(this.apps.values());
    }

    public ApplicationId getId(String name) {
        return this.idStore.getAppId(name);
    }

    public Application getApplication(ApplicationId appId) {
        return this.apps.get(appId);
    }

    public ApplicationState getState(ApplicationId appId) {
        InternalState s;
        Application app = this.apps.get(appId);
        InternalState internalState = s = app == null ? null : this.states.get(app);
        return s == null ? null : (s == InternalState.ACTIVATED ? ApplicationState.ACTIVE : ApplicationState.INSTALLED);
    }

    public Application create(InputStream appDescStream) {
        ApplicationDescription appDesc = this.saveApplication(appDescStream);
        return this.create(appDesc);
    }

    private Application create(ApplicationDescription appDesc) {
        Application app = this.registerApp(appDesc);
        this.apps.put(app.id(), app);
        this.states.put(app, InternalState.INSTALLED);
        return app;
    }

    public void remove(ApplicationId appId) {
        Application app = this.apps.get(appId);
        if (app != null) {
            this.apps.remove(appId);
            this.states.remove(app);
            this.permissions.remove(app);
        }
    }

    public void activate(ApplicationId appId) {
        Application app = this.apps.get(appId);
        if (app != null) {
            this.states.put(app, InternalState.ACTIVATED);
        }
    }

    public void deactivate(ApplicationId appId) {
        Application app = this.apps.get(appId);
        if (app != null) {
            this.states.put(app, InternalState.DEACTIVATED);
        }
    }

    public Set<Permission> getPermissions(ApplicationId appId) {
        Application app = this.apps.get(appId);
        return app != null ? this.permissions.get(app) : null;
    }

    public void setPermissions(ApplicationId appId, Set<Permission> permissions) {
        Application app = this.getApplication(appId);
        if (app != null) {
            this.permissions.put(app, permissions);
            ((ApplicationStoreDelegate)this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_PERMISSIONS_CHANGED, app));
        }
    }

    private boolean appBitsAvailable(Application app) {
        try {
            ApplicationDescription appDesc = this.getApplicationDescription(app.id().name());
            return appDesc.version().equals((Object)app.version());
        }
        catch (ApplicationException e) {
            return false;
        }
    }

    private void fetchBitsIfNeeded(Application app) {
        if (!this.appBitsAvailable(app)) {
            this.fetchBits(app);
        }
    }

    private void installAppIfNeeded(Application app) {
        if (!this.appBitsAvailable(app)) {
            this.fetchBits(app);
            ((ApplicationStoreDelegate)this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_INSTALLED, app));
        }
    }

    private void fetchBits(Application app) {
        ControllerNode localNode = this.clusterService.getLocalNode();
        ClusterMessage message = new ClusterMessage(localNode.id(), APP_BITS_REQUEST, app.id().name().getBytes(Charsets.UTF_8));
        CountDownLatch latch = new CountDownLatch(1);
        this.log.info("Downloading bits for application {}", (Object)app.id().name());
        for (ControllerNode node : this.clusterService.getNodes()) {
            try {
                ListenableFuture future = this.clusterCommunicator.sendAndReceive(message, node.id());
                future.addListener((Runnable)new InternalBitListener(app, node, (ListenableFuture<byte[]>)future, latch), (Executor)this.executor);
            }
            catch (IOException e) {
                this.log.debug("Unable to request bits for application {} from node {}", (Object)app.id().name(), (Object)node.id());
            }
        }
        try {
            if (!latch.await(10000L, TimeUnit.MILLISECONDS)) {
                this.log.warn("Unable to fetch bits for application {}", (Object)app.id().name());
            }
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted while fetching bits for application {}", (Object)app.id().name());
        }
    }

    private void pruneUninstalledApps() {
        for (String name : this.getApplicationNames()) {
            if (this.getApplication(this.getId(name)) != null) continue;
            Application app = this.registerApp(this.getApplicationDescription(name));
            ((ApplicationStoreDelegate)this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_UNINSTALLED, app));
            this.purgeApplication(app.id().name());
        }
    }

    private Application registerApp(ApplicationDescription appDesc) {
        ApplicationId appId = this.idStore.registerApplication(appDesc.name());
        return new DefaultApplication(appId, appDesc.version(), appDesc.description(), appDesc.origin(), appDesc.permissions(), appDesc.featuresRepo(), appDesc.features());
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindIdStore(ApplicationIdStore applicationIdStore) {
        this.idStore = applicationIdStore;
    }

    protected void unbindIdStore(ApplicationIdStore applicationIdStore) {
        if (this.idStore == applicationIdStore) {
            this.idStore = null;
        }
    }

    private class InternalBitListener
    implements Runnable {
        private final Application app;
        private final ControllerNode node;
        private final ListenableFuture<byte[]> future;
        private final CountDownLatch latch;

        public InternalBitListener(Application app, ControllerNode node, ListenableFuture<byte[]> future, CountDownLatch latch) {
            this.app = app;
            this.node = node;
            this.future = future;
            this.latch = latch;
        }

        @Override
        public void run() {
            if (this.latch.getCount() > 0L && !this.future.isCancelled()) {
                try {
                    byte[] bits = (byte[])this.future.get(1L, TimeUnit.MILLISECONDS);
                    GossipApplicationStore.this.saveApplication(new ByteArrayInputStream(bits));
                    GossipApplicationStore.this.log.info("Downloaded bits for application {} from node {}", (Object)this.app.id().name(), (Object)this.node.id());
                    this.latch.countDown();
                }
                catch (Exception e) {
                    GossipApplicationStore.this.log.warn("Unable to fetch bits for application {} from node {}", (Object)this.app.id().name(), (Object)this.node.id());
                }
            }
        }
    }

    private class InternalBitServer
    implements ClusterMessageHandler {
        private InternalBitServer() {
        }

        public void handle(ClusterMessage message) {
            String name = new String(message.payload(), Charsets.UTF_8);
            try {
                message.respond(ByteStreams.toByteArray((InputStream)GossipApplicationStore.this.getApplicationInputStream(name)));
            }
            catch (Exception e) {
                GossipApplicationStore.this.log.debug("Unable to read bits for application {}", (Object)name);
            }
        }
    }

    private final class InternalAppStatesListener
    implements EventuallyConsistentMapListener<Application, InternalState> {
        private InternalAppStatesListener() {
        }

        @Override
        public void event(EventuallyConsistentMapEvent<Application, InternalState> event) {
            Application app = event.key();
            InternalState state = event.value();
            if (event.type() == EventuallyConsistentMapEvent.Type.PUT) {
                if (state == InternalState.INSTALLED) {
                    GossipApplicationStore.this.fetchBitsIfNeeded(app);
                    ((ApplicationStoreDelegate)GossipApplicationStore.this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_INSTALLED, app));
                } else if (state == InternalState.ACTIVATED) {
                    GossipApplicationStore.this.installAppIfNeeded(app);
                    GossipApplicationStore.this.setActive(app.id().name());
                    ((ApplicationStoreDelegate)GossipApplicationStore.this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_ACTIVATED, app));
                } else if (state == InternalState.DEACTIVATED) {
                    GossipApplicationStore.this.clearActive(app.id().name());
                    ((ApplicationStoreDelegate)GossipApplicationStore.this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_DEACTIVATED, app));
                }
            } else if (event.type() == EventuallyConsistentMapEvent.Type.REMOVE) {
                ((ApplicationStoreDelegate)GossipApplicationStore.this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_UNINSTALLED, app));
                GossipApplicationStore.this.purgeApplication(app.id().name());
            }
        }
    }

    public static enum InternalState {
        INSTALLED,
        ACTIVATED,
        DEACTIVATED;

    }
}

