/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cfg;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.cfg.ComponentConfigEvent;
import org.onosproject.cfg.ComponentConfigStore;
import org.onosproject.cfg.ComponentConfigStoreDelegate;
import org.onosproject.cluster.ClusterService;
import org.onosproject.event.Event;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.ecmap.EventuallyConsistentMap;
import org.onosproject.store.ecmap.EventuallyConsistentMapEvent;
import org.onosproject.store.ecmap.EventuallyConsistentMapImpl;
import org.onosproject.store.ecmap.EventuallyConsistentMapListener;
import org.onosproject.store.impl.WallclockClockManager;
import org.onosproject.store.serializers.KryoNamespaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class GossipComponentConfigStore
extends AbstractStore<ComponentConfigEvent, ComponentConfigStoreDelegate>
implements ComponentConfigStore {
    private static final String SEP = "#";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private EventuallyConsistentMap<String, String> properties;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;

    @Activate
    public void activate() {
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API);
        this.properties = new EventuallyConsistentMapImpl("cfg", this.clusterService, this.clusterCommunicator, serializer, new WallclockClockManager());
        this.properties.addListener(new InternalPropertiesListener());
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public void setProperty(String componentName, String name, String value) {
        this.properties.put(this.key(componentName, name), value);
    }

    public void unsetProperty(String componentName, String name) {
        this.properties.remove(this.key(componentName, name));
    }

    private String key(String componentName, String name) {
        return componentName + SEP + name;
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    private final class InternalPropertiesListener
    implements EventuallyConsistentMapListener<String, String> {
        private InternalPropertiesListener() {
        }

        @Override
        public void event(EventuallyConsistentMapEvent<String, String> event) {
            String[] keys = event.key().split(GossipComponentConfigStore.SEP);
            String value = event.value();
            if (event.type() == EventuallyConsistentMapEvent.Type.PUT) {
                ((ComponentConfigStoreDelegate)GossipComponentConfigStore.this.delegate).notify((Event)new ComponentConfigEvent(ComponentConfigEvent.Type.PROPERTY_SET, keys[0], keys[1], value));
            } else if (event.type() == EventuallyConsistentMapEvent.Type.REMOVE) {
                ((ComponentConfigStoreDelegate)GossipComponentConfigStore.this.delegate).notify((Event)new ComponentConfigEvent(ComponentConfigEvent.Type.PROPERTY_UNSET, keys[0], keys[1], null));
            }
        }
    }
}

