/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.hazelcast.util.AddressUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onlab.netty.Endpoint;
import org.onlab.netty.Message;
import org.onlab.netty.MessageHandler;
import org.onlab.netty.NettyMessagingService;
import org.onlab.packet.IpAddress;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ClusterStore;
import org.onosproject.cluster.ClusterStoreDelegate;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.cluster.impl.ClusterDefinition;
import org.onosproject.store.cluster.impl.ClusterDefinitionStore;
import org.onosproject.store.cluster.impl.PhiAccrualFailureDetector;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.KryoSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedClusterStore
extends AbstractStore<ClusterEvent, ClusterStoreDelegate>
implements ClusterStore {
    private final Logger log = LoggerFactory.getLogger(DistributedClusterStore.class);
    private static final int HEARTBEAT_FD_PORT = 2419;
    private static final int HEARTBEAT_INTERVAL_MS = 100;
    private static final int PHI_FAILURE_THRESHOLD = 10;
    private static final String CONFIG_DIR = "../config";
    private static final String CLUSTER_DEFINITION_FILE = "cluster.json";
    private static final String HEARTBEAT_MESSAGE = "onos-cluster-heartbeat";
    private static final KryoSerializer SERIALIZER = new KryoSerializer(){

        protected void setupKryoPool() {
            this.serializerPool = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{HeartbeatMessage.class}).build().populate(1);
        }
    };
    private static final String INSTANCE_ID_NULL = "Instance ID cannot be null";
    private ClusterDefinition clusterDefinition;
    private Set<ControllerNode> seedNodes;
    private final Map<NodeId, ControllerNode> allNodes = Maps.newConcurrentMap();
    private final Map<NodeId, ControllerNode.State> nodeStates = Maps.newConcurrentMap();
    private NettyMessagingService messagingService = new NettyMessagingService();
    private ScheduledExecutorService heartBeatSender = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/cluster/membership", (String)"heartbeat-sender"));
    private ExecutorService heartBeatMessageHandler = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/cluster/membership", (String)"heartbeat-receiver"));
    private PhiAccrualFailureDetector failureDetector;
    private ControllerNode localNode;

    @Activate
    public void activate() {
        File clusterDefinitionFile = new File(CONFIG_DIR, CLUSTER_DEFINITION_FILE);
        try {
            this.clusterDefinition = new ClusterDefinitionStore(clusterDefinitionFile.getPath()).read();
            this.seedNodes = ImmutableSet.copyOf(this.clusterDefinition.getNodes()).stream().map(nodeInfo -> new DefaultControllerNode(new NodeId(nodeInfo.getId()), IpAddress.valueOf((String)nodeInfo.getIp()), nodeInfo.getTcpPort())).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read cluster definition.", e);
        }
        this.seedNodes.forEach(node -> {
            this.allNodes.put(node.id(), (ControllerNode)node);
            this.nodeStates.put(node.id(), ControllerNode.State.INACTIVE);
        });
        this.establishSelfIdentity();
        this.messagingService = new NettyMessagingService(2419);
        try {
            this.messagingService.activate();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Failed to cleanly initialize membership and failure detector communication channel.", e);
        }
        this.messagingService.registerHandler(HEARTBEAT_MESSAGE, (MessageHandler)new HeartbeatMessageHandler(), this.heartBeatMessageHandler);
        this.failureDetector = new PhiAccrualFailureDetector();
        this.heartBeatSender.scheduleWithFixedDelay(this::heartbeat, 0L, 100L, TimeUnit.MILLISECONDS);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        try {
            this.messagingService.deactivate();
        }
        catch (Exception e) {
            this.log.trace("Failed to cleanly shutdown cluster membership messaging", (Throwable)e);
        }
        this.heartBeatSender.shutdownNow();
        this.heartBeatMessageHandler.shutdownNow();
        this.log.info("Stopped");
    }

    public void setDelegate(ClusterStoreDelegate delegate) {
        Preconditions.checkNotNull((Object)delegate, (Object)"Delegate cannot be null");
        this.delegate = delegate;
    }

    public void unsetDelegate(ClusterStoreDelegate delegate) {
        this.delegate = null;
    }

    public boolean hasDelegate() {
        return this.delegate != null;
    }

    public ControllerNode getLocalNode() {
        return this.localNode;
    }

    public Set<ControllerNode> getNodes() {
        return ImmutableSet.copyOf(this.allNodes.values());
    }

    public ControllerNode getNode(NodeId nodeId) {
        Preconditions.checkNotNull((Object)nodeId, (Object)INSTANCE_ID_NULL);
        return this.allNodes.get(nodeId);
    }

    public ControllerNode.State getState(NodeId nodeId) {
        Preconditions.checkNotNull((Object)nodeId, (Object)INSTANCE_ID_NULL);
        return this.nodeStates.get(nodeId);
    }

    public ControllerNode addNode(NodeId nodeId, IpAddress ip, int tcpPort) {
        Preconditions.checkNotNull((Object)nodeId, (Object)INSTANCE_ID_NULL);
        Preconditions.checkNotNull((Object)ip, (Object)"IP address must not be null");
        Preconditions.checkArgument((tcpPort > 5000 ? 1 : 0) != 0, (Object)"Tcp port must be greater than 5000");
        DefaultControllerNode node = new DefaultControllerNode(nodeId, ip, tcpPort);
        this.allNodes.put(node.id(), (ControllerNode)node);
        this.nodeStates.put(nodeId, ControllerNode.State.INACTIVE);
        ((ClusterStoreDelegate)this.delegate).notify((Event)new ClusterEvent(ClusterEvent.Type.INSTANCE_ADDED, (ControllerNode)node));
        return node;
    }

    public void removeNode(NodeId nodeId) {
        Preconditions.checkNotNull((Object)nodeId, (Object)INSTANCE_ID_NULL);
        ControllerNode node = this.allNodes.remove(nodeId);
        if (node != null) {
            this.nodeStates.remove(nodeId);
            ((ClusterStoreDelegate)this.delegate).notify((Event)new ClusterEvent(ClusterEvent.Type.INSTANCE_REMOVED, node));
        }
    }

    private void establishSelfIdentity() {
        try {
            IpAddress ip = this.findLocalIp();
            this.localNode = new DefaultControllerNode(new NodeId(ip.toString()), ip);
            this.allNodes.put(this.localNode.id(), this.localNode);
            this.nodeStates.put(this.localNode.id(), ControllerNode.State.ACTIVE);
            this.log.info("Local Node: {}", (Object)this.localNode);
        }
        catch (SocketException e) {
            throw new IllegalStateException("Cannot determine local IP", e);
        }
    }

    private void heartbeat() {
        try {
            Set<ControllerNode> peers = this.allNodes.values().stream().filter(node -> !node.id().equals((Object)this.localNode.id())).collect(Collectors.toSet());
            byte[] hbMessagePayload = SERIALIZER.encode((Object)new HeartbeatMessage(this.localNode, peers));
            peers.forEach(node -> {
                this.heartbeatToPeer(hbMessagePayload, (ControllerNode)node);
                ControllerNode.State currentState = this.nodeStates.get(node.id());
                double phi = this.failureDetector.phi(node.id());
                if (phi >= 10.0) {
                    if (currentState == ControllerNode.State.ACTIVE) {
                        this.nodeStates.put(node.id(), ControllerNode.State.INACTIVE);
                        this.notifyStateChange(node.id(), ControllerNode.State.ACTIVE, ControllerNode.State.INACTIVE);
                    }
                } else if (currentState == ControllerNode.State.INACTIVE) {
                    this.nodeStates.put(node.id(), ControllerNode.State.ACTIVE);
                    this.notifyStateChange(node.id(), ControllerNode.State.INACTIVE, ControllerNode.State.ACTIVE);
                }
            });
        }
        catch (Exception e) {
            this.log.debug("Failed to send heartbeat", (Throwable)e);
        }
    }

    private void notifyStateChange(NodeId nodeId, ControllerNode.State oldState, ControllerNode.State newState) {
        ControllerNode node = this.allNodes.get(nodeId);
        if (newState == ControllerNode.State.ACTIVE) {
            ((ClusterStoreDelegate)this.delegate).notify((Event)new ClusterEvent(ClusterEvent.Type.INSTANCE_ACTIVATED, node));
        } else {
            ((ClusterStoreDelegate)this.delegate).notify((Event)new ClusterEvent(ClusterEvent.Type.INSTANCE_DEACTIVATED, node));
        }
    }

    private void heartbeatToPeer(byte[] messagePayload, ControllerNode peer) {
        Endpoint remoteEp = new Endpoint(peer.ip(), 2419);
        try {
            this.messagingService.sendAsync(remoteEp, HEARTBEAT_MESSAGE, messagePayload);
        }
        catch (IOException e) {
            this.log.debug("Sending heartbeat to {} failed", (Object)remoteEp, (Object)e);
        }
    }

    private IpAddress findLocalIp() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = iface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                IpAddress ip = IpAddress.valueOf((InetAddress)inetAddresses.nextElement());
                if (!AddressUtil.matchInterface((String)ip.toString(), (String)this.clusterDefinition.getIpPrefix())) continue;
                return ip;
            }
        }
        throw new IllegalStateException("Unable to determine local ip");
    }

    private static class HeartbeatMessage {
        private ControllerNode source;
        private Set<ControllerNode> knownPeers;

        public HeartbeatMessage(ControllerNode source, Set<ControllerNode> members) {
            this.source = source;
            this.knownPeers = ImmutableSet.copyOf(members);
        }

        public ControllerNode source() {
            return this.source;
        }

        public Set<ControllerNode> knownPeers() {
            return this.knownPeers;
        }
    }

    private class HeartbeatMessageHandler
    implements MessageHandler {
        private HeartbeatMessageHandler() {
        }

        public void handle(Message message) throws IOException {
            HeartbeatMessage hb = (HeartbeatMessage)SERIALIZER.decode(message.payload());
            DistributedClusterStore.this.failureDetector.report(hb.source().id());
            hb.knownPeers().forEach(node -> DistributedClusterStore.this.allNodes.put(node.id(), node));
        }
    }
}

