/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.impl;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.net.InetAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ClusterStore;
import org.onosproject.cluster.ClusterStoreDelegate;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.store.hz.AbsentInvalidatingLoadingCache;
import org.onosproject.store.hz.AbstractHazelcastStore;
import org.onosproject.store.hz.OptionalCacheLoader;

@Component(immediate=true, enabled=false)
@Service
public class HazelcastClusterStore
extends AbstractHazelcastStore<ClusterEvent, ClusterStoreDelegate>
implements ClusterStore {
    private IMap<byte[], byte[]> rawNodes;
    private LoadingCache<NodeId, Optional<DefaultControllerNode>> nodes;
    private String listenerId;
    private final MembershipListener listener = new InternalMembershipListener();
    private final Map<NodeId, ControllerNode.State> states = new ConcurrentHashMap<NodeId, ControllerNode.State>();
    private String nodesListenerId;

    @Override
    @Activate
    public void activate() {
        super.activate();
        this.listenerId = this.theInstance.getCluster().addMembershipListener(this.listener);
        this.rawNodes = this.theInstance.getMap("nodes");
        OptionalCacheLoader nodeLoader = new OptionalCacheLoader(this.serializer, this.rawNodes);
        this.nodes = new AbsentInvalidatingLoadingCache(CacheBuilder.newBuilder().build(nodeLoader));
        this.nodesListenerId = this.rawNodes.addEntryListener(new AbstractHazelcastStore.RemoteCacheEventHandler<NodeId, DefaultControllerNode>(this, this.nodes), true);
        this.loadClusterNodes();
        this.log.info("Started");
    }

    private void loadClusterNodes() {
        for (Member member : this.theInstance.getCluster().getMembers()) {
            this.addNode(this.node(member));
        }
    }

    @Deactivate
    public void deactivate() {
        this.rawNodes.removeEntryListener(this.nodesListenerId);
        this.theInstance.getCluster().removeMembershipListener(this.listenerId);
        this.log.info("Stopped");
    }

    public ControllerNode getLocalNode() {
        return this.node(this.theInstance.getCluster().getLocalMember());
    }

    public Set<ControllerNode> getNodes() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Optional optional : this.nodes.asMap().values()) {
            builder.add(optional.get());
        }
        return builder.build();
    }

    public ControllerNode getNode(NodeId nodeId) {
        return (ControllerNode)((Optional)this.nodes.getUnchecked((Object)nodeId)).orNull();
    }

    public ControllerNode.State getState(NodeId nodeId) {
        ControllerNode.State state = this.states.get(nodeId);
        return state == null ? ControllerNode.State.INACTIVE : state;
    }

    public ControllerNode addNode(NodeId nodeId, IpAddress ip, int tcpPort) {
        return this.addNode(new DefaultControllerNode(nodeId, ip, tcpPort));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(NodeId nodeId) {
        HazelcastClusterStore hazelcastClusterStore = this;
        synchronized (hazelcastClusterStore) {
            this.rawNodes.remove((Object)this.serialize(nodeId));
            this.nodes.invalidate((Object)nodeId);
        }
    }

    private synchronized ControllerNode addNode(DefaultControllerNode node) {
        this.rawNodes.put((Object)this.serialize(node.id()), (Object)this.serialize(node));
        this.nodes.put((Object)node.id(), (Object)Optional.of((Object)node));
        this.states.put(node.id(), ControllerNode.State.ACTIVE);
        return node;
    }

    private DefaultControllerNode node(Member member) {
        IpAddress ip = this.memberAddress(member);
        return new DefaultControllerNode(new NodeId(ip.toString()), ip);
    }

    private IpAddress memberAddress(Member member) {
        return IpAddress.valueOf((InetAddress)member.getSocketAddress().getAddress());
    }

    private class InternalMembershipListener
    implements MembershipListener {
        private InternalMembershipListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            HazelcastClusterStore.this.log.info("Member {} added", (Object)membershipEvent.getMember());
            ControllerNode node = HazelcastClusterStore.this.addNode(HazelcastClusterStore.this.node(membershipEvent.getMember()));
            HazelcastClusterStore.this.notifyDelegate((Event)new ClusterEvent(ClusterEvent.Type.INSTANCE_ACTIVATED, node));
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            HazelcastClusterStore.this.log.info("Member {} removed", (Object)membershipEvent.getMember());
            NodeId nodeId = new NodeId(HazelcastClusterStore.this.memberAddress(membershipEvent.getMember()).toString());
            HazelcastClusterStore.this.states.put(nodeId, ControllerNode.State.INACTIVE);
            HazelcastClusterStore.this.notifyDelegate((Event)new ClusterEvent(ClusterEvent.Type.INSTANCE_DEACTIVATED, HazelcastClusterStore.this.getNode(nodeId)));
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            HazelcastClusterStore.this.log.info("Member {} attribute {} changed to {}", new Object[]{memberAttributeEvent.getMember(), memberAttributeEvent.getKey(), memberAttributeEvent.getValue()});
        }
    }
}

