/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.messaging.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.netty.Endpoint;
import org.onlab.netty.Message;
import org.onlab.netty.MessageHandler;
import org.onlab.netty.MessagingService;
import org.onlab.netty.NettyMessagingService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class ClusterCommunicationManager
implements ClusterCommunicationService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private ClusterService clusterService;
    private MessagingService messagingService;

    @Activate
    public void activate() {
        ControllerNode localNode = this.clusterService.getLocalNode();
        NettyMessagingService netty = new NettyMessagingService(localNode.ip(), localNode.tcpPort());
        try {
            netty.activate();
        }
        catch (Exception e) {
            this.log.error("NettyMessagingService#activate", (Throwable)e);
        }
        this.messagingService = netty;
        this.log.info("Started on {}:{}", (Object)localNode.ip(), (Object)localNode.tcpPort());
    }

    @Deactivate
    public void deactivate() {
        try {
            ((NettyMessagingService)this.messagingService).deactivate();
        }
        catch (Exception e) {
            this.log.error("NettyMessagingService#deactivate", (Throwable)e);
        }
        this.log.info("Stopped");
    }

    public boolean broadcast(ClusterMessage message) {
        boolean ok = true;
        ControllerNode localNode = this.clusterService.getLocalNode();
        byte[] payload = message.getBytes();
        for (ControllerNode node : this.clusterService.getNodes()) {
            if (node.equals(localNode)) continue;
            ok = this.unicastUnchecked(message.subject(), payload, node.id()) && ok;
        }
        return ok;
    }

    public boolean broadcastIncludeSelf(ClusterMessage message) {
        boolean ok = true;
        byte[] payload = message.getBytes();
        for (ControllerNode node : this.clusterService.getNodes()) {
            ok = this.unicastUnchecked(message.subject(), payload, node.id()) && ok;
        }
        return ok;
    }

    public boolean multicast(ClusterMessage message, Iterable<NodeId> nodes) {
        boolean ok = true;
        ControllerNode localNode = this.clusterService.getLocalNode();
        byte[] payload = message.getBytes();
        for (NodeId nodeId : nodes) {
            if (nodeId.equals((Object)localNode.id())) continue;
            ok = this.unicastUnchecked(message.subject(), payload, nodeId) && ok;
        }
        return ok;
    }

    public boolean unicast(ClusterMessage message, NodeId toNodeId) {
        return this.unicastUnchecked(message.subject(), message.getBytes(), toNodeId);
    }

    private boolean unicast(MessageSubject subject, byte[] payload, NodeId toNodeId) throws IOException {
        ControllerNode node = this.clusterService.getNode(toNodeId);
        Preconditions.checkArgument((node != null ? 1 : 0) != 0, (String)"Unknown nodeId: %s", (Object[])new Object[]{toNodeId});
        Endpoint nodeEp = new Endpoint(node.ip(), node.tcpPort());
        try {
            this.messagingService.sendAsync(nodeEp, subject.value(), payload);
            return true;
        }
        catch (IOException e) {
            this.log.debug("Failed to send cluster message to nodeId: " + toNodeId, (Throwable)e);
            throw e;
        }
    }

    private boolean unicastUnchecked(MessageSubject subject, byte[] payload, NodeId toNodeId) {
        try {
            return this.unicast(subject, payload, toNodeId);
        }
        catch (IOException e) {
            return false;
        }
    }

    public ListenableFuture<byte[]> sendAndReceive(ClusterMessage message, NodeId toNodeId) throws IOException {
        ControllerNode node = this.clusterService.getNode(toNodeId);
        Preconditions.checkArgument((node != null ? 1 : 0) != 0, (String)"Unknown nodeId: %s", (Object[])new Object[]{toNodeId});
        Endpoint nodeEp = new Endpoint(node.ip(), node.tcpPort());
        try {
            return this.messagingService.sendAndReceive(nodeEp, message.subject().value(), message.getBytes());
        }
        catch (IOException e) {
            this.log.trace("Failed interaction with remote nodeId: " + toNodeId, (Throwable)e);
            throw e;
        }
    }

    @Deprecated
    public void addSubscriber(MessageSubject subject, ClusterMessageHandler subscriber) {
        this.messagingService.registerHandler(subject.value(), (MessageHandler)new InternalClusterMessageHandler(subscriber));
    }

    public void addSubscriber(MessageSubject subject, ClusterMessageHandler subscriber, ExecutorService executor) {
        this.messagingService.registerHandler(subject.value(), (MessageHandler)new InternalClusterMessageHandler(subscriber), executor);
    }

    public void removeSubscriber(MessageSubject subject) {
        this.messagingService.unregisterHandler(subject.value());
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    public static final class InternalClusterMessage
    extends ClusterMessage {
        private final Message rawMessage;

        public InternalClusterMessage(ClusterMessage clusterMessage, Message rawMessage) {
            super(clusterMessage.sender(), clusterMessage.subject(), clusterMessage.payload());
            this.rawMessage = rawMessage;
        }

        public void respond(byte[] response) throws IOException {
            this.rawMessage.respond(response);
        }
    }

    private final class InternalClusterMessageHandler
    implements MessageHandler {
        private final ClusterMessageHandler handler;

        public InternalClusterMessageHandler(ClusterMessageHandler handler) {
            this.handler = handler;
        }

        public void handle(Message message) {
            ClusterMessage clusterMessage;
            try {
                clusterMessage = ClusterMessage.fromBytes((byte[])message.payload());
            }
            catch (Exception e) {
                ClusterCommunicationManager.this.log.error("Failed decoding {}", (Object)message, (Object)e);
                throw e;
            }
            try {
                this.handler.handle((ClusterMessage)new InternalClusterMessage(clusterMessage, message));
            }
            catch (Exception e) {
                ClusterCommunicationManager.this.log.trace("Failed handling {}", (Object)clusterMessage, (Object)e);
                throw e;
            }
        }
    }
}

