/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.onlab.util.HexString;
import org.onosproject.store.consistent.impl.DatabaseProxy;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.Versioned;

public class ConsistentMapImpl<K, V>
implements ConsistentMap<K, V> {
    private final String name;
    private final DatabaseProxy<String, byte[]> proxy;
    private final Serializer serializer;
    private static final int OPERATION_TIMEOUT_MILLIS = 5000;
    private static final String ERROR_NULL_KEY = "Key cannot be null";
    private static final String ERROR_NULL_VALUE = "Null values are not allowed";
    private final LoadingCache<K, String> keyCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<K, String>(){

        public String load(K key) {
            return HexString.toHexString((byte[])ConsistentMapImpl.this.serializer.encode(key));
        }
    });

    protected K dK(String key) {
        return (K)this.serializer.decode(HexString.fromHexString((String)key));
    }

    public ConsistentMapImpl(String name, DatabaseProxy<String, byte[]> proxy, Serializer serializer) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"map name cannot be null");
        this.proxy = (DatabaseProxy)Preconditions.checkNotNull(proxy, (Object)"database proxy cannot be null");
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
    }

    public int size() {
        return ConsistentMapImpl.complete(this.proxy.size(this.name));
    }

    public boolean isEmpty() {
        return ConsistentMapImpl.complete(this.proxy.isEmpty(this.name));
    }

    public boolean containsKey(K key) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        return ConsistentMapImpl.complete(this.proxy.containsKey(this.name, (String)this.keyCache.getUnchecked(key)));
    }

    public boolean containsValue(V value) {
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        return ConsistentMapImpl.complete(this.proxy.containsValue(this.name, this.serializer.encode(value)));
    }

    public Versioned<V> get(K key) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Versioned<byte[]> value = ConsistentMapImpl.complete(this.proxy.get(this.name, (String)this.keyCache.getUnchecked(key)));
        if (value == null) {
            return null;
        }
        return new Versioned(this.serializer.decode((byte[])value.value()), value.version(), value.creationTime());
    }

    public Versioned<V> put(K key, V value) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        Versioned<byte[]> previousValue = ConsistentMapImpl.complete(this.proxy.put(this.name, (String)this.keyCache.getUnchecked(key), this.serializer.encode(value)));
        if (previousValue == null) {
            return null;
        }
        return new Versioned(this.serializer.decode((byte[])previousValue.value()), previousValue.version(), previousValue.creationTime());
    }

    public Versioned<V> remove(K key) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Versioned<byte[]> value = ConsistentMapImpl.complete(this.proxy.remove(this.name, (String)this.keyCache.getUnchecked(key)));
        if (value == null) {
            return null;
        }
        return new Versioned(this.serializer.decode((byte[])value.value()), value.version(), value.creationTime());
    }

    public void clear() {
        ConsistentMapImpl.complete(this.proxy.clear(this.name));
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(ConsistentMapImpl.complete(this.proxy.keySet(this.name)).stream().map(this::dK).collect(Collectors.toSet()));
    }

    public Collection<Versioned<V>> values() {
        return Collections.unmodifiableList(ConsistentMapImpl.complete(this.proxy.values(this.name)).stream().map(v -> new Versioned(this.serializer.decode((byte[])v.value()), v.version(), v.creationTime())).collect(Collectors.toList()));
    }

    public Set<Map.Entry<K, Versioned<V>>> entrySet() {
        return Collections.unmodifiableSet(ConsistentMapImpl.complete(this.proxy.entrySet(this.name)).stream().map(this::fromRawEntry).collect(Collectors.toSet()));
    }

    public Versioned<V> putIfAbsent(K key, V value) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        Versioned<byte[]> existingValue = ConsistentMapImpl.complete(this.proxy.putIfAbsent(this.name, (String)this.keyCache.getUnchecked(key), this.serializer.encode(value)));
        if (existingValue == null) {
            return null;
        }
        return new Versioned(this.serializer.decode((byte[])existingValue.value()), existingValue.version(), existingValue.creationTime());
    }

    public boolean remove(K key, V value) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        return ConsistentMapImpl.complete(this.proxy.remove(this.name, (String)this.keyCache.getUnchecked(key), this.serializer.encode(value)));
    }

    public boolean remove(K key, long version) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        return ConsistentMapImpl.complete(this.proxy.remove(this.name, (String)this.keyCache.getUnchecked(key), version));
    }

    public boolean replace(K key, V oldValue, V newValue) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(newValue, (Object)ERROR_NULL_VALUE);
        byte[] existing = oldValue != null ? this.serializer.encode(oldValue) : null;
        return ConsistentMapImpl.complete(this.proxy.replace(this.name, (String)this.keyCache.getUnchecked(key), existing, this.serializer.encode(newValue)));
    }

    public boolean replace(K key, long oldVersion, V newValue) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(newValue, (Object)ERROR_NULL_VALUE);
        return ConsistentMapImpl.complete(this.proxy.replace(this.name, (String)this.keyCache.getUnchecked(key), oldVersion, this.serializer.encode(newValue)));
    }

    private static <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConsistentMapException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new ConsistentMapException.Timeout();
        }
        catch (ExecutionException e) {
            throw new ConsistentMapException(e.getCause());
        }
    }

    private Map.Entry<K, Versioned<V>> fromRawEntry(Map.Entry<String, Versioned<byte[]>> e) {
        return Pair.of(this.dK(e.getKey()), (Object)new Versioned(this.serializer.decode((byte[])e.getValue().value()), e.getValue().version(), e.getValue().creationTime()));
    }
}

