/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.log.FileLog;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.netty.NettyTcpProtocol;
import net.kuujo.copycat.protocol.Consistency;
import net.kuujo.copycat.protocol.Protocol;
import net.kuujo.copycat.util.serializer.Serializer;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.cluster.ClusterService;
import org.onosproject.store.cluster.impl.NodeInfo;
import org.onosproject.store.consistent.impl.ConsistentMapImpl;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DatabaseConfig;
import org.onosproject.store.consistent.impl.DatabaseDefinitionStore;
import org.onosproject.store.consistent.impl.DatabaseSerializer;
import org.onosproject.store.consistent.impl.DefaultTransactionContext;
import org.onosproject.store.consistent.impl.PartitionedDatabase;
import org.onosproject.store.consistent.impl.PartitionedDatabaseConfig;
import org.onosproject.store.consistent.impl.PartitionedDatabaseManager;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.PartitionInfo;
import org.onosproject.store.service.StorageAdminService;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.TransactionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class DatabaseManager
implements StorageService,
StorageAdminService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private PartitionedDatabase partitionedDatabase;
    public static final int COPYCAT_TCP_PORT = 7238;
    private static final String CONFIG_DIR = "../config";
    private static final String PARTITION_DEFINITION_FILE = "tablets.json";
    private static final int DATABASE_STARTUP_TIMEOUT_SEC = 60;
    private final PartitionedDatabaseConfig databaseConfig = new PartitionedDatabaseConfig();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;

    protected String nodeToUri(NodeInfo node) {
        return String.format("tcp://%s:%d", node.getIp(), 7238);
    }

    @Activate
    public void activate() {
        Map<String, Set<NodeInfo>> partitionMap;
        String logDir = System.getProperty("karaf.data", "./data");
        File file = new File(CONFIG_DIR, PARTITION_DEFINITION_FILE);
        this.log.info("Loading database definition: {}", (Object)file.getAbsolutePath());
        try {
            DatabaseDefinitionStore databaseDef = new DatabaseDefinitionStore(file);
            partitionMap = databaseDef.read().getPartitions();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load database config", e);
        }
        String[] activeNodeUris = (String[])partitionMap.values().stream().reduce((s1, s2) -> Sets.union((Set)s1, (Set)s2)).get().stream().map(this::nodeToUri).toArray(String[]::new);
        String localNodeUri = this.nodeToUri(NodeInfo.of(this.clusterService.getLocalNode()));
        ClusterConfig clusterConfig = new ClusterConfig().withProtocol((Protocol)new NettyTcpProtocol().withSsl(false).withConnectTimeout(60000).withAcceptBacklog(1024).withTrafficClass(-1).withSoLinger(-1).withReceiveBufferSize(32768).withSendBufferSize(8192).withThreads(1)).withElectionTimeout(3000L).withHeartbeatInterval(1500L).withMembers(activeNodeUris).withLocalMember(localNodeUri);
        partitionMap.forEach((name, nodes) -> {
            Set replicas = nodes.stream().map(this::nodeToUri).collect(Collectors.toSet());
            DatabaseConfig partitionConfig = (DatabaseConfig)((DatabaseConfig)((DatabaseConfig)((DatabaseConfig)((DatabaseConfig)new DatabaseConfig().withElectionTimeout(3000L)).withHeartbeatInterval(1500L)).withConsistency(Consistency.STRONG).withLog((Log)new FileLog().withDirectory(logDir).withSegmentSize(0x40000000).withFlushOnWrite(true).withSegmentInterval(Long.MAX_VALUE))).withDefaultSerializer((Serializer)new DatabaseSerializer())).withReplicas(replicas);
            this.databaseConfig.addPartition((String)name, partitionConfig);
        });
        this.partitionedDatabase = PartitionedDatabaseManager.create("onos-store", clusterConfig, this.databaseConfig);
        CountDownLatch latch = new CountDownLatch(1);
        this.partitionedDatabase.open().whenComplete((db, error) -> {
            if (error != null) {
                this.log.warn("Failed to open database.", error);
            } else {
                latch.countDown();
                this.log.info("Successfully opened database.");
            }
        });
        try {
            if (!latch.await(60L, TimeUnit.SECONDS)) {
                this.log.warn("Timed out waiting for database to initialize.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.warn("Failed to complete database initialization.");
        }
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.partitionedDatabase.close().whenComplete((result, error) -> {
            if (error != null) {
                this.log.warn("Failed to cleanly close database.", error);
            } else {
                this.log.info("Successfully closed database.");
            }
        });
        this.log.info("Stopped");
    }

    public <K, V> ConsistentMap<K, V> createConsistentMap(String name, org.onosproject.store.service.Serializer serializer) {
        return new ConsistentMapImpl(name, this.partitionedDatabase, serializer);
    }

    public TransactionContext createTransactionContext() {
        return new DefaultTransactionContext(this.partitionedDatabase);
    }

    public List<PartitionInfo> getPartitionInfo() {
        return this.partitionedDatabase.getRegisteredPartitions().values().stream().map(db -> DatabaseManager.toPartitionInfo(db, this.databaseConfig.partitions().get(db.name()))).collect(Collectors.toList());
    }

    private static PartitionInfo toPartitionInfo(Database database, DatabaseConfig dbConfig) {
        return new PartitionInfo(database.name(), database.cluster().term(), database.cluster().members().stream().map(Member::uri).filter(uri -> dbConfig.getReplicas().contains(uri)).collect(Collectors.toList()), database.cluster().leader() != null ? database.cluster().leader().uri() : null);
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }
}

