/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.hash.Hashing;
import java.util.Map;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.Partitioner;

public abstract class DatabasePartitioner
implements Partitioner<String> {
    protected final Database[] sortedPartitions;

    public DatabasePartitioner(Map<String, Database> partitionMap) {
        Preconditions.checkState((partitionMap != null && !partitionMap.isEmpty() ? 1 : 0) != 0, (Object)"Partition map cannot be null or empty");
        this.sortedPartitions = (Database[])ImmutableSortedMap.copyOf(partitionMap).values().toArray((Object[])new Database[0]);
    }

    protected int hash(String key) {
        return Math.abs(Hashing.md5().newHasher().putBytes(key.getBytes(Charsets.UTF_8)).hash().asInt());
    }
}

