/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.kuujo.copycat.resource.internal.AbstractResource;
import net.kuujo.copycat.resource.internal.ResourceContext;
import net.kuujo.copycat.state.StateMachine;
import net.kuujo.copycat.state.internal.DefaultStateMachine;
import net.kuujo.copycat.util.concurrent.Futures;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DatabaseProxy;
import org.onosproject.store.consistent.impl.DatabaseState;
import org.onosproject.store.consistent.impl.DefaultDatabaseState;
import org.onosproject.store.service.UpdateOperation;
import org.onosproject.store.service.Versioned;

public class DefaultDatabase
extends AbstractResource<Database>
implements Database {
    private final StateMachine<DatabaseState<String, byte[]>> stateMachine;
    private DatabaseProxy<String, byte[]> proxy;

    public DefaultDatabase(ResourceContext context) {
        super(context);
        this.stateMachine = new DefaultStateMachine(context, DatabaseState.class, DefaultDatabaseState.class);
    }

    protected <T> CompletableFuture<T> checkOpen(Supplier<CompletableFuture<T>> supplier) {
        if (this.proxy == null) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("Database closed"));
        }
        return supplier.get();
    }

    @Override
    public CompletableFuture<Integer> size(String tableName) {
        return this.checkOpen(() -> this.proxy.size(tableName));
    }

    @Override
    public CompletableFuture<Boolean> isEmpty(String tableName) {
        return this.checkOpen(() -> this.proxy.isEmpty(tableName));
    }

    @Override
    public CompletableFuture<Boolean> containsKey(String tableName, String key) {
        return this.checkOpen(() -> this.proxy.containsKey(tableName, key));
    }

    @Override
    public CompletableFuture<Boolean> containsValue(String tableName, byte[] value) {
        return this.checkOpen(() -> this.proxy.containsValue(tableName, value));
    }

    @Override
    public CompletableFuture<Versioned<byte[]>> get(String tableName, String key) {
        return this.checkOpen(() -> this.proxy.get(tableName, key));
    }

    @Override
    public CompletableFuture<Versioned<byte[]>> put(String tableName, String key, byte[] value) {
        return this.checkOpen(() -> this.proxy.put(tableName, key, value));
    }

    @Override
    public CompletableFuture<Versioned<byte[]>> remove(String tableName, String key) {
        return this.checkOpen(() -> this.proxy.remove(tableName, key));
    }

    @Override
    public CompletableFuture<Void> clear(String tableName) {
        return this.checkOpen(() -> this.proxy.clear(tableName));
    }

    @Override
    public CompletableFuture<Set<String>> keySet(String tableName) {
        return this.checkOpen(() -> this.proxy.keySet(tableName));
    }

    @Override
    public CompletableFuture<Collection<Versioned<byte[]>>> values(String tableName) {
        return this.checkOpen(() -> this.proxy.values(tableName));
    }

    @Override
    public CompletableFuture<Set<Map.Entry<String, Versioned<byte[]>>>> entrySet(String tableName) {
        return this.checkOpen(() -> this.proxy.entrySet(tableName));
    }

    @Override
    public CompletableFuture<Versioned<byte[]>> putIfAbsent(String tableName, String key, byte[] value) {
        return this.checkOpen(() -> this.proxy.putIfAbsent(tableName, key, value));
    }

    @Override
    public CompletableFuture<Boolean> remove(String tableName, String key, byte[] value) {
        return this.checkOpen(() -> this.proxy.remove(tableName, key, value));
    }

    @Override
    public CompletableFuture<Boolean> remove(String tableName, String key, long version) {
        return this.checkOpen(() -> this.proxy.remove(tableName, key, version));
    }

    @Override
    public CompletableFuture<Boolean> replace(String tableName, String key, byte[] oldValue, byte[] newValue) {
        return this.checkOpen(() -> this.proxy.replace(tableName, key, oldValue, newValue));
    }

    @Override
    public CompletableFuture<Boolean> replace(String tableName, String key, long oldVersion, byte[] newValue) {
        return this.checkOpen(() -> this.proxy.replace(tableName, key, oldVersion, newValue));
    }

    @Override
    public CompletableFuture<Boolean> atomicBatchUpdate(List<UpdateOperation<String, byte[]>> updates) {
        return this.checkOpen(() -> this.proxy.atomicBatchUpdate(updates));
    }

    public synchronized CompletableFuture<Database> open() {
        return ((CompletableFuture)((CompletableFuture)this.runStartupTasks().thenCompose(v -> this.stateMachine.open())).thenRun(() -> {
            this.proxy = (DatabaseProxy)this.stateMachine.createProxy(DatabaseProxy.class, this.getClass().getClassLoader());
        })).thenApply(v -> null);
    }

    public synchronized CompletableFuture<Void> close() {
        this.proxy = null;
        return this.stateMachine.close().thenCompose(v -> this.runShutdownTasks());
    }
}

