/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.kuujo.copycat.state.Initializer;
import net.kuujo.copycat.state.StateContext;
import org.apache.commons.lang3.tuple.Pair;
import org.onosproject.store.consistent.impl.DatabaseState;
import org.onosproject.store.service.UpdateOperation;
import org.onosproject.store.service.Versioned;

public class DefaultDatabaseState<K, V>
implements DatabaseState<K, V> {
    private Long nextVersion;
    private Map<String, Map<K, Versioned<V>>> tables;

    @Override
    @Initializer
    public void init(StateContext<DatabaseState<K, V>> context) {
        this.tables = (Map)context.get("tables");
        if (this.tables == null) {
            this.tables = new HashMap<String, Map<K, Versioned<V>>>();
            context.put("tables", this.tables);
        }
        this.nextVersion = (Long)context.get("nextVersion");
        if (this.nextVersion == null) {
            this.nextVersion = new Long(0L);
            context.put("nextVersion", (Object)this.nextVersion);
        }
    }

    private Map<K, Versioned<V>> getTableMap(String tableName) {
        Map<K, Versioned<V>> table = this.tables.get(tableName);
        if (table == null) {
            table = new HashMap<K, Versioned<V>>();
            this.tables.put(tableName, table);
        }
        return table;
    }

    @Override
    public int size(String tableName) {
        return this.getTableMap(tableName).size();
    }

    @Override
    public boolean isEmpty(String tableName) {
        return this.getTableMap(tableName).isEmpty();
    }

    @Override
    public boolean containsKey(String tableName, K key) {
        return this.getTableMap(tableName).containsKey(key);
    }

    @Override
    public boolean containsValue(String tableName, V value) {
        return this.getTableMap(tableName).values().stream().anyMatch(v -> this.checkEquality(v.value(), value));
    }

    @Override
    public Versioned<V> get(String tableName, K key) {
        return this.getTableMap(tableName).get(key);
    }

    @Override
    public Versioned<V> put(String tableName, K key, V value) {
        this.nextVersion = this.nextVersion + 1L;
        return this.getTableMap(tableName).put(key, new Versioned(value, this.nextVersion.longValue()));
    }

    @Override
    public Versioned<V> remove(String tableName, K key) {
        return this.getTableMap(tableName).remove(key);
    }

    @Override
    public void clear(String tableName) {
        this.getTableMap(tableName).clear();
    }

    @Override
    public Set<K> keySet(String tableName) {
        return ImmutableSet.copyOf(this.getTableMap(tableName).keySet());
    }

    @Override
    public Collection<Versioned<V>> values(String tableName) {
        return ImmutableList.copyOf(this.getTableMap(tableName).values());
    }

    @Override
    public Set<Map.Entry<K, Versioned<V>>> entrySet(String tableName) {
        return ImmutableSet.copyOf((Collection)this.getTableMap(tableName).entrySet().stream().map(entry -> Pair.of(entry.getKey(), entry.getValue())).collect(Collectors.toSet()));
    }

    @Override
    public Versioned<V> putIfAbsent(String tableName, K key, V value) {
        Versioned<V> existingValue = this.getTableMap(tableName).get(key);
        return existingValue != null ? existingValue : this.put(tableName, key, value);
    }

    @Override
    public boolean remove(String tableName, K key, V value) {
        Versioned<V> existing = this.getTableMap(tableName).get(key);
        if (existing != null && this.checkEquality(existing.value(), value)) {
            this.getTableMap(tableName).remove(key);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(String tableName, K key, long version) {
        Versioned<V> existing = this.getTableMap(tableName).get(key);
        if (existing != null && existing.version() == version) {
            this.remove(tableName, key);
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(String tableName, K key, V oldValue, V newValue) {
        Versioned<V> existing = this.getTableMap(tableName).get(key);
        if (existing != null && this.checkEquality(existing.value(), oldValue)) {
            this.put(tableName, key, newValue);
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(String tableName, K key, long oldVersion, V newValue) {
        Versioned<V> existing = this.getTableMap(tableName).get(key);
        if (existing != null && existing.version() == oldVersion) {
            this.put(tableName, key, newValue);
            return true;
        }
        return false;
    }

    @Override
    public boolean batchUpdate(List<UpdateOperation<K, V>> updates) {
        if (updates.stream().anyMatch(update -> !this.checkIfUpdateIsPossible((UpdateOperation<K, V>)update))) {
            return false;
        }
        updates.stream().forEach(this::doUpdate);
        return true;
    }

    private void doUpdate(UpdateOperation<K, V> update) {
        String tableName = update.tableName();
        Object key = update.key();
        switch (update.type()) {
            case PUT: {
                this.put(tableName, key, update.value());
                return;
            }
            case REMOVE: {
                this.remove(tableName, key);
                return;
            }
            case PUT_IF_ABSENT: {
                this.putIfAbsent(tableName, key, update.value());
                return;
            }
            case PUT_IF_VERSION_MATCH: {
                this.replace(tableName, key, update.currentValue(), update.value());
                return;
            }
            case PUT_IF_VALUE_MATCH: {
                this.replace(tableName, key, update.currentVersion(), update.value());
                return;
            }
            case REMOVE_IF_VERSION_MATCH: {
                this.remove(tableName, key, update.currentVersion());
                return;
            }
            case REMOVE_IF_VALUE_MATCH: {
                this.remove(tableName, key, update.currentValue());
                return;
            }
        }
        throw new IllegalStateException("Unsupported type: " + update.type());
    }

    private boolean checkIfUpdateIsPossible(UpdateOperation<K, V> update) {
        Versioned<V> existingEntry = this.get(update.tableName(), update.key());
        switch (update.type()) {
            case PUT: 
            case REMOVE: {
                return true;
            }
            case PUT_IF_ABSENT: {
                return existingEntry == null;
            }
            case PUT_IF_VERSION_MATCH: {
                return existingEntry != null && existingEntry.version() == update.currentVersion();
            }
            case PUT_IF_VALUE_MATCH: {
                return existingEntry != null && this.checkEquality(existingEntry.value(), update.currentValue());
            }
            case REMOVE_IF_VERSION_MATCH: {
                return existingEntry == null || existingEntry.version() == update.currentVersion();
            }
            case REMOVE_IF_VALUE_MATCH: {
                return existingEntry == null || this.checkEquality(existingEntry.value(), update.currentValue());
            }
        }
        throw new IllegalStateException("Unsupported type: " + update.type());
    }

    private boolean checkEquality(V value1, V value2) {
        if (value1 instanceof byte[]) {
            return Arrays.equals((byte[])value1, (byte[])value2);
        }
        return value1.equals(value2);
    }
}

