/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.onosproject.store.consistent.impl.ConsistentMapImpl;
import org.onosproject.store.consistent.impl.DatabaseProxy;
import org.onosproject.store.consistent.impl.DefaultTransactionalMap;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionException;
import org.onosproject.store.service.TransactionalMap;

public class DefaultTransactionContext
implements TransactionContext {
    private final Map<String, DefaultTransactionalMap> txMaps = Maps.newHashMap();
    private boolean isOpen = false;
    DatabaseProxy<String, byte[]> databaseProxy;
    private static final String TX_NOT_OPEN_ERROR = "Transaction is not open";
    private static final int TRANSACTION_TIMEOUT_MILLIS = 2000;

    DefaultTransactionContext(DatabaseProxy<String, byte[]> proxy) {
        this.databaseProxy = proxy;
    }

    public void begin() {
        this.isOpen = true;
    }

    public <K, V> TransactionalMap<K, V> createTransactionalMap(String mapName, Serializer serializer) {
        Preconditions.checkNotNull((Object)mapName, (Object)"map name is null");
        Preconditions.checkNotNull((Object)serializer, (Object)"serializer is null");
        Preconditions.checkState((boolean)this.isOpen, (Object)TX_NOT_OPEN_ERROR);
        if (!this.txMaps.containsKey(mapName)) {
            ConsistentMapImpl backingMap = new ConsistentMapImpl(mapName, this.databaseProxy, serializer);
            DefaultTransactionalMap txMap = new DefaultTransactionalMap(mapName, backingMap, this, serializer);
            this.txMaps.put(mapName, txMap);
        }
        return this.txMaps.get(mapName);
    }

    public void commit() {
        Preconditions.checkState((boolean)this.isOpen, (Object)TX_NOT_OPEN_ERROR);
        LinkedList allUpdates = Lists.newLinkedList();
        try {
            this.txMaps.values().stream().forEach(m -> allUpdates.addAll(m.prepareDatabaseUpdates()));
            if (!DefaultTransactionContext.complete(this.databaseProxy.atomicBatchUpdate(allUpdates)).booleanValue()) {
                throw new TransactionException.OptimisticConcurrencyFailure();
            }
        }
        finally {
            this.isOpen = false;
        }
    }

    public void rollback() {
        Preconditions.checkState((boolean)this.isOpen, (Object)TX_NOT_OPEN_ERROR);
        this.txMaps.values().stream().forEach(m -> m.rollback());
    }

    public boolean isOpen() {
        return false;
    }

    private static <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TransactionException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new TransactionException.Timeout();
        }
        catch (ExecutionException e) {
            throw new TransactionException(e.getCause());
        }
    }
}

