/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.util.HexString;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionalMap;
import org.onosproject.store.service.UpdateOperation;
import org.onosproject.store.service.Versioned;

public class DefaultTransactionalMap<K, V>
implements TransactionalMap<K, V> {
    private final TransactionContext txContext;
    private static final String TX_CLOSED_ERROR = "Transaction is closed";
    private final ConsistentMap<K, V> backingMap;
    private final String name;
    private final Serializer serializer;
    private final Map<K, Versioned<V>> readCache = Maps.newConcurrentMap();
    private final Map<K, V> writeCache = Maps.newConcurrentMap();
    private final Set<K> deleteSet = Sets.newConcurrentHashSet();

    public DefaultTransactionalMap(String name, ConsistentMap<K, V> backingMap, TransactionContext txContext, Serializer serializer) {
        this.name = name;
        this.backingMap = backingMap;
        this.txContext = txContext;
        this.serializer = serializer;
    }

    public V get(K key) {
        Versioned<V> v;
        Preconditions.checkState((boolean)this.txContext.isOpen(), (Object)TX_CLOSED_ERROR);
        if (this.deleteSet.contains(key)) {
            return null;
        }
        if (this.writeCache.containsKey(key)) {
            return this.writeCache.get(key);
        }
        if (!this.readCache.containsKey(key)) {
            this.readCache.put(key, this.backingMap.get(key));
        }
        return (V)((v = this.readCache.get(key)) != null ? v.value() : null);
    }

    public V put(K key, V value) {
        Preconditions.checkState((boolean)this.txContext.isOpen(), (Object)TX_CLOSED_ERROR);
        Versioned<V> original = this.readCache.get(key);
        V recentUpdate = this.writeCache.put(key, value);
        this.deleteSet.remove(key);
        return (V)(recentUpdate == null ? (original != null ? original.value() : null) : recentUpdate);
    }

    public V remove(K key) {
        Preconditions.checkState((boolean)this.txContext.isOpen(), (Object)TX_CLOSED_ERROR);
        Versioned<V> original = this.readCache.get(key);
        V recentUpdate = this.writeCache.remove(key);
        this.deleteSet.add(key);
        return (V)(recentUpdate == null ? (original != null ? original.value() : null) : recentUpdate);
    }

    public boolean remove(K key, V value) {
        V currentValue = this.get(key);
        if (value.equals(currentValue)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        V currentValue = this.get(key);
        if (oldValue.equals(currentValue)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(K key) {
        return this.get(key) != null;
    }

    public boolean containsValue(V value) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    public V putIfAbsent(K key, V value) {
        V currentValue = this.get(key);
        if (currentValue == null) {
            this.put(key, value);
            return null;
        }
        return currentValue;
    }

    protected List<UpdateOperation<String, byte[]>> prepareDatabaseUpdates() {
        LinkedList updates = Lists.newLinkedList();
        this.deleteSet.forEach(key -> {
            Versioned<V> original = this.readCache.get(key);
            if (original != null) {
                updates.add(UpdateOperation.newBuilder().withTableName(this.name).withType(UpdateOperation.Type.REMOVE_IF_VERSION_MATCH).withKey(key).withCurrentVersion(original.version()).build());
            }
        });
        this.writeCache.forEach((key, value) -> {
            Versioned<V> original = this.readCache.get(key);
            if (original == null) {
                updates.add(UpdateOperation.newBuilder().withTableName(this.name).withType(UpdateOperation.Type.PUT_IF_ABSENT).withKey(key).withValue(value).build());
            } else {
                updates.add(UpdateOperation.newBuilder().withTableName(this.name).withType(UpdateOperation.Type.PUT_IF_VERSION_MATCH).withKey(key).withCurrentVersion(original.version()).withValue(value).build());
            }
        });
        return updates.stream().map(this::toRawUpdateOperation).collect(Collectors.toList());
    }

    private UpdateOperation<String, byte[]> toRawUpdateOperation(UpdateOperation<K, V> update) {
        UpdateOperation.Builder rawUpdate = UpdateOperation.newBuilder();
        rawUpdate = rawUpdate.withKey((Object)HexString.toHexString((byte[])this.serializer.encode(update.key()))).withCurrentVersion(update.currentVersion()).withType(update.type());
        rawUpdate = rawUpdate.withTableName(update.tableName());
        if (update.value() != null) {
            rawUpdate = rawUpdate.withValue((Object)this.serializer.encode(update.value()));
        }
        if (update.currentValue() != null) {
            rawUpdate = rawUpdate.withCurrentValue((Object)this.serializer.encode(update.currentValue()));
        }
        return rawUpdate.build();
    }

    protected void rollback() {
        this.readCache.clear();
        this.writeCache.clear();
        this.deleteSet.clear();
    }
}

