/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.kuujo.copycat.CopycatConfig;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.ClusterCoordinator;
import net.kuujo.copycat.cluster.internal.coordinator.DefaultClusterCoordinator;
import net.kuujo.copycat.util.concurrent.NamedThreadFactory;
import net.kuujo.copycat.util.serializer.Serializer;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DatabaseConfig;
import org.onosproject.store.consistent.impl.DatabaseSerializer;
import org.onosproject.store.consistent.impl.PartitionedDatabase;
import org.onosproject.store.consistent.impl.PartitionedDatabaseConfig;
import org.onosproject.store.consistent.impl.Partitioner;
import org.onosproject.store.consistent.impl.SimpleKeyHashPartitioner;

public interface PartitionedDatabaseManager {
    public CompletableFuture<PartitionedDatabase> open();

    public CompletableFuture<Void> close();

    public void setPartitioner(Partitioner<String> var1);

    public void registerPartition(String var1, Database var2);

    public Map<String, Database> getRegisteredPartitions();

    public static PartitionedDatabase create(String name, ClusterConfig clusterConfig, PartitionedDatabaseConfig partitionedDatabaseConfig) {
        CopycatConfig copycatConfig = new CopycatConfig().withName(name).withClusterConfig(clusterConfig).withDefaultSerializer((Serializer)new DatabaseSerializer()).withDefaultExecutor((Executor)Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("copycat-coordinator-%d")));
        DefaultClusterCoordinator coordinator = new DefaultClusterCoordinator(copycatConfig.resolve());
        PartitionedDatabase partitionedDatabase = new PartitionedDatabase((ClusterCoordinator)coordinator);
        partitionedDatabaseConfig.partitions().forEach((arg_0, arg_1) -> PartitionedDatabaseManager.lambda$create$17(partitionedDatabase, (ClusterCoordinator)coordinator, clusterConfig, copycatConfig, arg_0, arg_1));
        partitionedDatabase.setPartitioner(new SimpleKeyHashPartitioner(partitionedDatabase.getRegisteredPartitions()));
        return partitionedDatabase;
    }

    private static /* synthetic */ void lambda$create$17(PartitionedDatabase partitionedDatabase, ClusterCoordinator clusterCoordinator, ClusterConfig clusterConfig, CopycatConfig copycatConfig, String partitionName, DatabaseConfig partitionConfig) {
        partitionedDatabase.registerPartition(partitionName, (Database)clusterCoordinator.getResource(partitionName, partitionConfig.resolve(clusterConfig).withSerializer(copycatConfig.getDefaultSerializer()).withDefaultExecutor(copycatConfig.getDefaultExecutor())));
    }
}

