/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.core.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.IdBlock;
import org.onosproject.core.IdBlockStore;
import org.onosproject.store.hz.StoreService;

@Component(immediate=true)
@Service
public class DistributedIdBlockStore
implements IdBlockStore {
    private static final long DEFAULT_BLOCK_SIZE = 0x100000L;
    protected Map<String, IAtomicLong> topicBlocks;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StoreService storeService;
    protected HazelcastInstance theInstance;

    @Activate
    public void activate() {
        this.theInstance = this.storeService.getHazelcastInstance();
    }

    public IdBlock getIdBlock(String topic) {
        Long blockBase = this.theInstance.getAtomicLong(topic).getAndAdd(0x100000L);
        return new IdBlock(blockBase.longValue(), 0x100000L);
    }

    protected void bindStoreService(StoreService storeService) {
        this.storeService = storeService;
    }

    protected void unbindStoreService(StoreService storeService) {
        if (this.storeService == storeService) {
            this.storeService = null;
        }
    }
}

