/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.device.impl;

import com.esotericsoftware.kryo.Serializer;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.ChassisId;
import org.onlab.util.KryoNamespace;
import org.onlab.util.NewConcurrentHashMap;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNodeToNodeId;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.mastership.MastershipService;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.mastership.MastershipTermService;
import org.onosproject.net.Annotations;
import org.onosproject.net.AnnotationsUtil;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DeviceClockService;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceStore;
import org.onosproject.net.device.DeviceStoreDelegate;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.Timestamp;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.device.impl.DeviceAntiEntropyAdvertisement;
import org.onosproject.store.device.impl.DeviceDescriptions;
import org.onosproject.store.device.impl.DeviceFragmentId;
import org.onosproject.store.device.impl.DeviceInjectedEvent;
import org.onosproject.store.device.impl.GossipDeviceStoreMessageSubjects;
import org.onosproject.store.device.impl.InternalDeviceEvent;
import org.onosproject.store.device.impl.InternalDeviceEventSerializer;
import org.onosproject.store.device.impl.InternalDeviceOfflineEvent;
import org.onosproject.store.device.impl.InternalDeviceOfflineEventSerializer;
import org.onosproject.store.device.impl.InternalDeviceRemovedEvent;
import org.onosproject.store.device.impl.InternalPortEvent;
import org.onosproject.store.device.impl.InternalPortEventSerializer;
import org.onosproject.store.device.impl.InternalPortStatusEvent;
import org.onosproject.store.device.impl.InternalPortStatusEventSerializer;
import org.onosproject.store.device.impl.PortFragmentId;
import org.onosproject.store.device.impl.PortInjectedEvent;
import org.onosproject.store.impl.Timestamped;
import org.onosproject.store.serializers.KryoSerializer;
import org.onosproject.store.serializers.impl.DistributedStoreSerializers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class GossipDeviceStore
extends AbstractStore<DeviceEvent, DeviceStoreDelegate>
implements DeviceStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String DEVICE_NOT_FOUND = "Device with ID %s not found";
    private static final int REMOTE_MASTER_TIMEOUT = 1000;
    private final ConcurrentMap<DeviceId, Map<ProviderId, DeviceDescriptions>> deviceDescs = Maps.newConcurrentMap();
    private final ConcurrentMap<DeviceId, Device> devices = Maps.newConcurrentMap();
    private final ConcurrentMap<DeviceId, ConcurrentMap<PortNumber, Port>> devicePorts = Maps.newConcurrentMap();
    private final Map<DeviceId, Timestamp> offline = Maps.newHashMap();
    private final Map<DeviceId, Timestamp> removalRequest = Maps.newHashMap();
    private final Set<DeviceId> availableDevices = Sets.newConcurrentHashSet();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceClockService deviceClockService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipTermService termService;
    protected static final KryoSerializer SERIALIZER = new KryoSerializer(){

        protected void setupKryoPool() {
            this.serializerPool = KryoNamespace.newBuilder().register(DistributedStoreSerializers.STORE_COMMON).nextId(310).register((Serializer)new InternalDeviceEventSerializer(), new Class[]{InternalDeviceEvent.class}).register((Serializer)new InternalDeviceOfflineEventSerializer(), new Class[]{InternalDeviceOfflineEvent.class}).register(new Class[]{InternalDeviceRemovedEvent.class}).register((Serializer)new InternalPortEventSerializer(), new Class[]{InternalPortEvent.class}).register((Serializer)new InternalPortStatusEventSerializer(), new Class[]{InternalPortStatusEvent.class}).register(new Class[]{DeviceAntiEntropyAdvertisement.class}).register(new Class[]{DeviceFragmentId.class}).register(new Class[]{PortFragmentId.class}).register(new Class[]{DeviceInjectedEvent.class}).register(new Class[]{PortInjectedEvent.class}).build();
        }
    };
    private ExecutorService executor;
    private ScheduledExecutorService backgroundExecutor;
    private long initialDelaySec = 5L;
    private long periodSec = 5L;

    @Activate
    public void activate() {
        this.executor = Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/device", (String)"fg-%d"));
        this.backgroundExecutor = Executors.newSingleThreadScheduledExecutor(Tools.minPriority((ThreadFactory)Tools.groupedThreads((String)"onos/device", (String)"bg-%d")));
        this.clusterCommunicator.addSubscriber(GossipDeviceStoreMessageSubjects.DEVICE_UPDATE, (ClusterMessageHandler)new InternalDeviceEventListener(), this.executor);
        this.clusterCommunicator.addSubscriber(GossipDeviceStoreMessageSubjects.DEVICE_OFFLINE, (ClusterMessageHandler)new InternalDeviceOfflineEventListener(), this.executor);
        this.clusterCommunicator.addSubscriber(GossipDeviceStoreMessageSubjects.DEVICE_REMOVE_REQ, (ClusterMessageHandler)new InternalRemoveRequestListener(), this.executor);
        this.clusterCommunicator.addSubscriber(GossipDeviceStoreMessageSubjects.DEVICE_REMOVED, (ClusterMessageHandler)new InternalDeviceRemovedEventListener(), this.executor);
        this.clusterCommunicator.addSubscriber(GossipDeviceStoreMessageSubjects.PORT_UPDATE, (ClusterMessageHandler)new InternalPortEventListener(), this.executor);
        this.clusterCommunicator.addSubscriber(GossipDeviceStoreMessageSubjects.PORT_STATUS_UPDATE, (ClusterMessageHandler)new InternalPortStatusEventListener(), this.executor);
        this.clusterCommunicator.addSubscriber(GossipDeviceStoreMessageSubjects.DEVICE_ADVERTISE, (ClusterMessageHandler)new InternalDeviceAdvertisementListener(), (ExecutorService)this.backgroundExecutor);
        this.clusterCommunicator.addSubscriber(GossipDeviceStoreMessageSubjects.DEVICE_INJECTED, (ClusterMessageHandler)new DeviceInjectedEventListener(), this.executor);
        this.clusterCommunicator.addSubscriber(GossipDeviceStoreMessageSubjects.PORT_INJECTED, (ClusterMessageHandler)new PortInjectedEventListener(), this.executor);
        this.backgroundExecutor.scheduleAtFixedRate(new SendAdvertisementTask(), this.initialDelaySec, this.periodSec, TimeUnit.SECONDS);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.executor.shutdownNow();
        this.backgroundExecutor.shutdownNow();
        try {
            if (!this.backgroundExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.log.error("Timeout during executor shutdown");
            }
        }
        catch (InterruptedException e) {
            this.log.error("Error during executor shutdown", (Throwable)e);
        }
        this.deviceDescs.clear();
        this.devices.clear();
        this.devicePorts.clear();
        this.availableDevices.clear();
        this.log.info("Stopped");
    }

    public int getDeviceCount() {
        return this.devices.size();
    }

    public Iterable<Device> getDevices() {
        return Collections.unmodifiableCollection(this.devices.values());
    }

    public Iterable<Device> getAvailableDevices() {
        return FluentIterable.from(this.getDevices()).filter((Predicate)new Predicate<Device>(){

            public boolean apply(Device input) {
                return GossipDeviceStore.this.isAvailable(input.id());
            }
        });
    }

    public Device getDevice(DeviceId deviceId) {
        return (Device)this.devices.get(deviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DeviceEvent createOrUpdateDevice(ProviderId providerId, DeviceId deviceId, DeviceDescription deviceDescription) {
        NodeId localNode = this.clusterService.getLocalNode().id();
        NodeId deviceNode = this.mastershipService.getMasterFor(deviceId);
        DeviceEvent deviceEvent = null;
        if (localNode.equals((Object)deviceNode)) {
            Timestamped<DeviceDescription> mergedDesc;
            Map<ProviderId, DeviceDescriptions> device;
            Timestamp newTimestamp = this.deviceClockService.getTimestamp(deviceId);
            Timestamped<DeviceDescription> deltaDesc = new Timestamped<DeviceDescription>(deviceDescription, newTimestamp);
            Map<ProviderId, DeviceDescriptions> map = device = this.getOrCreateDeviceDescriptionsMap(deviceId);
            synchronized (map) {
                deviceEvent = this.createOrUpdateDeviceInternal(providerId, deviceId, deltaDesc);
                mergedDesc = device.get(providerId).getDeviceDesc();
            }
            if (deviceEvent != null) {
                this.log.info("Notifying peers of a device update topology event for providerId: {} and deviceId: {}", (Object)providerId, (Object)deviceId);
                this.notifyPeers(new InternalDeviceEvent(providerId, deviceId, mergedDesc));
            }
        } else {
            if (deviceNode == null) {
                return null;
            }
            DeviceInjectedEvent deviceInjectedEvent = new DeviceInjectedEvent(providerId, deviceId, deviceDescription);
            ClusterMessage clusterMessage = new ClusterMessage(localNode, GossipDeviceStoreMessageSubjects.DEVICE_INJECTED, SERIALIZER.encode((Object)deviceInjectedEvent));
            this.clusterCommunicator.unicast(clusterMessage, deviceNode);
        }
        return deviceEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceEvent createOrUpdateDeviceInternal(ProviderId providerId, DeviceId deviceId, Timestamped<DeviceDescription> deltaDesc) {
        Map<ProviderId, DeviceDescriptions> device;
        Map<ProviderId, DeviceDescriptions> map = device = this.getOrCreateDeviceDescriptionsMap(deviceId);
        synchronized (map) {
            if (this.isDeviceRemoved(deviceId, deltaDesc.timestamp())) {
                this.log.debug("Ignoring outdated event: {}", deltaDesc);
                return null;
            }
            DeviceDescriptions descs = this.getOrCreateProviderDeviceDescriptions(device, providerId, deltaDesc);
            Device oldDevice = (Device)this.devices.get(deviceId);
            if (deltaDesc != descs.getDeviceDesc() && !deltaDesc.isNewer(descs.getDeviceDesc())) {
                return null;
            }
            descs.putDeviceDesc(deltaDesc);
            Device newDevice = this.composeDevice(deviceId, device);
            if (oldDevice == null) {
                return this.createDevice(providerId, newDevice, deltaDesc.timestamp());
            }
            return this.updateDevice(providerId, oldDevice, newDevice, deltaDesc.timestamp());
        }
    }

    private DeviceEvent createDevice(ProviderId providerId, Device newDevice, Timestamp timestamp) {
        Device oldDevice = this.devices.putIfAbsent(newDevice.id(), newDevice);
        Verify.verify((oldDevice == null ? 1 : 0) != 0, (String)"Unexpected Device in cache. PID:%s [old=%s, new=%s]", (Object[])new Object[]{providerId, oldDevice, newDevice});
        if (!providerId.isAncillary()) {
            this.markOnline(newDevice.id(), timestamp);
        }
        return new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, newDevice, null);
    }

    private DeviceEvent updateDevice(ProviderId providerId, Device oldDevice, Device newDevice, Timestamp newTimestamp) {
        boolean annotationsChanged;
        boolean propertiesChanged = !Objects.equals(oldDevice.hwVersion(), newDevice.hwVersion()) || !Objects.equals(oldDevice.swVersion(), newDevice.swVersion());
        boolean bl = annotationsChanged = !AnnotationsUtil.isEqual((Annotations)oldDevice.annotations(), (Annotations)newDevice.annotations());
        if (providerId.isAncillary() && annotationsChanged || !providerId.isAncillary() && (propertiesChanged || annotationsChanged)) {
            boolean replaced = this.devices.replace(newDevice.id(), oldDevice, newDevice);
            if (!replaced) {
                Verify.verify((boolean)replaced, (String)"Replacing devices cache failed. PID:%s [expected:%s, found:%s, new=%s]", (Object[])new Object[]{providerId, oldDevice, this.devices.get(newDevice.id()), newDevice});
            }
            if (!providerId.isAncillary()) {
                this.markOnline(newDevice.id(), newTimestamp);
            }
            return new DeviceEvent(DeviceEvent.Type.DEVICE_UPDATED, newDevice, null);
        }
        if (!providerId.isAncillary()) {
            boolean added = this.markOnline(newDevice.id(), newTimestamp);
            return !added ? null : new DeviceEvent(DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED, newDevice, null);
        }
        return null;
    }

    public DeviceEvent markOffline(DeviceId deviceId) {
        Timestamp timestamp = this.deviceClockService.getTimestamp(deviceId);
        DeviceEvent event = this.markOfflineInternal(deviceId, timestamp);
        if (event != null) {
            this.log.info("Notifying peers of a device offline topology event for deviceId: {} {}", (Object)deviceId, (Object)timestamp);
            this.notifyPeers(new InternalDeviceOfflineEvent(deviceId, timestamp));
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceEvent markOfflineInternal(DeviceId deviceId, Timestamp timestamp) {
        Map<ProviderId, DeviceDescriptions> providerDescs;
        Map<ProviderId, DeviceDescriptions> map = providerDescs = this.getOrCreateDeviceDescriptionsMap(deviceId);
        synchronized (map) {
            DeviceDescriptions primDescs = this.getPrimaryDescriptions(providerDescs);
            Timestamp lastTimestamp = primDescs.getLatestTimestamp();
            if (timestamp.compareTo((Object)lastTimestamp) <= 0) {
                return null;
            }
            this.offline.put(deviceId, timestamp);
            Device device = (Device)this.devices.get(deviceId);
            if (device == null) {
                return null;
            }
            boolean removed = this.availableDevices.remove(deviceId);
            if (removed) {
                return new DeviceEvent(DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED, device, null);
            }
            return null;
        }
    }

    private boolean markOnline(DeviceId deviceId, Timestamp timestamp) {
        Timestamp offlineTimestamp = this.offline.get(deviceId);
        if (offlineTimestamp == null || offlineTimestamp.compareTo((Object)timestamp) < 0) {
            this.offline.remove(deviceId);
            return this.availableDevices.add(deviceId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<DeviceEvent> updatePorts(ProviderId providerId, DeviceId deviceId, List<PortDescription> portDescriptions) {
        NodeId localNode = this.clusterService.getLocalNode().id();
        NodeId deviceNode = this.mastershipService.getMasterFor(deviceId);
        List<DeviceEvent> deviceEvents = null;
        if (localNode.equals((Object)deviceNode)) {
            Timestamped<ImmutableList> merged;
            Map<ProviderId, DeviceDescriptions> device;
            Timestamp newTimestamp;
            try {
                newTimestamp = this.deviceClockService.getTimestamp(deviceId);
            }
            catch (IllegalStateException e) {
                this.log.info("Timestamp was not available for device {}", (Object)deviceId);
                this.log.debug("  discarding {}", portDescriptions);
                return Collections.emptyList();
            }
            this.log.debug("timestamp for {} {}", (Object)deviceId, (Object)newTimestamp);
            Timestamped<List<PortDescription>> timestampedInput = new Timestamped<List<PortDescription>>(portDescriptions, newTimestamp);
            Map<ProviderId, DeviceDescriptions> map = device = this.getOrCreateDeviceDescriptionsMap(deviceId);
            synchronized (map) {
                deviceEvents = this.updatePortsInternal(providerId, deviceId, timestampedInput);
                final DeviceDescriptions descs = device.get(providerId);
                ImmutableList mergedList = FluentIterable.from(portDescriptions).transform((Function)new Function<PortDescription, PortDescription>(){

                    public PortDescription apply(PortDescription input) {
                        return descs.getPortDesc(input.portNumber()).value();
                    }
                }).toList();
                merged = new Timestamped<ImmutableList>(mergedList, newTimestamp);
            }
            if (!deviceEvents.isEmpty()) {
                this.log.info("Notifying peers of a ports update topology event for providerId: {} and deviceId: {}", (Object)providerId, (Object)deviceId);
                this.notifyPeers(new InternalPortEvent(providerId, deviceId, merged));
            }
        } else {
            if (deviceNode == null) {
                return Collections.emptyList();
            }
            PortInjectedEvent portInjectedEvent = new PortInjectedEvent(providerId, deviceId, portDescriptions);
            ClusterMessage clusterMessage = new ClusterMessage(localNode, GossipDeviceStoreMessageSubjects.PORT_INJECTED, SERIALIZER.encode((Object)portInjectedEvent));
            this.clusterCommunicator.unicast(clusterMessage, deviceNode);
        }
        return deviceEvents == null ? Collections.emptyList() : deviceEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private List<DeviceEvent> updatePortsInternal(ProviderId providerId, DeviceId deviceId, Timestamped<List<PortDescription>> portDescriptions) {
        Device device = (Device)this.devices.get(deviceId);
        Preconditions.checkArgument((device != null ? 1 : 0) != 0, (String)DEVICE_NOT_FOUND, (Object[])new Object[]{deviceId});
        Map descsMap = (Map)this.deviceDescs.get(deviceId);
        Preconditions.checkArgument((descsMap != null ? 1 : 0) != 0, (String)DEVICE_NOT_FOUND, (Object[])new Object[]{deviceId});
        ArrayList<DeviceEvent> events = new ArrayList<DeviceEvent>();
        Map map = descsMap;
        synchronized (map) {
            if (this.isDeviceRemoved(deviceId, portDescriptions.timestamp())) {
                this.log.debug("Ignoring outdated events: {}", portDescriptions);
                return null;
            }
            DeviceDescriptions descs = (DeviceDescriptions)descsMap.get(providerId);
            Preconditions.checkArgument((descs != null ? 1 : 0) != 0, (String)"Device description for Device ID %s from Provider %s was not found", (Object[])new Object[]{deviceId, providerId});
            ConcurrentMap<PortNumber, Port> ports = this.getPortMap(deviceId);
            Timestamp newTimestamp = portDescriptions.timestamp();
            HashSet<PortNumber> processed = new HashSet<PortNumber>();
            for (PortDescription portDescription : portDescriptions.value()) {
                void var16_16;
                PortNumber number = portDescription.portNumber();
                processed.add(number);
                Port oldPort = (Port)ports.get(number);
                Timestamped<PortDescription> existingPortDesc = descs.getPortDesc(number);
                if (existingPortDesc != null && newTimestamp.compareTo((Object)existingPortDesc.timestamp()) < 0) continue;
                descs.putPortDesc(new Timestamped<PortDescription>(portDescription, portDescriptions.timestamp()));
                Port newPort = this.composePort(device, number, descsMap);
                events.add(oldPort == null ? this.createPort(device, (Port)var16_16, ports) : this.updatePort(device, oldPort, (Port)var16_16, ports));
            }
            events.addAll(this.pruneOldPorts(device, ports, processed));
        }
        return FluentIterable.from(events).filter(Predicates.notNull()).toList();
    }

    private DeviceEvent createPort(Device device, Port newPort, Map<PortNumber, Port> ports) {
        ports.put(newPort.number(), newPort);
        return new DeviceEvent(DeviceEvent.Type.PORT_ADDED, device, newPort);
    }

    private DeviceEvent updatePort(Device device, Port oldPort, Port newPort, Map<PortNumber, Port> ports) {
        if (oldPort.isEnabled() != newPort.isEnabled() || oldPort.type() != newPort.type() || oldPort.portSpeed() != newPort.portSpeed() || !AnnotationsUtil.isEqual((Annotations)oldPort.annotations(), (Annotations)newPort.annotations())) {
            ports.put(oldPort.number(), newPort);
            return new DeviceEvent(DeviceEvent.Type.PORT_UPDATED, device, newPort);
        }
        return null;
    }

    private List<DeviceEvent> pruneOldPorts(Device device, Map<PortNumber, Port> ports, Set<PortNumber> processed) {
        ArrayList<DeviceEvent> events = new ArrayList<DeviceEvent>();
        Iterator<Map.Entry<PortNumber, Port>> iterator = ports.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PortNumber, Port> e = iterator.next();
            PortNumber portNumber = e.getKey();
            if (processed.contains(portNumber)) continue;
            events.add(new DeviceEvent(DeviceEvent.Type.PORT_REMOVED, device, e.getValue()));
            iterator.remove();
        }
        return events;
    }

    private ConcurrentMap<PortNumber, Port> getPortMap(DeviceId deviceId) {
        return (ConcurrentMap)ConcurrentUtils.createIfAbsentUnchecked(this.devicePorts, (Object)deviceId, (ConcurrentInitializer)NewConcurrentHashMap.ifNeeded());
    }

    private Map<ProviderId, DeviceDescriptions> getOrCreateDeviceDescriptionsMap(DeviceId deviceId) {
        Map concurrentlyAdded;
        Map r = (HashMap)this.deviceDescs.get(deviceId);
        if (r == null && (concurrentlyAdded = (Map)this.deviceDescs.putIfAbsent(deviceId, r = new HashMap())) != null) {
            r = concurrentlyAdded;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceDescriptions getOrCreateProviderDeviceDescriptions(Map<ProviderId, DeviceDescriptions> device, ProviderId providerId, Timestamped<DeviceDescription> deltaDesc) {
        Map<ProviderId, DeviceDescriptions> map = device;
        synchronized (map) {
            DeviceDescriptions r = device.get(providerId);
            if (r == null) {
                r = new DeviceDescriptions(deltaDesc);
                device.put(providerId, r);
            }
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DeviceEvent updatePortStatus(ProviderId providerId, DeviceId deviceId, PortDescription portDescription) {
        Timestamped<PortDescription> mergedDesc;
        DeviceEvent event;
        Map<ProviderId, DeviceDescriptions> device;
        Timestamp newTimestamp;
        try {
            newTimestamp = this.deviceClockService.getTimestamp(deviceId);
        }
        catch (IllegalStateException e) {
            this.log.info("Timestamp was not available for device {}", (Object)deviceId);
            this.log.debug("  discarding {}", (Object)portDescription);
            return null;
        }
        Timestamped<PortDescription> deltaDesc = new Timestamped<PortDescription>(portDescription, newTimestamp);
        Map<ProviderId, DeviceDescriptions> map = device = this.getOrCreateDeviceDescriptionsMap(deviceId);
        synchronized (map) {
            event = this.updatePortStatusInternal(providerId, deviceId, deltaDesc);
            mergedDesc = device.get(providerId).getPortDesc(portDescription.portNumber());
        }
        if (event != null) {
            this.log.info("Notifying peers of a port status update topology event for providerId: {} and deviceId: {}", (Object)providerId, (Object)deviceId);
            this.notifyPeers(new InternalPortStatusEvent(providerId, deviceId, mergedDesc));
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceEvent updatePortStatusInternal(ProviderId providerId, DeviceId deviceId, Timestamped<PortDescription> deltaDesc) {
        Device device = (Device)this.devices.get(deviceId);
        Preconditions.checkArgument((device != null ? 1 : 0) != 0, (String)DEVICE_NOT_FOUND, (Object[])new Object[]{deviceId});
        Map descsMap = (Map)this.deviceDescs.get(deviceId);
        Preconditions.checkArgument((descsMap != null ? 1 : 0) != 0, (String)DEVICE_NOT_FOUND, (Object[])new Object[]{deviceId});
        Map map = descsMap;
        synchronized (map) {
            if (this.isDeviceRemoved(deviceId, deltaDesc.timestamp())) {
                this.log.debug("Ignoring outdated event: {}", deltaDesc);
                return null;
            }
            DeviceDescriptions descs = (DeviceDescriptions)descsMap.get(providerId);
            Verify.verify((descs != null ? 1 : 0) != 0, (String)"Device description for Device ID %s from Provider %s was not found", (Object[])new Object[]{deviceId, providerId});
            ConcurrentMap<PortNumber, Port> ports = this.getPortMap(deviceId);
            PortNumber number = deltaDesc.value().portNumber();
            Port oldPort = (Port)ports.get(number);
            Timestamped<PortDescription> existingPortDesc = descs.getPortDesc(number);
            if (existingPortDesc != null && !deltaDesc.isNewer(existingPortDesc)) {
                this.log.trace("ignore same or outdated {} >= {}", existingPortDesc, deltaDesc);
                return null;
            }
            descs.putPortDesc(deltaDesc);
            Port newPort = this.composePort(device, number, descsMap);
            if (oldPort == null) {
                return this.createPort(device, newPort, ports);
            }
            return this.updatePort(device, oldPort, newPort, ports);
        }
    }

    public List<Port> getPorts(DeviceId deviceId) {
        Map ports = (Map)this.devicePorts.get(deviceId);
        if (ports == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(ports.values());
    }

    public Port getPort(DeviceId deviceId, PortNumber portNumber) {
        Map ports = (Map)this.devicePorts.get(deviceId);
        return ports == null ? null : (Port)ports.get(portNumber);
    }

    public boolean isAvailable(DeviceId deviceId) {
        return this.availableDevices.contains(deviceId);
    }

    public synchronized DeviceEvent removeDevice(DeviceId deviceId) {
        NodeId myId = this.clusterService.getLocalNode().id();
        NodeId master = this.mastershipService.getMasterFor(deviceId);
        boolean relinquishAtEnd = false;
        if (master == null) {
            MastershipRole myRole = this.mastershipService.getLocalRole(deviceId);
            if (myRole != MastershipRole.NONE) {
                relinquishAtEnd = true;
            }
            this.log.debug("Temporarily requesting role for {} to remove", (Object)deviceId);
            this.mastershipService.requestRoleFor(deviceId);
            MastershipTerm term = this.termService.getMastershipTerm(deviceId);
            if (myId.equals((Object)term.master())) {
                master = myId;
            }
        }
        if (!myId.equals((Object)master)) {
            this.log.debug("{} has control of {}, forwarding remove request", (Object)master, (Object)deviceId);
            ClusterMessage message = new ClusterMessage(myId, GossipDeviceStoreMessageSubjects.DEVICE_REMOVE_REQ, SERIALIZER.encode((Object)deviceId));
            this.clusterCommunicator.unicast(message, master);
            return null;
        }
        Timestamp timestamp = this.deviceClockService.getTimestamp(deviceId);
        DeviceEvent event = this.removeDeviceInternal(deviceId, timestamp);
        if (event != null) {
            this.log.debug("Notifying peers of a device removed topology event for deviceId: {}", (Object)deviceId);
            this.notifyPeers(new InternalDeviceRemovedEvent(deviceId, timestamp));
        }
        if (relinquishAtEnd) {
            this.log.debug("Relinquishing temporary role acquired for {}", (Object)deviceId);
            this.mastershipService.relinquishMastership(deviceId);
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceEvent removeDeviceInternal(DeviceId deviceId, Timestamp timestamp) {
        Map<ProviderId, DeviceDescriptions> descs;
        Map<ProviderId, DeviceDescriptions> map = descs = this.getOrCreateDeviceDescriptionsMap(deviceId);
        synchronized (map) {
            DeviceDescriptions primDescs = this.getPrimaryDescriptions(descs);
            Timestamp lastTimestamp = primDescs.getLatestTimestamp();
            if (timestamp.compareTo((Object)lastTimestamp) <= 0) {
                return null;
            }
            this.removalRequest.put(deviceId, timestamp);
            Device device = (Device)this.devices.remove(deviceId);
            Map ports = (Map)this.devicePorts.get(deviceId);
            if (ports != null) {
                ports.clear();
            }
            this.markOfflineInternal(deviceId, timestamp);
            descs.clear();
            return device == null ? null : new DeviceEvent(DeviceEvent.Type.DEVICE_REMOVED, device, null);
        }
    }

    private boolean isDeviceRemoved(DeviceId deviceId, Timestamp timestampToCheck) {
        Timestamp removalTimestamp = this.removalRequest.get(deviceId);
        return removalTimestamp != null && removalTimestamp.compareTo((Object)timestampToCheck) >= 0;
    }

    private Device composeDevice(DeviceId deviceId, Map<ProviderId, DeviceDescriptions> providerDescs) {
        Preconditions.checkArgument((!providerDescs.isEmpty() ? 1 : 0) != 0, (Object)"No device descriptions supplied");
        ProviderId primary = this.pickPrimaryPID(providerDescs);
        DeviceDescriptions desc = providerDescs.get(primary);
        DeviceDescription base = desc.getDeviceDesc().value();
        Device.Type type = base.type();
        String manufacturer = base.manufacturer();
        String hwVersion = base.hwVersion();
        String swVersion = base.swVersion();
        String serialNumber = base.serialNumber();
        ChassisId chassisId = base.chassisId();
        DefaultAnnotations annotations = DefaultAnnotations.builder().build();
        annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)base.annotations());
        for (Map.Entry<ProviderId, DeviceDescriptions> e : providerDescs.entrySet()) {
            if (e.getKey().equals((Object)primary)) continue;
            annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)e.getValue().getDeviceDesc().value().annotations());
        }
        return new DefaultDevice(primary, deviceId, type, manufacturer, hwVersion, swVersion, serialNumber, chassisId, new Annotations[]{annotations});
    }

    private Port composePort(Device device, PortNumber number, Map<ProviderId, DeviceDescriptions> descsMap) {
        ProviderId primary = this.pickPrimaryPID(descsMap);
        DeviceDescriptions primDescs = descsMap.get(primary);
        boolean isEnabled = false;
        DefaultAnnotations annotations = DefaultAnnotations.builder().build();
        Timestamped<PortDescription> portDesc = primDescs.getPortDesc(number);
        if (portDesc != null) {
            isEnabled = portDesc.value().isEnabled();
            annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)portDesc.value().annotations());
        }
        for (Map.Entry<ProviderId, DeviceDescriptions> e : descsMap.entrySet()) {
            Timestamped<PortDescription> otherPortDesc;
            if (e.getKey().equals((Object)primary) || (otherPortDesc = e.getValue().getPortDesc(number)) == null) continue;
            annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)otherPortDesc.value().annotations());
        }
        return portDesc == null ? new DefaultPort((Element)device, number, false, new Annotations[]{annotations}) : new DefaultPort((Element)device, number, isEnabled, portDesc.value().type(), portDesc.value().portSpeed(), new Annotations[]{annotations});
    }

    private ProviderId pickPrimaryPID(Map<ProviderId, DeviceDescriptions> providerDescs) {
        ProviderId fallBackPrimary = null;
        for (Map.Entry<ProviderId, DeviceDescriptions> e : providerDescs.entrySet()) {
            if (!e.getKey().isAncillary()) {
                return e.getKey();
            }
            if (fallBackPrimary != null) continue;
            fallBackPrimary = e.getKey();
        }
        return fallBackPrimary;
    }

    private DeviceDescriptions getPrimaryDescriptions(Map<ProviderId, DeviceDescriptions> providerDescs) {
        ProviderId pid = this.pickPrimaryPID(providerDescs);
        return providerDescs.get(pid);
    }

    private void unicastMessage(NodeId recipient, MessageSubject subject, Object event) throws IOException {
        ClusterMessage message = new ClusterMessage(this.clusterService.getLocalNode().id(), subject, SERIALIZER.encode(event));
        this.clusterCommunicator.unicast(message, recipient);
    }

    private void broadcastMessage(MessageSubject subject, Object event) {
        ClusterMessage message = new ClusterMessage(this.clusterService.getLocalNode().id(), subject, SERIALIZER.encode(event));
        this.clusterCommunicator.broadcast(message);
    }

    private void notifyPeers(InternalDeviceEvent event) {
        this.broadcastMessage(GossipDeviceStoreMessageSubjects.DEVICE_UPDATE, event);
    }

    private void notifyPeers(InternalDeviceOfflineEvent event) {
        this.broadcastMessage(GossipDeviceStoreMessageSubjects.DEVICE_OFFLINE, event);
    }

    private void notifyPeers(InternalDeviceRemovedEvent event) {
        this.broadcastMessage(GossipDeviceStoreMessageSubjects.DEVICE_REMOVED, event);
    }

    private void notifyPeers(InternalPortEvent event) {
        this.broadcastMessage(GossipDeviceStoreMessageSubjects.PORT_UPDATE, event);
    }

    private void notifyPeers(InternalPortStatusEvent event) {
        this.broadcastMessage(GossipDeviceStoreMessageSubjects.PORT_STATUS_UPDATE, event);
    }

    private void notifyPeer(NodeId recipient, InternalDeviceEvent event) {
        try {
            this.unicastMessage(recipient, GossipDeviceStoreMessageSubjects.DEVICE_UPDATE, event);
        }
        catch (IOException e) {
            this.log.error("Failed to send" + event + " to " + recipient, (Throwable)e);
        }
    }

    private void notifyPeer(NodeId recipient, InternalDeviceOfflineEvent event) {
        try {
            this.unicastMessage(recipient, GossipDeviceStoreMessageSubjects.DEVICE_OFFLINE, event);
        }
        catch (IOException e) {
            this.log.error("Failed to send" + event + " to " + recipient, (Throwable)e);
        }
    }

    private void notifyPeer(NodeId recipient, InternalDeviceRemovedEvent event) {
        try {
            this.unicastMessage(recipient, GossipDeviceStoreMessageSubjects.DEVICE_REMOVED, event);
        }
        catch (IOException e) {
            this.log.error("Failed to send" + event + " to " + recipient, (Throwable)e);
        }
    }

    private void notifyPeer(NodeId recipient, InternalPortEvent event) {
        try {
            this.unicastMessage(recipient, GossipDeviceStoreMessageSubjects.PORT_UPDATE, event);
        }
        catch (IOException e) {
            this.log.error("Failed to send" + event + " to " + recipient, (Throwable)e);
        }
    }

    private void notifyPeer(NodeId recipient, InternalPortStatusEvent event) {
        try {
            this.unicastMessage(recipient, GossipDeviceStoreMessageSubjects.PORT_STATUS_UPDATE, event);
        }
        catch (IOException e) {
            this.log.error("Failed to send" + event + " to " + recipient, (Throwable)e);
        }
    }

    private DeviceAntiEntropyAdvertisement createAdvertisement() {
        NodeId self = this.clusterService.getLocalNode().id();
        int numDevices = this.deviceDescs.size();
        HashMap<DeviceFragmentId, Timestamp> adDevices = new HashMap<DeviceFragmentId, Timestamp>(numDevices);
        int portsPerDevice = 8;
        HashMap<PortFragmentId, Timestamp> adPorts = new HashMap<PortFragmentId, Timestamp>(numDevices * 8);
        HashMap<DeviceId, Timestamp> adOffline = new HashMap<DeviceId, Timestamp>(numDevices);
        this.deviceDescs.forEach((deviceId, devDescs) -> {
            Map map4 = devDescs;
            synchronized (map4) {
                Timestamp lOffline = this.offline.get(deviceId);
                if (lOffline != null) {
                    adOffline.put((DeviceId)deviceId, lOffline);
                }
                for (Map.Entry prov : devDescs.entrySet()) {
                    ProviderId provId = (ProviderId)prov.getKey();
                    DeviceDescriptions descs = (DeviceDescriptions)prov.getValue();
                    adDevices.put(new DeviceFragmentId((DeviceId)deviceId, provId), descs.getDeviceDesc().timestamp());
                    for (Map.Entry<PortNumber, Timestamped<PortDescription>> portDesc : descs.getPortDescs().entrySet()) {
                        PortNumber number = portDesc.getKey();
                        adPorts.put(new PortFragmentId((DeviceId)deviceId, provId, number), portDesc.getValue().timestamp());
                    }
                }
            }
        });
        return new DeviceAntiEntropyAdvertisement(self, adDevices, adPorts, adOffline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAdvertisement(DeviceAntiEntropyAdvertisement advertisement) {
        NodeId sender = advertisement.sender();
        HashMap<DeviceFragmentId, Timestamp> devAds = new HashMap<DeviceFragmentId, Timestamp>(advertisement.deviceFingerPrints());
        HashMap<PortFragmentId, Timestamp> portAds = new HashMap<PortFragmentId, Timestamp>(advertisement.ports());
        HashMap<DeviceId, Timestamp> offlineAds = new HashMap<DeviceId, Timestamp>(advertisement.offline());
        ArrayList<DeviceFragmentId> reqDevices = new ArrayList<DeviceFragmentId>();
        ArrayList<PortFragmentId> reqPorts = new ArrayList<PortFragmentId>();
        for (Map.Entry de : this.deviceDescs.entrySet()) {
            Map lDevice;
            DeviceId deviceId = (DeviceId)de.getKey();
            Map map = lDevice = (Map)de.getValue();
            synchronized (map) {
                Timestamp lOffline;
                Timestamp localLatest = this.offline.get(deviceId);
                for (Map.Entry prov : lDevice.entrySet()) {
                    ProviderId provId = (ProviderId)prov.getKey();
                    DeviceDescriptions lDeviceDescs = (DeviceDescriptions)prov.getValue();
                    DeviceFragmentId devFragId = new DeviceFragmentId(deviceId, provId);
                    Timestamped<DeviceDescription> lProvDevice = lDeviceDescs.getDeviceDesc();
                    Timestamp advDevTimestamp = (Timestamp)devAds.get(devFragId);
                    if (advDevTimestamp == null || lProvDevice.isNewerThan(advDevTimestamp)) {
                        this.notifyPeer(sender, new InternalDeviceEvent(provId, deviceId, lProvDevice));
                    } else if (!lProvDevice.timestamp().equals((Object)advDevTimestamp)) {
                        reqDevices.add(devFragId);
                    }
                    for (Map.Entry<PortNumber, Timestamped<PortDescription>> pe : lDeviceDescs.getPortDescs().entrySet()) {
                        PortNumber num = pe.getKey();
                        Timestamped<PortDescription> lPort = pe.getValue();
                        PortFragmentId portFragId = new PortFragmentId(deviceId, provId, num);
                        Timestamp advPortTimestamp = (Timestamp)portAds.get(portFragId);
                        if (advPortTimestamp == null || lPort.isNewerThan(advPortTimestamp)) {
                            this.notifyPeer(sender, new InternalPortStatusEvent(provId, deviceId, lPort));
                        } else if (!lPort.timestamp().equals((Object)advPortTimestamp)) {
                            this.log.trace("need update {} < {}", (Object)lPort.timestamp(), (Object)advPortTimestamp);
                            reqPorts.add(portFragId);
                        }
                        portAds.remove(portFragId);
                    }
                    devAds.remove(devFragId);
                    Timestamp providerLatest = lDeviceDescs.getLatestTimestamp();
                    if (localLatest != null && providerLatest.compareTo((Object)localLatest) <= 0) continue;
                    localLatest = providerLatest;
                }
                Timestamp rOffline = (Timestamp)offlineAds.get(deviceId);
                if (rOffline != null && rOffline.compareTo((Object)localLatest) > 0) {
                    this.markOfflineInternal(deviceId, rOffline);
                }
                if ((lOffline = this.offline.get(deviceId)) != null && rOffline == null) {
                    this.notifyPeer(sender, new InternalDeviceOfflineEvent(deviceId, lOffline));
                }
                offlineAds.remove(deviceId);
            }
        }
        this.log.trace("Ads left {}, {}", devAds, portAds);
        reqDevices.addAll(devAds.keySet());
        reqPorts.addAll(portAds.keySet());
        if (reqDevices.isEmpty() && reqPorts.isEmpty()) {
            this.log.trace("Nothing to request to remote peer {}", (Object)sender);
            return;
        }
        this.log.debug("Need to sync {} {}", reqDevices, reqPorts);
        try {
            this.unicastMessage(sender, GossipDeviceStoreMessageSubjects.DEVICE_ADVERTISE, this.createAdvertisement());
        }
        catch (IOException e) {
            this.log.error("Failed to send response advertisement to " + sender, (Throwable)e);
        }
    }

    private void notifyDelegateIfNotNull(DeviceEvent event) {
        if (event != null) {
            this.notifyDelegate((Event)event);
        }
    }

    protected void bindDeviceClockService(DeviceClockService deviceClockService) {
        this.deviceClockService = deviceClockService;
    }

    protected void unbindDeviceClockService(DeviceClockService deviceClockService) {
        if (this.deviceClockService == deviceClockService) {
            this.deviceClockService = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindTermService(MastershipTermService mastershipTermService) {
        this.termService = mastershipTermService;
    }

    protected void unbindTermService(MastershipTermService mastershipTermService) {
        if (this.termService == mastershipTermService) {
            this.termService = null;
        }
    }

    private final class PortInjectedEventListener
    implements ClusterMessageHandler {
        private PortInjectedEventListener() {
        }

        public void handle(ClusterMessage message) {
            GossipDeviceStore.this.log.debug("Received injected port event from peer: {}", (Object)message.sender());
            PortInjectedEvent event = (PortInjectedEvent)SERIALIZER.decode(message.payload());
            ProviderId providerId = event.providerId();
            DeviceId deviceId = event.deviceId();
            List<PortDescription> portDescriptions = event.portDescriptions();
            if (!GossipDeviceStore.this.deviceClockService.isTimestampAvailable(deviceId)) {
                GossipDeviceStore.this.log.warn("Not ready to accept update. Dropping {}", portDescriptions);
                return;
            }
            try {
                GossipDeviceStore.this.updatePorts(providerId, deviceId, portDescriptions);
            }
            catch (Exception e) {
                GossipDeviceStore.this.log.warn("Exception thrown handling port injected event.", (Throwable)e);
            }
        }
    }

    private final class DeviceInjectedEventListener
    implements ClusterMessageHandler {
        private DeviceInjectedEventListener() {
        }

        public void handle(ClusterMessage message) {
            GossipDeviceStore.this.log.debug("Received injected device event from peer: {}", (Object)message.sender());
            DeviceInjectedEvent event = (DeviceInjectedEvent)SERIALIZER.decode(message.payload());
            ProviderId providerId = event.providerId();
            DeviceId deviceId = event.deviceId();
            DeviceDescription deviceDescription = event.deviceDescription();
            if (!GossipDeviceStore.this.deviceClockService.isTimestampAvailable(deviceId)) {
                GossipDeviceStore.this.log.warn("Not ready to accept update. Dropping {}", (Object)deviceDescription);
                return;
            }
            try {
                GossipDeviceStore.this.createOrUpdateDevice(providerId, deviceId, deviceDescription);
            }
            catch (Exception e) {
                GossipDeviceStore.this.log.warn("Exception thrown handling device injected event.", (Throwable)e);
            }
        }
    }

    private final class InternalDeviceAdvertisementListener
    implements ClusterMessageHandler {
        private InternalDeviceAdvertisementListener() {
        }

        public void handle(ClusterMessage message) {
            GossipDeviceStore.this.log.trace("Received Device Anti-Entropy advertisement from peer: {}", (Object)message.sender());
            DeviceAntiEntropyAdvertisement advertisement = (DeviceAntiEntropyAdvertisement)SERIALIZER.decode(message.payload());
            try {
                GossipDeviceStore.this.handleAdvertisement(advertisement);
            }
            catch (Exception e) {
                GossipDeviceStore.this.log.warn("Exception thrown handling Device advertisements.", (Throwable)e);
            }
        }
    }

    private final class InternalPortStatusEventListener
    implements ClusterMessageHandler {
        private InternalPortStatusEventListener() {
        }

        public void handle(ClusterMessage message) {
            GossipDeviceStore.this.log.debug("Received port status update event from peer: {}", (Object)message.sender());
            InternalPortStatusEvent event = (InternalPortStatusEvent)SERIALIZER.decode(message.payload());
            ProviderId providerId = event.providerId();
            DeviceId deviceId = event.deviceId();
            Timestamped<PortDescription> portDescription = event.portDescription();
            if (GossipDeviceStore.this.getDevice(deviceId) == null) {
                GossipDeviceStore.this.log.debug("{} not found on this node yet, ignoring.", (Object)deviceId);
                return;
            }
            try {
                GossipDeviceStore.this.notifyDelegateIfNotNull(GossipDeviceStore.this.updatePortStatusInternal(providerId, deviceId, portDescription));
            }
            catch (Exception e) {
                GossipDeviceStore.this.log.warn("Exception thrown handling port update", (Throwable)e);
            }
        }
    }

    private final class InternalPortEventListener
    implements ClusterMessageHandler {
        private InternalPortEventListener() {
        }

        public void handle(ClusterMessage message) {
            GossipDeviceStore.this.log.debug("Received port update event from peer: {}", (Object)message.sender());
            InternalPortEvent event = (InternalPortEvent)SERIALIZER.decode(message.payload());
            ProviderId providerId = event.providerId();
            DeviceId deviceId = event.deviceId();
            Timestamped<List<PortDescription>> portDescriptions = event.portDescriptions();
            if (GossipDeviceStore.this.getDevice(deviceId) == null) {
                GossipDeviceStore.this.log.debug("{} not found on this node yet, ignoring.", (Object)deviceId);
                return;
            }
            try {
                GossipDeviceStore.this.notifyDelegate(GossipDeviceStore.this.updatePortsInternal(providerId, deviceId, portDescriptions));
            }
            catch (Exception e) {
                GossipDeviceStore.this.log.warn("Exception thrown handling port update", (Throwable)e);
            }
        }
    }

    private final class InternalDeviceRemovedEventListener
    implements ClusterMessageHandler {
        private InternalDeviceRemovedEventListener() {
        }

        public void handle(ClusterMessage message) {
            GossipDeviceStore.this.log.debug("Received device removed event from peer: {}", (Object)message.sender());
            InternalDeviceRemovedEvent event = (InternalDeviceRemovedEvent)SERIALIZER.decode(message.payload());
            DeviceId deviceId = event.deviceId();
            Timestamp timestamp = event.timestamp();
            try {
                GossipDeviceStore.this.notifyDelegateIfNotNull(GossipDeviceStore.this.removeDeviceInternal(deviceId, timestamp));
            }
            catch (Exception e) {
                GossipDeviceStore.this.log.warn("Exception thrown handling device removed", (Throwable)e);
            }
        }
    }

    private final class InternalRemoveRequestListener
    implements ClusterMessageHandler {
        private InternalRemoveRequestListener() {
        }

        public void handle(ClusterMessage message) {
            GossipDeviceStore.this.log.debug("Received device remove request from peer: {}", (Object)message.sender());
            DeviceId did = (DeviceId)SERIALIZER.decode(message.payload());
            try {
                GossipDeviceStore.this.removeDevice(did);
            }
            catch (Exception e) {
                GossipDeviceStore.this.log.warn("Exception thrown handling device remove", (Throwable)e);
            }
        }
    }

    private final class InternalDeviceOfflineEventListener
    implements ClusterMessageHandler {
        private InternalDeviceOfflineEventListener() {
        }

        public void handle(ClusterMessage message) {
            GossipDeviceStore.this.log.debug("Received device offline event from peer: {}", (Object)message.sender());
            InternalDeviceOfflineEvent event = (InternalDeviceOfflineEvent)SERIALIZER.decode(message.payload());
            DeviceId deviceId = event.deviceId();
            Timestamp timestamp = event.timestamp();
            try {
                GossipDeviceStore.this.notifyDelegateIfNotNull(GossipDeviceStore.this.markOfflineInternal(deviceId, timestamp));
            }
            catch (Exception e) {
                GossipDeviceStore.this.log.warn("Exception thrown handling device offline", (Throwable)e);
            }
        }
    }

    private final class InternalDeviceEventListener
    implements ClusterMessageHandler {
        private InternalDeviceEventListener() {
        }

        public void handle(ClusterMessage message) {
            GossipDeviceStore.this.log.debug("Received device update event from peer: {}", (Object)message.sender());
            InternalDeviceEvent event = (InternalDeviceEvent)SERIALIZER.decode(message.payload());
            ProviderId providerId = event.providerId();
            DeviceId deviceId = event.deviceId();
            Timestamped<DeviceDescription> deviceDescription = event.deviceDescription();
            try {
                GossipDeviceStore.this.notifyDelegateIfNotNull(GossipDeviceStore.this.createOrUpdateDeviceInternal(providerId, deviceId, deviceDescription));
            }
            catch (Exception e) {
                GossipDeviceStore.this.log.warn("Exception thrown handling device update", (Throwable)e);
            }
        }
    }

    private final class SendAdvertisementTask
    implements Runnable {
        private SendAdvertisementTask() {
        }

        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                GossipDeviceStore.this.log.debug("Interrupted, quitting");
                return;
            }
            try {
                int idx;
                NodeId peer;
                NodeId self = GossipDeviceStore.this.clusterService.getLocalNode().id();
                Set nodes = GossipDeviceStore.this.clusterService.getNodes();
                ImmutableList nodeIds = FluentIterable.from((Iterable)nodes).transform((Function)ControllerNodeToNodeId.toNodeId()).toList();
                if (nodeIds.size() == 1 && ((NodeId)nodeIds.get(0)).equals((Object)self)) {
                    GossipDeviceStore.this.log.trace("No other peers in the cluster.");
                    return;
                }
                while ((peer = (NodeId)nodeIds.get(idx = RandomUtils.nextInt((int)0, (int)nodeIds.size()))).equals((Object)self)) {
                }
                DeviceAntiEntropyAdvertisement ad = GossipDeviceStore.this.createAdvertisement();
                if (Thread.currentThread().isInterrupted()) {
                    GossipDeviceStore.this.log.debug("Interrupted, quitting");
                    return;
                }
                try {
                    GossipDeviceStore.this.unicastMessage(peer, GossipDeviceStoreMessageSubjects.DEVICE_ADVERTISE, ad);
                }
                catch (IOException e) {
                    GossipDeviceStore.this.log.debug("Failed to send anti-entropy advertisement to {}", (Object)peer);
                    return;
                }
            }
            catch (Exception e) {
                GossipDeviceStore.this.log.error("Exception thrown while sending advertisement", (Throwable)e);
            }
        }
    }
}

