/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.flow.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.hazelcast.core.IMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.BoundedThreadPool;
import org.onlab.util.KryoNamespace;
import org.onlab.util.NewConcurrentHashMap;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.Event;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.CompletedBatchOperation;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleBatchEntry;
import org.onosproject.net.flow.FlowRuleBatchEvent;
import org.onosproject.net.flow.FlowRuleBatchOperation;
import org.onosproject.net.flow.FlowRuleBatchRequest;
import org.onosproject.net.flow.FlowRuleEvent;
import org.onosproject.net.flow.FlowRuleStore;
import org.onosproject.net.flow.FlowRuleStoreDelegate;
import org.onosproject.net.flow.StoredFlowEntry;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.flow.ReplicaInfo;
import org.onosproject.store.flow.ReplicaInfoEvent;
import org.onosproject.store.flow.ReplicaInfoEventListener;
import org.onosproject.store.flow.ReplicaInfoService;
import org.onosproject.store.flow.impl.FlowStoreMessageSubjects;
import org.onosproject.store.hz.AbstractHazelcastStore;
import org.onosproject.store.hz.SMap;
import org.onosproject.store.serializers.KryoSerializer;
import org.onosproject.store.serializers.StoreSerializer;
import org.onosproject.store.serializers.impl.DistributedStoreSerializers;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedFlowRuleStore
extends AbstractHazelcastStore<FlowRuleBatchEvent, FlowRuleStoreDelegate>
implements FlowRuleStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int MESSAGE_HANDLER_THREAD_POOL_SIZE = 8;
    private static final boolean DEFAULT_BACKUP_ENABLED = true;
    private static final long FLOW_RULE_STORE_TIMEOUT_MILLIS = 5000L;
    @Property(name="msgHandlerPoolSize", intValue={8}, label="Number of threads in the message handler pool")
    private int msgHandlerPoolSize = 8;
    @Property(name="backupEnabled", boolValue={true}, label="Indicates whether backups are enabled or not")
    private boolean backupEnabled = true;
    private InternalFlowTable flowTable = new InternalFlowTable();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ReplicaInfoService replicaInfoManager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService configService;
    private Map<Long, NodeId> pendingResponses = Maps.newConcurrentMap();
    private LoadingCache<DeviceId, SMap<FlowId, ImmutableList<StoredFlowEntry>>> smaps;
    private ExecutorService messageHandlingExecutor;
    private final ExecutorService backupExecutors = BoundedThreadPool.newSingleThreadExecutor((ThreadFactory)Tools.groupedThreads((String)"onos/flow", (String)"async-backups"));
    private boolean syncBackup = false;
    protected static final StoreSerializer SERIALIZER = new KryoSerializer(){

        protected void setupKryoPool() {
            this.serializerPool = KryoNamespace.newBuilder().register(DistributedStoreSerializers.STORE_COMMON).nextId(310).register(new Class[]{FlowRuleEvent.class}).register(new Class[]{FlowRuleEvent.Type.class}).build();
        }
    };
    private ReplicaInfoEventListener replicaInfoEventListener;
    private IdGenerator idGenerator;

    @Activate
    public void activate(ComponentContext context) {
        this.configService.registerProperties(((Object)((Object)this)).getClass());
        this.serializer = SERIALIZER;
        this.theInstance = this.storeService.getHazelcastInstance();
        this.idGenerator = this.coreService.getIdGenerator("flow-ops-ids");
        this.smaps = CacheBuilder.newBuilder().softValues().build((CacheLoader)new SMapLoader());
        NodeId local = this.clusterService.getLocalNode().id();
        this.messageHandlingExecutor = Executors.newFixedThreadPool(this.msgHandlerPoolSize, Tools.groupedThreads((String)"onos/store/flow", (String)"message-handlers"));
        this.clusterCommunicator.addSubscriber(FlowStoreMessageSubjects.APPLY_BATCH_FLOWS, (ClusterMessageHandler)new OnStoreBatch(local), this.messageHandlingExecutor);
        this.clusterCommunicator.addSubscriber(FlowStoreMessageSubjects.REMOTE_APPLY_COMPLETED, new ClusterMessageHandler(){

            public void handle(ClusterMessage message) {
                FlowRuleBatchEvent event = (FlowRuleBatchEvent)SERIALIZER.decode(message.payload());
                DistributedFlowRuleStore.this.log.trace("received completed notification for {}", (Object)event);
                DistributedFlowRuleStore.this.notifyDelegate((Event)event);
            }
        }, this.messageHandlingExecutor);
        this.clusterCommunicator.addSubscriber(FlowStoreMessageSubjects.GET_FLOW_ENTRY, new ClusterMessageHandler(){

            public void handle(ClusterMessage message) {
                FlowRule rule = (FlowRule)SERIALIZER.decode(message.payload());
                DistributedFlowRuleStore.this.log.trace("received get flow entry request for {}", (Object)rule);
                StoredFlowEntry flowEntry = DistributedFlowRuleStore.this.flowTable.getFlowEntry(rule);
                try {
                    message.respond(SERIALIZER.encode((Object)flowEntry));
                }
                catch (IOException e) {
                    DistributedFlowRuleStore.this.log.error("Failed to respond back", (Throwable)e);
                }
            }
        }, this.messageHandlingExecutor);
        this.clusterCommunicator.addSubscriber(FlowStoreMessageSubjects.GET_DEVICE_FLOW_ENTRIES, new ClusterMessageHandler(){

            public void handle(ClusterMessage message) {
                DeviceId deviceId = (DeviceId)SERIALIZER.decode(message.payload());
                DistributedFlowRuleStore.this.log.trace("Received get flow entries request for {} from {}", (Object)deviceId, (Object)message.sender());
                Set<FlowEntry> flowEntries = DistributedFlowRuleStore.this.flowTable.getFlowEntries(deviceId);
                try {
                    message.respond(SERIALIZER.encode(flowEntries));
                }
                catch (IOException e) {
                    DistributedFlowRuleStore.this.log.error("Failed to respond to peer's getFlowEntries request", (Throwable)e);
                }
            }
        }, this.messageHandlingExecutor);
        this.clusterCommunicator.addSubscriber(FlowStoreMessageSubjects.REMOVE_FLOW_ENTRY, new ClusterMessageHandler(){

            public void handle(ClusterMessage message) {
                FlowEntry rule = (FlowEntry)SERIALIZER.decode(message.payload());
                DistributedFlowRuleStore.this.log.trace("received get flow entry request for {}", (Object)rule);
                FlowRuleEvent event = DistributedFlowRuleStore.this.removeFlowRuleInternal(rule);
                try {
                    message.respond(SERIALIZER.encode((Object)event));
                }
                catch (IOException e) {
                    DistributedFlowRuleStore.this.log.error("Failed to respond back", (Throwable)e);
                }
            }
        }, this.messageHandlingExecutor);
        this.replicaInfoEventListener = new InternalReplicaInfoEventListener();
        this.replicaInfoManager.addListener(this.replicaInfoEventListener);
        this.logConfig("Started");
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        this.configService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.clusterCommunicator.removeSubscriber(FlowStoreMessageSubjects.REMOVE_FLOW_ENTRY);
        this.clusterCommunicator.removeSubscriber(FlowStoreMessageSubjects.GET_DEVICE_FLOW_ENTRIES);
        this.clusterCommunicator.removeSubscriber(FlowStoreMessageSubjects.GET_FLOW_ENTRY);
        this.clusterCommunicator.removeSubscriber(FlowStoreMessageSubjects.APPLY_BATCH_FLOWS);
        this.clusterCommunicator.removeSubscriber(FlowStoreMessageSubjects.REMOTE_APPLY_COMPLETED);
        this.messageHandlingExecutor.shutdown();
        this.replicaInfoManager.removeListener(this.replicaInfoEventListener);
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        boolean newBackupEnabled;
        int newPoolSize;
        if (context == null) {
            this.backupEnabled = true;
            this.logConfig("Default config");
            return;
        }
        Dictionary properties = context.getProperties();
        try {
            String s = Tools.get((Dictionary)properties, (String)"msgHandlerPoolSize");
            newPoolSize = Strings.isNullOrEmpty((String)s) ? this.msgHandlerPoolSize : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)"backupEnabled");
            newBackupEnabled = Strings.isNullOrEmpty((String)s) ? this.backupEnabled : Boolean.parseBoolean(s.trim());
        }
        catch (ClassCastException | NumberFormatException e) {
            newPoolSize = 8;
            newBackupEnabled = true;
        }
        if (newPoolSize != this.msgHandlerPoolSize || newBackupEnabled != this.backupEnabled) {
            this.msgHandlerPoolSize = newPoolSize;
            this.backupEnabled = newBackupEnabled;
            ExecutorService oldMsgHandler = this.messageHandlingExecutor;
            this.messageHandlingExecutor = Executors.newFixedThreadPool(this.msgHandlerPoolSize, Tools.groupedThreads((String)"onos/store/flow", (String)"message-handlers"));
            oldMsgHandler.shutdown();
            this.logConfig("Reconfigured");
        }
    }

    private void logConfig(String prefix) {
        this.log.info("{} with msgHandlerPoolSize = {}; backupEnabled = {}", new Object[]{prefix, this.msgHandlerPoolSize, this.backupEnabled});
    }

    public int getFlowRuleCount() {
        int sum = 0;
        for (Device device : this.deviceService.getDevices()) {
            DeviceId did = device.id();
            sum += Iterables.size(this.getFlowEntries(did));
        }
        return sum;
    }

    public FlowEntry getFlowEntry(FlowRule rule) {
        ReplicaInfo replicaInfo = this.replicaInfoManager.getReplicaInfoFor(rule.deviceId());
        if (!replicaInfo.master().isPresent()) {
            this.log.warn("Failed to getFlowEntry: No master for {}", (Object)rule.deviceId());
            return null;
        }
        if (((NodeId)replicaInfo.master().get()).equals((Object)this.clusterService.getLocalNode().id())) {
            return this.flowTable.getFlowEntry(rule);
        }
        this.log.trace("Forwarding getFlowEntry to {}, which is the primary (master) for device {}", replicaInfo.master().orNull(), (Object)rule.deviceId());
        ClusterMessage message = new ClusterMessage(this.clusterService.getLocalNode().id(), FlowStoreMessageSubjects.GET_FLOW_ENTRY, SERIALIZER.encode((Object)rule));
        try {
            ListenableFuture responseFuture = this.clusterCommunicator.sendAndReceive(message, (NodeId)replicaInfo.master().get());
            return (FlowEntry)SERIALIZER.decode((byte[])responseFuture.get(5000L, TimeUnit.MILLISECONDS));
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            this.log.warn("Unable to fetch flow store contents from {}", replicaInfo.master().get());
            return null;
        }
    }

    public Iterable<FlowEntry> getFlowEntries(DeviceId deviceId) {
        ReplicaInfo replicaInfo = this.replicaInfoManager.getReplicaInfoFor(deviceId);
        if (!replicaInfo.master().isPresent()) {
            this.log.warn("Failed to getFlowEntries: No master for {}", (Object)deviceId);
            return Collections.emptyList();
        }
        if (((NodeId)replicaInfo.master().get()).equals((Object)this.clusterService.getLocalNode().id())) {
            return this.flowTable.getFlowEntries(deviceId);
        }
        this.log.trace("Forwarding getFlowEntries to {}, which is the primary (master) for device {}", replicaInfo.master().orNull(), (Object)deviceId);
        ClusterMessage message = new ClusterMessage(this.clusterService.getLocalNode().id(), FlowStoreMessageSubjects.GET_DEVICE_FLOW_ENTRIES, SERIALIZER.encode((Object)deviceId));
        try {
            ListenableFuture responseFuture = this.clusterCommunicator.sendAndReceive(message, (NodeId)replicaInfo.master().get());
            return (Iterable)SERIALIZER.decode((byte[])responseFuture.get(5000L, TimeUnit.MILLISECONDS));
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            this.log.warn("Unable to fetch flow store contents from {}", replicaInfo.master().get());
            return Collections.emptyList();
        }
    }

    public void storeFlowRule(FlowRule rule) {
        this.storeBatch(new FlowRuleBatchOperation(Arrays.asList(new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.ADD, rule)), rule.deviceId(), this.idGenerator.getNewId()));
    }

    public void storeBatch(FlowRuleBatchOperation operation) {
        if (operation.getOperations().isEmpty()) {
            this.notifyDelegate((Event)FlowRuleBatchEvent.completed((FlowRuleBatchRequest)new FlowRuleBatchRequest(operation.id(), Collections.emptySet()), (CompletedBatchOperation)new CompletedBatchOperation(true, Collections.emptySet(), operation.deviceId())));
            return;
        }
        DeviceId deviceId = operation.deviceId();
        ReplicaInfo replicaInfo = this.replicaInfoManager.getReplicaInfoFor(deviceId);
        if (!replicaInfo.master().isPresent()) {
            this.log.warn("No master for {} : flows will be marked for removal", (Object)deviceId);
            this.updateStoreInternal(operation);
            this.notifyDelegate((Event)FlowRuleBatchEvent.completed((FlowRuleBatchRequest)new FlowRuleBatchRequest(operation.id(), Collections.emptySet()), (CompletedBatchOperation)new CompletedBatchOperation(true, Collections.emptySet(), operation.deviceId())));
            return;
        }
        NodeId local = this.clusterService.getLocalNode().id();
        if (((NodeId)replicaInfo.master().get()).equals((Object)local)) {
            this.storeBatchInternal(operation);
            return;
        }
        this.log.trace("Forwarding storeBatch to {}, which is the primary (master) for device {}", replicaInfo.master().orNull(), (Object)deviceId);
        ClusterMessage message = new ClusterMessage(local, FlowStoreMessageSubjects.APPLY_BATCH_FLOWS, SERIALIZER.encode((Object)operation));
        if (!this.clusterCommunicator.unicast(message, (NodeId)replicaInfo.master().get())) {
            this.log.warn("Failed to storeBatch: {} to {}", (Object)message, replicaInfo.master());
            Set allFailures = operation.getOperations().stream().map(op -> (FlowRule)op.target()).collect(Collectors.toSet());
            this.notifyDelegate((Event)FlowRuleBatchEvent.completed((FlowRuleBatchRequest)new FlowRuleBatchRequest(operation.id(), Collections.emptySet()), (CompletedBatchOperation)new CompletedBatchOperation(false, allFailures, deviceId)));
            return;
        }
    }

    private void storeBatchInternal(FlowRuleBatchOperation operation) {
        DeviceId did = operation.deviceId();
        Set<FlowRuleBatchEntry> currentOps = this.updateStoreInternal(operation);
        if (currentOps.isEmpty()) {
            this.batchOperationComplete(FlowRuleBatchEvent.completed((FlowRuleBatchRequest)new FlowRuleBatchRequest(operation.id(), Collections.emptySet()), (CompletedBatchOperation)new CompletedBatchOperation(true, Collections.emptySet(), did)));
            return;
        }
        this.updateBackup(did, currentOps);
        this.notifyDelegate((Event)FlowRuleBatchEvent.requested((FlowRuleBatchRequest)new FlowRuleBatchRequest(operation.id(), currentOps), (DeviceId)operation.deviceId()));
    }

    private Set<FlowRuleBatchEntry> updateStoreInternal(FlowRuleBatchOperation operation) {
        return operation.getOperations().stream().map(op -> {
            switch ((FlowRuleBatchEntry.FlowRuleOperation)op.operator()) {
                case ADD: {
                    DefaultFlowEntry entry = new DefaultFlowEntry((FlowRule)op.target());
                    this.flowTable.remove(entry.deviceId(), (FlowEntry)entry);
                    this.flowTable.add((FlowEntry)entry);
                    return op;
                }
                case REMOVE: {
                    StoredFlowEntry entry = this.flowTable.getFlowEntry((FlowRule)op.target());
                    if (entry == null) break;
                    entry.setState(FlowEntry.FlowEntryState.PENDING_REMOVE);
                    return op;
                }
                case MODIFY: {
                    break;
                }
                default: {
                    this.log.warn("Unknown flow operation operator: {}", (Object)op.operator());
                }
            }
            return null;
        }).filter(op -> op != null).collect(Collectors.toSet());
    }

    private void updateBackup(DeviceId deviceId, Set<FlowRuleBatchEntry> entries) {
        if (!this.backupEnabled) {
            return;
        }
        Future<?> backup = this.backupExecutors.submit(new UpdateBackup(deviceId, entries));
        if (this.syncBackup) {
            try {
                backup.get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.log.error("Failed to create backups", (Throwable)e);
            }
        }
    }

    public void deleteFlowRule(FlowRule rule) {
        this.storeBatch(new FlowRuleBatchOperation(Arrays.asList(new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.REMOVE, rule)), rule.deviceId(), this.idGenerator.getNewId()));
    }

    public FlowRuleEvent addOrUpdateFlowRule(FlowEntry rule) {
        ReplicaInfo replicaInfo = this.replicaInfoManager.getReplicaInfoFor(rule.deviceId());
        NodeId localId = this.clusterService.getLocalNode().id();
        if (localId.equals(replicaInfo.master().orNull())) {
            return this.addOrUpdateFlowRuleInternal(rule);
        }
        this.log.warn("Tried to update FlowRule {} state, while the Node was not the master.", (Object)rule);
        return null;
    }

    private FlowRuleEvent addOrUpdateFlowRuleInternal(FlowEntry rule) {
        DeviceId did = rule.deviceId();
        StoredFlowEntry stored = this.flowTable.getFlowEntry((FlowRule)rule);
        if (stored != null) {
            stored.setBytes(rule.bytes());
            stored.setLife(rule.life());
            stored.setPackets(rule.packets());
            if (stored.state() == FlowEntry.FlowEntryState.PENDING_ADD) {
                stored.setState(FlowEntry.FlowEntryState.ADDED);
                FlowRuleBatchEntry entry = new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.ADD, (FlowRule)stored);
                this.updateBackup(did, Sets.newHashSet((Object[])new FlowRuleBatchEntry[]{entry}));
                return new FlowRuleEvent(FlowRuleEvent.Type.RULE_ADDED, (FlowRule)rule);
            }
            return new FlowRuleEvent(FlowRuleEvent.Type.RULE_UPDATED, (FlowRule)rule);
        }
        this.flowTable.add(rule);
        return null;
    }

    public FlowRuleEvent removeFlowRule(FlowEntry rule) {
        DeviceId deviceId = rule.deviceId();
        ReplicaInfo replicaInfo = this.replicaInfoManager.getReplicaInfoFor(deviceId);
        NodeId localId = this.clusterService.getLocalNode().id();
        if (localId.equals(replicaInfo.master().orNull())) {
            return this.removeFlowRuleInternal(rule);
        }
        if (!replicaInfo.master().isPresent()) {
            this.log.warn("Failed to removeFlowRule: No master for {}", (Object)deviceId);
            return null;
        }
        this.log.trace("Forwarding removeFlowRule to {}, which is the primary (master) for device {}", replicaInfo.master().orNull(), (Object)deviceId);
        ClusterMessage message = new ClusterMessage(this.clusterService.getLocalNode().id(), FlowStoreMessageSubjects.REMOVE_FLOW_ENTRY, SERIALIZER.encode((Object)rule));
        try {
            ListenableFuture responseFuture = this.clusterCommunicator.sendAndReceive(message, (NodeId)replicaInfo.master().get());
            return (FlowRuleEvent)SERIALIZER.decode((byte[])responseFuture.get(5000L, TimeUnit.MILLISECONDS));
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private FlowRuleEvent removeFlowRuleInternal(FlowEntry rule) {
        DeviceId deviceId = rule.deviceId();
        boolean removed = this.flowTable.remove(deviceId, rule);
        FlowRuleBatchEntry entry = new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.REMOVE, (FlowRule)rule);
        this.updateBackup(deviceId, Sets.newHashSet((Object[])new FlowRuleBatchEntry[]{entry}));
        if (removed) {
            return new FlowRuleEvent(FlowRuleEvent.Type.RULE_REMOVED, (FlowRule)rule);
        }
        return null;
    }

    public void batchOperationComplete(FlowRuleBatchEvent event) {
        NodeId nodeId = this.pendingResponses.remove(((FlowRuleBatchRequest)event.subject()).batchId());
        if (nodeId == null) {
            this.notifyDelegate((Event)event);
        } else {
            ClusterMessage message = new ClusterMessage(this.clusterService.getLocalNode().id(), FlowStoreMessageSubjects.REMOTE_APPLY_COMPLETED, SERIALIZER.encode((Object)event));
            this.clusterCommunicator.unicast(message, nodeId);
        }
    }

    private void loadFromBackup(DeviceId did) {
        if (!this.backupEnabled) {
            return;
        }
        this.log.info("We are now the master for {}. Will load flow rules from backup", (Object)did);
        try {
            this.log.debug("Loading FlowRules for {} from backups", (Object)did);
            SMap backupFlowTable = (SMap)this.smaps.get((Object)did);
            for (Map.Entry e : backupFlowTable.entrySet()) {
                this.log.trace("loading {}", e.getValue());
                for (StoredFlowEntry entry : (ImmutableList)e.getValue()) {
                    this.flowTable.getFlowEntriesById((FlowEntry)entry).remove(entry);
                    this.flowTable.getFlowEntriesById((FlowEntry)entry).add(entry);
                }
            }
        }
        catch (ExecutionException e) {
            this.log.error("Failed to load backup flowtable for {}", (Object)did, (Object)e);
        }
    }

    private void removeFromPrimary(DeviceId did) {
        this.flowTable.clearDevice(did);
    }

    protected void bindReplicaInfoManager(ReplicaInfoService replicaInfoService) {
        this.replicaInfoManager = replicaInfoService;
    }

    protected void unbindReplicaInfoManager(ReplicaInfoService replicaInfoService) {
        if (this.replicaInfoManager == replicaInfoService) {
            this.replicaInfoManager = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindConfigService(ComponentConfigService componentConfigService) {
        this.configService = componentConfigService;
    }

    protected void unbindConfigService(ComponentConfigService componentConfigService) {
        if (this.configService == componentConfigService) {
            this.configService = null;
        }
    }

    private class InternalFlowTable {
        private final ConcurrentMap<DeviceId, ConcurrentMap<FlowId, Set<StoredFlowEntry>>> flowEntries = new ConcurrentHashMap<DeviceId, ConcurrentMap<FlowId, Set<StoredFlowEntry>>>();

        private InternalFlowTable() {
        }

        private NewConcurrentHashMap<FlowId, Set<StoredFlowEntry>> lazyEmptyFlowTable() {
            return NewConcurrentHashMap.ifNeeded();
        }

        private ConcurrentMap<FlowId, Set<StoredFlowEntry>> getFlowTable(DeviceId deviceId) {
            return (ConcurrentMap)ConcurrentUtils.createIfAbsentUnchecked(this.flowEntries, (Object)deviceId, this.lazyEmptyFlowTable());
        }

        private Set<StoredFlowEntry> getFlowEntriesInternal(DeviceId deviceId, FlowId flowId) {
            Set concurrentlyAdded;
            ConcurrentMap<FlowId, Set<StoredFlowEntry>> flowTable = this.getFlowTable(deviceId);
            CopyOnWriteArraySet r = (CopyOnWriteArraySet)flowTable.get(flowId);
            if (r == null && (concurrentlyAdded = (Set)flowTable.putIfAbsent(flowId, r = new CopyOnWriteArraySet())) != null) {
                return concurrentlyAdded;
            }
            return r;
        }

        private StoredFlowEntry getFlowEntryInternal(FlowRule rule) {
            for (StoredFlowEntry f : this.getFlowEntriesInternal(rule.deviceId(), rule.id())) {
                if (!f.equals(rule)) continue;
                return f;
            }
            return null;
        }

        private Set<FlowEntry> getFlowEntriesInternal(DeviceId deviceId) {
            return this.getFlowTable(deviceId).values().stream().flatMap(list -> list.stream()).collect(Collectors.toSet());
        }

        public StoredFlowEntry getFlowEntry(FlowRule rule) {
            return this.getFlowEntryInternal(rule);
        }

        public Set<FlowEntry> getFlowEntries(DeviceId deviceId) {
            return this.getFlowEntriesInternal(deviceId);
        }

        public Set<StoredFlowEntry> getFlowEntriesById(FlowEntry entry) {
            return this.getFlowEntriesInternal(entry.deviceId(), entry.id());
        }

        public void add(FlowEntry rule) {
            ((CopyOnWriteArraySet)this.getFlowEntriesInternal(rule.deviceId(), rule.id())).add(rule);
        }

        public boolean remove(DeviceId deviceId, FlowEntry rule) {
            return ((CopyOnWriteArraySet)this.getFlowEntriesInternal(deviceId, rule.id())).remove(rule);
        }

        public void clearDevice(DeviceId did) {
            this.flowEntries.remove(did);
        }
    }

    private final class UpdateBackup
    implements Runnable {
        private final DeviceId deviceId;
        private final Set<FlowRuleBatchEntry> ops;

        public UpdateBackup(DeviceId deviceId, Set<FlowRuleBatchEntry> ops) {
            this.deviceId = (DeviceId)Preconditions.checkNotNull((Object)deviceId);
            this.ops = (Set)Preconditions.checkNotNull(ops);
        }

        @Override
        public void run() {
            try {
                DistributedFlowRuleStore.this.log.trace("update backup {} {}", (Object)this.deviceId, this.ops);
                SMap backupFlowTable = (SMap)DistributedFlowRuleStore.this.smaps.get((Object)this.deviceId);
                this.ops.stream().forEach(op -> {
                    FlowRule entry = (FlowRule)op.target();
                    FlowId id = entry.id();
                    ImmutableList original = (ImmutableList)backupFlowTable.get(id);
                    ArrayList<StoredFlowEntry> list = new ArrayList<StoredFlowEntry>();
                    if (original != null) {
                        list.addAll((Collection<StoredFlowEntry>)original);
                    }
                    list.remove(op.target());
                    if (op.operator() == FlowRuleBatchEntry.FlowRuleOperation.ADD) {
                        list.add((StoredFlowEntry)entry);
                    }
                    ImmutableList newValue = ImmutableList.copyOf(list);
                    boolean success = original == null ? backupFlowTable.putIfAbsent(id, newValue) == null : backupFlowTable.replace(id, original, newValue);
                    if (!success) {
                        DistributedFlowRuleStore.this.log.error("Updating backup failed.");
                    }
                });
            }
            catch (ExecutionException e) {
                DistributedFlowRuleStore.this.log.error("Failed to write to backups", (Throwable)e);
            }
        }
    }

    private final class InternalReplicaInfoEventListener
    implements ReplicaInfoEventListener {
        private InternalReplicaInfoEventListener() {
        }

        public void event(ReplicaInfoEvent event) {
            NodeId local = DistributedFlowRuleStore.this.clusterService.getLocalNode().id();
            DeviceId did = (DeviceId)event.subject();
            ReplicaInfo rInfo = event.replicaInfo();
            switch ((ReplicaInfoEvent.Type)event.type()) {
                case MASTER_CHANGED: {
                    if (!local.equals(rInfo.master().orNull())) break;
                    DistributedFlowRuleStore.this.loadFromBackup(did);
                    break;
                }
            }
        }
    }

    private final class SMapLoader
    extends CacheLoader<DeviceId, SMap<FlowId, ImmutableList<StoredFlowEntry>>> {
        private SMapLoader() {
        }

        public SMap<FlowId, ImmutableList<StoredFlowEntry>> load(DeviceId id) throws Exception {
            IMap map = DistributedFlowRuleStore.this.theInstance.getMap("flowtable_" + id.toString());
            return new SMap<FlowId, ImmutableList<StoredFlowEntry>>((IMap<byte[], byte[]>)map, SERIALIZER);
        }
    }

    private final class OnStoreBatch
    implements ClusterMessageHandler {
        private final NodeId local;

        private OnStoreBatch(NodeId local) {
            this.local = local;
        }

        public void handle(ClusterMessage message) {
            FlowRuleBatchOperation operation = (FlowRuleBatchOperation)SERIALIZER.decode(message.payload());
            DistributedFlowRuleStore.this.log.debug("received batch request {}", (Object)operation);
            DeviceId deviceId = operation.deviceId();
            ReplicaInfo replicaInfo = DistributedFlowRuleStore.this.replicaInfoManager.getReplicaInfoFor(deviceId);
            if (!this.local.equals(replicaInfo.master().orNull())) {
                HashSet<Object> failures = new HashSet<Object>(operation.size());
                for (FlowRuleBatchEntry op : operation.getOperations()) {
                    failures.add(op.target());
                }
                CompletedBatchOperation allFailed = new CompletedBatchOperation(false, failures, deviceId);
                try {
                    message.respond(SERIALIZER.encode((Object)allFailed));
                }
                catch (IOException e) {
                    DistributedFlowRuleStore.this.log.error("Failed to respond back", (Throwable)e);
                }
                return;
            }
            DistributedFlowRuleStore.this.pendingResponses.put(operation.id(), message.sender());
            DistributedFlowRuleStore.this.storeBatchInternal(operation);
        }
    }
}

