/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.flow.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.event.AbstractListenerRegistry;
import org.onosproject.event.Event;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.store.flow.ReplicaInfo;
import org.onosproject.store.flow.ReplicaInfoEvent;
import org.onosproject.store.flow.ReplicaInfoEventListener;
import org.onosproject.store.flow.ReplicaInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class ReplicaInfoManager
implements ReplicaInfoService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MastershipListener mastershipListener = new InternalMastershipListener();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected EventDeliveryService eventDispatcher;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    protected final AbstractListenerRegistry<ReplicaInfoEvent, ReplicaInfoEventListener> listenerRegistry = new AbstractListenerRegistry();

    @Activate
    public void activate() {
        this.eventDispatcher.addSink(ReplicaInfoEvent.class, this.listenerRegistry);
        this.mastershipService.addListener(this.mastershipListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.eventDispatcher.removeSink(ReplicaInfoEvent.class);
        this.mastershipService.removeListener(this.mastershipListener);
        this.log.info("Stopped");
    }

    @Override
    public ReplicaInfo getReplicaInfoFor(DeviceId deviceId) {
        return new ReplicaInfo(this.mastershipService.getMasterFor(deviceId), Collections.emptyList());
    }

    @Override
    public void addListener(ReplicaInfoEventListener listener) {
        this.listenerRegistry.addListener((EventListener)Preconditions.checkNotNull((Object)listener));
    }

    @Override
    public void removeListener(ReplicaInfoEventListener listener) {
        this.listenerRegistry.removeListener((EventListener)Preconditions.checkNotNull((Object)listener));
    }

    protected void bindEventDispatcher(EventDeliveryService eventDeliveryService) {
        this.eventDispatcher = eventDeliveryService;
    }

    protected void unbindEventDispatcher(EventDeliveryService eventDeliveryService) {
        if (this.eventDispatcher == eventDeliveryService) {
            this.eventDispatcher = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    final class InternalMastershipListener
    implements MastershipListener {
        InternalMastershipListener() {
        }

        public void event(MastershipEvent event) {
            ReplicaInfo replicaInfo = new ReplicaInfo(event.roleInfo().master(), event.roleInfo().backups());
            switch ((MastershipEvent.Type)event.type()) {
                case MASTER_CHANGED: {
                    ReplicaInfoManager.this.eventDispatcher.post((Event)new ReplicaInfoEvent(ReplicaInfoEvent.Type.MASTER_CHANGED, (DeviceId)event.subject(), replicaInfo));
                    break;
                }
                case BACKUPS_CHANGED: {
                    ReplicaInfoManager.this.eventDispatcher.post((Event)new ReplicaInfoEvent(ReplicaInfoEvent.Type.BACKUPS_CHANGED, (DeviceId)event.subject(), replicaInfo));
                    break;
                }
            }
        }
    }
}

