/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.group.impl;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.NewConcurrentHashMap;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.core.GroupId;
import org.onosproject.event.Event;
import org.onosproject.net.DeviceId;
import org.onosproject.net.group.DefaultGroup;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupEvent;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupOperation;
import org.onosproject.net.group.GroupStore;
import org.onosproject.net.group.GroupStoreDelegate;
import org.onosproject.net.group.StoredGroupEntry;
import org.onosproject.store.AbstractStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedGroupStore
extends AbstractStore<GroupEvent, GroupStoreDelegate>
implements GroupStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final int dummyId = -1;
    private final GroupId dummyGroupId = new DefaultGroupId(-1);
    private final ConcurrentMap<DeviceId, ConcurrentMap<GroupKey, StoredGroupEntry>> groupEntriesByKey = new ConcurrentHashMap<DeviceId, ConcurrentMap<GroupKey, StoredGroupEntry>>();
    private final ConcurrentMap<DeviceId, ConcurrentMap<GroupId, StoredGroupEntry>> groupEntriesById = new ConcurrentHashMap<DeviceId, ConcurrentMap<GroupId, StoredGroupEntry>>();
    private final ConcurrentMap<DeviceId, ConcurrentMap<GroupKey, StoredGroupEntry>> pendingGroupEntriesByKey = new ConcurrentHashMap<DeviceId, ConcurrentMap<GroupKey, StoredGroupEntry>>();
    private final ConcurrentMap<DeviceId, ConcurrentMap<GroupId, Group>> extraneousGroupEntriesById = new ConcurrentHashMap<DeviceId, ConcurrentMap<GroupId, Group>>();
    private final HashMap<DeviceId, Boolean> deviceAuditStatus = new HashMap();
    private final AtomicInteger groupIdGen = new AtomicInteger();

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.groupEntriesByKey.clear();
        this.groupEntriesById.clear();
        this.log.info("Stopped");
    }

    private static NewConcurrentHashMap<GroupKey, StoredGroupEntry> lazyEmptyGroupKeyTable() {
        return NewConcurrentHashMap.ifNeeded();
    }

    private static NewConcurrentHashMap<GroupId, StoredGroupEntry> lazyEmptyGroupIdTable() {
        return NewConcurrentHashMap.ifNeeded();
    }

    private static NewConcurrentHashMap<GroupKey, StoredGroupEntry> lazyEmptyPendingGroupKeyTable() {
        return NewConcurrentHashMap.ifNeeded();
    }

    private static NewConcurrentHashMap<GroupId, Group> lazyEmptyExtraneousGroupIdTable() {
        return NewConcurrentHashMap.ifNeeded();
    }

    private ConcurrentMap<GroupKey, StoredGroupEntry> getGroupKeyTable(DeviceId deviceId) {
        return (ConcurrentMap)ConcurrentUtils.createIfAbsentUnchecked(this.groupEntriesByKey, (Object)deviceId, DistributedGroupStore.lazyEmptyGroupKeyTable());
    }

    private ConcurrentMap<GroupId, StoredGroupEntry> getGroupIdTable(DeviceId deviceId) {
        return (ConcurrentMap)ConcurrentUtils.createIfAbsentUnchecked(this.groupEntriesById, (Object)deviceId, DistributedGroupStore.lazyEmptyGroupIdTable());
    }

    private ConcurrentMap<GroupKey, StoredGroupEntry> getPendingGroupKeyTable(DeviceId deviceId) {
        return (ConcurrentMap)ConcurrentUtils.createIfAbsentUnchecked(this.pendingGroupEntriesByKey, (Object)deviceId, DistributedGroupStore.lazyEmptyPendingGroupKeyTable());
    }

    private ConcurrentMap<GroupId, Group> getExtraneousGroupIdTable(DeviceId deviceId) {
        return (ConcurrentMap)ConcurrentUtils.createIfAbsentUnchecked(this.extraneousGroupEntriesById, (Object)deviceId, DistributedGroupStore.lazyEmptyExtraneousGroupIdTable());
    }

    public int getGroupCount(DeviceId deviceId) {
        return this.groupEntriesByKey.get(deviceId) != null ? ((ConcurrentMap)this.groupEntriesByKey.get(deviceId)).size() : 0;
    }

    public Iterable<Group> getGroups(DeviceId deviceId) {
        return FluentIterable.from(this.getGroupKeyTable(deviceId).values()).transform((Function)new Function<StoredGroupEntry, Group>(){

            public Group apply(StoredGroupEntry input) {
                return input;
            }
        });
    }

    public Group getGroup(DeviceId deviceId, GroupKey appCookie) {
        return this.groupEntriesByKey.get(deviceId) != null ? (Group)((ConcurrentMap)this.groupEntriesByKey.get(deviceId)).get(appCookie) : null;
    }

    private int getFreeGroupIdValue(DeviceId deviceId) {
        int freeId = this.groupIdGen.incrementAndGet();
        while (true) {
            Group existing;
            Group group = existing = this.groupEntriesById.get(deviceId) != null ? (Group)((ConcurrentMap)this.groupEntriesById.get(deviceId)).get(new DefaultGroupId(freeId)) : null;
            if (existing == null) {
                Group group2 = existing = this.extraneousGroupEntriesById.get(deviceId) != null ? (Group)((ConcurrentMap)this.extraneousGroupEntriesById.get(deviceId)).get(new DefaultGroupId(freeId)) : null;
            }
            if (existing == null) break;
            freeId = this.groupIdGen.incrementAndGet();
        }
        return freeId;
    }

    public void storeGroupDescription(GroupDescription groupDesc) {
        if (this.getGroup(groupDesc.deviceId(), groupDesc.appCookie()) != null) {
            return;
        }
        if (this.deviceAuditStatus.get(groupDesc.deviceId()) == null) {
            DefaultGroup group = new DefaultGroup(this.dummyGroupId, groupDesc);
            group.setState(Group.GroupState.WAITING_AUDIT_COMPLETE);
            ConcurrentMap<GroupKey, StoredGroupEntry> pendingKeyTable = this.getPendingGroupKeyTable(groupDesc.deviceId());
            pendingKeyTable.put(groupDesc.appCookie(), (StoredGroupEntry)group);
            return;
        }
        this.storeGroupDescriptionInternal(groupDesc);
    }

    private void storeGroupDescriptionInternal(GroupDescription groupDesc) {
        if (this.getGroup(groupDesc.deviceId(), groupDesc.appCookie()) != null) {
            return;
        }
        DefaultGroupId id = new DefaultGroupId(this.getFreeGroupIdValue(groupDesc.deviceId()));
        DefaultGroup group = new DefaultGroup((GroupId)id, groupDesc);
        ConcurrentMap<GroupKey, StoredGroupEntry> keyTable = this.getGroupKeyTable(groupDesc.deviceId());
        keyTable.put(groupDesc.appCookie(), (StoredGroupEntry)group);
        ConcurrentMap<GroupId, StoredGroupEntry> idTable = this.getGroupIdTable(groupDesc.deviceId());
        idTable.put((GroupId)id, (StoredGroupEntry)group);
        this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_ADD_REQUESTED, (Group)group));
    }

    public void updateGroupDescription(DeviceId deviceId, GroupKey oldAppCookie, GroupStore.UpdateType type, GroupBuckets newBuckets, GroupKey newAppCookie) {
        Group oldGroup = this.getGroup(deviceId, oldAppCookie);
        if (oldGroup == null) {
            return;
        }
        List<GroupBucket> newBucketList = this.getUpdatedBucketList(oldGroup, type, newBuckets);
        if (newBucketList != null) {
            GroupBuckets updatedBuckets = new GroupBuckets(newBucketList);
            GroupKey newCookie = newAppCookie != null ? newAppCookie : oldAppCookie;
            DefaultGroupDescription updatedGroupDesc = new DefaultGroupDescription(oldGroup.deviceId(), oldGroup.type(), updatedBuckets, newCookie, oldGroup.appId());
            DefaultGroup newGroup = new DefaultGroup(oldGroup.id(), (GroupDescription)updatedGroupDesc);
            newGroup.setState(Group.GroupState.PENDING_UPDATE);
            newGroup.setLife(oldGroup.life());
            newGroup.setPackets(oldGroup.packets());
            newGroup.setBytes(oldGroup.bytes());
            ConcurrentMap<GroupKey, StoredGroupEntry> keyTable = this.getGroupKeyTable(oldGroup.deviceId());
            ConcurrentMap<GroupId, StoredGroupEntry> idTable = this.getGroupIdTable(oldGroup.deviceId());
            keyTable.remove(oldGroup.appCookie());
            idTable.remove(oldGroup.id());
            keyTable.put(newGroup.appCookie(), (StoredGroupEntry)newGroup);
            idTable.put(newGroup.id(), (StoredGroupEntry)newGroup);
            this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_UPDATE_REQUESTED, (Group)newGroup));
        }
    }

    private List<GroupBucket> getUpdatedBucketList(Group oldGroup, GroupStore.UpdateType type, GroupBuckets buckets) {
        GroupBuckets oldBuckets = oldGroup.buckets();
        ArrayList<GroupBucket> newBucketList = new ArrayList<GroupBucket>(oldBuckets.buckets());
        boolean groupDescUpdated = false;
        if (type == GroupStore.UpdateType.ADD) {
            for (GroupBucket addBucket : buckets.buckets()) {
                if (newBucketList.contains(addBucket)) continue;
                newBucketList.add(addBucket);
                groupDescUpdated = true;
            }
        } else if (type == GroupStore.UpdateType.REMOVE) {
            for (GroupBucket removeBucket : buckets.buckets()) {
                if (!newBucketList.contains(removeBucket)) continue;
                newBucketList.remove(removeBucket);
                groupDescUpdated = true;
            }
        }
        if (groupDescUpdated) {
            return newBucketList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroupDescription(DeviceId deviceId, GroupKey appCookie) {
        StoredGroupEntry existing;
        StoredGroupEntry storedGroupEntry = existing = this.groupEntriesByKey.get(deviceId) != null ? (StoredGroupEntry)((ConcurrentMap)this.groupEntriesByKey.get(deviceId)).get(appCookie) : null;
        if (existing == null) {
            return;
        }
        StoredGroupEntry storedGroupEntry2 = existing;
        synchronized (storedGroupEntry2) {
            existing.setState(Group.GroupState.PENDING_DELETE);
        }
        this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_REMOVE_REQUESTED, (Group)existing));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateGroupEntry(Group group) {
        StoredGroupEntry existing = this.groupEntriesById.get(group.deviceId()) != null ? (StoredGroupEntry)((ConcurrentMap)this.groupEntriesById.get(group.deviceId())).get(group.id()) : null;
        GroupEvent event = null;
        if (existing != null) {
            StoredGroupEntry storedGroupEntry = existing;
            synchronized (storedGroupEntry) {
                existing.setLife(group.life());
                existing.setPackets(group.packets());
                existing.setBytes(group.bytes());
                if (existing.state() == Group.GroupState.PENDING_ADD) {
                    existing.setState(Group.GroupState.ADDED);
                    event = new GroupEvent(GroupEvent.Type.GROUP_ADDED, (Group)existing);
                } else {
                    if (existing.state() == Group.GroupState.PENDING_UPDATE) {
                        existing.setState(Group.GroupState.PENDING_UPDATE);
                    }
                    event = new GroupEvent(GroupEvent.Type.GROUP_UPDATED, (Group)existing);
                }
            }
        }
        if (event != null) {
            this.notifyDelegate((Event)event);
        }
    }

    public void removeGroupEntry(Group group) {
        StoredGroupEntry existing;
        StoredGroupEntry storedGroupEntry = existing = this.groupEntriesById.get(group.deviceId()) != null ? (StoredGroupEntry)((ConcurrentMap)this.groupEntriesById.get(group.deviceId())).get(group.id()) : null;
        if (existing != null) {
            ConcurrentMap<GroupKey, StoredGroupEntry> keyTable = this.getGroupKeyTable(existing.deviceId());
            ConcurrentMap<GroupId, StoredGroupEntry> idTable = this.getGroupIdTable(existing.deviceId());
            idTable.remove(existing.id());
            keyTable.remove(existing.appCookie());
            this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_REMOVED, (Group)existing));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceInitialAuditCompleted(DeviceId deviceId, boolean completed) {
        HashMap<DeviceId, Boolean> hashMap = this.deviceAuditStatus;
        synchronized (hashMap) {
            if (completed) {
                this.log.debug("deviceInitialAuditCompleted: AUDIT completed for device {}", (Object)deviceId);
                this.deviceAuditStatus.put(deviceId, true);
                ConcurrentMap<GroupKey, StoredGroupEntry> pendingGroupRequests = this.getPendingGroupKeyTable(deviceId);
                for (Group group : pendingGroupRequests.values()) {
                    DefaultGroupDescription tmp = new DefaultGroupDescription(group.deviceId(), group.type(), group.buckets(), group.appCookie(), group.appId());
                    this.storeGroupDescriptionInternal((GroupDescription)tmp);
                }
                this.getPendingGroupKeyTable(deviceId).clear();
            } else if (this.deviceAuditStatus.get(deviceId).booleanValue()) {
                this.log.debug("deviceInitialAuditCompleted: Clearing AUDIT status for device {}", (Object)deviceId);
                this.deviceAuditStatus.put(deviceId, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deviceInitialAuditStatus(DeviceId deviceId) {
        HashMap<DeviceId, Boolean> hashMap = this.deviceAuditStatus;
        synchronized (hashMap) {
            return this.deviceAuditStatus.get(deviceId) != null ? this.deviceAuditStatus.get(deviceId) : false;
        }
    }

    public void groupOperationFailed(DeviceId deviceId, GroupOperation operation) {
        StoredGroupEntry existing;
        StoredGroupEntry storedGroupEntry = existing = this.groupEntriesById.get(deviceId) != null ? (StoredGroupEntry)((ConcurrentMap)this.groupEntriesById.get(deviceId)).get(operation.groupId()) : null;
        if (existing == null) {
            this.log.warn("No group entry with ID {} found ", (Object)operation.groupId());
            return;
        }
        switch (operation.opType()) {
            case ADD: {
                this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_ADD_FAILED, (Group)existing));
                break;
            }
            case MODIFY: {
                this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_UPDATE_FAILED, (Group)existing));
                break;
            }
            case DELETE: {
                this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_REMOVE_FAILED, (Group)existing));
                break;
            }
            default: {
                this.log.warn("Unknown group operation type {}", (Object)operation.opType());
            }
        }
        ConcurrentMap<GroupKey, StoredGroupEntry> keyTable = this.getGroupKeyTable(existing.deviceId());
        ConcurrentMap<GroupId, StoredGroupEntry> idTable = this.getGroupIdTable(existing.deviceId());
        idTable.remove(existing.id());
        keyTable.remove(existing.appCookie());
    }

    public void addOrUpdateExtraneousGroupEntry(Group group) {
        ConcurrentMap<GroupId, Group> extraneousIdTable = this.getExtraneousGroupIdTable(group.deviceId());
        extraneousIdTable.put(group.id(), group);
        if (group.referenceCount() == 0L) {
            this.notifyDelegate((Event)new GroupEvent(GroupEvent.Type.GROUP_REMOVE_REQUESTED, group));
        }
    }

    public void removeExtraneousGroupEntry(Group group) {
        ConcurrentMap<GroupId, Group> extraneousIdTable = this.getExtraneousGroupIdTable(group.deviceId());
        extraneousIdTable.remove(group.id());
    }

    public Iterable<Group> getExtraneousGroups(DeviceId deviceId) {
        return FluentIterable.from(this.getExtraneousGroupIdTable(deviceId).values());
    }
}

