/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.host.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNodeToNodeId;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.net.Annotations;
import org.onosproject.net.AnnotationsUtil;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.host.DefaultHostDescription;
import org.onosproject.net.host.HostClockService;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostStore;
import org.onosproject.net.host.HostStoreDelegate;
import org.onosproject.net.host.PortAddresses;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.Timestamp;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.host.impl.GossipHostStoreMessageSubjects;
import org.onosproject.store.host.impl.HostAntiEntropyAdvertisement;
import org.onosproject.store.host.impl.HostFragmentId;
import org.onosproject.store.host.impl.InternalHostEvent;
import org.onosproject.store.host.impl.InternalHostRemovedEvent;
import org.onosproject.store.impl.Timestamped;
import org.onosproject.store.serializers.KryoSerializer;
import org.onosproject.store.serializers.impl.DistributedStoreSerializers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class GossipHostStore
extends AbstractStore<HostEvent, HostStoreDelegate>
implements HostStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private int hostsExpected = 2000000;
    private final Map<HostId, StoredHost> hosts = new ConcurrentHashMap<HostId, StoredHost>(this.hostsExpected, 0.75f, 16);
    private final Map<HostId, Timestamped<Host>> removedHosts = new ConcurrentHashMap<HostId, Timestamped<Host>>(this.hostsExpected, 0.75f, 16);
    private final Multimap<ConnectPoint, Host> locations = Multimaps.synchronizedSetMultimap((SetMultimap)Multimaps.newSetMultimap(new ConcurrentHashMap(), () -> Sets.newConcurrentHashSet()));
    private final SetMultimap<ConnectPoint, PortAddresses> portAddresses = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostClockService hostClockService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    private static final KryoSerializer SERIALIZER = new KryoSerializer(){

        protected void setupKryoPool() {
            this.serializerPool = KryoNamespace.newBuilder().register(DistributedStoreSerializers.STORE_COMMON).nextId(310).register(new Class[]{InternalHostEvent.class}).register(new Class[]{InternalHostRemovedEvent.class}).register(new Class[]{HostFragmentId.class}).register(new Class[]{HostAntiEntropyAdvertisement.class}).build();
        }
    };
    private ExecutorService executor;
    private ScheduledExecutorService backgroundExecutor;
    private long initialDelaySec = 5L;
    private long periodSec = 5L;

    @Activate
    public void activate() {
        this.executor = Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/host", (String)"fg-%d"));
        this.backgroundExecutor = Executors.newSingleThreadScheduledExecutor(Tools.minPriority((ThreadFactory)Tools.groupedThreads((String)"onos/host", (String)"bg-%d")));
        this.clusterCommunicator.addSubscriber(GossipHostStoreMessageSubjects.HOST_UPDATED_MSG, (ClusterMessageHandler)new InternalHostEventListener(), this.executor);
        this.clusterCommunicator.addSubscriber(GossipHostStoreMessageSubjects.HOST_REMOVED_MSG, (ClusterMessageHandler)new InternalHostRemovedEventListener(), this.executor);
        this.clusterCommunicator.addSubscriber(GossipHostStoreMessageSubjects.HOST_ANTI_ENTROPY_ADVERTISEMENT, (ClusterMessageHandler)new InternalHostAntiEntropyAdvertisementListener(), (ExecutorService)this.backgroundExecutor);
        this.backgroundExecutor.scheduleAtFixedRate(new SendAdvertisementTask(), this.initialDelaySec, this.periodSec, TimeUnit.SECONDS);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.executor.shutdownNow();
        this.backgroundExecutor.shutdownNow();
        try {
            if (!this.backgroundExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.log.error("Timeout during executor shutdown");
            }
        }
        catch (InterruptedException e) {
            this.log.error("Error during executor shutdown", (Throwable)e);
        }
        this.hosts.clear();
        this.removedHosts.clear();
        this.locations.clear();
        this.portAddresses.clear();
        this.log.info("Stopped");
    }

    public HostEvent createOrUpdateHost(ProviderId providerId, HostId hostId, HostDescription hostDescription) {
        Timestamp timestamp = this.hostClockService.getTimestamp(hostId);
        HostEvent event = this.createOrUpdateHostInternal(providerId, hostId, hostDescription, timestamp);
        if (event != null) {
            this.log.debug("Notifying peers of a host topology event for providerId: {}; hostId: {}; hostDescription: {}", new Object[]{providerId, hostId, hostDescription});
            this.notifyPeers(new InternalHostEvent(providerId, hostId, hostDescription, timestamp));
        }
        return event;
    }

    private HostEvent createOrUpdateHostInternal(ProviderId providerId, HostId hostId, HostDescription hostDescription, Timestamp timestamp) {
        if (this.isHostRemoved(hostId, timestamp)) {
            this.log.debug("Ignoring update for removed host {}@{}", (Object)hostDescription, (Object)timestamp);
            return null;
        }
        StoredHost host = this.hosts.get(hostId);
        if (host == null) {
            return this.createHost(providerId, hostId, hostDescription, timestamp);
        }
        return this.updateHost(providerId, hostId, host, hostDescription, timestamp);
    }

    private boolean isHostRemoved(HostId hostId, Timestamp timestamp) {
        Timestamped<Host> removedInfo = this.removedHosts.get(hostId);
        if (removedInfo != null) {
            if (removedInfo.isNewerThan(timestamp)) {
                return true;
            }
            this.removedHosts.remove(hostId, removedInfo);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostEvent createHost(ProviderId providerId, HostId hostId, HostDescription descr, Timestamp timestamp) {
        GossipHostStore gossipHostStore = this;
        synchronized (gossipHostStore) {
            StoredHost newhost = new StoredHost(timestamp, providerId, hostId, descr.hwAddress(), descr.vlan(), descr.location(), (Set<IpAddress>)ImmutableSet.copyOf((Collection)descr.ipAddress()), new Annotations[0]);
            StoredHost concAdd = this.hosts.putIfAbsent(hostId, newhost);
            if (concAdd != null) {
                return this.updateHost(providerId, hostId, concAdd, descr, timestamp);
            }
            this.locations.put((Object)descr.location(), (Object)newhost);
            return new HostEvent(HostEvent.Type.HOST_ADDED, (Host)newhost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostEvent updateHost(ProviderId providerId, HostId hostId, StoredHost oldHost, HostDescription descr, Timestamp timestamp) {
        boolean hostMoved;
        if (timestamp.compareTo((Object)oldHost.timestamp()) < 0) {
            this.log.debug("Ignoring outdated host update {}@{}", (Object)descr, (Object)timestamp);
            return null;
        }
        boolean bl = hostMoved = !oldHost.location().equals((Object)descr.location());
        if (hostMoved || !oldHost.ipAddresses().containsAll(descr.ipAddress()) || !descr.annotations().keys().isEmpty()) {
            boolean deltaUpdate;
            HashSet<IpAddress> addresses = new HashSet<IpAddress>(oldHost.ipAddresses());
            addresses.addAll(descr.ipAddress());
            DefaultAnnotations annotations = DefaultAnnotations.merge((DefaultAnnotations)((DefaultAnnotations)oldHost.annotations()), (SparseAnnotations)descr.annotations());
            Timestamp newTimestamp = timestamp;
            boolean bl2 = deltaUpdate = !descr.ipAddress().equals(addresses) || !AnnotationsUtil.isEqual((Annotations)descr.annotations(), (Annotations)annotations);
            if (deltaUpdate) {
                newTimestamp = this.hostClockService.getTimestamp(hostId);
                this.log.debug("delta update detected on {}, substepping timestamp to {}", (Object)hostId, (Object)newTimestamp);
            }
            StoredHost updated = new StoredHost(newTimestamp, providerId, oldHost.id(), oldHost.mac(), oldHost.vlan(), descr.location(), addresses, new Annotations[]{annotations});
            GossipHostStore gossipHostStore = this;
            synchronized (gossipHostStore) {
                boolean replaced = this.hosts.replace(hostId, oldHost, updated);
                if (!replaced) {
                    return this.createOrUpdateHostInternal(providerId, hostId, descr, timestamp);
                }
                this.locations.remove((Object)oldHost.location(), (Object)oldHost);
                this.locations.put((Object)updated.location(), (Object)updated);
                HostEvent.Type eventType = hostMoved ? HostEvent.Type.HOST_MOVED : HostEvent.Type.HOST_UPDATED;
                return new HostEvent(eventType, (Host)updated);
            }
        }
        return null;
    }

    public HostEvent removeHost(HostId hostId) {
        Timestamp timestamp = this.hostClockService.getTimestamp(hostId);
        HostEvent event = this.removeHostInternal(hostId, timestamp);
        if (event != null) {
            this.log.debug("Notifying peers of a host removed topology event for hostId: {}", (Object)hostId);
            this.notifyPeers(new InternalHostRemovedEvent(hostId, timestamp));
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostEvent removeHostInternal(HostId hostId, Timestamp timestamp) {
        GossipHostStore gossipHostStore = this;
        synchronized (gossipHostStore) {
            Host host = (Host)this.hosts.remove(hostId);
            if (host != null) {
                this.locations.remove((Object)host.location(), (Object)host);
                this.removedHosts.put(hostId, new Timestamped<Host>(host, timestamp));
                return new HostEvent(HostEvent.Type.HOST_REMOVED, host);
            }
            return null;
        }
    }

    public int getHostCount() {
        return this.hosts.size();
    }

    public Iterable<Host> getHosts() {
        return ImmutableSet.copyOf(this.hosts.values());
    }

    public Host getHost(HostId hostId) {
        return (Host)this.hosts.get(hostId);
    }

    public Set<Host> getHosts(VlanId vlanId) {
        HashSet<Host> vlanset = new HashSet<Host>();
        for (Host host : this.hosts.values()) {
            if (!host.vlan().equals((Object)vlanId)) continue;
            vlanset.add(host);
        }
        return vlanset;
    }

    public Set<Host> getHosts(MacAddress mac) {
        HashSet<Host> macset = new HashSet<Host>();
        for (Host host : this.hosts.values()) {
            if (!host.mac().equals((Object)mac)) continue;
            macset.add(host);
        }
        return macset;
    }

    public Set<Host> getHosts(IpAddress ip) {
        HashSet<Host> ipset = new HashSet<Host>();
        for (Host host : this.hosts.values()) {
            if (!host.ipAddresses().contains(ip)) continue;
            ipset.add(host);
        }
        return ipset;
    }

    public Set<Host> getConnectedHosts(ConnectPoint connectPoint) {
        return ImmutableSet.copyOf((Collection)this.locations.get((Object)connectPoint));
    }

    public Set<Host> getConnectedHosts(DeviceId deviceId) {
        HashSet<Host> hostset = new HashSet<Host>();
        for (ConnectPoint p : this.locations.keySet()) {
            if (!p.deviceId().equals((Object)deviceId)) continue;
            hostset.addAll(this.locations.get((Object)p));
        }
        return hostset;
    }

    public void updateAddressBindings(PortAddresses addresses) {
        this.portAddresses.put((Object)addresses.connectPoint(), (Object)addresses);
    }

    public void removeAddressBindings(PortAddresses addresses) {
        this.portAddresses.remove((Object)addresses.connectPoint(), (Object)addresses);
    }

    public void clearAddressBindings(ConnectPoint connectPoint) {
        this.portAddresses.removeAll((Object)connectPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PortAddresses> getAddressBindings() {
        SetMultimap<ConnectPoint, PortAddresses> setMultimap = this.portAddresses;
        synchronized (setMultimap) {
            return ImmutableSet.copyOf((Collection)this.portAddresses.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PortAddresses> getAddressBindingsForPort(ConnectPoint connectPoint) {
        SetMultimap<ConnectPoint, PortAddresses> setMultimap = this.portAddresses;
        synchronized (setMultimap) {
            Set addresses = this.portAddresses.get((Object)connectPoint);
            if (addresses == null) {
                return Collections.emptySet();
            }
            return ImmutableSet.copyOf((Collection)addresses);
        }
    }

    private void notifyPeers(InternalHostRemovedEvent event) {
        this.broadcastMessage(GossipHostStoreMessageSubjects.HOST_REMOVED_MSG, event);
    }

    private void notifyPeers(InternalHostEvent event) {
        this.broadcastMessage(GossipHostStoreMessageSubjects.HOST_UPDATED_MSG, event);
    }

    private void broadcastMessage(MessageSubject subject, Object event) {
        ClusterMessage message = new ClusterMessage(this.clusterService.getLocalNode().id(), subject, SERIALIZER.encode(event));
        this.clusterCommunicator.broadcast(message);
    }

    private void unicastMessage(NodeId peer, MessageSubject subject, Object event) throws IOException {
        ClusterMessage message = new ClusterMessage(this.clusterService.getLocalNode().id(), subject, SERIALIZER.encode(event));
        this.clusterCommunicator.unicast(message, peer);
    }

    private void notifyDelegateIfNotNull(HostEvent event) {
        if (event != null) {
            this.notifyDelegate((Event)event);
        }
    }

    private HostAntiEntropyAdvertisement createAdvertisement() {
        NodeId self = this.clusterService.getLocalNode().id();
        HashMap<HostFragmentId, Timestamp> timestamps = new HashMap<HostFragmentId, Timestamp>(this.hosts.size());
        HashMap<HostId, Timestamp> tombstones = new HashMap<HostId, Timestamp>(this.removedHosts.size());
        this.hosts.forEach((hostId, hostInfo) -> {
            ProviderId providerId = hostInfo.providerId();
            timestamps.put(new HostFragmentId((HostId)hostId, providerId), hostInfo.timestamp());
        });
        this.removedHosts.forEach((hostId, timestamped) -> tombstones.put((HostId)hostId, timestamped.timestamp()));
        return new HostAntiEntropyAdvertisement(self, timestamps, tombstones);
    }

    private synchronized void handleAntiEntropyAdvertisement(HostAntiEntropyAdvertisement ad) {
        HostFragmentId hostFragId;
        ProviderId providerId;
        HostId hostId;
        NodeId sender = ad.sender();
        for (Map.Entry<HostId, StoredHost> entry : this.hosts.entrySet()) {
            Timestamp remoteDeadTimestamp;
            hostId = entry.getKey();
            StoredHost localHost = entry.getValue();
            providerId = localHost.providerId();
            hostFragId = new HostFragmentId(hostId, providerId);
            Timestamp localLiveTimestamp = localHost.timestamp();
            Timestamp remoteTimestamp = ad.timestamps().get(hostFragId);
            if (remoteTimestamp == null) {
                remoteTimestamp = ad.tombstones().get(hostId);
            }
            if (remoteTimestamp == null || localLiveTimestamp.compareTo((Object)remoteTimestamp) > 0) {
                DefaultHostDescription desc = new DefaultHostDescription(localHost.mac(), localHost.vlan(), localHost.location(), localHost.ipAddresses(), new SparseAnnotations[0]);
                try {
                    this.unicastMessage(sender, GossipHostStoreMessageSubjects.HOST_UPDATED_MSG, new InternalHostEvent(providerId, hostId, (HostDescription)desc, localHost.timestamp()));
                }
                catch (IOException e1) {
                    this.log.debug("Failed to send advertisement response", (Throwable)e1);
                }
            }
            if ((remoteDeadTimestamp = ad.tombstones().get(hostId)) == null || remoteDeadTimestamp.compareTo((Object)localLiveTimestamp) <= 0) continue;
            this.notifyDelegateIfNotNull(this.removeHostInternal(hostId, remoteDeadTimestamp));
        }
        for (Map.Entry<HostId, Object> entry : this.removedHosts.entrySet()) {
            hostId = entry.getKey();
            Timestamp localDeadTimestamp = ((Timestamped)entry.getValue()).timestamp();
            providerId = ((Host)((Timestamped)entry.getValue()).value()).providerId();
            hostFragId = new HostFragmentId(hostId, providerId);
            Timestamp remoteLiveTimestamp = ad.timestamps().get(hostFragId);
            if (remoteLiveTimestamp == null || localDeadTimestamp.compareTo((Object)remoteLiveTimestamp) <= 0) continue;
            try {
                this.unicastMessage(sender, GossipHostStoreMessageSubjects.HOST_REMOVED_MSG, new InternalHostRemovedEvent(hostId, localDeadTimestamp));
            }
            catch (IOException e1) {
                this.log.debug("Failed to send advertisement response", (Throwable)e1);
            }
        }
        for (Map.Entry<HostId, Object> entry : ad.tombstones().entrySet()) {
            hostId = entry.getKey();
            Timestamp adRemoveTimestamp = (Timestamp)entry.getValue();
            StoredHost storedHost = this.hosts.get(hostId);
            if (storedHost == null || adRemoveTimestamp.compareTo((Object)storedHost.timestamp()) <= 0) continue;
            this.notifyDelegateIfNotNull(this.removeHostInternal(hostId, adRemoveTimestamp));
        }
        for (HostFragmentId hostFragmentId : ad.timestamps().keySet()) {
            if (this.hosts.containsKey(hostFragmentId.hostId())) continue;
            HostAntiEntropyAdvertisement myAd = this.createAdvertisement();
            try {
                this.unicastMessage(sender, GossipHostStoreMessageSubjects.HOST_ANTI_ENTROPY_ADVERTISEMENT, myAd);
                break;
            }
            catch (IOException e) {
                this.log.debug("Failed to send reactive anti-entropy advertisement to {}", (Object)sender);
            }
        }
    }

    protected void bindHostClockService(HostClockService hostClockService) {
        this.hostClockService = hostClockService;
    }

    protected void unbindHostClockService(HostClockService hostClockService) {
        if (this.hostClockService == hostClockService) {
            this.hostClockService = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    private final class InternalHostAntiEntropyAdvertisementListener
    implements ClusterMessageHandler {
        private InternalHostAntiEntropyAdvertisementListener() {
        }

        public void handle(ClusterMessage message) {
            GossipHostStore.this.log.trace("Received Host Anti-Entropy advertisement from peer: {}", (Object)message.sender());
            HostAntiEntropyAdvertisement advertisement = (HostAntiEntropyAdvertisement)SERIALIZER.decode(message.payload());
            try {
                GossipHostStore.this.handleAntiEntropyAdvertisement(advertisement);
            }
            catch (Exception e) {
                GossipHostStore.this.log.warn("Exception thrown handling Host advertisements", (Throwable)e);
            }
        }
    }

    private final class SendAdvertisementTask
    implements Runnable {
        private SendAdvertisementTask() {
        }

        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                GossipHostStore.this.log.info("Interrupted, quitting");
                return;
            }
            try {
                int idx;
                NodeId peer;
                NodeId self = GossipHostStore.this.clusterService.getLocalNode().id();
                Set nodes = GossipHostStore.this.clusterService.getNodes();
                ImmutableList nodeIds = FluentIterable.from((Iterable)nodes).transform((Function)ControllerNodeToNodeId.toNodeId()).toList();
                if (nodeIds.size() == 1 && ((NodeId)nodeIds.get(0)).equals((Object)self)) {
                    GossipHostStore.this.log.trace("No other peers in the cluster.");
                    return;
                }
                while ((peer = (NodeId)nodeIds.get(idx = RandomUtils.nextInt((int)0, (int)nodeIds.size()))).equals((Object)self)) {
                }
                HostAntiEntropyAdvertisement ad = GossipHostStore.this.createAdvertisement();
                if (Thread.currentThread().isInterrupted()) {
                    GossipHostStore.this.log.info("Interrupted, quitting");
                    return;
                }
                try {
                    GossipHostStore.this.unicastMessage(peer, GossipHostStoreMessageSubjects.HOST_ANTI_ENTROPY_ADVERTISEMENT, ad);
                }
                catch (IOException e) {
                    GossipHostStore.this.log.debug("Failed to send anti-entropy advertisement to {}", (Object)peer);
                    return;
                }
            }
            catch (Exception e) {
                GossipHostStore.this.log.error("Exception thrown while sending advertisement", (Throwable)e);
            }
        }
    }

    private final class InternalHostRemovedEventListener
    implements ClusterMessageHandler {
        private InternalHostRemovedEventListener() {
        }

        public void handle(ClusterMessage message) {
            GossipHostStore.this.log.debug("Received host removed event from peer: {}", (Object)message.sender());
            InternalHostRemovedEvent event = (InternalHostRemovedEvent)SERIALIZER.decode(message.payload());
            HostId hostId = event.hostId();
            Timestamp timestamp = event.timestamp();
            try {
                GossipHostStore.this.notifyDelegateIfNotNull(GossipHostStore.this.removeHostInternal(hostId, timestamp));
            }
            catch (Exception e) {
                GossipHostStore.this.log.warn("Exception thrown handling host removed", (Throwable)e);
            }
        }
    }

    private final class InternalHostEventListener
    implements ClusterMessageHandler {
        private InternalHostEventListener() {
        }

        public void handle(ClusterMessage message) {
            GossipHostStore.this.log.debug("Received host update event from peer: {}", (Object)message.sender());
            InternalHostEvent event = (InternalHostEvent)SERIALIZER.decode(message.payload());
            ProviderId providerId = event.providerId();
            HostId hostId = event.hostId();
            HostDescription hostDescription = event.hostDescription();
            Timestamp timestamp = event.timestamp();
            try {
                GossipHostStore.this.notifyDelegateIfNotNull(GossipHostStore.this.createOrUpdateHostInternal(providerId, hostId, hostDescription, timestamp));
            }
            catch (Exception e) {
                GossipHostStore.this.log.warn("Exception thrown handling host removed", (Throwable)e);
            }
        }
    }

    private static final class StoredHost
    extends DefaultHost {
        private final Timestamp timestamp;

        public StoredHost(Timestamp timestamp, ProviderId providerId, HostId id, MacAddress mac, VlanId vlan, HostLocation location, Set<IpAddress> ips, Annotations ... annotations) {
            super(providerId, id, mac, vlan, location, ips, annotations);
            this.timestamp = (Timestamp)Preconditions.checkNotNull((Object)timestamp);
        }

        public Timestamp timestamp() {
            return this.timestamp;
        }
    }
}

